/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.facebook.presto.hive.$internal.com.google.common.collect.Iterables;
import com.facebook.presto.hive.$internal.org.apache.commons.lang.StringEscapeUtils;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.merge.MergeFileTask;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateTask;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateWork;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.CheckResult;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreChecker;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.parse.AlterTablePartMergeFilesDesc;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.AlterIndexDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableAlterPartDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableExchangePartition;
import org.apache.hadoop.hive.ql.plan.AlterTableSimpleDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateIndexDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.plan.CreateViewDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DescFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropIndexDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.FileMergeDesc;
import org.apache.hadoop.hive.ql.plan.GrantDesc;
import org.apache.hadoop.hive.ql.plan.GrantRevokeRoleDDL;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LockDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.LockTableDesc;
import org.apache.hadoop.hive.ql.plan.MsckDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OrcFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.plan.RCFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.RenamePartitionDesc;
import org.apache.hadoop.hive.ql.plan.RevokeDesc;
import org.apache.hadoop.hive.ql.plan.RoleDDLDesc;
import org.apache.hadoop.hive.ql.plan.ShowColumnsDesc;
import org.apache.hadoop.hive.ql.plan.ShowCompactionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowConfDesc;
import org.apache.hadoop.hive.ql.plan.ShowCreateTableDesc;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowGrantDesc;
import org.apache.hadoop.hive.ql.plan.ShowIndexesDesc;
import org.apache.hadoop.hive.ql.plan.ShowLocksDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.ShowTblPropertiesDesc;
import org.apache.hadoop.hive.ql.plan.ShowTxnsDesc;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.TruncateTableDesc;
import org.apache.hadoop.hive.ql.plan.UnlockDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.UnlockTableDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveRoleGrant;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveV1Authorizer;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.dynamic_type.DynamicSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hive.common.util.AnnotationUtils;
import org.apache.hive.common.util.ReflectionUtil;

public class DDLTask
extends Task<DDLWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog("hive.ql.exec.DDLTask");
    private static final int separator = 9;
    private static final int terminator = 10;
    private static String INTERMEDIATE_ARCHIVED_DIR_SUFFIX;
    private static String INTERMEDIATE_ORIGINAL_DIR_SUFFIX;
    private static String INTERMEDIATE_EXTRACTED_DIR_SUFFIX;
    private MetaDataFormatter formatter;
    private static final String[] DELIMITER_PREFIXES;

    @Override
    public boolean requireLock() {
        return this.work != null && ((DDLWork)this.work).getNeedLock();
    }

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext ctx) {
        super.initialize(conf, queryPlan, ctx);
        this.formatter = MetaDataFormatUtils.getFormatter(conf);
        INTERMEDIATE_ARCHIVED_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ARCHIVED);
        INTERMEDIATE_ORIGINAL_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ORIGINAL);
        INTERMEDIATE_EXTRACTED_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_EXTRACTED);
    }

    @Override
    public int execute(DriverContext driverContext) {
        try {
            MsckDesc msckDesc;
            Hive db = Hive.get(this.conf);
            CreateDatabaseDesc createDatabaseDesc = ((DDLWork)this.work).getCreateDatabaseDesc();
            if (null != createDatabaseDesc) {
                return this.createDatabase(db, createDatabaseDesc);
            }
            DropDatabaseDesc dropDatabaseDesc = ((DDLWork)this.work).getDropDatabaseDesc();
            if (dropDatabaseDesc != null) {
                return this.dropDatabase(db, dropDatabaseDesc);
            }
            LockDatabaseDesc lockDatabaseDesc = ((DDLWork)this.work).getLockDatabaseDesc();
            if (lockDatabaseDesc != null) {
                return this.lockDatabase(lockDatabaseDesc);
            }
            UnlockDatabaseDesc unlockDatabaseDesc = ((DDLWork)this.work).getUnlockDatabaseDesc();
            if (unlockDatabaseDesc != null) {
                return this.unlockDatabase(unlockDatabaseDesc);
            }
            SwitchDatabaseDesc switchDatabaseDesc = ((DDLWork)this.work).getSwitchDatabaseDesc();
            if (switchDatabaseDesc != null) {
                return this.switchDatabase(db, switchDatabaseDesc);
            }
            DescDatabaseDesc descDatabaseDesc = ((DDLWork)this.work).getDescDatabaseDesc();
            if (descDatabaseDesc != null) {
                return this.descDatabase(descDatabaseDesc);
            }
            AlterDatabaseDesc alterDatabaseDesc = ((DDLWork)this.work).getAlterDatabaseDesc();
            if (alterDatabaseDesc != null) {
                return this.alterDatabase(alterDatabaseDesc);
            }
            CreateTableDesc crtTbl = ((DDLWork)this.work).getCreateTblDesc();
            if (crtTbl != null) {
                return this.createTable(db, crtTbl);
            }
            CreateIndexDesc crtIndex = ((DDLWork)this.work).getCreateIndexDesc();
            if (crtIndex != null) {
                return this.createIndex(db, crtIndex);
            }
            AlterIndexDesc alterIndex = ((DDLWork)this.work).getAlterIndexDesc();
            if (alterIndex != null) {
                return this.alterIndex(db, alterIndex);
            }
            DropIndexDesc dropIdx = ((DDLWork)this.work).getDropIdxDesc();
            if (dropIdx != null) {
                return this.dropIndex(db, dropIdx);
            }
            CreateTableLikeDesc crtTblLike = ((DDLWork)this.work).getCreateTblLikeDesc();
            if (crtTblLike != null) {
                return this.createTableLike(db, crtTblLike);
            }
            DropTableDesc dropTbl = ((DDLWork)this.work).getDropTblDesc();
            if (dropTbl != null) {
                this.dropTableOrPartitions(db, dropTbl);
                return 0;
            }
            AlterTableDesc alterTbl = ((DDLWork)this.work).getAlterTblDesc();
            if (alterTbl != null) {
                return this.alterTable(db, alterTbl);
            }
            CreateViewDesc crtView = ((DDLWork)this.work).getCreateViewDesc();
            if (crtView != null) {
                return this.createView(db, crtView);
            }
            AddPartitionDesc addPartitionDesc = ((DDLWork)this.work).getAddPartitionDesc();
            if (addPartitionDesc != null) {
                return this.addPartitions(db, addPartitionDesc);
            }
            RenamePartitionDesc renamePartitionDesc = ((DDLWork)this.work).getRenamePartitionDesc();
            if (renamePartitionDesc != null) {
                return this.renamePartition(db, renamePartitionDesc);
            }
            AlterTableSimpleDesc simpleDesc = ((DDLWork)this.work).getAlterTblSimpleDesc();
            if (simpleDesc != null) {
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.TOUCH) {
                    return this.touch(db, simpleDesc);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.ARCHIVE) {
                    return this.archive(db, simpleDesc, driverContext);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.UNARCHIVE) {
                    return this.unarchive(db, simpleDesc);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.COMPACT) {
                    return this.compact(db, simpleDesc);
                }
            }
            if ((msckDesc = ((DDLWork)this.work).getMsckDesc()) != null) {
                return this.msck(db, msckDesc);
            }
            DescTableDesc descTbl = ((DDLWork)this.work).getDescTblDesc();
            if (descTbl != null) {
                return this.describeTable(db, descTbl);
            }
            DescFunctionDesc descFunc = ((DDLWork)this.work).getDescFunctionDesc();
            if (descFunc != null) {
                return this.describeFunction(descFunc);
            }
            ShowDatabasesDesc showDatabases = ((DDLWork)this.work).getShowDatabasesDesc();
            if (showDatabases != null) {
                return this.showDatabases(db, showDatabases);
            }
            ShowTablesDesc showTbls = ((DDLWork)this.work).getShowTblsDesc();
            if (showTbls != null) {
                return this.showTables(db, showTbls);
            }
            ShowColumnsDesc showCols = ((DDLWork)this.work).getShowColumnsDesc();
            if (showCols != null) {
                return this.showColumns(db, showCols);
            }
            ShowTableStatusDesc showTblStatus = ((DDLWork)this.work).getShowTblStatusDesc();
            if (showTblStatus != null) {
                return this.showTableStatus(db, showTblStatus);
            }
            ShowTblPropertiesDesc showTblProperties = ((DDLWork)this.work).getShowTblPropertiesDesc();
            if (showTblProperties != null) {
                return this.showTableProperties(db, showTblProperties);
            }
            ShowFunctionsDesc showFuncs = ((DDLWork)this.work).getShowFuncsDesc();
            if (showFuncs != null) {
                return this.showFunctions(showFuncs);
            }
            ShowLocksDesc showLocks = ((DDLWork)this.work).getShowLocksDesc();
            if (showLocks != null) {
                return this.showLocks(showLocks);
            }
            ShowCompactionsDesc compactionsDesc = ((DDLWork)this.work).getShowCompactionsDesc();
            if (compactionsDesc != null) {
                return this.showCompactions(compactionsDesc);
            }
            ShowTxnsDesc txnsDesc = ((DDLWork)this.work).getShowTxnsDesc();
            if (txnsDesc != null) {
                return this.showTxns(txnsDesc);
            }
            LockTableDesc lockTbl = ((DDLWork)this.work).getLockTblDesc();
            if (lockTbl != null) {
                return this.lockTable(lockTbl);
            }
            UnlockTableDesc unlockTbl = ((DDLWork)this.work).getUnlockTblDesc();
            if (unlockTbl != null) {
                return this.unlockTable(unlockTbl);
            }
            ShowPartitionsDesc showParts = ((DDLWork)this.work).getShowPartsDesc();
            if (showParts != null) {
                return this.showPartitions(db, showParts);
            }
            ShowCreateTableDesc showCreateTbl = ((DDLWork)this.work).getShowCreateTblDesc();
            if (showCreateTbl != null) {
                return this.showCreateTable(db, showCreateTbl);
            }
            ShowConfDesc showConf = ((DDLWork)this.work).getShowConfDesc();
            if (showConf != null) {
                return this.showConf(db, showConf);
            }
            RoleDDLDesc roleDDLDesc = ((DDLWork)this.work).getRoleDDLDesc();
            if (roleDDLDesc != null) {
                return this.roleDDL(roleDDLDesc);
            }
            GrantDesc grantDesc = ((DDLWork)this.work).getGrantDesc();
            if (grantDesc != null) {
                return this.grantOrRevokePrivileges(grantDesc.getPrincipals(), grantDesc.getPrivileges(), grantDesc.getPrivilegeSubjectDesc(), grantDesc.getGrantor(), grantDesc.getGrantorType(), grantDesc.isGrantOption(), true);
            }
            RevokeDesc revokeDesc = ((DDLWork)this.work).getRevokeDesc();
            if (revokeDesc != null) {
                return this.grantOrRevokePrivileges(revokeDesc.getPrincipals(), revokeDesc.getPrivileges(), revokeDesc.getPrivilegeSubjectDesc(), null, null, revokeDesc.isGrantOption(), false);
            }
            ShowGrantDesc showGrantDesc = ((DDLWork)this.work).getShowGrantDesc();
            if (showGrantDesc != null) {
                return this.showGrants(showGrantDesc);
            }
            GrantRevokeRoleDDL grantOrRevokeRoleDDL = ((DDLWork)this.work).getGrantRevokeRoleDDL();
            if (grantOrRevokeRoleDDL != null) {
                return this.grantOrRevokeRole(grantOrRevokeRoleDDL);
            }
            ShowIndexesDesc showIndexes = ((DDLWork)this.work).getShowIndexesDesc();
            if (showIndexes != null) {
                return this.showIndexes(db, showIndexes);
            }
            AlterTablePartMergeFilesDesc mergeFilesDesc = ((DDLWork)this.work).getMergeFilesDesc();
            if (mergeFilesDesc != null) {
                return this.mergeFiles(db, mergeFilesDesc);
            }
            AlterTableAlterPartDesc alterPartDesc = ((DDLWork)this.work).getAlterTableAlterPartDesc();
            if (alterPartDesc != null) {
                return this.alterTableAlterPart(db, alterPartDesc);
            }
            TruncateTableDesc truncateTableDesc = ((DDLWork)this.work).getTruncateTblDesc();
            if (truncateTableDesc != null) {
                return this.truncateTable(db, truncateTableDesc);
            }
            AlterTableExchangePartition alterTableExchangePartition = ((DDLWork)this.work).getAlterTableExchangePartition();
            if (alterTableExchangePartition != null) {
                return this.exchangeTablePartition(db, alterTableExchangePartition);
            }
        }
        catch (Throwable e) {
            this.failed(e);
            return 1;
        }
        assert (false);
        return 0;
    }

    private void failed(Throwable e) {
        while (e.getCause() != null && e.getClass() == RuntimeException.class) {
            e = e.getCause();
        }
        this.setException(e);
        LOG.error(StringUtils.stringifyException((Throwable)e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int showConf(Hive db, ShowConfDesc showConf) throws Exception {
        HiveConf.ConfVars conf = HiveConf.getConfVars(showConf.getConfName());
        if (conf == null) {
            throw new HiveException("invalid configuration name " + showConf.getConfName());
        }
        String description = conf.getDescription();
        String defaultValue = conf.getDefaultValue();
        try (DataOutputStream output = this.getOutputStream(showConf.getResFile());){
            if (defaultValue != null) {
                output.write(defaultValue.getBytes());
            }
            output.write(9);
            output.write(conf.typeString().getBytes());
            output.write(9);
            if (description != null) {
                output.write(description.replaceAll(" *\n *", " ").getBytes());
            }
            output.write(10);
        }
        return 0;
    }

    private DataOutputStream getOutputStream(Path outputFile) throws Exception {
        FileSystem fs = outputFile.getFileSystem((Configuration)this.conf);
        return fs.create(outputFile);
    }

    private int mergeFiles(Hive db, AlterTablePartMergeFilesDesc mergeFilesDesc) throws HiveException {
        Task task;
        ListBucketingCtx lbCtx = mergeFilesDesc.getLbCtx();
        boolean lbatc = lbCtx == null ? false : lbCtx.isSkewedStoredAsDir();
        int lbd = lbCtx == null ? 0 : lbCtx.calculateListBucketingLevel();
        MergeFileWork mergeWork = new MergeFileWork(mergeFilesDesc.getInputDir(), mergeFilesDesc.getOutputDir(), mergeFilesDesc.getInputFormatClass().getName());
        LinkedHashMap<String, ArrayList<String>> pathToAliases = new LinkedHashMap<String, ArrayList<String>>();
        ArrayList<String> inputDirstr = new ArrayList<String>(1);
        inputDirstr.add(mergeFilesDesc.getInputDir().toString());
        pathToAliases.put(mergeFilesDesc.getInputDir().get(0).toString(), inputDirstr);
        mergeWork.setPathToAliases(pathToAliases);
        mergeWork.setListBucketingCtx(mergeFilesDesc.getLbCtx());
        mergeWork.resolveConcatenateMerge(db.getConf());
        mergeWork.setMapperCannotSpanPartns(true);
        mergeWork.setSourceTableInputFormat(mergeFilesDesc.getInputFormatClass().getName());
        FileMergeDesc fmd = mergeFilesDesc.getInputFormatClass().equals(RCFileInputFormat.class) ? new RCFileMergeDesc() : new OrcFileMergeDesc();
        fmd.setDpCtx(null);
        fmd.setHasDynamicPartitions(false);
        fmd.setListBucketingAlterTableConcatenate(lbatc);
        fmd.setListBucketingDepth(lbd);
        fmd.setOutputPath(mergeFilesDesc.getOutputDir());
        Operator<FileMergeDesc> mergeOp = OperatorFactory.get(fmd, new Operator[0]);
        LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = new LinkedHashMap<String, Operator<? extends OperatorDesc>>();
        aliasToWork.put(mergeFilesDesc.getInputDir().toString(), mergeOp);
        mergeWork.setAliasToWork(aliasToWork);
        DriverContext driverCxt = new DriverContext();
        if (this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
            TezWork tezWork = new TezWork(this.conf.getVar(HiveConf.ConfVars.HIVEQUERYID));
            mergeWork.setName("File Merge");
            tezWork.add(mergeWork);
            task = new TezTask();
            task.setWork(tezWork);
        } else {
            task = new MergeFileTask();
            task.setWork(mergeWork);
        }
        task.initialize(db.getConf(), this.getQueryPlan(), driverCxt);
        int ret = task.execute(driverCxt);
        return ret;
    }

    private HiveAuthorizer getSessionAuthorizer() {
        HiveAuthorizer authorizer = SessionState.get().getAuthorizerV2();
        if (authorizer == null) {
            authorizer = new HiveV1Authorizer(this.conf, this.db);
        }
        return authorizer;
    }

    private int grantOrRevokeRole(GrantRevokeRoleDDL grantOrRevokeRoleDDL) throws HiveException {
        HiveAuthorizer authorizer = this.getSessionAuthorizer();
        HivePrincipal grantorPrinc = null;
        if (grantOrRevokeRoleDDL.getGrantor() != null) {
            grantorPrinc = new HivePrincipal(grantOrRevokeRoleDDL.getGrantor(), AuthorizationUtils.getHivePrincipalType(grantOrRevokeRoleDDL.getGrantorType()));
        }
        List<HivePrincipal> principals = AuthorizationUtils.getHivePrincipals(grantOrRevokeRoleDDL.getPrincipalDesc());
        List<String> roles = grantOrRevokeRoleDDL.getRoles();
        boolean grantOption = grantOrRevokeRoleDDL.isGrantOption();
        if (grantOrRevokeRoleDDL.getGrant()) {
            authorizer.grantRole(principals, roles, grantOption, grantorPrinc);
        } else {
            authorizer.revokeRole(principals, roles, grantOption, grantorPrinc);
        }
        return 0;
    }

    private int showGrants(ShowGrantDesc showGrantDesc) throws HiveException {
        HiveAuthorizer authorizer = this.getSessionAuthorizer();
        try {
            List<HivePrivilegeInfo> privInfos = authorizer.showPrivileges(AuthorizationUtils.getHivePrincipal(showGrantDesc.getPrincipalDesc()), AuthorizationUtils.getHivePrivilegeObject(showGrantDesc.getHiveObj()));
            boolean testMode = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST);
            this.writeToFile(DDLTask.writeGrantInfo(privInfos, testMode), showGrantDesc.getResFile());
        }
        catch (IOException e) {
            throw new HiveException("Error in show grant statement", e);
        }
        return 0;
    }

    private int grantOrRevokePrivileges(List<PrincipalDesc> principals, List<PrivilegeDesc> privileges, PrivilegeObjectDesc privSubjectDesc, String grantor, PrincipalType grantorType, boolean grantOption, boolean isGrant) throws HiveException {
        HiveAuthorizer authorizer = this.getSessionAuthorizer();
        List<HivePrincipal> hivePrincipals = AuthorizationUtils.getHivePrincipals(principals);
        List<HivePrivilege> hivePrivileges = AuthorizationUtils.getHivePrivileges(privileges);
        HivePrivilegeObject hivePrivObject = AuthorizationUtils.getHivePrivilegeObject(privSubjectDesc);
        HivePrincipal grantorPrincipal = new HivePrincipal(grantor, AuthorizationUtils.getHivePrincipalType(grantorType));
        if (isGrant) {
            authorizer.grantPrivileges(hivePrincipals, hivePrivileges, hivePrivObject, grantorPrincipal, grantOption);
        } else {
            authorizer.revokePrivileges(hivePrincipals, hivePrivileges, hivePrivObject, grantorPrincipal, grantOption);
        }
        return 0;
    }

    private int roleDDL(RoleDDLDesc roleDDLDesc) throws Exception {
        HiveAuthorizer authorizer = this.getSessionAuthorizer();
        RoleDDLDesc.RoleOperation operation = roleDDLDesc.getOperation();
        switch (operation) {
            case CREATE_ROLE: {
                authorizer.createRole(roleDDLDesc.getName(), null);
                break;
            }
            case DROP_ROLE: {
                authorizer.dropRole(roleDDLDesc.getName());
                break;
            }
            case SHOW_ROLE_GRANT: {
                boolean testMode = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST);
                List<HiveRoleGrant> roles = authorizer.getRoleGrantInfoForPrincipal(AuthorizationUtils.getHivePrincipal(roleDDLDesc.getName(), roleDDLDesc.getPrincipalType()));
                this.writeToFile(DDLTask.writeRolesGrantedInfo(roles, testMode), roleDDLDesc.getResFile());
                break;
            }
            case SHOW_ROLES: {
                List<String> allRoles = authorizer.getAllRoles();
                this.writeListToFileAfterSort(allRoles, roleDDLDesc.getResFile());
                break;
            }
            case SHOW_CURRENT_ROLE: {
                List<String> roleNames = authorizer.getCurrentRoleNames();
                this.writeListToFileAfterSort(roleNames, roleDDLDesc.getResFile());
                break;
            }
            case SET_ROLE: {
                authorizer.setCurrentRole(roleDDLDesc.getName());
                break;
            }
            case SHOW_ROLE_PRINCIPALS: {
                boolean testMode = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST);
                List<HiveRoleGrant> roleGrants = authorizer.getPrincipalGrantInfoForRole(roleDDLDesc.getName());
                this.writeToFile(this.writeHiveRoleGrantInfo(roleGrants, testMode), roleDDLDesc.getResFile());
                break;
            }
            default: {
                throw new HiveException("Unkown role operation " + operation.getOperationName());
            }
        }
        return 0;
    }

    private String writeHiveRoleGrantInfo(List<HiveRoleGrant> roleGrants, boolean testMode) {
        if (roleGrants == null || roleGrants.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(roleGrants);
        for (HiveRoleGrant roleGrant : roleGrants) {
            DDLTask.appendNonNull(builder, roleGrant.getPrincipalName(), true);
            DDLTask.appendNonNull(builder, roleGrant.getPrincipalType());
            DDLTask.appendNonNull(builder, roleGrant.isGrantOption());
            DDLTask.appendNonNull(builder, roleGrant.getGrantor());
            DDLTask.appendNonNull(builder, roleGrant.getGrantorType());
            DDLTask.appendNonNull(builder, testMode ? -1L : (long)roleGrant.getGrantTime() * 1000L);
        }
        return builder.toString();
    }

    private void writeListToFileAfterSort(List<String> entries, String resFile) throws IOException {
        Collections.sort(entries);
        StringBuilder sb = new StringBuilder();
        for (String entry : entries) {
            DDLTask.appendNonNull(sb, entry, true);
        }
        this.writeToFile(sb.toString(), resFile);
    }

    private int alterDatabase(AlterDatabaseDesc alterDbDesc) throws HiveException {
        String dbName = alterDbDesc.getDatabaseName();
        Database database = this.db.getDatabase(dbName);
        if (database == null) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, dbName);
        }
        switch (alterDbDesc.getAlterType()) {
            case ALTER_PROPERTY: {
                Map<String, String> newParams = alterDbDesc.getDatabaseProperties();
                Map<String, String> params = database.getParameters();
                if (params != null && newParams != null) {
                    params.putAll(newParams);
                    database.setParameters(params);
                    break;
                }
                database.setParameters(newParams);
                break;
            }
            case ALTER_OWNER: {
                database.setOwnerName(alterDbDesc.getOwnerPrincipal().getName());
                database.setOwnerType(alterDbDesc.getOwnerPrincipal().getType());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported alter database type! : " + (Object)((Object)alterDbDesc.getAlterType())));
            }
        }
        this.db.alterDatabase(database.getName(), database);
        return 0;
    }

    private int dropIndex(Hive db, DropIndexDesc dropIdx) throws HiveException {
        db.dropIndex(dropIdx.getTableName(), dropIdx.getIndexName(), dropIdx.isThrowException(), true);
        return 0;
    }

    private int createIndex(Hive db, CreateIndexDesc crtIndex) throws HiveException {
        if (crtIndex.getSerde() != null) {
            this.validateSerDe(crtIndex.getSerde());
        }
        String indexTableName = crtIndex.getIndexTableName();
        if (!Utilities.isDefaultNameNode(this.conf)) {
            this.makeLocationQualified(crtIndex, indexTableName);
        }
        db.createIndex(crtIndex.getTableName(), crtIndex.getIndexName(), crtIndex.getIndexTypeHandlerClass(), crtIndex.getIndexedCols(), crtIndex.getIndexTableName(), crtIndex.getDeferredRebuild(), crtIndex.getInputFormat(), crtIndex.getOutputFormat(), crtIndex.getSerde(), crtIndex.getStorageHandler(), crtIndex.getLocation(), crtIndex.getIdxProps(), crtIndex.getTblProps(), crtIndex.getSerdeProps(), crtIndex.getCollItemDelim(), crtIndex.getFieldDelim(), crtIndex.getFieldEscape(), crtIndex.getLineDelim(), crtIndex.getMapKeyDelim(), crtIndex.getIndexComment());
        if (HiveUtils.getIndexHandler(this.conf, crtIndex.getIndexTypeHandlerClass()).usesIndexTable()) {
            Table indexTable = db.getTable(indexTableName);
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(indexTable, WriteEntity.WriteType.DDL_NO_LOCK));
        }
        return 0;
    }

    private int alterIndex(Hive db, AlterIndexDesc alterIndex) throws HiveException {
        String baseTableName = alterIndex.getBaseTableName();
        String indexName = alterIndex.getIndexName();
        Index idx = db.getIndex(baseTableName, indexName);
        switch (alterIndex.getOp()) {
            case ADDPROPS: {
                idx.getParameters().putAll(alterIndex.getProps());
                break;
            }
            case UPDATETIMESTAMP: {
                try {
                    HashMap<String, String> props = new HashMap<String, String>();
                    HashMap<LinkedHashMap<String, String>, Long> basePartTs = new HashMap<LinkedHashMap<String, String>, Long>();
                    Table baseTbl = db.getTable(baseTableName);
                    if (baseTbl.isPartitioned()) {
                        List<Partition> baseParts = alterIndex.getSpec() != null ? db.getPartitions(baseTbl, alterIndex.getSpec()) : db.getPartitions(baseTbl);
                        if (baseParts != null) {
                            for (Partition p : baseParts) {
                                FileSystem fs = p.getDataLocation().getFileSystem((Configuration)db.getConf());
                                FileStatus fss = fs.getFileStatus(p.getDataLocation());
                                basePartTs.put(p.getSpec(), fss.getModificationTime());
                            }
                        }
                    } else {
                        FileSystem fs = baseTbl.getPath().getFileSystem((Configuration)db.getConf());
                        FileStatus fss = fs.getFileStatus(baseTbl.getPath());
                        basePartTs.put(null, fss.getModificationTime());
                    }
                    for (Map spec : basePartTs.keySet()) {
                        if (spec != null) {
                            props.put(spec.toString(), ((Long)basePartTs.get(spec)).toString());
                            continue;
                        }
                        props.put("base_timestamp", ((Long)basePartTs.get(null)).toString());
                    }
                    idx.getParameters().putAll(props);
                    break;
                }
                catch (HiveException e) {
                    throw new HiveException("ERROR: Failed to update index timestamps");
                }
                catch (IOException e) {
                    throw new HiveException("ERROR: Failed to look up timestamps on filesystem");
                }
            }
            default: {
                this.console.printError("Unsupported Alter commnad");
                return 1;
            }
        }
        if (!this.updateModifiedParameters(idx.getParameters(), this.conf)) {
            return 1;
        }
        try {
            db.alterIndex(baseTableName, indexName, idx);
        }
        catch (InvalidOperationException e) {
            this.console.printError("Invalid alter operation: " + e.getMessage());
            LOG.info("alter index: " + StringUtils.stringifyException((Throwable)((Object)e)));
            return 1;
        }
        catch (HiveException e) {
            this.console.printError("Invalid alter operation: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    private int addPartitions(Hive db, AddPartitionDesc addPartitionDesc) throws HiveException {
        List<Partition> parts = db.createPartitions(addPartitionDesc);
        for (Partition part : parts) {
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(part, WriteEntity.WriteType.INSERT));
        }
        return 0;
    }

    private int renamePartition(Hive db, RenamePartitionDesc renamePartitionDesc) throws HiveException {
        LinkedHashMap<String, String> oldPartSpec;
        Table tbl = db.getTable(renamePartitionDesc.getTableName());
        Partition oldPart = db.getPartition(tbl, oldPartSpec = renamePartitionDesc.getOldPartSpec(), false);
        if (oldPart == null) {
            String partName = FileUtils.makePartName(new ArrayList<String>(oldPartSpec.keySet()), new ArrayList<String>(oldPartSpec.values()));
            throw new HiveException("Rename partition: source partition [" + partName + "] does not exist.");
        }
        Partition part = db.getPartition(tbl, oldPartSpec, false);
        part.setValues(renamePartitionDesc.getNewPartSpec());
        db.renamePartition(tbl, oldPartSpec, part);
        Partition newPart = db.getPartition(tbl, renamePartitionDesc.getNewPartSpec(), false);
        ((DDLWork)this.work).getInputs().add(new ReadEntity(oldPart));
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(newPart, WriteEntity.WriteType.DDL_NO_LOCK));
        return 0;
    }

    /*
     * Exception decompiling
     */
    private int alterTableAlterPart(Hive db, AlterTableAlterPartDesc alterPartitionDesc) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int touch(Hive db, AlterTableSimpleDesc touchDesc) throws HiveException {
        Table tbl = db.getTable(touchDesc.getTableName());
        if (touchDesc.getPartSpec() == null) {
            try {
                db.alterTable(touchDesc.getTableName(), tbl);
            }
            catch (InvalidOperationException e) {
                throw new HiveException("Uable to update table");
            }
            ((DDLWork)this.work).getInputs().add(new ReadEntity(tbl));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        } else {
            Partition part = db.getPartition(tbl, touchDesc.getPartSpec(), false);
            if (part == null) {
                throw new HiveException("Specified partition does not exist");
            }
            try {
                db.alterPartition(touchDesc.getTableName(), part);
            }
            catch (InvalidOperationException e) {
                throw new HiveException((Throwable)((Object)e));
            }
            ((DDLWork)this.work).getInputs().add(new ReadEntity(part));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(part, WriteEntity.WriteType.DDL_NO_LOCK));
        }
        return 0;
    }

    private void setIsArchived(Partition p, boolean state, int level) {
        Map<String, String> params = p.getParameters();
        if (state) {
            params.put("is_archived", "true");
            params.put(ArchiveUtils.ARCHIVING_LEVEL, Integer.toString(level));
        } else {
            params.remove("is_archived");
            params.remove(ArchiveUtils.ARCHIVING_LEVEL);
        }
    }

    private String getOriginalLocation(Partition p) {
        Map<String, String> params = p.getParameters();
        return params.get("original_location");
    }

    private void setOriginalLocation(Partition p, String loc) {
        Map<String, String> params = p.getParameters();
        if (loc == null) {
            params.remove("original_location");
        } else {
            params.put("original_location", loc);
        }
    }

    private void setArchived(Partition p, Path harPath, int level) {
        assert (!ArchiveUtils.isArchived(p));
        this.setIsArchived(p, true, level);
        this.setOriginalLocation(p, p.getLocation());
        p.setLocation(harPath.toString());
    }

    private void setUnArchived(Partition p) {
        assert (ArchiveUtils.isArchived(p));
        String parentDir = this.getOriginalLocation(p);
        this.setIsArchived(p, false, 0);
        this.setOriginalLocation(p, null);
        assert (parentDir != null);
        p.setLocation(parentDir);
    }

    private boolean pathExists(Path p) throws HiveException {
        try {
            FileSystem fs = p.getFileSystem((Configuration)this.conf);
            return fs.exists(p);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void moveDir(FileSystem fs, Path from, Path to) throws HiveException {
        try {
            if (!fs.rename(from, to)) {
                throw new HiveException("Moving " + from + " to " + to + " failed!");
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void deleteDir(Path dir) throws HiveException {
        try {
            Warehouse wh = new Warehouse(this.conf);
            wh.deleteDir(dir, true);
        }
        catch (MetaException e) {
            throw new HiveException((Throwable)((Object)e));
        }
    }

    boolean partitionInCustomLocation(Table tbl, Partition p) throws HiveException {
        String subdir = null;
        try {
            subdir = Warehouse.makePartName(tbl.getPartCols(), p.getValues());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to get partition's directory", (Throwable)((Object)e));
        }
        Path tableDir = tbl.getDataLocation();
        if (tableDir == null) {
            throw new HiveException("Table has no location set");
        }
        String standardLocation = new Path(tableDir, subdir).toString();
        if (ArchiveUtils.isArchived(p)) {
            return !this.getOriginalLocation(p).equals(standardLocation);
        }
        return !p.getLocation().equals(standardLocation);
    }

    private int archive(Hive db, AlterTableSimpleDesc simpleDesc, DriverContext driverContext) throws HiveException {
        Table tbl = db.getTable(simpleDesc.getTableName());
        if (tbl.getTableType() != TableType.MANAGED_TABLE) {
            throw new HiveException("ARCHIVE can only be performed on managed tables");
        }
        LinkedHashMap<String, String> partSpec = simpleDesc.getPartSpec();
        ArchiveUtils.PartSpecInfo partSpecInfo = ArchiveUtils.PartSpecInfo.create(tbl, partSpec);
        List<Partition> partitions = db.getPartitions(tbl, partSpec);
        Path originalDir = null;
        if (partitions.isEmpty()) {
            throw new HiveException("No partition matches the specification");
        }
        if (partSpecInfo.values.size() != tbl.getPartCols().size()) {
            for (Partition p : partitions) {
                if (!this.partitionInCustomLocation(tbl, p)) continue;
                String message = String.format("ARCHIVE cannot run for partition groups with custom locations like %s", p.getLocation());
                throw new HiveException(message);
            }
            originalDir = partSpecInfo.createPath(tbl);
        } else {
            Partition p = partitions.get(0);
            originalDir = ArchiveUtils.isArchived(p) ? new Path(this.getOriginalLocation(p)) : p.getDataLocation();
        }
        Path intermediateArchivedDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ARCHIVED_DIR_SUFFIX);
        Path intermediateOriginalDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ORIGINAL_DIR_SUFFIX);
        this.console.printInfo("intermediate.archived is " + intermediateArchivedDir.toString());
        this.console.printInfo("intermediate.original is " + intermediateOriginalDir.toString());
        String archiveName = "data.har";
        FileSystem fs = null;
        try {
            fs = originalDir.getFileSystem((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        URI archiveUri = new Path(originalDir, archiveName).toUri();
        URI originalUri = ArchiveUtils.addSlash(originalDir.toUri());
        ArchiveUtils.HarPathHelper harHelper = new ArchiveUtils.HarPathHelper(this.conf, archiveUri, originalUri);
        for (Partition p : partitions) {
            if (!ArchiveUtils.isArchived(p)) continue;
            if (ArchiveUtils.getArchivingLevel(p) != partSpecInfo.values.size()) {
                String name = ArchiveUtils.getPartialName(p, ArchiveUtils.getArchivingLevel(p));
                String m = String.format("Conflict with existing archive %s", name);
                throw new HiveException(m);
            }
            throw new HiveException("Partition(s) already archived");
        }
        boolean recovery = false;
        if (this.pathExists(intermediateArchivedDir) || this.pathExists(intermediateOriginalDir)) {
            recovery = true;
            this.console.printInfo("Starting recovery after failed ARCHIVE");
        }
        if (!this.pathExists(intermediateArchivedDir) && !this.pathExists(intermediateOriginalDir)) {
            Path tmpPath = new Path(driverContext.getCtx().getExternalTmpPath(originalDir), "partlevel");
            this.console.printInfo("Creating " + archiveName + " for " + originalDir.toString());
            this.console.printInfo("in " + tmpPath);
            this.console.printInfo("Please wait... (this may take a while)");
            int ret = 0;
            try {
                int maxJobNameLen = this.conf.getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
                String jobname = String.format("Archiving %s@%s", tbl.getTableName(), partSpecInfo.getName());
                jobname = Utilities.abbreviate(jobname, maxJobNameLen - 6);
                this.conf.setVar(HiveConf.ConfVars.HADOOPJOBNAME, jobname);
                HadoopArchives har = new HadoopArchives((Configuration)this.conf);
                ArrayList<String> args = new ArrayList<String>();
                args.add("-archiveName");
                args.add(archiveName);
                args.add("-p");
                args.add(originalDir.toString());
                args.add(tmpPath.toString());
                ret = ToolRunner.run((Tool)har, (String[])args.toArray(new String[0]));
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
            if (ret != 0) {
                throw new HiveException("Error while creating HAR");
            }
            try {
                this.console.printInfo("Moving " + tmpPath + " to " + intermediateArchivedDir);
                if (this.pathExists(intermediateArchivedDir)) {
                    throw new HiveException("The intermediate archive directory already exists.");
                }
                fs.rename(tmpPath, intermediateArchivedDir);
            }
            catch (IOException e) {
                throw new HiveException("Error while moving tmp directory");
            }
        }
        if (this.pathExists(intermediateArchivedDir)) {
            this.console.printInfo("Intermediate archive directory " + intermediateArchivedDir + " already exists. Assuming it contains an archived version of the partition");
        }
        if (!this.pathExists(intermediateOriginalDir)) {
            this.console.printInfo("Moving " + originalDir + " to " + intermediateOriginalDir);
            this.moveDir(fs, originalDir, intermediateOriginalDir);
        } else {
            this.console.printInfo(intermediateOriginalDir + " already exists. " + "Assuming it contains the original files in the partition");
        }
        if (!this.pathExists(originalDir)) {
            this.console.printInfo("Moving " + intermediateArchivedDir + " to " + originalDir);
            this.moveDir(fs, intermediateArchivedDir, originalDir);
        } else {
            this.console.printInfo(originalDir + " already exists. " + "Assuming it contains the archived version of the partition");
        }
        try {
            for (Partition p : partitions) {
                URI originalPartitionUri = ArchiveUtils.addSlash(p.getDataLocation().toUri());
                URI harPartitionDir = harHelper.getHarUri(originalPartitionUri);
                StringBuilder authority = new StringBuilder();
                if (harPartitionDir.getUserInfo() != null) {
                    authority.append(harPartitionDir.getUserInfo()).append("@");
                }
                authority.append(harPartitionDir.getHost());
                if (harPartitionDir.getPort() != -1) {
                    authority.append(":").append(harPartitionDir.getPort());
                }
                Path harPath = new Path(harPartitionDir.getScheme(), authority.toString(), harPartitionDir.getPath());
                this.setArchived(p, harPath, partSpecInfo.values.size());
                db.alterPartition(simpleDesc.getTableName(), p);
            }
        }
        catch (Exception e) {
            throw new HiveException("Unable to change the partition info for HAR", e);
        }
        if (this.pathExists(intermediateOriginalDir)) {
            this.deleteDir(intermediateOriginalDir);
        }
        if (recovery) {
            this.console.printInfo("Recovery after ARCHIVE succeeded");
        }
        return 0;
    }

    private int unarchive(Hive db, AlterTableSimpleDesc simpleDesc) throws HiveException, URISyntaxException {
        Table tbl = db.getTable(simpleDesc.getTableName());
        if (simpleDesc.getPartSpec() == null) {
            throw new HiveException("UNARCHIVE is for partitions only");
        }
        if (tbl.getTableType() != TableType.MANAGED_TABLE) {
            throw new HiveException("UNARCHIVE can only be performed on managed tables");
        }
        LinkedHashMap<String, String> partSpec = simpleDesc.getPartSpec();
        ArchiveUtils.PartSpecInfo partSpecInfo = ArchiveUtils.PartSpecInfo.create(tbl, partSpec);
        List<Partition> partitions = db.getPartitions(tbl, partSpec);
        int partSpecLevel = partSpec.size();
        Path originalDir = null;
        if (partitions.isEmpty()) {
            throw new HiveException("No partition matches the specification");
        }
        if (partSpecInfo.values.size() != tbl.getPartCols().size()) {
            for (Partition p : partitions) {
                if (!this.partitionInCustomLocation(tbl, p)) continue;
                String message = String.format("UNARCHIVE cannot run for partition groups with custom locations like %s", p.getLocation());
                throw new HiveException(message);
            }
            originalDir = partSpecInfo.createPath(tbl);
        } else {
            Partition p = partitions.get(0);
            originalDir = ArchiveUtils.isArchived(p) ? new Path(this.getOriginalLocation(p)) : new Path(p.getLocation());
        }
        URI originalUri = ArchiveUtils.addSlash(originalDir.toUri());
        Path intermediateArchivedDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ARCHIVED_DIR_SUFFIX);
        Path intermediateExtractedDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_EXTRACTED_DIR_SUFFIX);
        boolean recovery = false;
        if (this.pathExists(intermediateArchivedDir) || this.pathExists(intermediateExtractedDir)) {
            recovery = true;
            this.console.printInfo("Starting recovery after failed UNARCHIVE");
        }
        for (Partition p : partitions) {
            this.checkArchiveProperty(partSpecLevel, recovery, p);
        }
        String archiveName = "data.har";
        FileSystem fs = null;
        try {
            fs = originalDir.getFileSystem((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        Path archivePath = new Path(originalDir, archiveName);
        URI archiveUri = archivePath.toUri();
        ArchiveUtils.HarPathHelper harHelper = new ArchiveUtils.HarPathHelper(this.conf, archiveUri, originalUri);
        URI sourceUri = harHelper.getHarUri(originalUri);
        Path sourceDir = new Path(sourceUri.getScheme(), sourceUri.getAuthority(), sourceUri.getPath());
        if (!this.pathExists(intermediateArchivedDir) && !this.pathExists(archivePath)) {
            throw new HiveException("Haven't found any archive where it should be");
        }
        Path tmpPath = this.driverContext.getCtx().getExternalTmpPath(originalDir);
        try {
            fs = tmpPath.getFileSystem((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        if (!this.pathExists(intermediateExtractedDir) && !this.pathExists(intermediateArchivedDir)) {
            try {
                String copySource = sourceDir.toString();
                String copyDest = tmpPath.toString();
                ArrayList<String> args = new ArrayList<String>();
                args.add("-cp");
                args.add(copySource);
                args.add(copyDest);
                this.console.printInfo("Copying " + copySource + " to " + copyDest);
                FileSystem srcFs = FileSystem.get((URI)sourceDir.toUri(), (Configuration)this.conf);
                srcFs.initialize(sourceDir.toUri(), (Configuration)this.conf);
                FsShell fss = new FsShell((Configuration)this.conf);
                int ret = 0;
                try {
                    ret = ToolRunner.run((Tool)fss, (String[])args.toArray(new String[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new HiveException(e);
                }
                if (ret != 0) {
                    throw new HiveException("Error while copying files from archive, return code=" + ret);
                }
                this.console.printInfo("Succefully Copied " + copySource + " to " + copyDest);
                this.console.printInfo("Moving " + tmpPath + " to " + intermediateExtractedDir);
                if (fs.exists(intermediateExtractedDir)) {
                    throw new HiveException("Invalid state: the intermediate extracted directory already exists.");
                }
                fs.rename(tmpPath, intermediateExtractedDir);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
        if (!this.pathExists(intermediateArchivedDir)) {
            try {
                this.console.printInfo("Moving " + originalDir + " to " + intermediateArchivedDir);
                fs.rename(originalDir, intermediateArchivedDir);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        } else {
            this.console.printInfo(intermediateArchivedDir + " already exists. " + "Assuming it contains the archived version of the partition");
        }
        if (!this.pathExists(originalDir)) {
            try {
                this.console.printInfo("Moving " + intermediateExtractedDir + " to " + originalDir);
                fs.rename(intermediateExtractedDir, originalDir);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        } else {
            this.console.printInfo(originalDir + " already exists. " + "Assuming it contains the extracted files in the partition");
        }
        for (Partition p : partitions) {
            this.setUnArchived(p);
            try {
                db.alterPartition(simpleDesc.getTableName(), p);
            }
            catch (InvalidOperationException e) {
                throw new HiveException((Throwable)((Object)e));
            }
        }
        if (this.pathExists(intermediateArchivedDir)) {
            this.deleteDir(intermediateArchivedDir);
        }
        if (recovery) {
            this.console.printInfo("Recovery after UNARCHIVE succeeded");
        }
        return 0;
    }

    private void checkArchiveProperty(int partSpecLevel, boolean recovery, Partition p) throws HiveException {
        if (!ArchiveUtils.isArchived(p) && !recovery) {
            throw new HiveException("Partition " + p.getName() + " is not archived.");
        }
        int archiveLevel = ArchiveUtils.getArchivingLevel(p);
        if (partSpecLevel > archiveLevel) {
            throw new HiveException("Partition " + p.getName() + " is archived at level " + archiveLevel + ", and given partspec only has " + partSpecLevel + " specs.");
        }
    }

    private void msckAddPartitionsOneByOne(Hive db, Table table, List<CheckResult.PartitionResult> partsNotInMs, List<String> repairOutput) {
        for (CheckResult.PartitionResult part : partsNotInMs) {
            try {
                db.createPartition(table, Warehouse.makeSpecFromName(part.getPartitionName()));
                repairOutput.add("Repair: Added partition to metastore " + table.getTableName() + ':' + part.getPartitionName());
            }
            catch (Exception e) {
                LOG.warn("Repair error, could not add partition to metastore: ", e);
            }
        }
    }

    private int compact(Hive db, AlterTableSimpleDesc desc) throws HiveException {
        Table tbl = db.getTable(desc.getTableName());
        String partName = null;
        if (desc.getPartSpec() == null) {
            if (tbl.isPartitioned()) {
                throw new HiveException(ErrorMsg.NO_COMPACTION_PARTITION, new String[0]);
            }
        } else {
            LinkedHashMap<String, String> partSpec = desc.getPartSpec();
            List<Partition> partitions = db.getPartitions(tbl, partSpec);
            if (partitions.size() > 1) {
                throw new HiveException(ErrorMsg.TOO_MANY_COMPACTION_PARTITIONS, new String[0]);
            }
            if (partitions.size() == 0) {
                throw new HiveException(ErrorMsg.INVALID_PARTITION_SPEC, new String[0]);
            }
            partName = partitions.get(0).getName();
        }
        db.compact(tbl.getDbName(), tbl.getTableName(), partName, desc.getCompactionType());
        this.console.printInfo("Compaction enqueued.");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int msck(Hive db, MsckDesc msckDesc) {
        CheckResult result = new CheckResult();
        ArrayList<String> repairOutput = new ArrayList<String>();
        try {
            HiveMetaStoreChecker checker = new HiveMetaStoreChecker(db);
            String[] names = Utilities.getDbTableName(msckDesc.getTableName());
            checker.checkMetastore(names[0], names[1], msckDesc.getPartSpecs(), result);
            List<CheckResult.PartitionResult> partsNotInMs = result.getPartitionsNotInMs();
            if (!msckDesc.isRepairPartitions()) return 0;
            if (partsNotInMs.isEmpty()) return 0;
            Table table = db.getTable(msckDesc.getTableName());
            AddPartitionDesc apd = new AddPartitionDesc(table.getDbName(), table.getTableName(), false);
            try {
                for (CheckResult.PartitionResult part : partsNotInMs) {
                    apd.addPartition(Warehouse.makeSpecFromName(part.getPartitionName()), null);
                    repairOutput.add("Repair: Added partition to metastore " + msckDesc.getTableName() + ':' + part.getPartitionName());
                }
                db.createPartitions(apd);
                return 0;
            }
            catch (Exception e) {
                LOG.info("Could not bulk-add partitions to metastore; trying one by one", e);
                repairOutput.clear();
                this.msckAddPartitionsOneByOne(db, table, partsNotInMs, repairOutput);
                return 0;
            }
        }
        catch (HiveException e) {
            LOG.warn("Failed to run metacheck: ", e);
            int n = 1;
            return n;
        }
        catch (IOException e) {
            LOG.warn("Failed to run metacheck: ", e);
            int n = 1;
            return n;
        }
        finally {
            BufferedWriter resultOut = null;
            try {
                Path resFile = new Path(msckDesc.getResFile());
                FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
                resultOut = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(resFile)));
                boolean firstWritten = false;
                firstWritten |= this.writeMsckResult(result.getTablesNotInMs(), "Tables not in metastore:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getTablesNotOnFs(), "Tables missing on filesystem:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotInMs(), "Partitions not in metastore:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotOnFs(), "Partitions missing from filesystem:", resultOut, firstWritten);
                for (String rout : repairOutput) {
                    if (firstWritten) {
                        resultOut.write(10);
                    } else {
                        firstWritten = true;
                    }
                    resultOut.write(rout);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to save metacheck output: ", e);
                int fs = 1;
                return fs;
            }
            finally {
                if (resultOut != null) {
                    try {
                        resultOut.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to close output file: ", e);
                        return 1;
                    }
                }
            }
        }
    }

    private boolean writeMsckResult(List<? extends Object> result, String msg, Writer out, boolean wrote) throws IOException {
        if (!result.isEmpty()) {
            if (wrote) {
                out.write(10);
            }
            out.write(msg);
            for (Object object : result) {
                out.write(9);
                out.write(object.toString());
            }
            return true;
        }
        return false;
    }

    private int showPartitions(Hive db, ShowPartitionsDesc showParts) throws HiveException {
        String tabName = showParts.getTabName();
        Table tbl = null;
        List<String> parts = null;
        tbl = db.getTable(tabName);
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tabName);
        }
        parts = showParts.getPartSpec() != null ? db.getPartitionNames(tbl.getDbName(), tbl.getTableName(), showParts.getPartSpec(), (short)-1) : db.getPartitionNames(tbl.getDbName(), tbl.getTableName(), (short)-1);
        FSDataOutputStream outStream = null;
        try {
            Path resFile = new Path(showParts.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            outStream = fs.create(resFile);
            this.formatter.showTablePartitons((DataOutputStream)outStream, parts);
            outStream.close();
            outStream = null;
        }
        catch (Exception e) {
            try {
                throw new HiveException(e, ErrorMsg.GENERIC_ERROR, "show partitions for table " + tabName);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(outStream);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)outStream);
        return 0;
    }

    /*
     * Exception decompiling
     */
    private int showCreateTable(Hive db, ShowCreateTableDesc showCreateTbl) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean containsNonNull(String[] values) {
        for (String value : values) {
            if (value == null) continue;
            return true;
        }
        return false;
    }

    private StringBuilder appendSerdeParams(StringBuilder builder, Map<String, String> serdeParam) {
        serdeParam = new TreeMap<String, String>(serdeParam);
        builder.append("WITH SERDEPROPERTIES ( \n");
        ArrayList<String> serdeCols = new ArrayList<String>();
        for (Map.Entry<String, String> entry : serdeParam.entrySet()) {
            serdeCols.add("  '" + entry.getKey() + "'='" + this.escapeHiveCommand(StringEscapeUtils.escapeJava(entry.getValue())) + "'");
        }
        builder.append(com.facebook.presto.hive.$internal.org.apache.commons.lang.StringUtils.join(serdeCols, ", \n")).append(')');
        return builder;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int showIndexes(Hive db, ShowIndexesDesc showIndexes) throws HiveException {
        String tableName = showIndexes.getTableName();
        Table tbl = null;
        List<Index> indexes = null;
        tbl = db.getTable(tableName);
        indexes = db.getIndexes(tbl.getDbName(), tbl.getTableName(), (short)-1);
        FSDataOutputStream outStream = null;
        try {
            Path resFile = new Path(showIndexes.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            outStream = fs.create(resFile);
            if (showIndexes.isFormatted()) {
                outStream.writeBytes(MetaDataFormatUtils.getIndexColumnsHeader());
                outStream.write(10);
                outStream.write(10);
            }
            for (Index index : indexes) {
                outStream.writeBytes(MetaDataFormatUtils.getAllColumnsInformation(index));
            }
            outStream.close();
            outStream = null;
        }
        catch (FileNotFoundException e) {
            try {
                LOG.info("show indexes: " + StringUtils.stringifyException((Throwable)e));
                throw new HiveException(e.toString());
                catch (IOException e2) {
                    LOG.info("show indexes: " + StringUtils.stringifyException((Throwable)e2));
                    throw new HiveException(e2.toString());
                }
                catch (Exception e3) {
                    throw new HiveException(e3.toString());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(outStream);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)outStream);
        return 0;
    }

    private int showDatabases(Hive db, ShowDatabasesDesc showDatabasesDesc) throws HiveException {
        List<String> databases = null;
        if (showDatabasesDesc.getPattern() != null) {
            LOG.info("pattern: " + showDatabasesDesc.getPattern());
            databases = db.getDatabasesByPattern(showDatabasesDesc.getPattern());
        } else {
            databases = db.getAllDatabases();
        }
        LOG.info("results : " + databases.size());
        FSDataOutputStream outStream = null;
        try {
            Path resFile = new Path(showDatabasesDesc.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            outStream = fs.create(resFile);
            this.formatter.showDatabases((DataOutputStream)outStream, databases);
            outStream.close();
            outStream = null;
        }
        catch (Exception e) {
            try {
                throw new HiveException(e, ErrorMsg.GENERIC_ERROR, "show databases");
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(outStream);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)outStream);
        return 0;
    }

    private int showTables(Hive db, ShowTablesDesc showTbls) throws HiveException {
        List<String> tbls = null;
        String dbName = showTbls.getDbName();
        if (!db.databaseExists(dbName)) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, dbName);
        }
        if (showTbls.getPattern() != null) {
            LOG.info("pattern: " + showTbls.getPattern());
            tbls = db.getTablesByPattern(dbName, showTbls.getPattern());
            LOG.info("results : " + tbls.size());
        } else {
            tbls = db.getAllTables(dbName);
        }
        FSDataOutputStream outStream = null;
        try {
            Path resFile = new Path(showTbls.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            outStream = fs.create(resFile);
            TreeSet<String> sortedTbls = new TreeSet<String>(tbls);
            this.formatter.showTables((DataOutputStream)outStream, sortedTbls);
            outStream.close();
            outStream = null;
        }
        catch (Exception e) {
            try {
                throw new HiveException(e, ErrorMsg.GENERIC_ERROR, "in database" + dbName);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(outStream);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)outStream);
        return 0;
    }

    public int showColumns(Hive db, ShowColumnsDesc showCols) throws HiveException {
        Table table = db.getTable(showCols.getTableName());
        FSDataOutputStream outStream = null;
        try {
            Path resFile = new Path(showCols.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            outStream = fs.create(resFile);
            List<FieldSchema> cols = table.getCols();
            cols.addAll(table.getPartCols());
            boolean isOutputPadded = !SessionState.get().isHiveServerQuery();
            outStream.writeBytes(MetaDataFormatUtils.getAllColumnsInformation(cols, false, isOutputPadded, null));
            outStream.close();
            outStream = null;
        }
        catch (IOException e) {
            try {
                throw new HiveException(e, ErrorMsg.GENERIC_ERROR, new String[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(outStream);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)outStream);
        return 0;
    }

    /*
     * Exception decompiling
     */
    private int showFunctions(ShowFunctionsDesc showFuncs) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int showLocks(ShowLocksDesc showLocks) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int showLocksNewFormat(ShowLocksDesc showLocks, HiveLockManager lm) throws HiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int showCompactions(ShowCompactionsDesc desc) throws HiveException {
        ShowCompactResponse rsp = this.db.showCompactions();
        FSDataOutputStream os = null;
        try {
            Path resFile = new Path(desc.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            os = fs.create(resFile);
            os.writeBytes("Database");
            os.write(9);
            os.writeBytes("Table");
            os.write(9);
            os.writeBytes("Partition");
            os.write(9);
            os.writeBytes("Type");
            os.write(9);
            os.writeBytes("State");
            os.write(9);
            os.writeBytes("Worker");
            os.write(9);
            os.writeBytes("Start Time");
            os.write(10);
            if (rsp.getCompacts() != null) {
                for (ShowCompactResponseElement e : rsp.getCompacts()) {
                    os.writeBytes(e.getDbname());
                    os.write(9);
                    os.writeBytes(e.getTablename());
                    os.write(9);
                    String part = e.getPartitionname();
                    os.writeBytes(part == null ? "NULL" : part);
                    os.write(9);
                    os.writeBytes(e.getType().toString());
                    os.write(9);
                    os.writeBytes(e.getState());
                    os.write(9);
                    String wid = e.getWorkerid();
                    os.writeBytes(wid == null ? "NULL" : wid);
                    os.write(9);
                    os.writeBytes(Long.toString(e.getStart()));
                    os.write(10);
                }
            }
            os.close();
        }
        catch (IOException e) {
            int n;
            try {
                LOG.warn("show compactions: " + StringUtils.stringifyException((Throwable)e));
                n = 1;
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(os);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)os);
            return n;
        }
        IOUtils.closeStream((Closeable)os);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int showTxns(ShowTxnsDesc desc) throws HiveException {
        GetOpenTxnsInfoResponse rsp = this.db.showTransactions();
        FSDataOutputStream os = null;
        try {
            Path resFile = new Path(desc.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            os = fs.create(resFile);
            os.writeBytes("Transaction ID");
            os.write(9);
            os.writeBytes("Transaction State");
            os.write(9);
            os.writeBytes("User");
            os.write(9);
            os.writeBytes("Hostname");
            os.write(10);
            for (TxnInfo txn : rsp.getOpen_txns()) {
                os.writeBytes(Long.toString(txn.getId()));
                os.write(9);
                os.writeBytes(txn.getState().toString());
                os.write(9);
                os.writeBytes(txn.getUser());
                os.write(9);
                os.writeBytes(txn.getHostname());
                os.write(10);
            }
            os.close();
        }
        catch (IOException e) {
            int n;
            try {
                LOG.warn("show transactions: " + StringUtils.stringifyException((Throwable)e));
                n = 1;
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(os);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)os);
            return n;
        }
        IOUtils.closeStream((Closeable)os);
        return 0;
    }

    private int lockTable(LockTableDesc lockTbl) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        if (!txnManager.supportsExplicitLock()) {
            throw new HiveException(ErrorMsg.LOCK_REQUEST_UNSUPPORTED, this.conf.getVar(HiveConf.ConfVars.HIVE_TXN_MANAGER));
        }
        HiveLockManager lockMgr = txnManager.getLockManager();
        if (lockMgr == null) {
            throw new HiveException("lock Table LockManager not specified");
        }
        HiveLockMode mode = HiveLockMode.valueOf(lockTbl.getMode());
        String tabName = lockTbl.getTableName();
        Table tbl = this.db.getTable(tabName);
        if (tbl == null) {
            throw new HiveException("Table " + tabName + " does not exist ");
        }
        Map<String, String> partSpec = lockTbl.getPartSpec();
        HiveLockObject.HiveLockObjectData lockData = new HiveLockObject.HiveLockObjectData(lockTbl.getQueryId(), String.valueOf(System.currentTimeMillis()), "EXPLICIT", lockTbl.getQueryStr());
        if (partSpec == null) {
            HiveLock lck = lockMgr.lock(new HiveLockObject(tbl, lockData), mode, true);
            if (lck == null) {
                return 1;
            }
            return 0;
        }
        Partition par = this.db.getPartition(tbl, partSpec, false);
        if (par == null) {
            throw new HiveException("Partition " + partSpec + " for table " + tabName + " does not exist");
        }
        HiveLock lck = lockMgr.lock(new HiveLockObject(par, lockData), mode, true);
        if (lck == null) {
            return 1;
        }
        return 0;
    }

    private int lockDatabase(LockDatabaseDesc lockDb) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        if (!txnManager.supportsExplicitLock()) {
            throw new HiveException(ErrorMsg.LOCK_REQUEST_UNSUPPORTED, this.conf.getVar(HiveConf.ConfVars.HIVE_TXN_MANAGER));
        }
        HiveLockManager lockMgr = txnManager.getLockManager();
        if (lockMgr == null) {
            throw new HiveException("lock Database LockManager not specified");
        }
        HiveLockMode mode = HiveLockMode.valueOf(lockDb.getMode());
        String dbName = lockDb.getDatabaseName();
        Database dbObj = this.db.getDatabase(dbName);
        if (dbObj == null) {
            throw new HiveException("Database " + dbName + " does not exist ");
        }
        HiveLockObject.HiveLockObjectData lockData = new HiveLockObject.HiveLockObjectData(lockDb.getQueryId(), String.valueOf(System.currentTimeMillis()), "EXPLICIT", lockDb.getQueryStr());
        HiveLock lck = lockMgr.lock(new HiveLockObject(dbObj.getName(), lockData), mode, true);
        if (lck == null) {
            return 1;
        }
        return 0;
    }

    private int unlockDatabase(UnlockDatabaseDesc unlockDb) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        if (!txnManager.supportsExplicitLock()) {
            throw new HiveException(ErrorMsg.LOCK_REQUEST_UNSUPPORTED, this.conf.getVar(HiveConf.ConfVars.HIVE_TXN_MANAGER));
        }
        HiveLockManager lockMgr = txnManager.getLockManager();
        if (lockMgr == null) {
            throw new HiveException("unlock Database LockManager not specified");
        }
        String dbName = unlockDb.getDatabaseName();
        Database dbObj = this.db.getDatabase(dbName);
        if (dbObj == null) {
            throw new HiveException("Database " + dbName + " does not exist ");
        }
        HiveLockObject obj = new HiveLockObject(dbObj.getName(), null);
        List<HiveLock> locks = lockMgr.getLocks(obj, false, false);
        if (locks == null || locks.isEmpty()) {
            throw new HiveException("Database " + dbName + " is not locked ");
        }
        for (HiveLock lock2 : locks) {
            lockMgr.unlock(lock2);
        }
        return 0;
    }

    private HiveLockObject getHiveObject(String tabName, Map<String, String> partSpec) throws HiveException {
        Table tbl = this.db.getTable(tabName);
        if (tbl == null) {
            throw new HiveException("Table " + tabName + " does not exist ");
        }
        HiveLockObject obj = null;
        if (partSpec == null) {
            obj = new HiveLockObject(tbl, null);
        } else {
            Partition par = this.db.getPartition(tbl, partSpec, false);
            if (par == null) {
                throw new HiveException("Partition " + partSpec + " for table " + tabName + " does not exist");
            }
            obj = new HiveLockObject(par, null);
        }
        return obj;
    }

    private int unlockTable(UnlockTableDesc unlockTbl) throws HiveException {
        Context ctx = this.driverContext.getCtx();
        HiveTxnManager txnManager = ctx.getHiveTxnManager();
        if (!txnManager.supportsExplicitLock()) {
            throw new HiveException(ErrorMsg.LOCK_REQUEST_UNSUPPORTED, this.conf.getVar(HiveConf.ConfVars.HIVE_TXN_MANAGER));
        }
        HiveLockManager lockMgr = txnManager.getLockManager();
        if (lockMgr == null) {
            throw new HiveException("unlock Table LockManager not specified");
        }
        String tabName = unlockTbl.getTableName();
        HiveLockObject obj = this.getHiveObject(tabName, unlockTbl.getPartSpec());
        List<HiveLock> locks = lockMgr.getLocks(obj, false, false);
        if (locks == null || locks.isEmpty()) {
            throw new HiveException("Table " + tabName + " is not locked ");
        }
        for (HiveLock lock2 : locks) {
            lockMgr.unlock(lock2);
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    private int describeFunction(DescFunctionDesc descFunc) throws HiveException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int descDatabase(DescDatabaseDesc descDatabase) throws HiveException {
        FSDataOutputStream outStream = null;
        try {
            Path resFile = new Path(descDatabase.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            outStream = fs.create(resFile);
            Database database = this.db.getDatabase(descDatabase.getDatabaseName());
            if (database == null) {
                throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, descDatabase.getDatabaseName());
            }
            Map<String, String> params = null;
            if (descDatabase.isExt()) {
                params = database.getParameters();
            }
            if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_IN_TEST) && params != null) {
                params = new TreeMap<String, String>(params);
            }
            String location = database.getLocationUri();
            if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_IN_TEST)) {
                location = "location/in/test";
            }
            PrincipalType ownerType = database.getOwnerType();
            this.formatter.showDatabaseDescription((DataOutputStream)outStream, database.getName(), database.getDescription(), location, database.getOwnerName(), null == ownerType ? null : ownerType.name(), params);
            outStream.close();
            outStream = null;
        }
        catch (IOException e) {
            try {
                throw new HiveException(e, ErrorMsg.GENERIC_ERROR, new String[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(outStream);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)outStream);
        return 0;
    }

    private int showTableStatus(Hive db, ShowTableStatusDesc showTblStatus) throws HiveException {
        ArrayList<Table> tbls = new ArrayList<Table>();
        HashMap<String, String> part = showTblStatus.getPartSpec();
        Partition par = null;
        if (part != null) {
            Table tbl = db.getTable(showTblStatus.getDbName(), showTblStatus.getPattern());
            par = db.getPartition(tbl, part, false);
            if (par == null) {
                throw new HiveException("Partition " + part + " for table " + showTblStatus.getPattern() + " does not exist.");
            }
            tbls.add(tbl);
        } else {
            LOG.info("pattern: " + showTblStatus.getPattern());
            List<String> tblStr = db.getTablesForDb(showTblStatus.getDbName(), showTblStatus.getPattern());
            TreeSet<String> sortedTbls = new TreeSet<String>(tblStr);
            for (String tblName : sortedTbls) {
                Table tbl = db.getTable(showTblStatus.getDbName(), tblName);
                tbls.add(tbl);
            }
            LOG.info("results : " + tblStr.size());
        }
        FSDataOutputStream outStream = null;
        try {
            Path resFile = new Path(showTblStatus.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            outStream = fs.create(resFile);
            this.formatter.showTableStatus((DataOutputStream)outStream, db, this.conf, tbls, part, par);
            outStream.close();
            outStream = null;
        }
        catch (Exception e) {
            try {
                throw new HiveException(e, ErrorMsg.GENERIC_ERROR, "show table status");
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(outStream);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)outStream);
        return 0;
    }

    private int showTableProperties(Hive db, ShowTblPropertiesDesc showTblPrpt) throws HiveException {
        String tableName = showTblPrpt.getTableName();
        Table tbl = db.getTable(tableName, false);
        try {
            if (tbl == null) {
                String errMsg = "Table " + tableName + " does not exist";
                this.writeToFile(errMsg, showTblPrpt.getResFile());
                return 0;
            }
            LOG.info("DDLTask: show properties for " + tbl.getTableName());
            StringBuilder builder = new StringBuilder();
            String propertyName = showTblPrpt.getPropertyName();
            if (propertyName != null) {
                String propertyValue = tbl.getProperty(propertyName);
                if (propertyValue == null) {
                    String errMsg = "Table " + tableName + " does not have property: " + propertyName;
                    builder.append(errMsg);
                } else {
                    builder.append(propertyValue);
                }
            } else {
                TreeMap<String, String> properties = new TreeMap<String, String>(tbl.getParameters());
                for (Map.Entry entry : properties.entrySet()) {
                    DDLTask.appendNonNull(builder, entry.getKey(), true);
                    DDLTask.appendNonNull(builder, entry.getValue());
                }
            }
            LOG.info("DDLTask: written data for showing properties of " + tbl.getTableName());
            this.writeToFile(builder.toString(), showTblPrpt.getResFile());
        }
        catch (FileNotFoundException e) {
            LOG.info("show table properties: " + StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        catch (IOException e) {
            LOG.info("show table properties: " + StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String data, String file) throws IOException {
        Path resFile = new Path(file);
        FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
        FSDataOutputStream out = fs.create(resFile);
        try {
            if (data != null && !data.isEmpty()) {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                writer.write(data);
                writer.write(10);
                writer.flush();
            }
        }
        finally {
            IOUtils.closeStream((Closeable)out);
        }
    }

    private int describeTable(Hive db, DescTableDesc descTbl) throws HiveException {
        Path resFile;
        String colPath = descTbl.getColumnPath();
        String tableName = descTbl.getTableName();
        Table tbl = db.getTable(tableName, false);
        Partition part = null;
        FSDataOutputStream outStream = null;
        try {
            resFile = new Path(descTbl.getResFile());
            if (tbl == null) {
                FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
                outStream = fs.create(resFile);
                outStream.close();
                outStream = null;
                throw new HiveException(ErrorMsg.INVALID_TABLE, tableName);
            }
            if (descTbl.getPartSpec() != null) {
                part = db.getPartition(tbl, descTbl.getPartSpec(), false);
                if (part == null) {
                    FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
                    outStream = fs.create(resFile);
                    outStream.close();
                    outStream = null;
                    throw new HiveException(ErrorMsg.INVALID_PARTITION, com.facebook.presto.hive.$internal.org.apache.commons.lang.StringUtils.join(descTbl.getPartSpec().keySet(), ','), tableName);
                }
                tbl = part.getTable();
            }
        }
        catch (IOException e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR, tableName);
        }
        finally {
            IOUtils.closeStream(outStream);
        }
        try {
            String errorMsgs;
            LOG.info("DDLTask: got data for " + tbl.getTableName());
            resFile = new Path(descTbl.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            outStream = fs.create(resFile);
            List<FieldSchema> cols = null;
            List<ColumnStatisticsObj> colStats = null;
            Deserializer deserializer = tbl.getDeserializer(true);
            if (deserializer instanceof AbstractSerDe && (errorMsgs = ((AbstractSerDe)deserializer).getConfigurationErrors()) != null && !errorMsgs.isEmpty()) {
                throw new SQLException(errorMsgs);
            }
            if (colPath.equals(tableName)) {
                List<FieldSchema> list = cols = part == null || tbl.getTableType() == TableType.VIRTUAL_VIEW ? tbl.getCols() : part.getCols();
                if (!descTbl.isFormatted()) {
                    cols.addAll(tbl.getPartCols());
                }
            } else {
                cols = Hive.getFieldsFromDeserializer(colPath, deserializer);
                if (descTbl.isFormatted()) {
                    String colName = colPath.split("\\.")[1];
                    String[] dbTab = Utilities.getDbTableName(tableName);
                    ArrayList<String> colNames = new ArrayList<String>();
                    colNames.add(colName.toLowerCase());
                    if (null == part) {
                        colStats = db.getTableColumnStatistics(dbTab[0].toLowerCase(), dbTab[1].toLowerCase(), colNames);
                    } else {
                        ArrayList<String> partitions = new ArrayList<String>();
                        partitions.add(part.getName());
                        colStats = db.getPartitionColumnStatistics(dbTab[0].toLowerCase(), dbTab[1].toLowerCase(), partitions, colNames).get(part.getName());
                    }
                }
            }
            DDLTask.fixDecimalColumnTypeName(cols);
            boolean isOutputPadded = !SessionState.get().isHiveServerQuery();
            this.formatter.describeTable((DataOutputStream)outStream, colPath, tableName, tbl, part, cols, descTbl.isFormatted(), descTbl.isExt(), descTbl.isPretty(), isOutputPadded, colStats);
            LOG.info("DDLTask: written data for " + tbl.getTableName());
            outStream.close();
            outStream = null;
        }
        catch (SQLException e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR, tableName);
        }
        catch (IOException e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR, tableName);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }

    private static void fixDecimalColumnTypeName(List<FieldSchema> cols) {
        for (FieldSchema col : cols) {
            if (!"decimal".equals(col.getType())) continue;
            col.setType(DecimalTypeInfo.getQualifiedName(10, 0));
        }
    }

    static String writeGrantInfo(List<HivePrivilegeInfo> privileges, boolean testMode) {
        if (privileges == null || privileges.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(privileges, new Comparator<HivePrivilegeInfo>(){

            @Override
            public int compare(HivePrivilegeInfo o1, HivePrivilegeInfo o2) {
                int compare = o1.getObject().compareTo(o2.getObject());
                if (compare == 0) {
                    compare = o1.getPrincipal().compareTo(o2.getPrincipal());
                }
                if (compare == 0) {
                    compare = o1.getPrivilege().compareTo(o2.getPrivilege());
                }
                return compare;
            }
        });
        for (HivePrivilegeInfo privilege : privileges) {
            HivePrincipal principal = privilege.getPrincipal();
            HivePrivilegeObject resource = privilege.getObject();
            HivePrincipal grantor = privilege.getGrantorPrincipal();
            DDLTask.appendNonNull(builder, resource.getDbname(), true);
            DDLTask.appendNonNull(builder, resource.getObjectName());
            DDLTask.appendNonNull(builder, resource.getPartKeys());
            DDLTask.appendNonNull(builder, resource.getColumns());
            DDLTask.appendNonNull(builder, principal.getName());
            DDLTask.appendNonNull(builder, (Object)principal.getType());
            DDLTask.appendNonNull(builder, privilege.getPrivilege().getName());
            DDLTask.appendNonNull(builder, privilege.isGrantOption());
            DDLTask.appendNonNull(builder, testMode ? -1L : (long)privilege.getGrantTime() * 1000L);
            DDLTask.appendNonNull(builder, grantor.getName());
        }
        return builder.toString();
    }

    static String writeRoleGrantsInfo(List<RolePrincipalGrant> roleGrants, boolean testMode) {
        if (roleGrants == null || roleGrants.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(roleGrants);
        for (RolePrincipalGrant roleGrant : roleGrants) {
            DDLTask.appendNonNull(builder, roleGrant.getRoleName(), true);
            DDLTask.appendNonNull(builder, roleGrant.isGrantOption());
            DDLTask.appendNonNull(builder, testMode ? -1L : (long)roleGrant.getGrantTime() * 1000L);
            DDLTask.appendNonNull(builder, roleGrant.getGrantorName());
        }
        return builder.toString();
    }

    static String writeRolesGrantedInfo(List<HiveRoleGrant> roles, boolean testMode) {
        if (roles == null || roles.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(roles);
        for (HiveRoleGrant role : roles) {
            DDLTask.appendNonNull(builder, role.getRoleName(), true);
            DDLTask.appendNonNull(builder, role.isGrantOption());
            DDLTask.appendNonNull(builder, testMode ? -1L : (long)role.getGrantTime() * 1000L);
            DDLTask.appendNonNull(builder, role.getGrantor());
        }
        return builder.toString();
    }

    static StringBuilder appendNonNull(StringBuilder builder, Object value) {
        return DDLTask.appendNonNull(builder, value, false);
    }

    static StringBuilder appendNonNull(StringBuilder builder, Object value, boolean firstColumn) {
        if (!firstColumn) {
            builder.append('\t');
        } else if (builder.length() > 0) {
            builder.append('\n');
        }
        if (value != null) {
            builder.append(value);
        }
        return builder;
    }

    private void setAlterProtectMode(boolean protectModeEnable, AlterTableDesc.ProtectModeType protectMode, ProtectMode mode) {
        if (protectMode == AlterTableDesc.ProtectModeType.OFFLINE) {
            mode.offline = protectModeEnable;
        } else if (protectMode == AlterTableDesc.ProtectModeType.NO_DROP) {
            mode.noDrop = protectModeEnable;
        } else if (protectMode == AlterTableDesc.ProtectModeType.NO_DROP_CASCADE) {
            mode.noDropCascade = protectModeEnable;
        }
    }

    private int alterTable(Hive db, AlterTableDesc alterTbl) throws HiveException {
        Table tbl = db.getTable(alterTbl.getOldName());
        List<Object> allPartitions = null;
        if (alterTbl.getPartSpec() != null) {
            HashMap<String, String> partSpec = alterTbl.getPartSpec();
            if (DDLSemanticAnalyzer.isFullSpec(tbl, partSpec)) {
                allPartitions = new ArrayList();
                Partition part = db.getPartition(tbl, partSpec, false);
                if (part == null) {
                    throw new HiveException(ErrorMsg.INVALID_PARTITION, com.facebook.presto.hive.$internal.org.apache.commons.lang.StringUtils.join(alterTbl.getPartSpec().keySet(), ',') + " for table " + alterTbl.getOldName());
                }
                allPartitions.add(part);
            } else {
                allPartitions = db.getPartitions(tbl, alterTbl.getPartSpec());
            }
        }
        Table oldTbl = tbl.copy();
        if (allPartitions != null) {
            for (Partition partition : allPartitions) {
                this.alterTableOrSinglePartition(alterTbl, tbl, partition);
            }
        } else {
            this.alterTableOrSinglePartition(alterTbl, tbl, null);
        }
        if (allPartitions == null) {
            this.updateModifiedParameters(tbl.getTTable().getParameters(), this.conf);
            tbl.checkValidity();
        } else {
            for (Partition partition : allPartitions) {
                this.updateModifiedParameters(partition.getParameters(), this.conf);
            }
        }
        try {
            if (allPartitions == null) {
                db.alterTable(alterTbl.getOldName(), tbl, alterTbl.getIsCascade());
            } else {
                db.alterPartitions(tbl.getTableName(), allPartitions);
            }
        }
        catch (InvalidOperationException e) {
            LOG.error("alter table: " + StringUtils.stringifyException((Throwable)((Object)e)));
            throw new HiveException((Throwable)((Object)e), ErrorMsg.GENERIC_ERROR, new String[0]);
        }
        if (allPartitions != null) {
            for (Partition partition : allPartitions) {
                ((DDLWork)this.work).getInputs().add(new ReadEntity(partition));
                ((DDLWork)this.work).getOutputs().add(new WriteEntity(partition, WriteEntity.WriteType.DDL_NO_LOCK));
            }
        } else {
            ((DDLWork)this.work).getInputs().add(new ReadEntity(oldTbl));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        }
        return 0;
    }

    private int alterTableOrSinglePartition(AlterTableDesc alterTbl, Table tbl, Partition part) throws HiveException {
        if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.RENAME) {
            tbl.setDbName(Utilities.getDatabaseName(alterTbl.getNewName()));
            tbl.setTableName(Utilities.getTableName(alterTbl.getNewName()));
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDCOLS) {
            List<FieldSchema> oldCols = part == null ? tbl.getCols() : part.getCols();
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            ArrayList<FieldSchema> newCols = alterTbl.getNewCols();
            String serializationLib = sd.getSerdeInfo().getSerializationLib();
            if (serializationLib.equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
                this.console.printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
                sd.getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
                sd.setCols(newCols);
            } else {
                for (FieldSchema newCol : newCols) {
                    String newColName = newCol.getName();
                    Iterator<FieldSchema> iterOldCols = oldCols.iterator();
                    while (iterOldCols.hasNext()) {
                        String oldColName = iterOldCols.next().getName();
                        if (!oldColName.equalsIgnoreCase(newColName)) continue;
                        throw new HiveException(ErrorMsg.DUPLICATE_COLUMN_NAMES, newColName);
                    }
                    oldCols.add(newCol);
                }
                sd.setCols(oldCols);
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.RENAMECOLUMN) {
            List<FieldSchema> oldCols = part == null ? tbl.getCols() : part.getCols();
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            ArrayList<FieldSchema> newCols = new ArrayList<FieldSchema>();
            Iterator<FieldSchema> iterOldCols = oldCols.iterator();
            String oldName = alterTbl.getOldColName();
            String newName = alterTbl.getNewColName();
            String type = alterTbl.getNewColType();
            String comment = alterTbl.getNewColComment();
            boolean first = alterTbl.getFirst();
            String afterCol = alterTbl.getAfterCol();
            FieldSchema column = null;
            boolean found = false;
            int position = -1;
            if (first) {
                position = 0;
            }
            int i = 1;
            while (iterOldCols.hasNext()) {
                FieldSchema col = iterOldCols.next();
                String oldColName = col.getName();
                if (oldColName.equalsIgnoreCase(newName) && !oldColName.equalsIgnoreCase(oldName)) {
                    throw new HiveException(ErrorMsg.DUPLICATE_COLUMN_NAMES, newName);
                }
                if (oldColName.equalsIgnoreCase(oldName)) {
                    col.setName(newName);
                    if (type != null && !type.trim().equals("")) {
                        col.setType(type);
                    }
                    if (comment != null) {
                        col.setComment(comment);
                    }
                    found = true;
                    if (first || afterCol != null && !afterCol.trim().equals("")) {
                        column = col;
                        continue;
                    }
                }
                if (afterCol != null && !afterCol.trim().equals("") && oldColName.equalsIgnoreCase(afterCol)) {
                    position = i;
                }
                ++i;
                newCols.add(col);
            }
            if (!found) {
                throw new HiveException(ErrorMsg.INVALID_COLUMN, oldName);
            }
            if (afterCol != null && !afterCol.trim().equals("") && position < 0) {
                throw new HiveException(ErrorMsg.INVALID_COLUMN, afterCol);
            }
            if (position >= 0) {
                newCols.add(position, column);
            }
            sd.setCols(newCols);
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.REPLACECOLS) {
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            String serializationLib = sd.getSerdeInfo().getSerializationLib();
            if (serializationLib.equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
                this.console.printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
                sd.getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
            } else if (!(serializationLib.equals(MetadataTypedColumnsetSerDe.class.getName()) || serializationLib.equals(LazySimpleSerDe.class.getName()) || serializationLib.equals(ColumnarSerDe.class.getName()) || serializationLib.equals(DynamicSerDe.class.getName()) || serializationLib.equals(ParquetHiveSerDe.class.getName()))) {
                throw new HiveException(ErrorMsg.CANNOT_REPLACE_COLUMNS, alterTbl.getOldName());
            }
            sd.setCols(alterTbl.getNewCols());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDPROPS) {
            tbl.getTTable().getParameters().putAll(alterTbl.getProps());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.DROPPROPS) {
            Iterator<String> keyItr = alterTbl.getProps().keySet().iterator();
            while (keyItr.hasNext()) {
                tbl.getTTable().getParameters().remove(keyItr.next());
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSERDEPROPS) {
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            sd.getSerdeInfo().getParameters().putAll(alterTbl.getProps());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSERDE) {
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            String serdeName = alterTbl.getSerdeName();
            sd.getSerdeInfo().setSerializationLib(serdeName);
            if (alterTbl.getProps() != null && alterTbl.getProps().size() > 0) {
                sd.getSerdeInfo().getParameters().putAll(alterTbl.getProps());
            }
            if (part != null) {
                part.getTPartition().getSd().setCols(part.getTPartition().getSd().getCols());
            } else if (!Table.hasMetastoreBasedSchema(this.conf, serdeName)) {
                tbl.setFields(Hive.getFieldsFromDeserializer(tbl.getTableName(), tbl.getDeserializer()));
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDFILEFORMAT) {
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            sd.setInputFormat(alterTbl.getInputFormat());
            sd.setOutputFormat(alterTbl.getOutputFormat());
            if (alterTbl.getSerdeName() != null) {
                sd.getSerdeInfo().setSerializationLib(alterTbl.getSerdeName());
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERPROTECTMODE) {
            boolean protectModeEnable = alterTbl.isProtectModeEnable();
            AlterTableDesc.ProtectModeType protectMode = alterTbl.getProtectModeType();
            ProtectMode mode = null;
            if (part != null) {
                mode = part.getProtectMode();
                this.setAlterProtectMode(protectModeEnable, protectMode, mode);
                part.setProtectMode(mode);
            } else {
                mode = tbl.getProtectMode();
                this.setAlterProtectMode(protectModeEnable, protectMode, mode);
                tbl.setProtectMode(mode);
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDCLUSTERSORTCOLUMN) {
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            List<String> columns = Utilities.getColumnNamesFromFieldSchema(tbl.getCols());
            if (!alterTbl.isTurnOffSorting()) {
                Utilities.validateColumnNames(columns, alterTbl.getBucketColumns());
            }
            if (alterTbl.getSortColumns() != null) {
                Utilities.validateColumnNames(columns, Utilities.getColumnNamesFromSortCols(alterTbl.getSortColumns()));
            }
            if (alterTbl.isTurnOffSorting()) {
                sd.setSortCols(new ArrayList<Order>());
            } else if (alterTbl.getNumberBuckets() == -1) {
                sd.setBucketCols(new ArrayList<String>());
                sd.setNumBuckets(-1);
                sd.setSortCols(new ArrayList<Order>());
            } else {
                sd.setBucketCols(alterTbl.getBucketColumns());
                sd.setNumBuckets(alterTbl.getNumberBuckets());
                sd.setSortCols(alterTbl.getSortColumns());
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERLOCATION) {
            StorageDescriptor sd = part == null ? tbl.getTTable().getSd() : part.getTPartition().getSd();
            String newLocation = alterTbl.getNewLocation();
            try {
                URI locUri = new URI(newLocation);
                if (!locUri.isAbsolute() || locUri.getScheme() == null || locUri.getScheme().trim().equals("")) {
                    throw new HiveException(ErrorMsg.BAD_LOCATION_VALUE, newLocation);
                }
                sd.setLocation(newLocation);
            }
            catch (URISyntaxException e) {
                throw new HiveException(e);
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSKEWEDBY) {
            List<String> skewedColNames = null;
            List<List<String>> skewedValues = null;
            if (alterTbl.isTurnOffSkewed()) {
                skewedColNames = new ArrayList<String>();
                skewedValues = new ArrayList<List<String>>();
            } else {
                skewedColNames = alterTbl.getSkewedColNames();
                skewedValues = alterTbl.getSkewedColValues();
            }
            if (null == tbl.getSkewedInfo()) {
                SkewedInfo skewedInfo = new SkewedInfo();
                skewedInfo.setSkewedColNames(skewedColNames);
                skewedInfo.setSkewedColValues(skewedValues);
                tbl.setSkewedInfo(skewedInfo);
            } else {
                tbl.setSkewedColNames(skewedColNames);
                tbl.setSkewedColValues(skewedValues);
            }
            tbl.setStoredAsSubDirectories(alterTbl.isStoredAsSubDirectories());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERSKEWEDLOCATION) {
            Map<List<String>, String> locMaps = alterTbl.getSkewedLocations();
            Set<List<String>> keys = locMaps.keySet();
            for (List<String> key : keys) {
                String newLocation = locMaps.get(key);
                try {
                    ArrayList<String> slk;
                    URI locUri = new URI(newLocation);
                    if (part != null) {
                        slk = new ArrayList<String>(key);
                        part.setSkewedValueLocationMap(slk, locUri.toString());
                        continue;
                    }
                    slk = new ArrayList<String>(key);
                    tbl.setSkewedValueLocationMap(slk, locUri.toString());
                }
                catch (URISyntaxException e) {
                    throw new HiveException(e);
                }
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ALTERBUCKETNUM) {
            if (part != null) {
                if (part.getBucketCount() == alterTbl.getNumberBuckets()) {
                    return 0;
                }
                part.setBucketCount(alterTbl.getNumberBuckets());
            } else {
                if (tbl.getNumBuckets() == alterTbl.getNumberBuckets()) {
                    return 0;
                }
                tbl.setNumBuckets(alterTbl.getNumberBuckets());
            }
        } else {
            throw new HiveException(ErrorMsg.UNSUPPORTED_ALTER_TBL_OP, alterTbl.getOp().toString());
        }
        return 0;
    }

    private void dropTableOrPartitions(Hive db, DropTableDesc dropTbl) throws HiveException {
        Table tbl = null;
        try {
            tbl = db.getTable(dropTbl.getTableName());
        }
        catch (InvalidTableException invalidTableException) {
            // empty catch block
        }
        if (dropTbl.getPartSpecs() == null) {
            this.dropTable(db, tbl, dropTbl);
        } else {
            this.dropPartitions(db, tbl, dropTbl);
        }
    }

    private void dropPartitions(Hive db, Table tbl, DropTableDesc dropTbl) throws HiveException {
        ReplicationSpec replicationSpec = dropTbl.getReplicationSpec();
        if (replicationSpec.isInReplicationScope()) {
            for (DropTableDesc.PartSpec partSpec : dropTbl.getPartSpecs()) {
                try {
                    for (Partition p : Iterables.filter(db.getPartitionsByFilter(tbl, partSpec.getPartSpec().getExprString()), replicationSpec.allowEventReplacementInto())) {
                        db.dropPartition(tbl.getDbName(), tbl.getTableName(), p.getValues(), true);
                    }
                }
                catch (NoSuchObjectException noSuchObjectException) {
                }
                catch (Exception e) {
                    throw new HiveException(e.getMessage(), e);
                }
            }
            return;
        }
        List<Partition> droppedParts = db.dropPartitions(dropTbl.getTableName(), dropTbl.getPartSpecs(), PartitionDropOptions.instance().deleteData(true).ignoreProtection(dropTbl.getIgnoreProtection()).ifExists(true).purgeData(dropTbl.getIfPurge()));
        for (Partition partition : droppedParts) {
            this.console.printInfo("Dropped the partition " + partition.getName());
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(partition, WriteEntity.WriteType.DDL_NO_LOCK));
        }
    }

    private void dropTable(Hive db, Table tbl, DropTableDesc dropTbl) throws HiveException {
        if (tbl != null) {
            if (tbl.isView()) {
                if (!dropTbl.getExpectView()) {
                    if (dropTbl.getIfExists()) {
                        return;
                    }
                    throw new HiveException("Cannot drop a view with DROP TABLE");
                }
            } else if (dropTbl.getExpectView()) {
                if (dropTbl.getIfExists()) {
                    return;
                }
                throw new HiveException("Cannot drop a base table with DROP VIEW");
            }
        }
        if (tbl != null && !tbl.canDrop()) {
            throw new HiveException("Table " + tbl.getTableName() + " is protected from being dropped");
        }
        ReplicationSpec replicationSpec = dropTbl.getReplicationSpec();
        if (tbl != null && replicationSpec.isInReplicationScope() && !replicationSpec.allowEventReplacementInto(tbl)) {
            if (tbl.isPartitioned()) {
                PartitionIterable partitions = new PartitionIterable(db, tbl, null, this.conf.getIntVar(HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX));
                for (Partition p : Iterables.filter(partitions, replicationSpec.allowEventReplacementInto())) {
                    db.dropPartition(tbl.getDbName(), tbl.getTableName(), p.getValues(), true);
                }
            }
            return;
        }
        int partitionBatchSize = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_TABLE_PARTITION_MAX);
        if (tbl != null && tbl.isPartitioned()) {
            List<String> partitionNames = db.getPartitionNames(tbl.getDbName(), tbl.getTableName(), (short)-1);
            for (int i = 0; i < partitionNames.size(); i += partitionBatchSize) {
                List<String> partNames = partitionNames.subList(i, Math.min(i + partitionBatchSize, partitionNames.size()));
                List<Partition> listPartitions = db.getPartitionsByNames(tbl, partNames);
                for (Partition p : listPartitions) {
                    if (p.canDrop()) continue;
                    throw new HiveException("Table " + tbl.getTableName() + " Partition" + p.getName() + " is protected from being dropped");
                }
            }
        }
        db.dropTable(dropTbl.getTableName(), dropTbl.getIfPurge());
        if (tbl != null) {
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        }
    }

    private boolean updateModifiedParameters(Map<String, String> params, HiveConf conf) throws HiveException {
        String user = null;
        user = SessionState.getUserFromAuthenticator();
        params.put("last_modified_by", user);
        params.put("last_modified_time", Long.toString(System.currentTimeMillis() / 1000L));
        return true;
    }

    private void validateSerDe(String serdeName) throws HiveException {
        try {
            Deserializer d = ReflectionUtil.newInstance(this.conf.getClassByName(serdeName).asSubclass(Deserializer.class), this.conf);
            if (d != null) {
                LOG.debug("Found class for " + serdeName);
            }
        }
        catch (Exception e) {
            throw new HiveException("Cannot validate serde: " + serdeName, e);
        }
    }

    private int createDatabase(Hive db, CreateDatabaseDesc crtDb) throws HiveException {
        Database database = new Database();
        database.setName(crtDb.getName());
        database.setDescription(crtDb.getComment());
        database.setLocationUri(crtDb.getLocationUri());
        database.setParameters(crtDb.getDatabaseProperties());
        database.setOwnerName(SessionState.getUserFromAuthenticator());
        database.setOwnerType(PrincipalType.USER);
        try {
            if (!Utilities.isDefaultNameNode(this.conf)) {
                this.makeLocationQualified(database);
            }
            db.createDatabase(database, crtDb.getIfNotExists());
        }
        catch (AlreadyExistsException ex) {
            throw new HiveException((Throwable)((Object)ex), ErrorMsg.DATABSAE_ALREADY_EXISTS, crtDb.getName());
        }
        return 0;
    }

    private int dropDatabase(Hive db, DropDatabaseDesc dropDb) throws HiveException {
        try {
            db.dropDatabase(dropDb.getDatabaseName(), true, dropDb.getIfExists(), dropDb.isCasdade());
        }
        catch (NoSuchObjectException ex) {
            throw new HiveException((Throwable)((Object)ex), ErrorMsg.DATABASE_NOT_EXISTS, dropDb.getDatabaseName());
        }
        return 0;
    }

    private int switchDatabase(Hive db, SwitchDatabaseDesc switchDb) throws HiveException {
        String dbName = switchDb.getDatabaseName();
        if (!db.databaseExists(dbName)) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, dbName);
        }
        SessionState.get().setCurrentDatabase(dbName);
        Database database = db.getDatabase(dbName);
        assert (database != null);
        Map<String, String> dbParams = database.getParameters();
        if (dbParams != null) {
            for (HiveConf.ConfVars var : HiveConf.dbVars) {
                String newValue = dbParams.get(var.varname);
                if (newValue == null) continue;
                LOG.info("Changing " + var.varname + " from " + this.conf.getVar(var) + " to " + newValue);
                this.conf.setVar(var, newValue);
            }
        }
        return 0;
    }

    private int createTable(Hive db, CreateTableDesc crtTbl) throws HiveException {
        Table tbl = crtTbl.getDatabaseName() == null || crtTbl.getTableName().contains(".") ? db.newTable(crtTbl.getTableName()) : new Table(crtTbl.getDatabaseName(), crtTbl.getTableName());
        if (crtTbl.getTblProps() != null) {
            tbl.getTTable().getParameters().putAll(crtTbl.getTblProps());
        }
        if (crtTbl.getPartCols() != null) {
            tbl.setPartCols(crtTbl.getPartCols());
        }
        if (crtTbl.getNumBuckets() != -1) {
            tbl.setNumBuckets(crtTbl.getNumBuckets());
        }
        if (crtTbl.getStorageHandler() != null) {
            tbl.setProperty("storage_handler", crtTbl.getStorageHandler());
        }
        HiveStorageHandler storageHandler = tbl.getStorageHandler();
        if (crtTbl.getSerName() == null) {
            if (storageHandler == null) {
                LOG.info("Default to LazySimpleSerDe for table " + crtTbl.getTableName());
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            } else {
                String serDeClassName = storageHandler.getSerDeClass().getName();
                LOG.info("Use StorageHandler-supplied " + serDeClassName + " for table " + crtTbl.getTableName());
                tbl.setSerializationLib(serDeClassName);
            }
        } else {
            this.validateSerDe(crtTbl.getSerName());
            tbl.setSerializationLib(crtTbl.getSerName());
        }
        if (crtTbl.getFieldDelim() != null) {
            tbl.setSerdeParam("field.delim", crtTbl.getFieldDelim());
            tbl.setSerdeParam("serialization.format", crtTbl.getFieldDelim());
        }
        if (crtTbl.getFieldEscape() != null) {
            tbl.setSerdeParam("escape.delim", crtTbl.getFieldEscape());
        }
        if (crtTbl.getCollItemDelim() != null) {
            tbl.setSerdeParam("colelction.delim", crtTbl.getCollItemDelim());
        }
        if (crtTbl.getMapKeyDelim() != null) {
            tbl.setSerdeParam("mapkey.delim", crtTbl.getMapKeyDelim());
        }
        if (crtTbl.getLineDelim() != null) {
            tbl.setSerdeParam("line.delim", crtTbl.getLineDelim());
        }
        if (crtTbl.getNullFormat() != null) {
            tbl.setSerdeParam("serialization.null.format", crtTbl.getNullFormat());
        }
        if (crtTbl.getSerdeProps() != null) {
            for (Map.Entry<String, String> m : crtTbl.getSerdeProps().entrySet()) {
                tbl.setSerdeParam(m.getKey(), m.getValue());
            }
        }
        if (crtTbl.getCols() != null) {
            tbl.setFields(crtTbl.getCols());
        }
        if (crtTbl.getBucketCols() != null) {
            tbl.setBucketCols(crtTbl.getBucketCols());
        }
        if (crtTbl.getSortCols() != null) {
            tbl.setSortCols(crtTbl.getSortCols());
        }
        if (crtTbl.getComment() != null) {
            tbl.setProperty("comment", crtTbl.getComment());
        }
        if (crtTbl.getLocation() != null) {
            tbl.setDataLocation(new Path(crtTbl.getLocation()));
        }
        if (crtTbl.getSkewedColNames() != null) {
            tbl.setSkewedColNames(crtTbl.getSkewedColNames());
        }
        if (crtTbl.getSkewedColValues() != null) {
            tbl.setSkewedColValues(crtTbl.getSkewedColValues());
        }
        tbl.getTTable().setTemporary(crtTbl.isTemporary());
        tbl.setStoredAsSubDirectories(crtTbl.isStoredAsSubDirectories());
        tbl.setInputFormatClass(crtTbl.getInputFormat());
        tbl.setOutputFormatClass(crtTbl.getOutputFormat());
        if (crtTbl.getInputFormat() != null && !crtTbl.getInputFormat().isEmpty()) {
            tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
        }
        if (crtTbl.getOutputFormat() != null && !crtTbl.getOutputFormat().isEmpty()) {
            tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
        }
        if (!Utilities.isDefaultNameNode(this.conf) && DDLTask.doesTableNeedLocation(tbl)) {
            this.makeLocationQualified(tbl.getDbName(), tbl.getTTable().getSd(), tbl.getTableName());
        }
        if (crtTbl.isExternal()) {
            tbl.setProperty("EXTERNAL", "TRUE");
            tbl.setTableType(TableType.EXTERNAL_TABLE);
        }
        if (tbl.getBucketCols() != null && tbl.getSortCols() != null) {
            List<String> bucketCols = tbl.getBucketCols();
            List<Order> sortCols = tbl.getSortCols();
            if (sortCols.size() > 0 && sortCols.size() >= bucketCols.size()) {
                boolean found = true;
                for (String bucketCol : bucketCols) {
                    boolean colFound = false;
                    for (int i = 0; i < bucketCols.size(); ++i) {
                        if (!bucketCol.equals(sortCols.get(i).getCol())) continue;
                        colFound = true;
                        break;
                    }
                    if (colFound) continue;
                    found = false;
                    break;
                }
                if (found) {
                    tbl.setProperty("SORTBUCKETCOLSPREFIX", "TRUE");
                }
            }
        }
        if (crtTbl.getReplaceMode()) {
            try {
                db.alterTable(tbl.getDbName() + "." + tbl.getTableName(), tbl);
            }
            catch (InvalidOperationException e) {
                throw new HiveException("Unable to alter table. " + e.getMessage(), (Throwable)((Object)e));
            }
        } else {
            db.createTable(tbl, crtTbl.getIfNotExists());
        }
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        return 0;
    }

    private int createTableLike(Hive db, CreateTableLikeDesc crtTbl) throws Exception {
        Table tbl;
        Table oldtbl = db.getTable(crtTbl.getLikeTableName());
        if (oldtbl.getTableType() == TableType.VIRTUAL_VIEW) {
            String targetTableName = crtTbl.getTableName();
            tbl = db.newTable(targetTableName);
            if (crtTbl.getTblProps() != null) {
                tbl.getTTable().getParameters().putAll(crtTbl.getTblProps());
            }
            tbl.setTableType(TableType.MANAGED_TABLE);
            if (crtTbl.isExternal()) {
                tbl.setProperty("EXTERNAL", "TRUE");
                tbl.setTableType(TableType.EXTERNAL_TABLE);
            }
            tbl.setFields(oldtbl.getCols());
            tbl.setPartCols(oldtbl.getPartCols());
            if (crtTbl.getDefaultSerName() == null) {
                LOG.info("Default to LazySimpleSerDe for table " + crtTbl.getTableName());
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            } else {
                this.validateSerDe(crtTbl.getDefaultSerName());
                tbl.setSerializationLib(crtTbl.getDefaultSerName());
            }
            if (crtTbl.getDefaultSerdeProps() != null) {
                for (Map.Entry<String, String> m : crtTbl.getDefaultSerdeProps().entrySet()) {
                    tbl.setSerdeParam(m.getKey(), m.getValue());
                }
            }
            tbl.setInputFormatClass(crtTbl.getDefaultInputFormat());
            tbl.setOutputFormatClass(crtTbl.getDefaultOutputFormat());
            tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
            tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
        } else {
            tbl = oldtbl;
            String targetTableName = crtTbl.getTableName();
            String[] names = Utilities.getDbTableName(targetTableName);
            tbl.setDbName(names[0]);
            tbl.setTableName(names[1]);
            tbl.setOwner(SessionState.getUserFromAuthenticator());
            if (crtTbl.getLocation() != null) {
                tbl.setDataLocation(new Path(crtTbl.getLocation()));
            } else {
                tbl.unsetDataLocation();
            }
            Class<? extends Deserializer> serdeClass = oldtbl.getDeserializerClass();
            Map<String, String> params = tbl.getParameters();
            SerDeSpec spec = AnnotationUtils.getAnnotation(serdeClass, SerDeSpec.class);
            String paramsStr = HiveConf.getVar(this.conf, HiveConf.ConfVars.DDL_CTL_PARAMETERS_WHITELIST);
            HashSet<String> retainer = new HashSet<String>();
            if (spec != null && spec.schemaProps() != null) {
                retainer.addAll(Arrays.asList(spec.schemaProps()));
            }
            if (paramsStr != null) {
                retainer.addAll(Arrays.asList(paramsStr.split(",")));
            }
            if (!retainer.isEmpty()) {
                params.keySet().retainAll(retainer);
            } else {
                params.clear();
            }
            if (crtTbl.getTblProps() != null) {
                params.putAll(crtTbl.getTblProps());
            }
            if (crtTbl.isUserStorageFormat()) {
                tbl.setInputFormatClass(crtTbl.getDefaultInputFormat());
                tbl.setOutputFormatClass(crtTbl.getDefaultOutputFormat());
                tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
                tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
                if (crtTbl.getDefaultSerName() == null) {
                    LOG.info("Default to LazySimpleSerDe for like table " + crtTbl.getTableName());
                    tbl.setSerializationLib(LazySimpleSerDe.class.getName());
                } else {
                    this.validateSerDe(crtTbl.getDefaultSerName());
                    tbl.setSerializationLib(crtTbl.getDefaultSerName());
                }
            }
            tbl.getTTable().setTemporary(crtTbl.isTemporary());
            if (crtTbl.isExternal()) {
                tbl.setProperty("EXTERNAL", "TRUE");
                tbl.setTableType(TableType.EXTERNAL_TABLE);
            } else {
                tbl.getParameters().remove("EXTERNAL");
            }
        }
        if (!Utilities.isDefaultNameNode(this.conf)) {
            this.makeLocationQualified(tbl.getDbName(), tbl.getTTable().getSd(), tbl.getTableName());
        }
        db.createTable(tbl, crtTbl.getIfNotExists());
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        return 0;
    }

    private int createView(Hive db, CreateViewDesc crtView) throws HiveException {
        Table oldview = db.getTable(crtView.getViewName(), false);
        if (crtView.getOrReplace() && oldview != null) {
            oldview.setViewOriginalText(crtView.getViewOriginalText());
            oldview.setViewExpandedText(crtView.getViewExpandedText());
            oldview.setFields(crtView.getSchema());
            if (crtView.getComment() != null) {
                oldview.setProperty("comment", crtView.getComment());
            }
            if (crtView.getTblProps() != null) {
                oldview.getTTable().getParameters().putAll(crtView.getTblProps());
            }
            oldview.setPartCols(crtView.getPartCols());
            oldview.checkValidity();
            try {
                db.alterTable(crtView.getViewName(), oldview);
            }
            catch (InvalidOperationException e) {
                throw new HiveException((Throwable)((Object)e));
            }
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(oldview, WriteEntity.WriteType.DDL_NO_LOCK));
        } else {
            Table tbl = db.newTable(crtView.getViewName());
            tbl.setTableType(TableType.VIRTUAL_VIEW);
            tbl.setSerializationLib(null);
            tbl.clearSerDeInfo();
            tbl.setViewOriginalText(crtView.getViewOriginalText());
            tbl.setViewExpandedText(crtView.getViewExpandedText());
            tbl.setFields(crtView.getSchema());
            if (crtView.getComment() != null) {
                tbl.setProperty("comment", crtView.getComment());
            }
            if (crtView.getTblProps() != null) {
                tbl.getTTable().getParameters().putAll(crtView.getTblProps());
            }
            if (crtView.getPartCols() != null) {
                tbl.setPartCols(crtView.getPartCols());
            }
            db.createTable(tbl, crtView.getIfNotExists());
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
        }
        return 0;
    }

    private int truncateTable(Hive db, TruncateTableDesc truncateTableDesc) throws HiveException {
        if (truncateTableDesc.getColumnIndexes() != null) {
            ColumnTruncateWork truncateWork = new ColumnTruncateWork(truncateTableDesc.getColumnIndexes(), truncateTableDesc.getInputDir(), truncateTableDesc.getOutputDir());
            truncateWork.setListBucketingCtx(truncateTableDesc.getLbCtx());
            truncateWork.setMapperCannotSpanPartns(true);
            DriverContext driverCxt = new DriverContext();
            ColumnTruncateTask taskExec = new ColumnTruncateTask();
            taskExec.initialize(db.getConf(), null, driverCxt);
            taskExec.setWork(truncateWork);
            taskExec.setQueryPlan(this.getQueryPlan());
            return taskExec.execute(driverCxt);
        }
        String tableName = truncateTableDesc.getTableName();
        Map<String, String> partSpec = truncateTableDesc.getPartSpec();
        Table table = db.getTable(tableName, true);
        try {
            HadoopShims shim = ShimLoader.getHadoopShims();
            for (Path location : this.getLocations(db, table, partSpec)) {
                FileSystem fs = location.getFileSystem((Configuration)this.conf);
                HadoopShims.HdfsFileStatus fullFileStatus = shim.getFullFileStatus(this.conf, fs, location);
                fs.delete(location, true);
                fs.mkdirs(location);
                try {
                    shim.setFullFileStatus(this.conf, fullFileStatus, fs, location);
                }
                catch (Exception e) {
                    LOG.warn("Error setting permissions of " + location, e);
                }
            }
        }
        catch (Exception e) {
            throw new HiveException(e, ErrorMsg.GENERIC_ERROR, new String[0]);
        }
        return 0;
    }

    private int exchangeTablePartition(Hive db, AlterTableExchangePartition exchangePartition) throws HiveException {
        Map<String, String> partitionSpecs = exchangePartition.getPartitionSpecs();
        Table destTable = exchangePartition.getDestinationTable();
        Table sourceTable = exchangePartition.getSourceTable();
        db.exchangeTablePartitions(partitionSpecs, sourceTable.getDbName(), sourceTable.getTableName(), destTable.getDbName(), destTable.getTableName());
        return 0;
    }

    private List<Path> getLocations(Hive db, Table table, Map<String, String> partSpec) throws HiveException, InvalidOperationException {
        ArrayList<Path> locations;
        block4: {
            block2: {
                block3: {
                    locations = new ArrayList<Path>();
                    if (partSpec != null) break block2;
                    if (!table.isPartitioned()) break block3;
                    for (Partition partition : db.getPartitions(table)) {
                        locations.add(partition.getDataLocation());
                        if (!this.needToUpdateStats(partition.getParameters())) continue;
                        db.alterPartition(table.getDbName(), table.getTableName(), partition);
                    }
                    break block4;
                }
                locations.add(table.getPath());
                if (!this.needToUpdateStats(table.getParameters())) break block4;
                db.alterTable(table.getDbName() + "." + table.getTableName(), table);
                break block4;
            }
            for (Partition partition : db.getPartitionsByNames(table, partSpec)) {
                locations.add(partition.getDataLocation());
                if (!this.needToUpdateStats(partition.getParameters())) continue;
                db.alterPartition(table.getDbName(), table.getTableName(), partition);
            }
        }
        return locations;
    }

    private boolean needToUpdateStats(Map<String, String> props) {
        if (null == props) {
            return false;
        }
        boolean statsPresent = false;
        for (String stat : StatsSetupConst.supportedStats) {
            String statVal = props.get(stat);
            if (statVal == null || Long.parseLong(statVal) <= 0L) continue;
            statsPresent = true;
            props.put(stat, "0");
            props.put("COLUMN_STATS_ACCURATE", "false");
        }
        return statsPresent;
    }

    private String escapeHiveCommand(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\'' || c == ';') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public StageType getType() {
        return StageType.DDL;
    }

    @Override
    public String getName() {
        return "DDL";
    }

    private void makeLocationQualified(String databaseName, StorageDescriptor sd, String name) throws HiveException {
        Path path = null;
        if (!sd.isSetLocation()) {
            if (databaseName.equalsIgnoreCase("default")) {
                path = new Path(HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTOREWAREHOUSE), name.toLowerCase());
            }
        } else {
            path = new Path(sd.getLocation());
        }
        if (path != null) {
            sd.setLocation(Utilities.getQualifiedPath(this.conf, path));
        }
    }

    private void makeLocationQualified(CreateIndexDesc crtIndex, String name) throws HiveException {
        Path path = null;
        if (crtIndex.getLocation() == null) {
            if (Utilities.getDatabaseName(name).equalsIgnoreCase("default")) {
                String warehouse = HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTOREWAREHOUSE);
                String tableName = Utilities.getTableName(name);
                path = new Path(warehouse, tableName.toLowerCase());
            }
        } else {
            path = new Path(crtIndex.getLocation());
        }
        if (path != null) {
            crtIndex.setLocation(Utilities.getQualifiedPath(this.conf, path));
        }
    }

    private void makeLocationQualified(Database database) throws HiveException {
        if (database.isSetLocationUri()) {
            database.setLocationUri(Utilities.getQualifiedPath(this.conf, new Path(database.getLocationUri())));
        } else {
            database.setLocationUri(Utilities.getQualifiedPath(this.conf, new Path(HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTOREWAREHOUSE), database.getName().toLowerCase() + ".db")));
        }
    }

    private static boolean doesTableNeedLocation(Table tbl) {
        boolean retval = true;
        if (tbl.getStorageHandler() != null) {
            retval = !tbl.getStorageHandler().toString().equals("org.apache.hadoop.hive.hbase.HBaseStorageHandler");
        }
        return retval;
    }

    static {
        DELIMITER_PREFIXES = new String[]{"FIELDS TERMINATED BY", "COLLECTION ITEMS TERMINATED BY", "MAP KEYS TERMINATED BY", "LINES TERMINATED BY", "NULL DEFINED AS"};
    }
}

