/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;

public class PartitionPrune {
    public static Pair<RexNode, RexNode> extractPartitionPredicates(RelOptCluster cluster, RelOptHiveTable hiveTable, RexNode predicate) {
        RexNode partitionPruningPred = (RexNode)predicate.accept((RexVisitor)new ExtractPartPruningPredicate(cluster, hiveTable));
        RexNode remainingPred = (RexNode)predicate.accept((RexVisitor)new ExtractRemainingPredicate(cluster, partitionPruningPred));
        return new Pair((Object)partitionPruningPred, (Object)remainingPred);
    }

    public static class ExtractRemainingPredicate
    extends RexVisitorImpl<RexNode> {
        List<RexNode> pruningPredicates;
        final RelOptCluster cluster;

        public ExtractRemainingPredicate(RelOptCluster cluster, RexNode partPruningExpr) {
            super(true);
            this.cluster = cluster;
            this.pruningPredicates = new ArrayList<RexNode>();
            this.flattenPredicates(partPruningExpr);
        }

        private void flattenPredicates(RexNode r) {
            if (r instanceof RexCall && ((RexCall)r).getOperator() == SqlStdOperatorTable.AND) {
                for (RexNode c : ((RexCall)r).getOperands()) {
                    this.flattenPredicates(c);
                }
            } else {
                this.pruningPredicates.add(r);
            }
        }

        public RexNode visitLiteral(RexLiteral literal) {
            return literal;
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            return inputRef;
        }

        public RexNode visitCall(RexCall call) {
            if (!this.deep) {
                return null;
            }
            if (call.getOperator() != SqlStdOperatorTable.AND) {
                if (this.pruningPredicates.contains(call)) {
                    return null;
                }
                return call;
            }
            LinkedList<RexNode> args = new LinkedList<RexNode>();
            for (RexNode operand : call.operands) {
                RexNode n = (RexNode)operand.accept((RexVisitor)this);
                if (n == null) continue;
                args.add(n);
            }
            if (args.size() == 0) {
                return null;
            }
            if (args.size() == 1) {
                return (RexNode)args.get(0);
            }
            return this.cluster.getRexBuilder().makeCall(call.getOperator(), args);
        }
    }

    public static class ExtractPartPruningPredicate
    extends RexVisitorImpl<RexNode> {
        private static final Log LOG = LogFactory.getLog(ExtractPartPruningPredicate.class);
        final RelOptHiveTable hiveTable;
        final RelDataType rType;
        final Set<String> partCols;
        final RelOptCluster cluster;

        public ExtractPartPruningPredicate(RelOptCluster cluster, RelOptHiveTable hiveTable) {
            super(true);
            this.hiveTable = hiveTable;
            this.rType = hiveTable.getRowType();
            List<FieldSchema> pfs = hiveTable.getHiveTableMD().getPartCols();
            this.partCols = new HashSet<String>();
            for (FieldSchema pf : pfs) {
                this.partCols.add(pf.getName());
            }
            this.cluster = cluster;
        }

        public RexNode visitLiteral(RexLiteral literal) {
            return literal;
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            RelDataTypeField f = (RelDataTypeField)this.rType.getFieldList().get(inputRef.getIndex());
            if (this.partCols.contains(f.getName())) {
                return inputRef;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RexNode visitCall(RexCall call) {
            if (!this.deep) {
                return null;
            }
            GenericUDF hiveUDF = null;
            try {
                hiveUDF = SqlFunctionConverter.getHiveUDF(call.getOperator(), call.getType(), call.operands.size());
                if (hiveUDF != null && !FunctionRegistry.isDeterministic(hiveUDF)) {
                    RexNode rexNode = null;
                    return rexNode;
                }
            }
            finally {
                block18: {
                    if (hiveUDF != null) {
                        try {
                            hiveUDF.close();
                        }
                        catch (IOException e) {
                            if (!LOG.isDebugEnabled()) break block18;
                            LOG.debug("Exception in closing " + hiveUDF, e);
                        }
                    }
                }
            }
            LinkedList<RexNode> args = new LinkedList<RexNode>();
            boolean argsPruned = false;
            for (RexNode operand : call.operands) {
                RexNode n = (RexNode)operand.accept((RexVisitor)this);
                if (n != null) {
                    args.add(n);
                    continue;
                }
                argsPruned = true;
            }
            if (call.getOperator() != SqlStdOperatorTable.AND) {
                return argsPruned ? null : call;
            }
            if (args.size() == 0) {
                return null;
            }
            if (args.size() == 1) {
                return (RexNode)args.get(0);
            }
            return this.cluster.getRexBuilder().makeCall(call.getOperator(), args);
        }
    }
}

