/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.TreeWizard;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.exec.WindowFunctionInfo;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.HiveParser;
import org.apache.hadoop.hive.ql.parse.LeadLagInfo;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.parse.WindowingExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.PTFDeserializer;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.CurrentRowDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFInputDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFQueryInputDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.RangeBoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.ShapeDetails;
import org.apache.hadoop.hive.ql.plan.ptf.ValueBoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowTableFunctionDef;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLeadLag;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionEvaluator;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionResolver;
import org.apache.hadoop.hive.ql.udf.ptf.WindowingTableFunction;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class PTFTranslator {
    private static final Log LOG = LogFactory.getLog("org.apache.hadoop.hive.ql.parse");
    HiveConf hCfg;
    LeadLagInfo llInfo;
    SemanticAnalyzer semAly;
    UnparseTranslator unparseT;
    RowResolver inputRR;
    PTFDesc ptfDesc;
    PTFInvocationSpec ptfInvocation;
    WindowingSpec windowingSpec;

    private void init(SemanticAnalyzer semAly, HiveConf hCfg, RowResolver inputRR, UnparseTranslator unparseT) {
        this.semAly = semAly;
        this.hCfg = hCfg;
        this.inputRR = inputRR;
        this.unparseT = unparseT;
        this.llInfo = new LeadLagInfo();
    }

    public PTFDesc translate(PTFInvocationSpec qSpec, SemanticAnalyzer semAly, HiveConf hCfg, RowResolver inputRR, UnparseTranslator unparseT) throws SemanticException {
        this.init(semAly, hCfg, inputRR, unparseT);
        this.ptfInvocation = qSpec;
        this.ptfDesc = new PTFDesc();
        this.ptfDesc.setCfg(hCfg);
        this.ptfDesc.setLlInfo(this.llInfo);
        this.translatePTFChain();
        PTFDeserializer.alterOutputOIForStreaming(this.ptfDesc);
        return this.ptfDesc;
    }

    public PTFDesc translate(WindowingSpec wdwSpec, SemanticAnalyzer semAly, HiveConf hCfg, RowResolver inputRR, UnparseTranslator unparseT) throws SemanticException {
        this.init(semAly, hCfg, inputRR, unparseT);
        this.windowingSpec = wdwSpec;
        this.ptfDesc = new PTFDesc();
        this.ptfDesc.setCfg(hCfg);
        this.ptfDesc.setLlInfo(this.llInfo);
        WindowTableFunctionDef wdwTFnDef = new WindowTableFunctionDef();
        this.ptfDesc.setFuncDef(wdwTFnDef);
        PTFInvocationSpec.PTFQueryInputSpec inpSpec = new PTFInvocationSpec.PTFQueryInputSpec();
        inpSpec.setType(PTFInvocationSpec.PTFQueryInputType.WINDOWING);
        wdwTFnDef.setInput(this.translate(inpSpec, 0));
        ShapeDetails inpShape = wdwTFnDef.getInput().getOutputShape();
        WindowingTableFunction.WindowingTableFunctionResolver tFn = (WindowingTableFunction.WindowingTableFunctionResolver)FunctionRegistry.getTableFunctionResolver("windowingtablefunction");
        if (tFn == null) {
            throw new SemanticException(String.format("Internal Error: Unknown Table Function %s", "windowingtablefunction"));
        }
        wdwTFnDef.setName("windowingtablefunction");
        wdwTFnDef.setResolverClassName(tFn.getClass().getName());
        wdwTFnDef.setAlias("ptf_1");
        wdwTFnDef.setExpressionTreeString(null);
        wdwTFnDef.setTransformsRawInput(false);
        tFn.initialize(hCfg, this.ptfDesc, wdwTFnDef);
        TableFunctionEvaluator tEval = tFn.getEvaluator();
        wdwTFnDef.setTFunction(tEval);
        wdwTFnDef.setCarryForwardNames(tFn.carryForwardNames());
        wdwTFnDef.setRawInputShape(inpShape);
        PTFInvocationSpec.PartitioningSpec partiSpec = wdwSpec.getQueryPartitioningSpec();
        if (partiSpec == null) {
            throw new SemanticException("Invalid use of Windowing: there is no Partitioning associated with Windowing");
        }
        PartitionDef partDef = this.translate(inpShape, wdwSpec.getQueryPartitionSpec());
        OrderDef ordDef = this.translate(inpShape, wdwSpec.getQueryOrderSpec(), partDef);
        wdwTFnDef.setPartition(partDef);
        wdwTFnDef.setOrder(ordDef);
        ArrayList<WindowFunctionDef> windowFunctions = new ArrayList<WindowFunctionDef>();
        if (wdwSpec.getWindowExpressions() != null) {
            for (WindowingSpec.WindowExpressionSpec expr : wdwSpec.getWindowExpressions()) {
                if (!(expr instanceof WindowingSpec.WindowFunctionSpec)) continue;
                WindowFunctionDef wFnDef = this.translate(wdwTFnDef, (WindowingSpec.WindowFunctionSpec)expr);
                windowFunctions.add(wFnDef);
            }
            wdwTFnDef.setWindowFunctions(windowFunctions);
        }
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>();
        for (WindowFunctionDef wFnDef : windowFunctions) {
            aliases.add(wFnDef.getAlias());
            if (wFnDef.isPivotResult()) {
                fieldOIs.add(((ListObjectInspector)wFnDef.getOI()).getListElementObjectInspector());
                continue;
            }
            fieldOIs.add(wFnDef.getOI());
        }
        PTFTranslator.addInputColumnsToList(inpShape, aliases, fieldOIs);
        StandardStructObjectInspector wdwOutOI = ObjectInspectorFactory.getStandardStructObjectInspector(aliases, fieldOIs);
        tFn.setWdwProcessingOutputOI(wdwOutOI);
        RowResolver wdwOutRR = this.buildRowResolverForWindowing(wdwTFnDef);
        ShapeDetails wdwOutShape = this.setupShape(wdwOutOI, null, wdwOutRR);
        wdwTFnDef.setOutputShape(wdwOutShape);
        tFn.setupOutputOI();
        PTFDeserializer.alterOutputOIForStreaming(this.ptfDesc);
        return this.ptfDesc;
    }

    private void translatePTFChain() throws SemanticException {
        PTFInvocationSpec.PTFInputSpec currentSpec;
        ArrayDeque<PTFInvocationSpec.PartitionedTableFunctionSpec> ptfChain = new ArrayDeque<PTFInvocationSpec.PartitionedTableFunctionSpec>();
        for (currentSpec = this.ptfInvocation.getFunction(); currentSpec != null; currentSpec = ((PTFInvocationSpec.PTFInputSpec)currentSpec).getInput()) {
            ptfChain.push((PTFInvocationSpec.PartitionedTableFunctionSpec)currentSpec);
        }
        int inputNum = 0;
        PTFInputDef currentDef = null;
        while (!ptfChain.isEmpty()) {
            currentSpec = (PTFInvocationSpec.PTFInputSpec)ptfChain.pop();
            currentDef = currentSpec instanceof PTFInvocationSpec.PTFQueryInputSpec ? this.translate((PTFInvocationSpec.PTFQueryInputSpec)currentSpec, inputNum) : this.translate((PTFInvocationSpec.PartitionedTableFunctionSpec)currentSpec, currentDef, inputNum);
            ++inputNum;
        }
        this.ptfDesc.setFuncDef((PartitionedTableFunctionDef)currentDef);
    }

    private PTFQueryInputDef translate(PTFInvocationSpec.PTFQueryInputSpec spec, int inpNum) throws SemanticException {
        PTFQueryInputDef def = new PTFQueryInputDef();
        StructObjectInspector oi = PTFTranslator.getStandardStructOI(this.inputRR);
        ShapeDetails shp = this.setupShape(oi, null, this.inputRR);
        def.setOutputShape(shp);
        def.setType(spec.getType());
        def.setAlias(spec.getSource() == null ? "ptf_" + inpNum : spec.getSource());
        return def;
    }

    private PartitionedTableFunctionDef translate(PTFInvocationSpec.PartitionedTableFunctionSpec spec, PTFInputDef inpDef, int inpNum) throws SemanticException {
        TableFunctionResolver tFn = FunctionRegistry.getTableFunctionResolver(spec.getName());
        if (tFn == null) {
            throw new SemanticException(String.format("Unknown Table Function %s", spec.getName()));
        }
        PartitionedTableFunctionDef def = new PartitionedTableFunctionDef();
        def.setInput(inpDef);
        def.setName(spec.getName());
        def.setResolverClassName(tFn.getClass().getName());
        def.setAlias(spec.getAlias() == null ? "ptf_" + inpNum : spec.getAlias());
        def.setExpressionTreeString(spec.getAstNode().toStringTree());
        def.setTransformsRawInput(tFn.transformsRawInput());
        List<ASTNode> args = spec.getArgs();
        if (args != null) {
            for (ASTNode expr : args) {
                PTFExpressionDef argDef = null;
                try {
                    argDef = this.buildExpressionDef(inpDef.getOutputShape(), expr);
                }
                catch (HiveException he) {
                    throw new SemanticException(he);
                }
                def.addArg(argDef);
            }
        }
        tFn.initialize(this.hCfg, this.ptfDesc, def);
        TableFunctionEvaluator tEval = tFn.getEvaluator();
        def.setTFunction(tEval);
        def.setCarryForwardNames(tFn.carryForwardNames());
        tFn.setupRawInputOI();
        if (tFn.transformsRawInput()) {
            StructObjectInspector rawInOutOI = tEval.getRawInputOI();
            List<String> rawInOutColNames = tFn.getRawInputColumnNames();
            RowResolver rawInRR = PTFTranslator.buildRowResolverForPTF(def.getName(), spec.getAlias(), rawInOutOI, rawInOutColNames, inpDef.getOutputShape().getRr());
            ShapeDetails rawInpShape = this.setupTableFnShape(def.getName(), inpDef.getOutputShape(), rawInOutOI, rawInOutColNames, rawInRR);
            def.setRawInputShape(rawInpShape);
        } else {
            def.setRawInputShape(inpDef.getOutputShape());
        }
        this.translatePartitioning(def, spec);
        tFn.setupOutputOI();
        StructObjectInspector outputOI = tEval.getOutputOI();
        List<String> outColNames = tFn.getOutputColumnNames();
        RowResolver outRR = PTFTranslator.buildRowResolverForPTF(def.getName(), spec.getAlias(), outputOI, outColNames, def.getRawInputShape().getRr());
        ShapeDetails outputShape = this.setupTableFnShape(def.getName(), inpDef.getOutputShape(), outputOI, outColNames, outRR);
        def.setOutputShape(outputShape);
        def.setReferencedColumns(tFn.getReferencedColumns());
        return def;
    }

    private WindowFunctionDef translate(WindowTableFunctionDef wdwTFnDef, WindowingSpec.WindowFunctionSpec spec) throws SemanticException {
        WindowingSpec.WindowSpec wdwSpec;
        WindowFunctionInfo wFnInfo = FunctionRegistry.getWindowFunctionInfo(spec.getName());
        if (wFnInfo == null) {
            throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(spec.getName()));
        }
        WindowFunctionDef def = new WindowFunctionDef();
        def.setName(spec.getName());
        def.setAlias(spec.getAlias());
        def.setDistinct(spec.isDistinct());
        def.setExpressionTreeString(spec.getExpression().toStringTree());
        def.setStar(spec.isStar());
        def.setPivotResult(wFnInfo.isPivotResult());
        ShapeDetails inpShape = wdwTFnDef.getRawInputShape();
        ArrayList<ASTNode> args = spec.getArgs();
        if (args != null) {
            for (ASTNode expr : args) {
                PTFExpressionDef argDef = null;
                try {
                    argDef = this.buildExpressionDef(inpShape, expr);
                }
                catch (HiveException he) {
                    throw new SemanticException(he);
                }
                def.addArg(argDef);
            }
        }
        if (FunctionRegistry.isRankingFunction(spec.getName())) {
            this.setupRankingArgs(wdwTFnDef, def, spec);
        }
        if ((wdwSpec = spec.getWindowSpec()) != null) {
            String desc = spec.toString();
            WindowFrameDef wdwFrame = this.translate(spec.getName(), inpShape, wdwSpec);
            if (!wFnInfo.isSupportsWindow()) {
                WindowingSpec.BoundarySpec start = wdwSpec.getWindowFrame().getStart();
                if (start.getAmt() != WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
                    throw new SemanticException(String.format("Expecting left window frame boundary for function %s to be unbounded. Found : %d", desc, start.getAmt()));
                }
                WindowingSpec.BoundarySpec end = wdwSpec.getWindowFrame().getEnd();
                if (end.getAmt() != WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
                    throw new SemanticException(String.format("Expecting right window frame boundary for function %s to be unbounded. Found : %d", desc, start.getAmt()));
                }
            }
            def.setWindowFrame(wdwFrame);
        }
        try {
            PTFTranslator.setupWdwFnEvaluator(def);
        }
        catch (HiveException he) {
            throw new SemanticException(he);
        }
        return def;
    }

    private void translatePartitioning(PartitionedTableFunctionDef def, PTFInvocationSpec.PartitionedTableFunctionSpec spec) throws SemanticException {
        PTFTranslator.applyConstantPartition(spec);
        if (spec.getPartition() == null) {
            return;
        }
        PartitionDef partDef = this.translate(def.getRawInputShape(), spec.getPartition());
        OrderDef orderDef = this.translate(def.getRawInputShape(), spec.getOrder(), partDef);
        def.setPartition(partDef);
        def.setOrder(orderDef);
    }

    private static void applyConstantPartition(PTFInvocationSpec.PartitionedTableFunctionSpec spec) {
        if (spec.getPartition() != null) {
            return;
        }
        PTFInvocationSpec.PTFInputSpec iSpec = spec.getInput();
        if (iSpec instanceof PTFInvocationSpec.PTFInputSpec) {
            PTFInvocationSpec.PartitionSpec partSpec = new PTFInvocationSpec.PartitionSpec();
            PTFInvocationSpec.PartitionExpression partExpr = new PTFInvocationSpec.PartitionExpression();
            partExpr.setExpression(new ASTNode((Token)new CommonToken(302, "0")));
            partSpec.addExpression(partExpr);
            spec.setPartition(partSpec);
        }
    }

    private PartitionDef translate(ShapeDetails inpShape, PTFInvocationSpec.PartitionSpec spec) throws SemanticException {
        if (spec == null || spec.getExpressions() == null || spec.getExpressions().size() == 0) {
            return null;
        }
        PartitionDef pDef = new PartitionDef();
        for (PTFInvocationSpec.PartitionExpression pExpr : spec.getExpressions()) {
            PTFExpressionDef expDef = this.translate(inpShape, pExpr);
            pDef.addExpression(expDef);
        }
        return pDef;
    }

    private PTFExpressionDef translate(ShapeDetails inpShape, PTFInvocationSpec.PartitionExpression pExpr) throws SemanticException {
        PTFExpressionDef expDef = null;
        try {
            expDef = this.buildExpressionDef(inpShape, pExpr.getExpression());
        }
        catch (HiveException he) {
            throw new SemanticException(he);
        }
        PTFTranslator.validateComparable(expDef.getOI(), String.format("Partition Expression %s is not a comparable expression", pExpr.getExpression().toStringTree()));
        return expDef;
    }

    private OrderDef translate(ShapeDetails inpShape, PTFInvocationSpec.OrderSpec spec, PartitionDef partitionDef) throws SemanticException {
        OrderDef def = new OrderDef();
        if (null == spec) {
            return def;
        }
        for (PTFInvocationSpec.OrderExpression oExpr : spec.getExpressions()) {
            OrderExpressionDef oexpDef = this.translate(inpShape, oExpr);
            def.addExpression(oexpDef);
        }
        return def;
    }

    private OrderExpressionDef translate(ShapeDetails inpShape, PTFInvocationSpec.OrderExpression oExpr) throws SemanticException {
        OrderExpressionDef oexpDef = new OrderExpressionDef();
        oexpDef.setOrder(oExpr.getOrder());
        try {
            PTFExpressionDef expDef = this.buildExpressionDef(inpShape, oExpr.getExpression());
            oexpDef.setExpressionTreeString(expDef.getExpressionTreeString());
            oexpDef.setExprEvaluator(expDef.getExprEvaluator());
            oexpDef.setExprNode(expDef.getExprNode());
            oexpDef.setOI(expDef.getOI());
        }
        catch (HiveException he) {
            throw new SemanticException(he);
        }
        PTFTranslator.validateComparable(oexpDef.getOI(), String.format("Partition Expression %s is not a comparable expression", oExpr.getExpression().toStringTree()));
        return oexpDef;
    }

    private WindowFrameDef translate(String wFnName, ShapeDetails inpShape, WindowingSpec.WindowSpec spec) throws SemanticException {
        return this.translate(inpShape, spec.getWindowFrame());
    }

    private WindowFrameDef translate(ShapeDetails inpShape, WindowingSpec.WindowFrameSpec spec) throws SemanticException {
        WindowingSpec.BoundarySpec e;
        if (spec == null) {
            return null;
        }
        WindowingSpec.BoundarySpec s = spec.getStart();
        int cmp = s.compareTo(e = spec.getEnd());
        if (cmp > 0) {
            throw new SemanticException(String.format("Window range invalid, start boundary is greater than end boundary: %s", spec));
        }
        WindowFrameDef wfDef = new WindowFrameDef();
        wfDef.setStart(this.translate(inpShape, s));
        wfDef.setEnd(this.translate(inpShape, e));
        return wfDef;
    }

    private BoundaryDef translate(ShapeDetails inpShape, WindowingSpec.BoundarySpec bndSpec) throws SemanticException {
        if (bndSpec instanceof WindowingSpec.ValueBoundarySpec) {
            WindowingSpec.ValueBoundarySpec vBndSpec = (WindowingSpec.ValueBoundarySpec)bndSpec;
            ValueBoundaryDef vbDef = new ValueBoundaryDef();
            vbDef.setAmt(vBndSpec.getAmt());
            vbDef.setDirection(vBndSpec.getDirection());
            PTFTranslator.validateNoLeadLagInValueBoundarySpec(vBndSpec.getExpression());
            PTFExpressionDef exprDef = null;
            try {
                exprDef = this.buildExpressionDef(inpShape, vBndSpec.getExpression());
            }
            catch (HiveException he) {
                throw new SemanticException(he);
            }
            PTFTranslator.validateValueBoundaryExprType(exprDef.getOI());
            vbDef.setExpressionDef(exprDef);
            return vbDef;
        }
        if (bndSpec instanceof WindowingSpec.RangeBoundarySpec) {
            WindowingSpec.RangeBoundarySpec rBndSpec = (WindowingSpec.RangeBoundarySpec)bndSpec;
            RangeBoundaryDef rbDef = new RangeBoundaryDef();
            rbDef.setAmt(rBndSpec.getAmt());
            rbDef.setDirection(rBndSpec.getDirection());
            return rbDef;
        }
        if (bndSpec instanceof WindowingSpec.CurrentRowSpec) {
            CurrentRowDef cbDef = new CurrentRowDef();
            return cbDef;
        }
        throw new SemanticException("Unknown Boundary: " + bndSpec);
    }

    static void setupWdwFnEvaluator(WindowFunctionDef def) throws HiveException {
        List<PTFExpressionDef> args = def.getArgs();
        ArrayList<ObjectInspector> argOIs = new ArrayList<ObjectInspector>();
        ObjectInspector[] funcArgOIs = null;
        if (args != null) {
            for (PTFExpressionDef arg : args) {
                argOIs.add(arg.getOI());
            }
            funcArgOIs = new ObjectInspector[args.size()];
            funcArgOIs = argOIs.toArray(funcArgOIs);
        }
        GenericUDAFEvaluator wFnEval = FunctionRegistry.getGenericWindowingEvaluator(def.getName(), argOIs, def.isDistinct(), def.isStar());
        ObjectInspector OI = wFnEval.init(GenericUDAFEvaluator.Mode.COMPLETE, funcArgOIs);
        def.setWFnEval(wFnEval);
        def.setOI(OI);
    }

    private static void validateValueBoundaryExprType(ObjectInspector OI) throws SemanticException {
        if (!OI.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) {
            throw new SemanticException(String.format("Value Boundary expression must be of primitve type. Found: %s", OI.getTypeName()));
        }
        PrimitiveObjectInspector pOI = (PrimitiveObjectInspector)OI;
        PrimitiveObjectInspector.PrimitiveCategory pC = pOI.getPrimitiveCategory();
        switch (pC) {
            case BYTE: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: 
            case DECIMAL: 
            case TIMESTAMP: 
            case STRING: {
                break;
            }
            default: {
                throw new SemanticException(String.format("Primitve type %s not supported in Value Boundary expression", new Object[]{pC}));
            }
        }
    }

    private ShapeDetails setupTableFnShape(String fnName, ShapeDetails inpShape, StructObjectInspector OI, List<String> columnNames, RowResolver rr) throws SemanticException {
        if (FunctionRegistry.isNoopFunction(fnName)) {
            return this.setupShapeForNoop(inpShape, OI, columnNames, rr);
        }
        return this.setupShape(OI, columnNames, rr);
    }

    private ShapeDetails setupShape(StructObjectInspector OI, List<String> columnNames, RowResolver rr) throws SemanticException {
        LinkedHashMap<String, String> serdePropsMap = new LinkedHashMap<String, String>();
        SerDe serde = null;
        ShapeDetails shp = new ShapeDetails();
        try {
            serde = PTFTranslator.createLazyBinarySerDe(this.hCfg, OI, serdePropsMap);
            StructObjectInspector outOI = PTFPartition.setupPartitionOutputOI(serde, OI);
            shp.setOI(outOI);
        }
        catch (SerDeException se) {
            throw new SemanticException(se);
        }
        shp.setRr(rr);
        shp.setSerde(serde);
        shp.setSerdeClassName(serde.getClass().getName());
        shp.setSerdeProps(serdePropsMap);
        shp.setColumnNames(columnNames);
        TypeCheckCtx tCtx = new TypeCheckCtx(rr);
        tCtx.setUnparseTranslator(this.unparseT);
        shp.setTypeCheckCtx(tCtx);
        return shp;
    }

    private ShapeDetails copyShape(ShapeDetails src) {
        ShapeDetails dest = new ShapeDetails();
        dest.setSerdeClassName(src.getSerdeClassName());
        dest.setSerdeProps(src.getSerdeProps());
        dest.setColumnNames(src.getColumnNames());
        dest.setOI(src.getOI());
        dest.setSerde(src.getSerde());
        dest.setRr(src.getRr());
        dest.setTypeCheckCtx(src.getTypeCheckCtx());
        return dest;
    }

    private ShapeDetails setupShapeForNoop(ShapeDetails inpShape, StructObjectInspector OI, List<String> columnNames, RowResolver rr) throws SemanticException {
        ShapeDetails shp = new ShapeDetails();
        shp.setRr(rr);
        shp.setOI(inpShape.getOI());
        shp.setSerde(inpShape.getSerde());
        shp.setSerdeClassName(inpShape.getSerde().getClass().getName());
        shp.setSerdeProps(inpShape.getSerdeProps());
        shp.setColumnNames(columnNames);
        TypeCheckCtx tCtx = new TypeCheckCtx(rr);
        tCtx.setUnparseTranslator(this.unparseT);
        shp.setTypeCheckCtx(tCtx);
        return shp;
    }

    protected static ArrayList<PTFInvocationSpec.OrderExpression> addPartitionExpressionsToOrderList(ArrayList<PTFInvocationSpec.PartitionExpression> partCols, ArrayList<PTFInvocationSpec.OrderExpression> orderCols) throws SemanticException {
        int numOfPartColumns = 0;
        int chkSize = partCols.size();
        chkSize = chkSize > orderCols.size() ? orderCols.size() : chkSize;
        for (int i = 0; i < chkSize && orderCols.get(i).getExpression().toStringTree().equals(partCols.get(i).getExpression().toStringTree()); ++i) {
            ++numOfPartColumns;
        }
        if (numOfPartColumns != 0 && numOfPartColumns != partCols.size()) {
            ArrayList<String> partitionColumnNames = new ArrayList<String>();
            for (PTFInvocationSpec.PartitionExpression partitionExpression : partCols) {
                ASTNode column = partitionExpression.getExpression();
                if (column == null || column.getChildCount() <= 0) continue;
                partitionColumnNames.add(column.getChild(0).getText());
            }
            throw new SemanticException(String.format("all partition columns %s must be in order clause or none should be specified", ((Object)partitionColumnNames).toString()));
        }
        ArrayList<PTFInvocationSpec.OrderExpression> combinedOrdExprs = new ArrayList<PTFInvocationSpec.OrderExpression>();
        if (numOfPartColumns == 0) {
            for (PTFInvocationSpec.PartitionExpression partCol : partCols) {
                PTFInvocationSpec.OrderExpression orderCol = new PTFInvocationSpec.OrderExpression(partCol);
                combinedOrdExprs.add(orderCol);
            }
        }
        combinedOrdExprs.addAll(orderCols);
        return combinedOrdExprs;
    }

    private void setupRankingArgs(WindowTableFunctionDef wdwTFnDef, WindowFunctionDef wFnDef, WindowingSpec.WindowFunctionSpec wSpec) throws SemanticException {
        if (wSpec.getArgs().size() > 0) {
            throw new SemanticException("Ranking Functions can take no arguments");
        }
        OrderDef oDef = wdwTFnDef.getOrder();
        List<OrderExpressionDef> oExprs = oDef.getExpressions();
        for (OrderExpressionDef oExpr : oExprs) {
            wFnDef.addArg(oExpr);
        }
    }

    public PTFExpressionDef buildExpressionDef(ShapeDetails inpShape, ASTNode arg) throws HiveException {
        PTFExpressionDef argDef = new PTFExpressionDef();
        ExprNodeDesc exprNode = this.semAly.genExprNodeDesc(arg, inpShape.getRr(), inpShape.getTypeCheckCtx());
        ExprNodeEvaluator exprEval = WindowingExprNodeEvaluatorFactory.get(this.llInfo, exprNode);
        ObjectInspector oi = this.initExprNodeEvaluator(exprEval, exprNode, inpShape);
        argDef.setExpressionTreeString(arg.toStringTree());
        argDef.setExprNode(exprNode);
        argDef.setExprEvaluator(exprEval);
        argDef.setOI(oi);
        return argDef;
    }

    private ObjectInspector initExprNodeEvaluator(ExprNodeEvaluator exprEval, ExprNodeDesc exprNode, ShapeDetails inpShape) throws HiveException {
        ObjectInspector outOI = exprEval.initialize(inpShape.getOI());
        List<ExprNodeGenericFuncDesc> llFuncExprs = this.llInfo.getLLFuncExprsInTopExpr(exprNode);
        if (llFuncExprs != null) {
            for (ExprNodeGenericFuncDesc llFuncExpr : llFuncExprs) {
                ExprNodeDesc firstArg = llFuncExpr.getChildren().get(0);
                ExprNodeEvaluator dupExprEval = WindowingExprNodeEvaluatorFactory.get(this.llInfo, firstArg);
                dupExprEval.initialize(inpShape.getOI());
                GenericUDFLeadLag llFn = (GenericUDFLeadLag)llFuncExpr.getGenericUDF();
                llFn.setExprEvaluator(dupExprEval);
            }
        }
        return outOI;
    }

    protected static SerDe createLazyBinarySerDe(Configuration cfg, StructObjectInspector oi, Map<String, String> serdePropsMap) throws SerDeException {
        serdePropsMap = serdePropsMap == null ? new LinkedHashMap<String, String>() : serdePropsMap;
        PTFDeserializer.addOIPropertiestoSerDePropsMap(oi, serdePropsMap);
        LazyBinarySerDe serDe = new LazyBinarySerDe();
        Properties p = new Properties();
        p.setProperty("columns", (String)serdePropsMap.get("columns"));
        p.setProperty("columns.types", (String)serdePropsMap.get("columns.types"));
        SerDeUtils.initializeSerDe(serDe, cfg, p, null);
        return serDe;
    }

    private static ArrayList<? extends Object>[] getTypeMap(StructObjectInspector oi) {
        StructTypeInfo t = (StructTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector(oi);
        ArrayList<String> fnames = t.getAllStructFieldNames();
        ArrayList<TypeInfo> fields = t.getAllStructFieldTypeInfos();
        return new ArrayList[]{fnames, fields};
    }

    public static StructObjectInspector getStandardStructOI(RowResolver rr) {
        ArrayList<ColumnInfo> colLists = rr.getColumnInfos();
        ArrayList<String> structFieldNames = new ArrayList<String>();
        ArrayList<ObjectInspector> structFieldObjectInspectors = new ArrayList<ObjectInspector>();
        for (ColumnInfo columnInfo : colLists) {
            String colName = columnInfo.getInternalName();
            ObjectInspector colOI = columnInfo.getObjectInspector();
            structFieldNames.add(colName);
            structFieldObjectInspectors.add(colOI);
        }
        StandardStructObjectInspector oi = ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, structFieldObjectInspectors);
        return oi;
    }

    protected static void validateComparable(ObjectInspector OI, String errMsg) throws SemanticException {
        if (!ObjectInspectorUtils.compareSupported(OI)) {
            throw new SemanticException(errMsg);
        }
    }

    private static void addInputColumnsToList(ShapeDetails shape, ArrayList<String> fieldNames, ArrayList<ObjectInspector> fieldOIs) {
        StructObjectInspector OI = shape.getOI();
        for (StructField structField : OI.getAllStructFieldRefs()) {
            fieldNames.add(structField.getFieldName());
            fieldOIs.add(structField.getFieldObjectInspector());
        }
    }

    protected static RowResolver buildRowResolverForPTF(String tbFnName, String tabAlias, StructObjectInspector rowObjectInspector, List<String> outputColNames, RowResolver inputRR) throws SemanticException {
        if (FunctionRegistry.isNoopFunction(tbFnName)) {
            return PTFTranslator.buildRowResolverForNoop(tabAlias, rowObjectInspector, inputRR);
        }
        RowResolver rwsch = new RowResolver();
        List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
        for (int i = 0; i < fields.size(); ++i) {
            ColumnInfo colInfo = new ColumnInfo(fields.get(i).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()), tabAlias, false);
            rwsch.put(tabAlias, outputColNames.get(i), colInfo);
        }
        return rwsch;
    }

    protected RowResolver buildRowResolverForWindowing(WindowTableFunctionDef def) throws SemanticException {
        RowResolver rr = new RowResolver();
        HashMap<String, WindowingSpec.WindowExpressionSpec> aliasToExprMap = this.windowingSpec.getAliasToWdwExpr();
        for (WindowFunctionDef wFnDef : def.getWindowFunctions()) {
            ASTNode ast = aliasToExprMap.get(wFnDef.getAlias()).getExpression();
            ObjectInspector wFnOI = null;
            wFnOI = wFnDef.isPivotResult() ? ((ListObjectInspector)wFnDef.getOI()).getListElementObjectInspector() : wFnDef.getOI();
            ColumnInfo cInfo = new ColumnInfo(wFnDef.getAlias(), TypeInfoUtils.getTypeInfoFromObjectInspector(wFnOI), null, true, true);
            rr.putExpression(ast, cInfo);
        }
        RowResolver inpRR = def.getRawInputShape().getRr();
        for (ColumnInfo inpCInfo : this.inputRR.getColumnInfos()) {
            String[] altMapping;
            ColumnInfo cInfo = new ColumnInfo(inpCInfo);
            ASTNode inExpr = PTFTranslator.getASTNode(inpCInfo, inpRR);
            if (inExpr != null) {
                rr.putExpression(inExpr, cInfo);
            } else {
                String[] tabColAlias = this.inputRR.reverseLookup(inpCInfo.getInternalName());
                if (tabColAlias != null) {
                    rr.put(tabColAlias[0], tabColAlias[1], cInfo);
                } else {
                    rr.put(inpCInfo.getTabAlias(), inpCInfo.getAlias(), cInfo);
                }
            }
            if ((altMapping = this.inputRR.getAlternateMappings(inpCInfo.getInternalName())) == null) continue;
            rr.put(altMapping[0], altMapping[1], cInfo);
        }
        return rr;
    }

    protected static RowResolver buildRowResolverForNoop(String tabAlias, StructObjectInspector rowObjectInspector, RowResolver inputRowResolver) throws SemanticException {
        LOG.info("QueryTranslationInfo::getRowResolver invoked on ObjectInspector");
        RowResolver rwsch = new RowResolver();
        List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
        for (int i = 0; i < fields.size(); ++i) {
            ASTNode expr;
            ColumnInfo colInfo;
            ColumnInfo inpColInfo;
            String colAlias;
            StructField field = fields.get(i);
            String internalName = field.getFieldName();
            String[] tabColAlias = inputRowResolver == null ? null : inputRowResolver.reverseLookup(internalName);
            String colTabAlias = tabColAlias == null ? tabAlias : tabColAlias[0];
            String string = colAlias = tabColAlias == null ? null : tabColAlias[1];
            if (tabColAlias != null) {
                inpColInfo = inputRowResolver.get(colTabAlias, colAlias);
            } else {
                inpColInfo = inputRowResolver == null ? null : inputRowResolver.get(tabAlias, internalName);
                String string2 = colAlias = inpColInfo != null ? inpColInfo.getInternalName() : colAlias;
            }
            if (inpColInfo != null) {
                colInfo = new ColumnInfo(inpColInfo);
                colInfo.setTabAlias(tabAlias);
            } else {
                colInfo = new ColumnInfo(fields.get(i).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()), tabAlias, false);
                colAlias = colInfo.getInternalName();
            }
            ASTNode aSTNode = expr = inputRowResolver == null ? null : PTFTranslator.getASTNode(inpColInfo, inputRowResolver);
            if (expr != null) {
                rwsch.putExpression(expr, colInfo);
                continue;
            }
            rwsch.put(tabAlias, colAlias, colInfo);
        }
        return rwsch;
    }

    public static ASTNode getASTNode(ColumnInfo cInfo, RowResolver rr) throws SemanticException {
        for (Map.Entry<String, ASTNode> entry : rr.getExpressionMap().entrySet()) {
            ASTNode expr = entry.getValue();
            if (!rr.getExpression(expr).equals(cInfo)) continue;
            return expr;
        }
        return null;
    }

    public static void visit(Object t, TreeWizard.ContextVisitor visitor) {
        PTFTranslator._visit(t, null, 0, visitor);
    }

    private static void _visit(Object t, Object parent, int childIndex, TreeWizard.ContextVisitor visitor) {
        if (t == null) {
            return;
        }
        visitor.visit(t, parent, childIndex, null);
        int n = ParseDriver.adaptor.getChildCount(t);
        for (int i = 0; i < n; ++i) {
            Object child = ParseDriver.adaptor.getChild(t, i);
            PTFTranslator._visit(child, t, i, visitor);
        }
    }

    public static ArrayList<PTFInvocationSpec> componentize(PTFInvocationSpec ptfInvocation) throws SemanticException {
        ArrayList<PTFInvocationSpec> componentInvocations = new ArrayList<PTFInvocationSpec>();
        Stack<PTFInvocationSpec.PartitionedTableFunctionSpec> ptfChain = new Stack<PTFInvocationSpec.PartitionedTableFunctionSpec>();
        PTFInvocationSpec.PTFInputSpec spec = ptfInvocation.getFunction();
        while (spec instanceof PTFInvocationSpec.PartitionedTableFunctionSpec) {
            ptfChain.push((PTFInvocationSpec.PartitionedTableFunctionSpec)spec);
            spec = ((PTFInvocationSpec.PTFInputSpec)spec).getInput();
        }
        PTFInvocationSpec.PartitionedTableFunctionSpec prevFn = (PTFInvocationSpec.PartitionedTableFunctionSpec)ptfChain.pop();
        PTFTranslator.applyConstantPartition(prevFn);
        PTFInvocationSpec.PartitionSpec partSpec = prevFn.getPartition();
        PTFInvocationSpec.OrderSpec orderSpec = prevFn.getOrder();
        if (partSpec == null) {
            throw new SemanticException("No Partitioning specification specified at start of a PTFChain");
        }
        if (orderSpec == null) {
            orderSpec = new PTFInvocationSpec.OrderSpec(partSpec);
            prevFn.setOrder(orderSpec);
        }
        while (!ptfChain.isEmpty()) {
            PTFInvocationSpec.PartitionedTableFunctionSpec currentFn = (PTFInvocationSpec.PartitionedTableFunctionSpec)ptfChain.pop();
            String fnName = currentFn.getName();
            if (!FunctionRegistry.isTableFunction(fnName)) {
                throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(fnName));
            }
            boolean transformsRawInput = FunctionRegistry.getTableFunctionResolver(fnName).transformsRawInput();
            if (currentFn.getPartition() == null) {
                currentFn.setPartition(prevFn.getPartition());
                if (currentFn.getOrder() == null) {
                    currentFn.setOrder(prevFn.getOrder());
                }
            }
            if (currentFn.getOrder() == null) {
                currentFn.setOrder(new PTFInvocationSpec.OrderSpec(currentFn.getPartition()));
            }
            if (!currentFn.getPartition().equals(partSpec) || !currentFn.getOrder().equals(orderSpec) || transformsRawInput) {
                PTFInvocationSpec component = new PTFInvocationSpec();
                component.setFunction(prevFn);
                componentInvocations.add(component);
                PTFInvocationSpec.PTFQueryInputSpec cQInSpec = new PTFInvocationSpec.PTFQueryInputSpec();
                cQInSpec.setType(PTFInvocationSpec.PTFQueryInputType.PTFCOMPONENT);
                currentFn.setInput(cQInSpec);
            }
            prevFn = currentFn;
            partSpec = prevFn.getPartition();
            orderSpec = prevFn.getOrder();
        }
        componentInvocations.add(ptfInvocation);
        return componentInvocations;
    }

    public static void validateNoLeadLagInValueBoundarySpec(ASTNode node) throws SemanticException {
        String errMsg = "Lead/Lag not allowed in ValueBoundary Spec";
        TreeWizard tw = new TreeWizard(ParseDriver.adaptor, HiveParser.tokenNames);
        ValidateNoLeadLag visitor = new ValidateNoLeadLag(errMsg);
        tw.visit((Object)node, 705, (TreeWizard.ContextVisitor)visitor);
        visitor.checkValid();
    }

    public static class ValidateNoLeadLag
    implements TreeWizard.ContextVisitor {
        String errMsg;
        boolean throwError = false;
        ASTNode errorNode;

        public ValidateNoLeadLag(String errMsg) {
            this.errMsg = errMsg;
        }

        public void visit(Object t, Object parent, int childIndex, Map labels) {
            ASTNode expr = (ASTNode)t;
            ASTNode nameNode = (ASTNode)expr.getChild(0);
            if (nameNode.getText().equals("lead") || nameNode.getText().equals("lag")) {
                this.throwError = true;
                this.errorNode = expr;
            }
        }

        void checkValid() throws SemanticException {
            if (this.throwError) {
                throw new SemanticException(this.errMsg + this.errorNode.toStringTree());
            }
        }
    }
}

