/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.expressions.translator;

import com.facebook.presto.expressions.translator.TranslatedExpression;
import com.facebook.presto.expressions.translator.TranslatorAnnotationParser;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.relation.RowExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class FunctionTranslator<T> {
    private final Map<FunctionMetadata, MethodHandle> functionMapping;

    public static <T> FunctionTranslator<T> buildFunctionTranslator(Set<Class<?>> translatorContainers) {
        ImmutableMap.Builder functionMappingBuilder = new ImmutableMap.Builder();
        translatorContainers.stream().map(TranslatorAnnotationParser::parseFunctionDefinitions).forEach(arg_0 -> ((ImmutableMap.Builder)functionMappingBuilder).putAll(arg_0));
        return new FunctionTranslator<T>((Map<FunctionMetadata, MethodHandle>)functionMappingBuilder.build());
    }

    public TranslatedExpression<T> translate(FunctionMetadata functionMetadata, RowExpression original, List<TranslatedExpression<T>> translatedArguments) throws Throwable {
        if (!this.functionMapping.containsKey(functionMetadata)) {
            return new TranslatedExpression(Optional.empty(), original, translatedArguments);
        }
        return new TranslatedExpression<Object>(Optional.of(this.functionMapping.get(functionMetadata).invokeWithArguments(translatedArguments)), original, translatedArguments);
    }

    public TranslatedExpression<T> translate(FunctionMetadata functionMetadata, RowExpression original, TranslatedExpression<T> ... translatedArguments) throws Throwable {
        return this.translate(functionMetadata, original, (List<TranslatedExpression<T>>)ImmutableList.copyOf((Object[])translatedArguments));
    }

    public TranslatedExpression<T> translate(FunctionMetadata functionMetadata, RowExpression original) throws Throwable {
        return this.translate(functionMetadata, original, (List<TranslatedExpression<T>>)ImmutableList.of());
    }

    private FunctionTranslator(Map<FunctionMetadata, MethodHandle> functionMapping) {
        this.functionMapping = Objects.requireNonNull(functionMapping, "functionMapping is null");
    }
}

