/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DictionaryCompressionOptimizer;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSink;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.OrcWriterStats;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressedMetadataWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StripeStatistics;
import com.facebook.presto.orc.stream.OrcDataOutput;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.ColumnWriters;
import com.facebook.presto.orc.writer.SliceDictionaryColumnWriter;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class OrcWriter
implements Closeable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(OrcWriter.class).instanceSize();
    private static final Logger log = Logger.get(OrcWriter.class);
    static final String PRESTO_ORC_WRITER_VERSION_METADATA_KEY = "presto.writer.version";
    static final String PRESTO_ORC_WRITER_VERSION;
    private final OrcWriterStats stats;
    private final OrcDataSink orcDataSink;
    private final List<Type> types;
    private final OrcEncoding orcEncoding;
    private final CompressionKind compression;
    private final int stripeMinBytes;
    private final int stripeMaxBytes;
    private final int chunkMaxLogicalBytes;
    private final int stripeMaxRowCount;
    private final int rowGroupMaxRowCount;
    private final int maxCompressionBufferSize;
    private final Map<String, String> userMetadata;
    private final CompressedMetadataWriter metadataWriter;
    private final DateTimeZone hiveStorageTimeZone;
    private final List<ClosedStripe> closedStripes = new ArrayList<ClosedStripe>();
    private final List<OrcType> orcTypes;
    private final List<ColumnWriter> columnWriters;
    private final DictionaryCompressionOptimizer dictionaryCompressionOptimizer;
    private int stripeRowCount;
    private int rowGroupRowCount;
    private int bufferedBytes;
    private long columnWritersRetainedBytes;
    private long closedStripesRetainedBytes;
    private long previouslyRecordedSizeInBytes;
    private boolean closed;
    @Nullable
    private final OrcWriteValidation.OrcWriteValidationBuilder validationBuilder;

    public OrcWriter(OrcDataSink orcDataSink, List<String> columnNames, List<Type> types, OrcEncoding orcEncoding, CompressionKind compression, OrcWriterOptions options, Map<String, String> userMetadata, DateTimeZone hiveStorageTimeZone, boolean validate, OrcWriteValidation.OrcWriteValidationMode validationMode, OrcWriterStats stats) {
        this.validationBuilder = validate ? new OrcWriteValidation.OrcWriteValidationBuilder(validationMode, types).setStringStatisticsLimitInBytes(Math.toIntExact(options.getMaxStringStatisticsLimit().toBytes())) : null;
        this.orcDataSink = Objects.requireNonNull(orcDataSink, "orcDataSink is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.orcEncoding = Objects.requireNonNull(orcEncoding, "orcEncoding is null");
        this.compression = Objects.requireNonNull(compression, "compression is null");
        this.recordValidation(validation -> validation.setCompression(compression));
        Objects.requireNonNull(options, "options is null");
        Preconditions.checkArgument((options.getStripeMaxSize().compareTo(options.getStripeMinSize()) >= 0 ? 1 : 0) != 0, (Object)"stripeMaxSize must be greater than stripeMinSize");
        this.stripeMinBytes = Math.toIntExact(Objects.requireNonNull(options.getStripeMinSize(), "stripeMinSize is null").toBytes());
        this.stripeMaxBytes = Math.toIntExact(Objects.requireNonNull(options.getStripeMaxSize(), "stripeMaxSize is null").toBytes());
        this.chunkMaxLogicalBytes = Integer.max(1, this.stripeMaxBytes / 2);
        this.stripeMaxRowCount = options.getStripeMaxRowCount();
        this.rowGroupMaxRowCount = options.getRowGroupMaxRowCount();
        this.recordValidation(validation -> validation.setRowGroupMaxRowCount(this.rowGroupMaxRowCount));
        this.maxCompressionBufferSize = Math.toIntExact(options.getMaxCompressionBufferSize().toBytes());
        this.userMetadata = ImmutableMap.builder().putAll(Objects.requireNonNull(userMetadata, "userMetadata is null")).put((Object)PRESTO_ORC_WRITER_VERSION_METADATA_KEY, (Object)PRESTO_ORC_WRITER_VERSION).build();
        this.metadataWriter = new CompressedMetadataWriter(orcEncoding.createMetadataWriter(), compression, this.maxCompressionBufferSize);
        this.hiveStorageTimeZone = Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        this.orcTypes = OrcType.createOrcRowType(0, columnNames, types);
        this.recordValidation(validation -> validation.setColumnNames(columnNames));
        OrcType rootType = this.orcTypes.get(0);
        Preconditions.checkArgument((rootType.getFieldCount() == types.size() ? 1 : 0) != 0);
        ImmutableList.Builder columnWriters = ImmutableList.builder();
        ImmutableSet.Builder sliceColumnWriters = ImmutableSet.builder();
        for (int fieldId = 0; fieldId < types.size(); ++fieldId) {
            int fieldColumnIndex = rootType.getFieldTypeIndex(fieldId);
            Type fieldType = types.get(fieldId);
            ColumnWriter columnWriter = ColumnWriters.createColumnWriter(fieldColumnIndex, this.orcTypes, fieldType, compression, this.maxCompressionBufferSize, orcEncoding, hiveStorageTimeZone, options.getMaxStringStatisticsLimit());
            columnWriters.add((Object)columnWriter);
            if (columnWriter instanceof SliceDictionaryColumnWriter) {
                sliceColumnWriters.add((Object)((SliceDictionaryColumnWriter)columnWriter));
                continue;
            }
            for (ColumnWriter nestedColumnWriter : columnWriter.getNestedColumnWriters()) {
                if (!(nestedColumnWriter instanceof SliceDictionaryColumnWriter)) continue;
                sliceColumnWriters.add((Object)((SliceDictionaryColumnWriter)nestedColumnWriter));
            }
        }
        this.columnWriters = columnWriters.build();
        this.dictionaryCompressionOptimizer = new DictionaryCompressionOptimizer((Set<? extends DictionaryCompressionOptimizer.DictionaryColumn>)sliceColumnWriters.build(), this.stripeMinBytes, this.stripeMaxBytes, this.stripeMaxRowCount, Math.toIntExact(Objects.requireNonNull(options.getDictionaryMaxMemory(), "dictionaryMaxMemory is null").toBytes()));
        for (Map.Entry<String, String> entry : this.userMetadata.entrySet()) {
            this.recordValidation(validation -> validation.addMetadataProperty((String)entry.getKey(), Slices.utf8Slice((String)((String)entry.getValue()))));
        }
        this.previouslyRecordedSizeInBytes = this.getRetainedBytes();
        stats.updateSizeInBytes(this.previouslyRecordedSizeInBytes);
    }

    public long getWrittenBytes() {
        return this.orcDataSink.size();
    }

    public int getBufferedBytes() {
        return this.bufferedBytes;
    }

    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.columnWritersRetainedBytes + this.closedStripesRetainedBytes + this.orcDataSink.getRetainedSizeInBytes() + (this.validationBuilder == null ? 0L : this.validationBuilder.getRetainedSize());
    }

    public void write(Page page) throws IOException {
        Objects.requireNonNull(page, "page is null");
        if (page.getPositionCount() == 0) {
            return;
        }
        Preconditions.checkArgument((page.getChannelCount() == this.columnWriters.size() ? 1 : 0) != 0);
        if (this.validationBuilder != null) {
            this.validationBuilder.addPage((Page)page);
        }
        int averageLogicalSizePerRow = this.estimateAverageLogicalSizePerRow((Page)page);
        int maxChunkRowCount = Integer.max(1, this.chunkMaxLogicalBytes / Integer.max(1, averageLogicalSizePerRow));
        while (page != null) {
            int chunkRows = Integer.min(maxChunkRowCount, Integer.min(this.rowGroupMaxRowCount - this.rowGroupRowCount, this.stripeMaxRowCount - this.stripeRowCount));
            chunkRows = Integer.min(page.getPositionCount(), chunkRows);
            Page chunk = page.getRegion(0, chunkRows);
            page = chunkRows < page.getPositionCount() ? page.getRegion(chunkRows, page.getPositionCount() - chunkRows) : null;
            this.writeChunk(chunk);
        }
        long recordedSizeInBytes = this.getRetainedBytes();
        this.stats.updateSizeInBytes(recordedSizeInBytes - this.previouslyRecordedSizeInBytes);
        this.previouslyRecordedSizeInBytes = recordedSizeInBytes;
    }

    private void writeChunk(Page chunk) throws IOException {
        if (this.rowGroupRowCount == 0) {
            this.columnWriters.forEach(ColumnWriter::beginRowGroup);
        }
        this.bufferedBytes = 0;
        for (int channel = 0; channel < chunk.getChannelCount(); ++channel) {
            ColumnWriter writer = this.columnWriters.get(channel);
            writer.writeBlock(chunk.getBlock(channel));
            this.bufferedBytes = (int)((long)this.bufferedBytes + writer.getBufferedBytes());
        }
        this.rowGroupRowCount += chunk.getPositionCount();
        Preconditions.checkState((this.rowGroupRowCount <= this.rowGroupMaxRowCount ? 1 : 0) != 0);
        this.stripeRowCount += chunk.getPositionCount();
        if (this.rowGroupRowCount == this.rowGroupMaxRowCount) {
            this.finishRowGroup();
        }
        this.dictionaryCompressionOptimizer.optimize(this.bufferedBytes, this.stripeRowCount);
        this.bufferedBytes = Math.toIntExact(this.columnWriters.stream().mapToLong(ColumnWriter::getBufferedBytes).sum());
        if (this.stripeRowCount == this.stripeMaxRowCount) {
            this.flushStripe(OrcWriterStats.FlushReason.MAX_ROWS);
        } else if (this.bufferedBytes > this.stripeMaxBytes) {
            this.flushStripe(OrcWriterStats.FlushReason.MAX_BYTES);
        } else if (this.dictionaryCompressionOptimizer.isFull(this.bufferedBytes)) {
            this.flushStripe(OrcWriterStats.FlushReason.DICTIONARY_FULL);
        }
        this.columnWritersRetainedBytes = this.columnWriters.stream().mapToLong(ColumnWriter::getRetainedBytes).sum();
    }

    private void finishRowGroup() {
        HashMap columnStatistics = new HashMap();
        this.columnWriters.forEach(columnWriter -> columnStatistics.putAll(columnWriter.finishRowGroup()));
        this.recordValidation(validation -> validation.addRowGroupStatistics(columnStatistics));
        this.rowGroupRowCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushStripe(OrcWriterStats.FlushReason flushReason) throws IOException {
        ArrayList<OrcDataOutput> outputData = new ArrayList<OrcDataOutput>();
        long stripeStartOffset = this.orcDataSink.size();
        if (this.closedStripes.isEmpty()) {
            outputData.add(OrcDataOutput.createDataOutput(PostScript.MAGIC));
            stripeStartOffset += (long)PostScript.MAGIC.length();
        }
        try {
            outputData.addAll(this.bufferStripeData(stripeStartOffset, flushReason));
            if (flushReason == OrcWriterStats.FlushReason.CLOSED) {
                outputData.addAll(this.bufferFileFooter());
            }
            this.orcDataSink.write(outputData);
        }
        finally {
            this.columnWriters.forEach(ColumnWriter::reset);
            this.dictionaryCompressionOptimizer.reset();
            this.rowGroupRowCount = 0;
            this.stripeRowCount = 0;
            this.bufferedBytes = Math.toIntExact(this.columnWriters.stream().mapToLong(ColumnWriter::getBufferedBytes).sum());
        }
    }

    private List<OrcDataOutput> bufferStripeData(long stripeStartOffset, OrcWriterStats.FlushReason flushReason) throws IOException {
        if (this.stripeRowCount == 0) {
            Verify.verify((flushReason == OrcWriterStats.FlushReason.CLOSED ? 1 : 0) != 0, (String)"An empty stripe is not allowed", (Object[])new Object[0]);
            this.columnWriters.forEach(ColumnWriter::close);
            return ImmutableList.of();
        }
        if (this.rowGroupRowCount > 0) {
            this.finishRowGroup();
        }
        this.dictionaryCompressionOptimizer.finalOptimize(this.bufferedBytes);
        this.columnWriters.forEach(ColumnWriter::close);
        ArrayList<OrcDataOutput> outputData = new ArrayList<OrcDataOutput>();
        ArrayList<Stream> allStreams = new ArrayList<Stream>(this.columnWriters.size() * 3);
        long indexLength = 0L;
        for (ColumnWriter columnWriter2 : this.columnWriters) {
            for (StreamDataOutput streamDataOutput : columnWriter2.getIndexStreams(this.metadataWriter)) {
                outputData.add(streamDataOutput);
                allStreams.add(streamDataOutput.getStream());
                indexLength += streamDataOutput.size();
            }
        }
        long dataLength = 0L;
        ArrayList<StreamDataOutput> dataStreams = new ArrayList<StreamDataOutput>(this.columnWriters.size() * 2);
        for (ColumnWriter columnWriter3 : this.columnWriters) {
            List<StreamDataOutput> streams = columnWriter3.getDataStreams();
            dataStreams.addAll(streams);
            dataLength += streams.stream().mapToLong(StreamDataOutput::size).sum();
        }
        Collections.sort(dataStreams);
        for (StreamDataOutput dataStream : dataStreams) {
            outputData.add(dataStream);
            allStreams.add(dataStream.getStream());
        }
        HashMap<Integer, ColumnEncoding> hashMap = new HashMap<Integer, ColumnEncoding>();
        this.columnWriters.forEach(columnWriter -> columnEncodings.putAll(columnWriter.getColumnEncodings()));
        HashMap<Integer, ColumnStatistics> columnStatistics = new HashMap<Integer, ColumnStatistics>();
        this.columnWriters.forEach(columnWriter -> columnStatistics.putAll(columnWriter.getColumnStripeStatistics()));
        hashMap.put(0, new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0));
        columnStatistics.put(0, new ColumnStatistics(Long.valueOf(this.stripeRowCount), 0L, null, null, null, null, null, null, null, null));
        StripeFooter stripeFooter = new StripeFooter(allStreams, OrcWriter.toDenseList(hashMap, this.orcTypes.size()));
        Slice footer = this.metadataWriter.writeStripeFooter(stripeFooter);
        outputData.add(OrcDataOutput.createDataOutput(footer));
        StripeStatistics statistics = new StripeStatistics(OrcWriter.toDenseList(columnStatistics, this.orcTypes.size()));
        this.recordValidation(validation -> validation.addStripeStatistics(stripeStartOffset, statistics));
        StripeInformation stripeInformation = new StripeInformation(this.stripeRowCount, stripeStartOffset, indexLength, dataLength, footer.length());
        ClosedStripe closedStripe = new ClosedStripe(stripeInformation, statistics);
        this.closedStripes.add(closedStripe);
        this.closedStripesRetainedBytes += closedStripe.getRetainedSizeInBytes();
        this.recordValidation(validation -> validation.addStripe(stripeInformation.getNumberOfRows()));
        this.stats.recordStripeWritten(flushReason, stripeInformation.getTotalLength(), stripeInformation.getNumberOfRows(), this.dictionaryCompressionOptimizer.getDictionaryMemoryBytes());
        return outputData;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.stats.updateSizeInBytes(-this.previouslyRecordedSizeInBytes);
        this.previouslyRecordedSizeInBytes = 0L;
        this.flushStripe(OrcWriterStats.FlushReason.CLOSED);
        this.orcDataSink.close();
    }

    private List<OrcDataOutput> bufferFileFooter() throws IOException {
        ArrayList<OrcDataOutput> outputData = new ArrayList<OrcDataOutput>();
        Metadata metadata = new Metadata(this.closedStripes.stream().map(ClosedStripe::getStatistics).collect(Collectors.toList()));
        Slice metadataSlice = this.metadataWriter.writeMetadata(metadata);
        outputData.add(OrcDataOutput.createDataOutput(metadataSlice));
        long numberOfRows = this.closedStripes.stream().mapToLong(stripe -> stripe.getStripeInformation().getNumberOfRows()).sum();
        List<ColumnStatistics> fileStats = OrcWriter.toFileStats(this.closedStripes.stream().map(ClosedStripe::getStatistics).map(StripeStatistics::getColumnStatistics).collect(Collectors.toList()));
        this.recordValidation(validation -> validation.setFileStatistics(fileStats));
        Map<String, Slice> userMetadata = this.userMetadata.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Slices.utf8Slice((String)((String)entry.getValue()))));
        Footer footer = new Footer(numberOfRows, this.rowGroupMaxRowCount, this.closedStripes.stream().map(ClosedStripe::getStripeInformation).collect(Collectors.toList()), this.orcTypes, fileStats, userMetadata);
        this.closedStripes.clear();
        this.closedStripesRetainedBytes = 0L;
        Slice footerSlice = this.metadataWriter.writeFooter(footer);
        outputData.add(OrcDataOutput.createDataOutput(footerSlice));
        this.recordValidation(validation -> validation.setVersion(this.metadataWriter.getOrcMetadataVersion()));
        Slice postscriptSlice = this.metadataWriter.writePostscript(footerSlice.length(), metadataSlice.length(), this.compression, this.maxCompressionBufferSize);
        outputData.add(OrcDataOutput.createDataOutput(postscriptSlice));
        outputData.add(OrcDataOutput.createDataOutput(Slices.wrappedBuffer((byte[])new byte[]{(byte)postscriptSlice.length()})));
        return outputData;
    }

    private void recordValidation(Consumer<OrcWriteValidation.OrcWriteValidationBuilder> task) {
        if (this.validationBuilder != null) {
            task.accept(this.validationBuilder);
        }
    }

    public void validate(OrcDataSource input) throws OrcCorruptionException {
        Preconditions.checkState((this.validationBuilder != null ? 1 : 0) != 0, (Object)"validation is not enabled");
        OrcReader.validateFile(this.validationBuilder.build(), input, this.types, this.hiveStorageTimeZone, this.orcEncoding);
    }

    private int estimateAverageLogicalSizePerRow(Page page) {
        Preconditions.checkArgument((page.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"page is empty");
        Page chunk = page.getRegion(0, Integer.min(page.getPositionCount(), 100));
        return Math.toIntExact(chunk.getLogicalSizeInBytes() / (long)chunk.getPositionCount());
    }

    private static <T> List<T> toDenseList(Map<Integer, T> data, int expectedSize) {
        Preconditions.checkArgument((data.size() == expectedSize ? 1 : 0) != 0);
        ArrayList<T> list = new ArrayList<T>(expectedSize);
        for (int i = 0; i < expectedSize; ++i) {
            list.add(data.get(i));
        }
        return ImmutableList.copyOf(list);
    }

    private static List<ColumnStatistics> toFileStats(List<List<ColumnStatistics>> stripes) {
        if (stripes.isEmpty()) {
            return ImmutableList.of();
        }
        int columnCount = stripes.get(0).size();
        Preconditions.checkArgument((boolean)stripes.stream().allMatch(stripe -> columnCount == stripe.size()));
        ImmutableList.Builder fileStats = ImmutableList.builder();
        int i = 0;
        while (i < columnCount) {
            int column = i++;
            fileStats.add((Object)ColumnStatistics.mergeColumnStatistics(stripes.stream().map(stripe -> (ColumnStatistics)stripe.get(column)).collect(Collectors.toList())));
        }
        return fileStats.build();
    }

    static {
        String version = OrcWriter.class.getPackage().getImplementationVersion();
        PRESTO_ORC_WRITER_VERSION = version == null ? "UNKNOWN" : version;
    }

    private static class ClosedStripe {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(ClosedStripe.class).instanceSize() + ClassLayout.parseClass(StripeInformation.class).instanceSize();
        private final StripeInformation stripeInformation;
        private final StripeStatistics statistics;

        public ClosedStripe(StripeInformation stripeInformation, StripeStatistics statistics) {
            this.stripeInformation = Objects.requireNonNull(stripeInformation, "stripeInformation is null");
            this.statistics = Objects.requireNonNull(statistics, "stripeStatistics is null");
        }

        public StripeInformation getStripeInformation() {
            return this.stripeInformation;
        }

        public StripeStatistics getStatistics() {
            return this.statistics;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.statistics.getRetainedSizeInBytes();
        }
    }
}

