/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.DwrfSequenceEncoding;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.BatchStreamReaders;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class MapFlatBatchStreamReader
implements BatchStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapFlatBatchStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private final DateTimeZone hiveStorageTimeZone;
    private final StreamDescriptor baseValueStreamDescriptor;
    private final OrcType.OrcTypeKind keyOrcType;
    private final List<InputStreamSource<BooleanInputStream>> inMapStreamSources = new ArrayList<InputStreamSource<BooleanInputStream>>();
    private final List<BooleanInputStream> inMapStreams = new ArrayList<BooleanInputStream>();
    private final List<BatchStreamReader> valueStreamReaders = new ArrayList<BatchStreamReader>();
    private final List<StreamDescriptor> valueStreamDescriptors = new ArrayList<StreamDescriptor>();
    private Block keyBlockTemplate;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private boolean rowGroupOpen;

    public MapFlatBatchStreamReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.hiveStorageTimeZone = Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        this.keyOrcType = streamDescriptor.getNestedStreams().get(0).getOrcTypeKind();
        this.baseValueStreamDescriptor = streamDescriptor.getNestedStreams().get(1);
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                for (int i = 0; i < this.valueStreamReaders.size(); ++i) {
                    int valueReadOffset = this.inMapStreams.get(i).countBitsSet(this.readOffset);
                    this.valueStreamReaders.get(i).prepareNextRead(valueReadOffset);
                }
            }
        }
        boolean[][] inMapVectors = new boolean[this.inMapStreamSources.size()][];
        boolean[] nullVector = null;
        int totalMapEntries = 0;
        if (this.presentStream == null) {
            for (int keyIndex = 0; keyIndex < this.inMapStreams.size(); ++keyIndex) {
                inMapVectors[keyIndex] = new boolean[this.nextBatchSize];
                totalMapEntries += this.inMapStreams.get(keyIndex).getSetBits(this.nextBatchSize, inMapVectors[keyIndex]);
            }
        } else {
            int i;
            nullVector = new boolean[this.nextBatchSize];
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, nullVector);
            if (nullValues == this.nextBatchSize) {
                for (i = 0; i < this.inMapStreams.size(); ++i) {
                    inMapVectors[i] = null;
                    totalMapEntries += this.nextBatchSize;
                }
            } else {
                for (i = 0; i < this.inMapStreams.size(); ++i) {
                    inMapVectors[i] = new boolean[this.nextBatchSize];
                    totalMapEntries += this.inMapStreams.get(i).getSetBits(this.nextBatchSize, inMapVectors[i], nullVector);
                }
            }
        }
        MapType mapType = (MapType)type;
        Type valueType = mapType.getValueType();
        Block[] valueBlocks = new Block[this.valueStreamReaders.size()];
        for (int keyIndex = 0; keyIndex < this.valueStreamReaders.size(); ++keyIndex) {
            int mapsContainingKey = 0;
            for (int mapIndex = 0; mapIndex < this.nextBatchSize; ++mapIndex) {
                if (inMapVectors[keyIndex] != null && !inMapVectors[keyIndex][mapIndex]) continue;
                ++mapsContainingKey;
            }
            if (mapsContainingKey > 0) {
                BatchStreamReader streamReader = this.valueStreamReaders.get(keyIndex);
                streamReader.prepareNextRead(mapsContainingKey);
                valueBlocks[keyIndex] = streamReader.readBlock(valueType);
                continue;
            }
            valueBlocks[keyIndex] = valueType.createBlockBuilder(null, 0).build();
        }
        int[] valueBlockPositions = new int[inMapVectors.length];
        BlockBuilder valueBlockBuilder = valueType.createBlockBuilder(null, totalMapEntries);
        int[] keyIds = new int[totalMapEntries];
        int keyIdsIndex = 0;
        int[] mapOffsets = new int[this.nextBatchSize + 1];
        mapOffsets[0] = 0;
        for (int mapIndex = 0; mapIndex < this.nextBatchSize; ++mapIndex) {
            int mapLength = 0;
            for (int keyIndex = 0; keyIndex < inMapVectors.length; ++keyIndex) {
                if (inMapVectors[keyIndex] != null && !inMapVectors[keyIndex][mapIndex]) continue;
                ++mapLength;
                valueType.appendTo(valueBlocks[keyIndex], valueBlockPositions[keyIndex], valueBlockBuilder);
                keyIds[keyIdsIndex++] = keyIndex;
                int n = keyIndex;
                valueBlockPositions[n] = valueBlockPositions[n] + 1;
            }
            mapOffsets[mapIndex + 1] = mapOffsets[mapIndex] + mapLength;
        }
        Block block = mapType.createBlockFromKeyValue(this.nextBatchSize, Optional.ofNullable(nullVector), mapOffsets, (Block)new DictionaryBlock(this.keyBlockTemplate, keyIds), (Block)valueBlockBuilder);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        for (int i = 0; i < this.inMapStreamSources.size(); ++i) {
            BooleanInputStream inMapStream = Objects.requireNonNull(this.inMapStreamSources.get(i).openStream(), "missing inMapStream at position " + i);
            this.inMapStreams.add(inMapStream);
        }
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encodings) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.inMapStreamSources.clear();
        this.valueStreamDescriptors.clear();
        this.valueStreamReaders.clear();
        ColumnEncoding encoding = encodings.get(this.baseValueStreamDescriptor.getStreamId());
        SortedMap additionalSequenceEncodings = encoding.getAdditionalSequenceEncodings().orElse(Collections.emptySortedMap());
        Iterator iterator = additionalSequenceEncodings.keySet().iterator();
        while (iterator.hasNext()) {
            int sequence = (Integer)iterator.next();
            this.inMapStreamSources.add(MissingInputStreamSource.missingStreamSource(BooleanInputStream.class));
            StreamDescriptor valueStreamDescriptor = MapFlatBatchStreamReader.copyStreamDescriptorWithSequence(this.baseValueStreamDescriptor, sequence);
            this.valueStreamDescriptors.add(valueStreamDescriptor);
            BatchStreamReader valueStreamReader = BatchStreamReaders.createStreamReader(valueStreamDescriptor, this.hiveStorageTimeZone);
            valueStreamReader.startStripe(dictionaryStreamSources, encodings);
            this.valueStreamReaders.add(valueStreamReader);
        }
        this.keyBlockTemplate = this.getKeyBlockTemplate(additionalSequenceEncodings.values());
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
    }

    private static StreamDescriptor copyStreamDescriptorWithSequence(StreamDescriptor streamDescriptor, int sequence) {
        List streamDescriptors = (List)streamDescriptor.getNestedStreams().stream().map(stream -> MapFlatBatchStreamReader.copyStreamDescriptorWithSequence(stream, sequence)).collect(ImmutableList.toImmutableList());
        return new StreamDescriptor(streamDescriptor.getStreamName(), streamDescriptor.getStreamId(), streamDescriptor.getFieldName(), streamDescriptor.getOrcType(), streamDescriptor.getOrcDataSource(), streamDescriptors, sequence);
    }

    private Block getKeyBlockTemplate(Collection<DwrfSequenceEncoding> sequenceEncodings) {
        switch (this.keyOrcType) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return this.getIntegerKeyBlockTemplate(sequenceEncodings);
            }
            case STRING: 
            case BINARY: {
                return this.getSliceKeysBlockTemplate(sequenceEncodings);
            }
        }
        throw new IllegalArgumentException("Unsupported flat map key type: " + (Object)((Object)this.keyOrcType));
    }

    private Block getIntegerKeyBlockTemplate(Collection<DwrfSequenceEncoding> sequenceEncodings) {
        TinyintType keyType;
        switch (this.keyOrcType) {
            case BYTE: {
                keyType = TinyintType.TINYINT;
                break;
            }
            case SHORT: {
                keyType = SmallintType.SMALLINT;
                break;
            }
            case INT: {
                keyType = IntegerType.INTEGER;
                break;
            }
            case LONG: {
                keyType = BigintType.BIGINT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported flat map key type: " + (Object)((Object)this.keyOrcType));
            }
        }
        BlockBuilder blockBuilder = keyType.createBlockBuilder(null, sequenceEncodings.size());
        for (DwrfSequenceEncoding sequenceEncoding : sequenceEncodings) {
            keyType.writeLong(blockBuilder, sequenceEncoding.getKey().getIntKey());
        }
        return blockBuilder.build();
    }

    private Block getSliceKeysBlockTemplate(Collection<DwrfSequenceEncoding> sequenceEncodings) {
        int bytes = 0;
        for (DwrfSequenceEncoding sequenceEncoding : sequenceEncodings) {
            bytes += sequenceEncoding.getKey().getBytesKey().size();
        }
        VariableWidthBlockBuilder builder = new VariableWidthBlockBuilder(null, sequenceEncodings.size(), bytes);
        for (DwrfSequenceEncoding sequenceEncoding : sequenceEncodings) {
            Slice key = Slices.wrappedBuffer((byte[])sequenceEncoding.getKey().getBytesKey().toByteArray());
            builder.writeBytes(key, 0, key.length());
            builder.closeEntry();
        }
        return builder.build();
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        for (int i = 0; i < this.valueStreamDescriptors.size(); ++i) {
            InputStreamSource<BooleanInputStream> inMapStreamSource = dataStreamSources.getInputStreamSource(this.valueStreamDescriptors.get(i), Stream.StreamKind.IN_MAP, BooleanInputStream.class);
            this.inMapStreamSources.set(i, inMapStreamSource);
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inMapStreams.clear();
        this.rowGroupOpen = false;
        for (BatchStreamReader valueStreamReader : this.valueStreamReaders) {
            valueStreamReader.startRowGroup(dataStreamSources);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedSize = INSTANCE_SIZE;
        for (BatchStreamReader valueStreamReader : this.valueStreamReaders) {
            retainedSize += valueStreamReader.getRetainedSizeInBytes();
        }
        return retainedSize;
    }
}

