/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.ApacheHiveTimestampDecoder;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class TimestampBatchStreamReader
implements BatchStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TimestampBatchStreamReader.class).instanceSize();
    private static final int MILLIS_PER_SECOND = 1000;
    private final StreamDescriptor streamDescriptor;
    private final long baseTimestampInSeconds;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> secondsStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream secondsStream;
    private InputStreamSource<LongInputStream> nanosStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream nanosStream;
    private boolean rowGroupOpen;

    public TimestampBatchStreamReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.baseTimestampInSeconds = new DateTime(2015, 1, 1, 0, 0, Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null")).getMillis() / 1000L;
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.secondsStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but seconds stream is not present");
                }
                if (this.nanosStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but nanos stream is not present");
                }
                this.secondsStream.skip(this.readOffset);
                this.nanosStream.skip(this.readOffset);
            }
        }
        if (this.secondsStream == null && this.nanosStream == null && this.presentStream != null) {
            this.presentStream.skip(this.nextBatchSize);
            Block nullValueBlock = RunLengthEncodedBlock.create((Type)type, null, (int)this.nextBatchSize);
            this.readOffset = 0;
            this.nextBatchSize = 0;
            return nullValueBlock;
        }
        BlockBuilder builder = type.createBlockBuilder(null, this.nextBatchSize);
        if (this.presentStream == null) {
            if (this.secondsStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but seconds stream is not present");
            }
            if (this.nanosStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but nanos stream is not present");
            }
            for (int i = 0; i < this.nextBatchSize; ++i) {
                type.writeLong(builder, ApacheHiveTimestampDecoder.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.baseTimestampInSeconds));
            }
        } else {
            Verify.verify((this.secondsStream != null ? 1 : 0) != 0, (String)"Value is not null but seconds stream is not present", (Object[])new Object[0]);
            Verify.verify((this.nanosStream != null ? 1 : 0) != 0, (String)"Value is not null but nanos stream is not present", (Object[])new Object[0]);
            for (int i = 0; i < this.nextBatchSize; ++i) {
                if (this.presentStream.nextBit()) {
                    type.writeLong(builder, ApacheHiveTimestampDecoder.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.baseTimestampInSeconds));
                    continue;
                }
                builder.appendNull();
            }
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return builder.build();
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.secondsStream = this.secondsStreamSource.openStream();
        this.nanosStream = this.nanosStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.secondsStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.nanosStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.secondsStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.nanosStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

