/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.BitFieldReader;
import com.facebook.hive.orc.DynamicByteArray;
import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.RunLengthIntegerReader;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Text;

public class LazyStringDictionaryTreeReader
extends LazyTreeReader {
    private DynamicByteArray dictionaryBuffer = null;
    private DynamicByteArray strideDictionaryBuffer;
    private int dictionarySize;
    private int[] strideDictionarySizes;
    private int[] dictionaryOffsets;
    private int[] strideDictionaryOffsets;
    private RunLengthIntegerReader reader;
    private BitFieldReader inDictionary;
    private InStream directReader;
    private RunLengthIntegerReader directLengths;
    private int currentUnitDictionary = -1;

    LazyStringDictionaryTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        super.startStripe(streams, encodings, indexes, rowBaseInStripe);
        this.dictionarySize = encodings.get(this.columnId).getDictionarySize();
        StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH);
        InStream in = streams.get(name);
        RunLengthIntegerReader lenReader = new RunLengthIntegerReader(in, false, 4);
        int offset = 0;
        if (this.dictionaryOffsets == null || this.dictionaryOffsets.length < this.dictionarySize + 1) {
            this.dictionaryOffsets = new int[this.dictionarySize + 1];
        }
        for (int i = 0; i < this.dictionarySize; ++i) {
            this.dictionaryOffsets[i] = offset;
            offset += (int)lenReader.next();
        }
        this.dictionaryOffsets[this.dictionarySize] = offset;
        in.close();
        name = new StreamName(this.columnId, OrcProto.Stream.Kind.DICTIONARY_DATA);
        in = streams.get(name);
        if (in.available() > 0) {
            this.dictionaryBuffer = new DynamicByteArray(this.dictionaryOffsets[this.dictionarySize]);
            this.dictionaryBuffer.readAll(in);
        } else {
            this.dictionaryBuffer = null;
        }
        in.close();
        name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
        this.reader = new RunLengthIntegerReader(streams.get(name), false, 4);
        InStream inDictionaryStream = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.IN_DICTIONARY));
        this.inDictionary = inDictionaryStream == null ? null : new BitFieldReader(inDictionaryStream);
        this.directReader = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.STRIDE_DICTIONARY));
        InStream directLengthsStream = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.STRIDE_DICTIONARY_LENGTH));
        RunLengthIntegerReader runLengthIntegerReader = this.directLengths = directLengthsStream == null ? null : new RunLengthIntegerReader(directLengthsStream, false, 4);
        if (indexes[this.columnId] != null) {
            this.loadIndeces(indexes[this.columnId].getEntryList(), 0);
        }
    }

    @Override
    public void seek(int index) throws IOException {
        this.reader.seek(index);
        if (this.inDictionary != null) {
            this.inDictionary.seek(index);
        }
    }

    @Override
    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = super.loadIndeces(rowIndexEntries, startIndex);
        if (this.inDictionary != null) {
            updatedStartIndex = this.directReader.loadIndeces(rowIndexEntries, updatedStartIndex);
            updatedStartIndex = this.directLengths.loadIndeces(rowIndexEntries, updatedStartIndex);
            int numIndeces = rowIndexEntries.size();
            this.strideDictionarySizes = new int[numIndeces + 1];
            int i = 0;
            for (OrcProto.RowIndexEntry rowIndexEntry : rowIndexEntries) {
                this.strideDictionarySizes[i] = (int)rowIndexEntry.getPositions(updatedStartIndex);
                ++i;
            }
            ++updatedStartIndex;
            updatedStartIndex = this.reader.loadIndeces(rowIndexEntries, updatedStartIndex);
            return this.inDictionary.loadIndeces(rowIndexEntries, updatedStartIndex);
        }
        updatedStartIndex = this.reader.loadIndeces(rowIndexEntries, updatedStartIndex);
        return updatedStartIndex;
    }

    private void nextFromDictionary(Text result) throws IOException {
        int entry = (int)this.reader.next();
        int offset = this.dictionaryOffsets[entry];
        int length = this.dictionaryOffsets[entry + 1] - this.dictionaryOffsets[entry];
        if (this.dictionaryBuffer != null) {
            this.dictionaryBuffer.setText(result, offset, length);
        } else {
            result.clear();
        }
    }

    private void loadStrideDictionary(int indexEntry) throws IOException {
        this.currentUnitDictionary = indexEntry;
        int offset = 0;
        int unitDictionarySize = this.strideDictionarySizes[indexEntry];
        if (this.strideDictionaryOffsets == null || this.strideDictionaryOffsets.length < unitDictionarySize + 1) {
            this.strideDictionaryOffsets = new int[unitDictionarySize + 1];
        }
        this.directLengths.seek(indexEntry);
        for (int i = 0; i < unitDictionarySize; ++i) {
            this.strideDictionaryOffsets[i] = offset;
            offset += (int)this.directLengths.next();
        }
        this.strideDictionaryOffsets[unitDictionarySize] = offset;
        if (offset != 0) {
            this.directReader.seek(indexEntry);
            this.strideDictionaryBuffer = new DynamicByteArray(offset);
            this.strideDictionaryBuffer.read(this.directReader, offset);
        } else {
            this.strideDictionaryBuffer = null;
        }
    }

    private void nextFromStrideDictionary(Text result) throws IOException {
        int indexEntry = this.computeRowIndexEntry(this.previousRow);
        if (indexEntry != this.currentUnitDictionary) {
            this.loadStrideDictionary(indexEntry);
        }
        int entry = (int)this.reader.next();
        int offset = this.strideDictionaryOffsets[entry];
        int length = entry < this.strideDictionaryOffsets.length - 1 ? this.strideDictionaryOffsets[entry + 1] - offset : this.strideDictionaryBuffer.size() - offset;
        if (this.strideDictionaryBuffer != null) {
            this.strideDictionaryBuffer.setText(result, offset, length);
        } else {
            result.clear();
        }
    }

    @Override
    public Object next(Object previous) throws IOException {
        Text result = null;
        if (this.valuePresent) {
            boolean isDictionaryEncoded;
            result = previous == null ? new Text() : (Text)previous;
            boolean bl = isDictionaryEncoded = this.inDictionary == null || this.inDictionary.next() == 1;
            if (isDictionaryEncoded) {
                this.nextFromDictionary(result);
            } else {
                this.nextFromStrideDictionary(result);
            }
        }
        return result;
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        this.reader.skip(numNonNullValues);
        if (this.inDictionary != null) {
            this.inDictionary.skip(numNonNullValues);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.inDictionary != null) {
            this.inDictionary.close();
        }
        if (this.directReader != null) {
            this.directReader.close();
        }
        if (this.directLengths != null) {
            this.directLengths.close();
        }
        this.dictionaryBuffer = null;
        this.strideDictionaryBuffer = null;
        this.strideDictionarySizes = null;
        this.dictionaryOffsets = null;
        this.strideDictionaryOffsets = null;
    }
}

