/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.util.AutoValue_AsyncWriteChannelOptions;
import com.google.common.flogger.GoogleLogger;

@AutoValue
public abstract class AsyncWriteChannelOptions {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    @Deprecated
    public static final boolean LIMIT_FILESIZE_TO_250GB_DEFAULT = false;
    public static final int BUFFER_SIZE_DEFAULT = 0x800000;
    public static final int PIPE_BUFFER_SIZE_DEFAULT = 0x100000;
    public static final int UPLOAD_CHUNK_SIZE_DEFAULT = 0x4000000;
    @Deprecated
    public static final int UPLOAD_BUFFER_SIZE_DEFAULT = 0x4000000;
    public static final boolean DIRECT_UPLOAD_ENABLED_DEFAULT = false;

    @Deprecated
    public static Builder newBuilder() {
        return AsyncWriteChannelOptions.builder();
    }

    public static Builder builder() {
        return new AutoValue_AsyncWriteChannelOptions.Builder().setFileSizeLimitedTo250Gb(false).setBufferSize(0x800000).setPipeBufferSize(0x100000).setUploadChunkSize(0x4000000).setDirectUploadEnabled(false);
    }

    @Deprecated
    public abstract boolean isFileSizeLimitedTo250Gb();

    public abstract int getBufferSize();

    public abstract int getPipeBufferSize();

    @Deprecated
    public int getUploadBufferSize() {
        return this.getUploadChunkSize();
    }

    public abstract int getUploadChunkSize();

    public abstract boolean isDirectUploadEnabled();

    @AutoValue.Builder
    public static abstract class Builder {
        @Deprecated
        public abstract Builder setFileSizeLimitedTo250Gb(boolean var1);

        public abstract Builder setBufferSize(int var1);

        public abstract Builder setPipeBufferSize(int var1);

        @Deprecated
        public Builder setUploadBufferSize(int uploadBufferSize) {
            return this.setUploadChunkSize(uploadBufferSize);
        }

        public abstract Builder setUploadChunkSize(int var1);

        public abstract Builder setDirectUploadEnabled(boolean var1);

        abstract AsyncWriteChannelOptions autoBuild();

        public AsyncWriteChannelOptions build() {
            AsyncWriteChannelOptions options = this.autoBuild();
            if (options.isFileSizeLimitedTo250Gb()) {
                ((GoogleLogger.Api)logger.atWarning()).log("fileSizeLimitedTo250Gb now defaults to false. It is deprecated and will soon be removed. Files greater than 250Gb are allowed by default.");
            }
            return options;
        }
    }
}

