/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.GetServiceVersionPRequest;
import alluxio.grpc.GrpcChannel;
import alluxio.grpc.GrpcChannelBuilder;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.ServiceType;
import alluxio.grpc.ServiceVersionClientServiceGrpc;
import alluxio.master.MasterInquireClient;
import alluxio.retry.RetryPolicy;
import alluxio.retry.RetryUtils;
import alluxio.security.user.UserState;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.uri.Authority;
import alluxio.uri.MultiMasterAuthority;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingMasterInquireClient
implements MasterInquireClient {
    private static final Logger LOG = LoggerFactory.getLogger(PollingMasterInquireClient.class);
    private final MultiMasterConnectDetails mConnectDetails;
    private final Supplier<RetryPolicy> mRetryPolicySupplier;
    private final AlluxioConfiguration mConfiguration;
    private final UserState mUserState;

    public PollingMasterInquireClient(List<InetSocketAddress> masterAddresses, AlluxioConfiguration alluxioConf, UserState userState) {
        this(masterAddresses, () -> RetryUtils.defaultClientRetry(alluxioConf.getDuration(PropertyKey.USER_RPC_RETRY_MAX_DURATION), alluxioConf.getDuration(PropertyKey.USER_RPC_RETRY_BASE_SLEEP_MS), alluxioConf.getDuration(PropertyKey.USER_RPC_RETRY_MAX_SLEEP_MS)), alluxioConf, userState);
    }

    public PollingMasterInquireClient(List<InetSocketAddress> masterAddresses, Supplier<RetryPolicy> retryPolicySupplier, AlluxioConfiguration alluxioConf) {
        this.mConnectDetails = new MultiMasterConnectDetails(masterAddresses);
        this.mRetryPolicySupplier = retryPolicySupplier;
        this.mConfiguration = alluxioConf;
        this.mUserState = UserState.Factory.create(this.mConfiguration);
    }

    public PollingMasterInquireClient(List<InetSocketAddress> masterAddresses, Supplier<RetryPolicy> retryPolicySupplier, AlluxioConfiguration alluxioConf, UserState userState) {
        this.mConnectDetails = new MultiMasterConnectDetails(masterAddresses);
        this.mRetryPolicySupplier = retryPolicySupplier;
        this.mConfiguration = alluxioConf;
        this.mUserState = userState;
    }

    @Override
    public InetSocketAddress getPrimaryRpcAddress() throws UnavailableException {
        RetryPolicy retry = this.mRetryPolicySupplier.get();
        while (retry.attempt()) {
            InetSocketAddress address = this.getAddress();
            if (address == null) continue;
            return address;
        }
        throw new UnavailableException(String.format("Failed to determine primary master rpc address after polling each of %s %d times", this.mConnectDetails.getAddresses(), retry.getAttemptCount()));
    }

    @Nullable
    private InetSocketAddress getAddress() {
        for (InetSocketAddress address : this.mConnectDetails.getAddresses()) {
            try {
                LOG.debug("Checking whether {} is listening for RPCs", (Object)address);
                this.pingMetaService(address);
                LOG.debug("Successfully connected to {}", (Object)address);
                return address;
            }
            catch (UnavailableException e) {
                LOG.debug("Failed to connect to {}", (Object)address);
            }
            catch (AlluxioStatusException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private void pingMetaService(InetSocketAddress address) throws AlluxioStatusException {
        GrpcChannel channel = GrpcChannelBuilder.newBuilder(GrpcServerAddress.create(address), this.mConfiguration).setSubject(this.mUserState.getSubject()).setClientType("MasterInquireClient").disableAuthentication().build();
        ServiceVersionClientServiceGrpc.ServiceVersionClientServiceBlockingStub versionClient = ServiceVersionClientServiceGrpc.newBlockingStub(channel);
        ServiceType serviceType = address.getPort() == this.mConfiguration.getInt(PropertyKey.JOB_MASTER_RPC_PORT) ? ServiceType.JOB_MASTER_CLIENT_SERVICE : ServiceType.META_MASTER_CLIENT_SERVICE;
        try {
            versionClient.getServiceVersion(GetServiceVersionPRequest.newBuilder().setServiceType(serviceType).build());
        }
        catch (StatusRuntimeException e) {
            throw AlluxioStatusException.fromThrowable(e);
        }
        finally {
            channel.shutdown();
        }
    }

    @Override
    public List<InetSocketAddress> getMasterRpcAddresses() {
        return this.mConnectDetails.getAddresses();
    }

    @Override
    public MasterInquireClient.ConnectDetails getConnectDetails() {
        return this.mConnectDetails;
    }

    public static class MultiMasterConnectDetails
    implements MasterInquireClient.ConnectDetails {
        private final List<InetSocketAddress> mAddresses;

        public MultiMasterConnectDetails(List<InetSocketAddress> addresses) {
            this.mAddresses = addresses;
        }

        public List<InetSocketAddress> getAddresses() {
            return this.mAddresses;
        }

        @Override
        public Authority toAuthority() {
            return new MultiMasterAuthority(this.mAddresses.stream().map(addr -> addr.getHostString() + ":" + addr.getPort()).collect(Collectors.joining(",")));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MultiMasterConnectDetails)) {
                return false;
            }
            MultiMasterConnectDetails that = (MultiMasterConnectDetails)o;
            return this.mAddresses.equals(that.mAddresses);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.mAddresses);
        }

        public String toString() {
            return this.toAuthority().toString();
        }
    }
}

