/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.event.client;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

enum EventDataType {
    STRING((Class)String.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            1.validateFieldValueType(value, String.class);
            jsonGenerator.writeString((String)value);
        }
    }
    ,
    BOOLEAN((Class)Boolean.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            2.validateFieldValueType(value, Boolean.class);
            jsonGenerator.writeBoolean(((Boolean)value).booleanValue());
        }
    }
    ,
    BYTE((Class)Byte.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            3.validateFieldValueType(value, Byte.class);
            jsonGenerator.writeNumber((short)((Byte)value).byteValue());
        }
    }
    ,
    SHORT((Class)Short.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            4.validateFieldValueType(value, Short.class);
            jsonGenerator.writeNumber(((Short)value).shortValue());
        }
    }
    ,
    INTEGER((Class)Integer.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            5.validateFieldValueType(value, Integer.class);
            jsonGenerator.writeNumber(((Integer)value).intValue());
        }
    }
    ,
    LONG((Class)Long.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            6.validateFieldValueType(value, Long.class);
            jsonGenerator.writeNumber(((Long)value).longValue());
        }
    }
    ,
    FLOAT((Class)Float.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            7.validateFieldValueType(value, Float.class);
            jsonGenerator.writeNumber(((Float)value).floatValue());
        }
    }
    ,
    DOUBLE((Class)Double.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            8.validateFieldValueType(value, Double.class);
            jsonGenerator.writeNumber(((Double)value).doubleValue());
        }
    }
    ,
    BIG_DECIMAL((Class)BigDecimal.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            9.validateFieldValueType(value, BigDecimal.class);
            jsonGenerator.writeNumber((BigDecimal)value);
        }
    }
    ,
    BIG_INTEGER((Class)BigInteger.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            10.validateFieldValueType(value, BigInteger.class);
            jsonGenerator.writeNumber(new BigDecimal((BigInteger)value));
        }
    }
    ,
    INSTANT((Class)Instant.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            11.validateFieldValueType(value, Instant.class);
            jsonGenerator.writeString(java.time.format.DateTimeFormatter.ISO_INSTANT.format((Instant)value));
        }
    }
    ,
    DATETIME((Class)DateTime.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            12.validateFieldValueType(value, DateTime.class);
            jsonGenerator.writeString(ISO_DATETIME_FORMAT.print((ReadableInstant)((DateTime)value)));
        }
    }
    ,
    ENUM((Class)Enum.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            13.validateFieldValueType(value, Enum.class);
            jsonGenerator.writeString(value.toString());
        }
    }
    ,
    INET_ADDRESS((Class)InetAddress.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            14.validateFieldValueType(value, InetAddress.class);
            jsonGenerator.writeString(((InetAddress)value).getHostAddress());
        }
    }
    ,
    UUID((Class)UUID.class){

        @Override
        public void writeFieldValue(JsonGenerator jsonGenerator, Object value) throws IOException {
            15.validateFieldValueType(value, UUID.class);
            jsonGenerator.writeString(value.toString());
        }
    };

    private static final DateTimeFormatter ISO_DATETIME_FORMAT;
    private static final Map<Class<?>, EventDataType> byType;
    private final Class<?> type;

    public static EventDataType getEventDataType(Class<?> type) {
        return byType.get(type);
    }

    private EventDataType(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    static void validateFieldValueType(Object value, Class<?> expectedType) {
        Objects.requireNonNull(value, "value is null");
        Preconditions.checkArgument((boolean)expectedType.isInstance(value), (Object)("Expected 'value' to be a " + expectedType.getSimpleName() + " but it is a " + value.getClass().getName()));
    }

    public abstract void writeFieldValue(JsonGenerator var1, Object var2) throws IOException;

    static {
        ISO_DATETIME_FORMAT = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EventDataType eventDataType : EventDataType.values()) {
            Class<?> dataType = eventDataType.getType();
            builder.put(dataType, (Object)eventDataType);
            if (!Primitives.isWrapperType(dataType)) continue;
            builder.put((Object)Primitives.unwrap(dataType), (Object)eventDataType);
        }
        byType = builder.build();
    }
}

