/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.util;

public class HtmlEncoder {
    protected static final char[][] ATTR = new char[64][];
    protected static final char[][] TEXT = new char[64][];
    protected static final char[][] BLOCK = new char[64][];

    public static String attribute(String value) {
        return HtmlEncoder.encode(value, ATTR);
    }

    public static String text(String text) {
        return HtmlEncoder.encode(text, TEXT);
    }

    private static String encode(String text, char[][] array) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + (len >> 2));
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c < '@') {
                buffer.append(array[c]);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String block(String text) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + (len >> 2));
        int prev = 0;
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c != '\n' || prev != 13) {
                if (c < '@') {
                    buffer.append(BLOCK[c]);
                } else {
                    buffer.append(c);
                }
            }
            prev = c;
        }
        return buffer.toString();
    }

    public static String strict(String text) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + (len >> 2));
        int prev = 0;
        boolean prevSpace = false;
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == ' ') {
                if (prev != 32) {
                    prevSpace = false;
                }
                if (!prevSpace) {
                    buffer.append(' ');
                } else {
                    buffer.append("&nbsp;");
                }
                prevSpace = !prevSpace;
            } else if (c != '\n' || prev != 13) {
                if (c < '@') {
                    buffer.append(BLOCK[c]);
                } else {
                    buffer.append(c);
                }
            }
            prev = c;
        }
        return buffer.toString();
    }

    static {
        for (int i = 0; i < 64; ++i) {
            HtmlEncoder.TEXT[i] = new char[]{(char)i};
        }
        HtmlEncoder.TEXT[39] = "&#039;".toCharArray();
        HtmlEncoder.TEXT[34] = "&quot;".toCharArray();
        HtmlEncoder.TEXT[38] = "&amp;".toCharArray();
        HtmlEncoder.TEXT[60] = "&lt;".toCharArray();
        HtmlEncoder.TEXT[62] = "&gt;".toCharArray();
        System.arraycopy(TEXT, 0, BLOCK, 0, 64);
        HtmlEncoder.BLOCK[10] = "<br/>".toCharArray();
        HtmlEncoder.BLOCK[13] = "<br/>".toCharArray();
        System.arraycopy(TEXT, 0, ATTR, 0, 64);
        HtmlEncoder.ATTR[39] = "'".toCharArray();
    }
}

