/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.ShimLoader;

public final class TxnDbUtil {
    private static final Log LOG = LogFactory.getLog(TxnDbUtil.class.getName());
    private static final String TXN_MANAGER = "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager";
    private static int deadlockCnt = 0;

    private TxnDbUtil() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static void setConfValues(HiveConf conf) {
        conf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, TXN_MANAGER);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, true);
    }

    public static void prepDb() throws Exception {
        block6: {
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = TxnDbUtil.getConnection();
                stmt = conn.createStatement();
                stmt.execute("CREATE TABLE TXNS (  TXN_ID bigint PRIMARY KEY,  TXN_STATE char(1) NOT NULL,  TXN_STARTED bigint NOT NULL,  TXN_LAST_HEARTBEAT bigint NOT NULL,  TXN_USER varchar(128) NOT NULL,  TXN_HOST varchar(128) NOT NULL)");
                stmt.execute("CREATE TABLE TXN_COMPONENTS (  TC_TXNID bigint REFERENCES TXNS (TXN_ID),  TC_DATABASE varchar(128) NOT NULL,  TC_TABLE varchar(128),  TC_PARTITION varchar(767))");
                stmt.execute("CREATE TABLE COMPLETED_TXN_COMPONENTS (  CTC_TXNID bigint,  CTC_DATABASE varchar(128) NOT NULL,  CTC_TABLE varchar(128),  CTC_PARTITION varchar(767))");
                stmt.execute("CREATE TABLE NEXT_TXN_ID (  NTXN_NEXT bigint NOT NULL)");
                stmt.execute("INSERT INTO NEXT_TXN_ID VALUES(1)");
                stmt.execute("CREATE TABLE HIVE_LOCKS ( HL_LOCK_EXT_ID bigint NOT NULL, HL_LOCK_INT_ID bigint NOT NULL, HL_TXNID bigint, HL_DB varchar(128) NOT NULL, HL_TABLE varchar(128), HL_PARTITION varchar(767), HL_LOCK_STATE char(1) NOT NULL, HL_LOCK_TYPE char(1) NOT NULL, HL_LAST_HEARTBEAT bigint NOT NULL, HL_ACQUIRED_AT bigint, HL_USER varchar(128) NOT NULL, HL_HOST varchar(128) NOT NULL, PRIMARY KEY(HL_LOCK_EXT_ID, HL_LOCK_INT_ID))");
                stmt.execute("CREATE INDEX HL_TXNID_INDEX ON HIVE_LOCKS (HL_TXNID)");
                stmt.execute("CREATE TABLE NEXT_LOCK_ID ( NL_NEXT bigint NOT NULL)");
                stmt.execute("INSERT INTO NEXT_LOCK_ID VALUES(1)");
                stmt.execute("CREATE TABLE COMPACTION_QUEUE ( CQ_ID bigint PRIMARY KEY, CQ_DATABASE varchar(128) NOT NULL, CQ_TABLE varchar(128) NOT NULL, CQ_PARTITION varchar(767), CQ_STATE char(1) NOT NULL, CQ_TYPE char(1) NOT NULL, CQ_WORKER_ID varchar(128), CQ_START bigint, CQ_RUN_AS varchar(128))");
                stmt.execute("CREATE TABLE NEXT_COMPACTION_QUEUE_ID (NCQ_NEXT bigint NOT NULL)");
                stmt.execute("INSERT INTO NEXT_COMPACTION_QUEUE_ID VALUES(1)");
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                if (e instanceof SQLTransactionRollbackException && deadlockCnt++ < 5) {
                    LOG.warn("Caught deadlock, retrying db creation");
                    TxnDbUtil.prepDb();
                    break block6;
                }
                throw e;
            }
            finally {
                deadlockCnt = 0;
                TxnDbUtil.closeResources(conn, stmt, null);
            }
        }
    }

    public static void cleanDb() throws Exception {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = TxnDbUtil.getConnection();
            stmt = conn.createStatement();
            try {
                stmt.execute("DROP INDEX HL_TXNID_INDEX");
            }
            catch (Exception e) {
                System.err.println("Unable to drop index HL_TXNID_INDEX " + e.getMessage());
            }
            TxnDbUtil.dropTable(stmt, "TXN_COMPONENTS");
            TxnDbUtil.dropTable(stmt, "COMPLETED_TXN_COMPONENTS");
            TxnDbUtil.dropTable(stmt, "TXNS");
            TxnDbUtil.dropTable(stmt, "NEXT_TXN_ID");
            TxnDbUtil.dropTable(stmt, "HIVE_LOCKS");
            TxnDbUtil.dropTable(stmt, "NEXT_LOCK_ID");
            TxnDbUtil.dropTable(stmt, "COMPACTION_QUEUE");
            TxnDbUtil.dropTable(stmt, "NEXT_COMPACTION_QUEUE_ID");
            conn.commit();
        }
        finally {
            TxnDbUtil.closeResources(conn, stmt, null);
        }
    }

    private static void dropTable(Statement stmt, String name) {
        try {
            stmt.execute("DROP TABLE " + name);
        }
        catch (Exception e) {
            System.err.println("Unable to drop table " + name + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countLockComponents(long lockId) throws Exception {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block3: {
            int n;
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = TxnDbUtil.getConnection();
                stmt = conn.prepareStatement("SELECT count(*) FROM hive_locks WHERE hl_lock_ext_id = ?");
                stmt.setLong(1, lockId);
                rs = stmt.executeQuery();
                if (rs.next()) break block3;
                n = 0;
            }
            catch (Throwable throwable) {
                TxnDbUtil.closeResources(conn, stmt, rs);
                throw throwable;
            }
            TxnDbUtil.closeResources(conn, stmt, rs);
            return n;
        }
        int n = rs.getInt(1);
        TxnDbUtil.closeResources(conn, stmt, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findNumCurrentLocks() throws Exception {
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block3: {
            int n;
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = TxnDbUtil.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery("select count(*) from hive_locks");
                if (rs.next()) break block3;
                n = 0;
            }
            catch (Throwable throwable) {
                TxnDbUtil.closeResources(conn, stmt, rs);
                throw throwable;
            }
            TxnDbUtil.closeResources(conn, stmt, rs);
            return n;
        }
        int n = rs.getInt(1);
        TxnDbUtil.closeResources(conn, stmt, rs);
        return n;
    }

    private static Connection getConnection() throws Exception {
        HiveConf conf = new HiveConf();
        String jdbcDriver = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_CONNECTION_DRIVER);
        Driver driver = (Driver)Class.forName(jdbcDriver).newInstance();
        Properties prop = new Properties();
        String driverUrl = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORECONNECTURLKEY);
        String user = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_CONNECTION_USER_NAME);
        String passwd = ShimLoader.getHadoopShims().getPassword(conf, HiveConf.ConfVars.METASTOREPWD.varname);
        prop.setProperty("user", user);
        prop.setProperty("password", passwd);
        return driver.connect(driverUrl, prop);
    }

    private static void closeResources(Connection conn, Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                System.err.println("Error closing ResultSet: " + e.getMessage());
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                System.err.println("Error closing Statement: " + e.getMessage());
            }
        }
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                System.err.println("Error rolling back: " + e.getMessage());
            }
            try {
                conn.close();
            }
            catch (SQLException e) {
                System.err.println("Error closing Connection: " + e.getMessage());
            }
        }
    }
}

