/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.facebook.presto.hive.$internal.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jline.TerminalFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Heartbeater;
import org.apache.hadoop.hive.ql.exec.MapOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.internal.CLibrary;

public class TezJobMonitor {
    private static final String CLASS_NAME = TezJobMonitor.class.getName();
    private static final int MIN_TERMINAL_WIDTH = 80;
    private static final int COLUMN_1_WIDTH = 16;
    private static final int SEPARATOR_WIDTH = 80;
    private static final String HEADER_FORMAT = "%16s%12s  %5s  %9s  %7s  %7s  %6s  %6s";
    private static final String VERTEX_FORMAT = "%-16s%12s  %5s  %9s  %7s  %7s  %6s  %6s";
    private static final String FOOTER_FORMAT = "%-15s  %-30s %-4s  %-25s";
    private static final String HEADER = String.format("%16s%12s  %5s  %9s  %7s  %7s  %6s  %6s", "VERTICES", "STATUS", "TOTAL", "COMPLETED", "RUNNING", "PENDING", "FAILED", "KILLED");
    private static final String SUMMARY_HEADER_FORMAT = "%-16s %-12s %-12s %-12s %-19s %-19s %-15s %-15s %-15s";
    private static final String SUMMARY_VERTEX_FORMAT = "%-16s %11s %16s %12s %16s %18s %18s %14s %16s";
    private static final String SUMMARY_HEADER = String.format("%-16s %-12s %-12s %-12s %-19s %-19s %-15s %-15s %-15s", "VERTICES", "TOTAL_TASKS", "FAILED_ATTEMPTS", "KILLED_TASKS", "DURATION_SECONDS", "CPU_TIME_MILLIS", "GC_TIME_MILLIS", "INPUT_RECORDS", "OUTPUT_RECORDS");
    private static final String TOTAL_PREP_TIME = "TotalPrepTime";
    private static final String METHOD = "METHOD";
    private static final String DURATION = "DURATION(ms)";
    private int lines;
    private final PrintStream out;
    private String separator = "";
    private transient SessionState.LogHelper console;
    private final PerfLogger perfLogger = PerfLogger.getPerfLogger();
    private final int checkInterval = 200;
    private final int maxRetryInterval = 2500;
    private final int printInterval = 3000;
    private final int progressBarChars = 30;
    private long lastPrintTime;
    private Set<String> completed;
    private final NumberFormat secondsFormat;
    private final NumberFormat commaFormat;
    private static final List<DAGClient> shutdownList = Collections.synchronizedList(new LinkedList());
    private StringBuffer diagnostics;

    public static void initShutdownHook() {
        Preconditions.checkNotNull(shutdownList, "Shutdown hook was not properly initialized");
    }

    public TezJobMonitor() {
        this.console = SessionState.getConsole();
        this.secondsFormat = new DecimalFormat("#0.00");
        this.commaFormat = NumberFormat.getNumberInstance(Locale.US);
        this.out = this.console.getInfoStream();
        for (int i = 0; i < 80; ++i) {
            this.separator = this.separator + "-";
        }
    }

    private static boolean isUnixTerminal() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            return false;
        }
        try {
            if (CLibrary.isatty((int)CLibrary.STDOUT_FILENO) == 0) {
                return false;
            }
            if (CLibrary.isatty((int)CLibrary.STDERR_FILENO) == 0) {
                return false;
            }
        }
        catch (NoClassDefFoundError ignore) {
            return false;
        }
        catch (UnsatisfiedLinkError ignore) {
            return false;
        }
        return true;
    }

    public void reprintLine(String line) {
        this.out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).a(line).a('\n').toString());
        this.out.flush();
        ++this.lines;
    }

    public void reprintLineWithColorAsBold(String line, Ansi.Color color) {
        this.out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).fg(color).bold().a(line).a('\n').boldOff().reset().toString());
        this.out.flush();
        ++this.lines;
    }

    public void reprintMultiLine(String line) {
        int numLines = line.split("\r\n|\r|\n").length;
        this.out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).a(line).a('\n').toString());
        this.out.flush();
        this.lines += numLines;
    }

    public void repositionCursor() {
        if (this.lines > 0) {
            this.out.print(Ansi.ansi().cursorUp(this.lines).toString());
            this.out.flush();
            this.lines = 0;
        }
    }

    public int getTerminalWidth() {
        return TerminalFactory.get().getWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int monitorExecution(DAGClient dagClient, HiveTxnManager txnMgr, HiveConf conf, DAG dag) throws InterruptedException {
        boolean isTerminal;
        DAGStatus status = null;
        this.completed = new HashSet<String>();
        this.diagnostics = new StringBuffer();
        boolean running = false;
        boolean done = false;
        int failedCounter = 0;
        int rc = 0;
        DAGStatus.State lastState = null;
        String lastReport = null;
        HashSet opts = new HashSet();
        Heartbeater heartbeater = new Heartbeater(txnMgr, conf);
        long startTime = 0L;
        boolean isProfileEnabled = HiveConf.getBoolVar(conf, HiveConf.ConfVars.TEZ_EXEC_SUMMARY) || Utilities.isPerfOrAboveLogging(conf);
        boolean inPlaceUpdates = HiveConf.getBoolVar(conf, HiveConf.ConfVars.TEZ_EXEC_INPLACE_PROGRESS);
        boolean wideTerminal = false;
        boolean bl = isTerminal = inPlaceUpdates ? TezJobMonitor.isUnixTerminal() : false;
        if (isTerminal && this.getTerminalWidth() >= 80) {
            wideTerminal = true;
        }
        boolean inPlaceEligible = false;
        if (inPlaceUpdates && isTerminal && wideTerminal && !this.console.getIsSilent()) {
            inPlaceEligible = true;
        }
        shutdownList.add(dagClient);
        this.console.printInfo("\n");
        this.perfLogger.PerfLogBegin(CLASS_NAME, "TezRunDag");
        this.perfLogger.PerfLogBegin(CLASS_NAME, "TezSubmitToRunningDag");
        while (true) {
            try {
                while (true) {
                    status = dagClient.getDAGStatus(opts);
                    Map progressMap = status.getVertexProgress();
                    DAGStatus.State state = status.getState();
                    heartbeater.heartbeat();
                    if (state != lastState || state == DAGStatus.State.RUNNING) {
                        lastState = state;
                        switch (state) {
                            case SUBMITTED: {
                                this.console.printInfo("Status: Submitted");
                                break;
                            }
                            case INITING: {
                                this.console.printInfo("Status: Initializing");
                                startTime = System.currentTimeMillis();
                                break;
                            }
                            case RUNNING: {
                                if (!running) {
                                    this.perfLogger.PerfLogEnd(CLASS_NAME, "TezSubmitToRunningDag");
                                    this.console.printInfo("Status: Running (" + dagClient.getExecutionContext() + ")\n");
                                    startTime = System.currentTimeMillis();
                                    running = true;
                                }
                                if (inPlaceEligible) {
                                    this.printStatusInPlace(progressMap, startTime, false, dagClient);
                                    lastReport = this.logStatus(progressMap, lastReport, this.console);
                                    break;
                                }
                                lastReport = this.printStatus(progressMap, lastReport, this.console);
                                break;
                            }
                            case SUCCEEDED: {
                                if (inPlaceEligible) {
                                    this.printStatusInPlace(progressMap, startTime, false, dagClient);
                                    lastReport = this.logStatus(progressMap, lastReport, this.console);
                                } else {
                                    lastReport = this.printStatus(progressMap, lastReport, this.console);
                                }
                                if (isProfileEnabled) {
                                    double duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                                    this.console.printInfo("Status: DAG finished successfully in " + String.format("%.2f seconds", duration));
                                    this.console.printInfo("\n");
                                    this.printMethodsSummary();
                                    this.printDagSummary(progressMap, this.console, dagClient, conf, dag);
                                }
                                running = false;
                                done = true;
                                break;
                            }
                            case KILLED: {
                                if (inPlaceEligible) {
                                    this.printStatusInPlace(progressMap, startTime, true, dagClient);
                                    lastReport = this.logStatus(progressMap, lastReport, this.console);
                                }
                                this.console.printInfo("Status: Killed");
                                running = false;
                                done = true;
                                rc = 1;
                                break;
                            }
                            case FAILED: 
                            case ERROR: {
                                if (inPlaceEligible) {
                                    this.printStatusInPlace(progressMap, startTime, true, dagClient);
                                    lastReport = this.logStatus(progressMap, lastReport, this.console);
                                }
                                this.console.printError("Status: Failed");
                                running = false;
                                done = true;
                                rc = 2;
                                break;
                            }
                        }
                    }
                    if (done) continue;
                    Thread.sleep(200L);
                }
            }
            catch (Exception e) {
                this.console.printInfo("Exception: " + e.getMessage());
                if (++failedCounter % 2500 / 200 != 0 && !(e instanceof InterruptedException)) {
                    this.console.printInfo("Retrying...");
                }
                try {
                    this.console.printInfo("Killing DAG...");
                    dagClient.tryKillDAG();
                }
                catch (IOException diag) {
                }
                catch (TezException diag) {
                    // empty catch block
                }
                e.printStackTrace();
                this.console.printError("Execution has failed.");
                rc = 1;
                done = true;
            }
            finally {
                if (!done) continue;
                if (rc != 0 && status != null) {
                    for (String diag : status.getDiagnostics()) {
                        this.console.printError(diag);
                        this.diagnostics.append(diag);
                    }
                }
                shutdownList.remove(dagClient);
            }
            break;
        }
        this.perfLogger.PerfLogEnd(CLASS_NAME, "TezRunDag");
        return rc;
    }

    public static void killRunningJobs() {
        for (DAGClient c : shutdownList) {
            try {
                System.err.println("Trying to shutdown DAG");
                c.tryKillDAG();
            }
            catch (Exception exception) {}
        }
    }

    private static long getCounterValueByGroupName(TezCounters vertexCounters, String groupNamePattern, String counterName) {
        TezCounter tezCounter = ((CounterGroup)vertexCounters.getGroup(groupNamePattern)).findCounter(counterName);
        return tezCounter == null ? 0L : tezCounter.getValue();
    }

    private void printMethodsSummary() {
        long totalInPrepTime = 0L;
        String[] perfLoggerReportMethods = new String[]{"parse", "semanticAnalyze", "TezBuildDag", "TezSubmitToRunningDag"};
        String methodBreakdownHeader = String.format("%-30s %-13s", METHOD, DURATION);
        this.console.printInfo(methodBreakdownHeader);
        for (String method : perfLoggerReportMethods) {
            long duration = this.perfLogger.getDuration(method);
            totalInPrepTime += duration;
            this.console.printInfo(String.format("%-30s %11s", method, this.commaFormat.format(duration)));
        }
        totalInPrepTime = this.perfLogger.getStartTime("TezRunDag") - this.perfLogger.getStartTime("TimeToSubmit");
        this.console.printInfo(String.format("%-30s %11s\n", TOTAL_PREP_TIME, this.commaFormat.format(totalInPrepTime)));
    }

    private void printDagSummary(Map<String, Progress> progressMap, SessionState.LogHelper console, DAGClient dagClient, HiveConf conf, DAG dag) {
        String hiveCountersGroup = HiveConf.getVar(conf, HiveConf.ConfVars.HIVECOUNTERGROUP);
        EnumSet<StatusGetOpts> statusGetOpts = EnumSet.of(StatusGetOpts.GET_COUNTERS);
        TezCounters hiveCounters = null;
        try {
            hiveCounters = dagClient.getDAGStatus(statusGetOpts).getDAGCounters();
        }
        catch (IOException iOException) {
        }
        catch (TezException tezException) {
            // empty catch block
        }
        if (hiveCounters == null) {
            return;
        }
        console.printInfo(SUMMARY_HEADER);
        TreeSet<String> keys = new TreeSet<String>(progressMap.keySet());
        HashSet<StatusGetOpts> statusOptions = new HashSet<StatusGetOpts>(1);
        statusOptions.add(StatusGetOpts.GET_COUNTERS);
        for (String vertexName : keys) {
            Progress progress = progressMap.get(vertexName);
            if (progress == null) continue;
            int totalTasks = progress.getTotalTaskCount();
            int failedTaskAttempts = progress.getFailedTaskAttemptCount();
            int killedTaskAttempts = progress.getKilledTaskAttemptCount();
            double duration = (double)this.perfLogger.getDuration("TezRunVertex." + vertexName).longValue() / 1000.0;
            VertexStatus vertexStatus = null;
            try {
                vertexStatus = dagClient.getVertexStatus(vertexName, statusOptions);
            }
            catch (IOException iOException) {
            }
            catch (TezException tezException) {
                // empty catch block
            }
            if (vertexStatus == null) continue;
            Vertex currentVertex = dag.getVertex(vertexName);
            List inputVerticesList = currentVertex.getInputVertices();
            long hiveInputRecordsFromOtherVertices = 0L;
            if (inputVerticesList.size() > 0) {
                for (Vertex inputVertex : inputVerticesList) {
                    String inputVertexName = inputVertex.getName();
                    hiveInputRecordsFromOtherVertices += TezJobMonitor.getCounterValueByGroupName(hiveCounters, hiveCountersGroup, String.format("%s_", ReduceSinkOperator.Counter.RECORDS_OUT_INTERMEDIATE.toString()) + inputVertexName.replace(" ", "_"));
                    hiveInputRecordsFromOtherVertices += TezJobMonitor.getCounterValueByGroupName(hiveCounters, hiveCountersGroup, String.format("%s_", FileSinkOperator.Counter.RECORDS_OUT.toString()) + inputVertexName.replace(" ", "_"));
                }
            }
            TezCounters vertexCounters = vertexStatus.getVertexCounters();
            double cpuTimeMillis = TezJobMonitor.getCounterValueByGroupName(vertexCounters, TaskCounter.class.getName(), TaskCounter.CPU_MILLISECONDS.name());
            double gcTimeMillis = TezJobMonitor.getCounterValueByGroupName(vertexCounters, TaskCounter.class.getName(), TaskCounter.GC_TIME_MILLIS.name());
            long hiveInputRecords = TezJobMonitor.getCounterValueByGroupName(hiveCounters, hiveCountersGroup, String.format("%s_", MapOperator.Counter.RECORDS_IN.toString()) + vertexName.replace(" ", "_")) + hiveInputRecordsFromOtherVertices;
            long hiveOutputIntermediateRecords = TezJobMonitor.getCounterValueByGroupName(hiveCounters, hiveCountersGroup, String.format("%s_", ReduceSinkOperator.Counter.RECORDS_OUT_INTERMEDIATE.toString()) + vertexName.replace(" ", "_"));
            long hiveOutputRecords = TezJobMonitor.getCounterValueByGroupName(hiveCounters, hiveCountersGroup, String.format("%s_", FileSinkOperator.Counter.RECORDS_OUT.toString()) + vertexName.replace(" ", "_")) + hiveOutputIntermediateRecords;
            String vertexExecutionStats = String.format(SUMMARY_VERTEX_FORMAT, vertexName, totalTasks, failedTaskAttempts, killedTaskAttempts, this.secondsFormat.format(duration), this.commaFormat.format(cpuTimeMillis), this.commaFormat.format(gcTimeMillis), this.commaFormat.format(hiveInputRecords), this.commaFormat.format(hiveOutputRecords));
            console.printInfo(vertexExecutionStats);
        }
    }

    private void printStatusInPlace(Map<String, Progress> progressMap, long startTime, boolean vextexStatusFromAM, DAGClient dagClient) {
        StringBuffer reportBuffer = new StringBuffer();
        int sumComplete = 0;
        int sumTotal = 0;
        this.repositionCursor();
        this.reprintLine(this.separator);
        this.reprintLineWithColorAsBold(HEADER, Ansi.Color.CYAN);
        this.reprintLine(this.separator);
        TreeSet<String> keys = new TreeSet<String>(progressMap.keySet());
        int idx = 0;
        int maxKeys = keys.size();
        for (String s : keys) {
            ++idx;
            Progress progress = progressMap.get(s);
            int complete = progress.getSucceededTaskCount();
            int total = progress.getTotalTaskCount();
            int running = progress.getRunningTaskCount();
            int failed = progress.getFailedTaskAttemptCount();
            int pending = progress.getTotalTaskCount() - progress.getSucceededTaskCount() - progress.getRunningTaskCount();
            int killed = progress.getKilledTaskAttemptCount();
            VertexStatus.State vertexState = VertexStatus.State.INITIALIZING;
            if (total > 0) {
                vertexState = VertexStatus.State.INITED;
                sumComplete += complete;
                sumTotal += total;
            }
            if (complete < total && (complete > 0 || running > 0 || failed > 0)) {
                vertexState = VertexStatus.State.RUNNING;
                if (!this.perfLogger.startTimeHasMethod("TezRunVertex." + s)) {
                    this.perfLogger.PerfLogBegin(CLASS_NAME, "TezRunVertex." + s);
                }
            }
            if (complete == total) {
                vertexState = VertexStatus.State.SUCCEEDED;
                if (!this.completed.contains(s)) {
                    this.completed.add(s);
                    if (!this.perfLogger.startTimeHasMethod("TezRunVertex." + s)) {
                        this.perfLogger.PerfLogBegin(CLASS_NAME, "TezRunVertex." + s);
                    }
                    this.perfLogger.PerfLogEnd(CLASS_NAME, "TezRunVertex." + s);
                }
            }
            if (vextexStatusFromAM) {
                VertexStatus vertexStatus = null;
                try {
                    vertexStatus = dagClient.getVertexStatus(s, null);
                }
                catch (IOException iOException) {
                }
                catch (TezException tezException) {
                    // empty catch block
                }
                if (vertexStatus != null) {
                    vertexState = vertexStatus.getState();
                }
            }
            String nameWithProgress = this.getNameWithProgress(s, complete, total);
            String vertexStr = String.format(VERTEX_FORMAT, nameWithProgress, vertexState.toString(), total, complete, running, pending, failed, killed);
            reportBuffer.append(vertexStr);
            if (idx == maxKeys) continue;
            reportBuffer.append("\n");
        }
        this.reprintMultiLine(reportBuffer.toString());
        this.reprintLine(this.separator);
        float progress = sumTotal == 0 ? 0.0f : (float)sumComplete / (float)sumTotal;
        String footer = this.getFooter(keys.size(), this.completed.size(), progress, startTime);
        this.reprintLineWithColorAsBold(footer, Ansi.Color.RED);
        this.reprintLine(this.separator);
    }

    private String getNameWithProgress(String s, int complete, int total) {
        String result = "";
        if (s != null) {
            float percent = total == 0 ? 0.0f : (float)complete / (float)total;
            int spaceRemaining = 16 - s.length() - 1;
            String trimmedVName = s;
            if (s.length() > 16) {
                trimmedVName = s.substring(0, 15);
                trimmedVName = trimmedVName + "..";
            }
            result = trimmedVName + " ";
            int toFill = (int)((float)spaceRemaining * percent);
            for (int i = 0; i < toFill; ++i) {
                result = result + ".";
            }
        }
        return result;
    }

    private String getFooter(int keySize, int completedSize, float progress, long startTime) {
        String verticesSummary = String.format("VERTICES: %02d/%02d", completedSize, keySize);
        String progressBar = this.getInPlaceProgressBar(progress);
        int progressPercent = (int)(progress * 100.0f);
        String progressStr = "" + progressPercent + "%";
        float et = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
        String elapsedTime = "ELAPSED TIME: " + this.secondsFormat.format(et) + " s";
        String footer = String.format(FOOTER_FORMAT, verticesSummary, progressBar, progressStr, elapsedTime);
        return footer;
    }

    private String getInPlaceProgressBar(float percent) {
        int i;
        StringBuilder bar = new StringBuilder("[");
        int remainingChars = 26;
        int completed = (int)((float)remainingChars * percent);
        int pending = remainingChars - completed;
        for (i = 0; i < completed; ++i) {
            bar.append("=");
        }
        bar.append(">>");
        for (i = 0; i < pending; ++i) {
            bar.append("-");
        }
        bar.append("]");
        return bar.toString();
    }

    private String printStatus(Map<String, Progress> progressMap, String lastReport, SessionState.LogHelper console) {
        String report = this.getReport(progressMap);
        if (!report.equals(lastReport) || System.currentTimeMillis() >= this.lastPrintTime + 3000L) {
            console.printInfo(report);
            this.lastPrintTime = System.currentTimeMillis();
        }
        return report;
    }

    private String logStatus(Map<String, Progress> progressMap, String lastReport, SessionState.LogHelper console) {
        String report = this.getReport(progressMap);
        if (!report.equals(lastReport) || System.currentTimeMillis() >= this.lastPrintTime + 3000L) {
            console.logInfo(report);
            this.lastPrintTime = System.currentTimeMillis();
        }
        return report;
    }

    private String getReport(Map<String, Progress> progressMap) {
        StringBuffer reportBuffer = new StringBuffer();
        TreeSet<String> keys = new TreeSet<String>(progressMap.keySet());
        for (String s : keys) {
            Progress progress = progressMap.get(s);
            int complete = progress.getSucceededTaskCount();
            int total = progress.getTotalTaskCount();
            int running = progress.getRunningTaskCount();
            int failed = progress.getFailedTaskAttemptCount();
            if (total <= 0) {
                reportBuffer.append(String.format("%s: -/-\t", s));
                continue;
            }
            if (complete == total && !this.completed.contains(s)) {
                this.completed.add(s);
                if (!this.perfLogger.startTimeHasMethod("TezRunVertex." + s)) {
                    this.perfLogger.PerfLogBegin(CLASS_NAME, "TezRunVertex." + s);
                }
                this.perfLogger.PerfLogEnd(CLASS_NAME, "TezRunVertex." + s);
            }
            if (complete < total && (complete > 0 || running > 0 || failed > 0)) {
                if (!this.perfLogger.startTimeHasMethod("TezRunVertex." + s)) {
                    this.perfLogger.PerfLogBegin(CLASS_NAME, "TezRunVertex." + s);
                }
                if (failed > 0) {
                    reportBuffer.append(String.format("%s: %d(+%d,-%d)/%d\t", s, complete, running, failed, total));
                    continue;
                }
                reportBuffer.append(String.format("%s: %d(+%d)/%d\t", s, complete, running, total));
                continue;
            }
            if (failed > 0) {
                reportBuffer.append(String.format("%s: %d(-%d)/%d\t", s, complete, failed, total));
                continue;
            }
            reportBuffer.append(String.format("%s: %d/%d\t", s, complete, total));
        }
        return reportBuffer.toString();
    }

    public String getDiagnostics() {
        return this.diagnostics.toString();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (DAGClient c : shutdownList) {
                    TezJobMonitor.killRunningJobs();
                }
                try {
                    for (TezSessionState s : TezSessionPoolManager.getInstance().getOpenSessions()) {
                        System.err.println("Shutting down tez session.");
                        TezSessionPoolManager.getInstance().close(s, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

