/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.airlift.json.ObjectMapperProvider;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.ForRecordingHiveMetastore;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePartitionName;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.HiveTableName;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionFilter;
import com.facebook.presto.hive.metastore.PartitionNameWithVersion;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.UserTableKey;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

public class RecordingHiveMetastore
implements ExtendedHiveMetastore {
    private final ExtendedHiveMetastore delegate;
    private final String recordingPath;
    private final boolean replay;
    private volatile Optional<List<String>> allDatabases = Optional.empty();
    private volatile Optional<Set<String>> allRoles = Optional.empty();
    private final Cache<String, Optional<Database>> databaseCache;
    private final Cache<HiveTableName, Optional<Table>> tableCache;
    private final Cache<String, Set<ColumnStatisticType>> supportedColumnStatisticsCache;
    private final Cache<HiveTableName, PartitionStatistics> tableStatisticsCache;
    private final Cache<Set<HivePartitionName>, Map<String, PartitionStatistics>> partitionStatisticsCache;
    private final Cache<String, Optional<List<String>>> allTablesCache;
    private final Cache<String, Optional<List<String>>> allViewsCache;
    private final Cache<HivePartitionName, Optional<Partition>> partitionCache;
    private final Cache<HiveTableName, Optional<List<String>>> partitionNamesCache;
    private final Cache<String, List<String>> partitionNamesByFilterCache;
    private final Cache<Set<HivePartitionName>, Map<String, Optional<Partition>>> partitionsByNamesCache;
    private final Cache<UserTableKey, Set<HivePrivilegeInfo>> tablePrivilegesCache;
    private final Cache<PrestoPrincipal, Set<RoleGrant>> roleGrantsCache;

    @Inject
    public RecordingHiveMetastore(@ForRecordingHiveMetastore ExtendedHiveMetastore delegate, MetastoreClientConfig metastoreClientConfig) throws IOException {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Objects.requireNonNull(metastoreClientConfig, "hiveClientConfig is null");
        this.recordingPath = Objects.requireNonNull(metastoreClientConfig.getRecordingPath(), "recordingPath is null");
        this.replay = metastoreClientConfig.isReplay();
        this.databaseCache = RecordingHiveMetastore.createCache(metastoreClientConfig);
        this.tableCache = RecordingHiveMetastore.createCache(metastoreClientConfig);
        this.supportedColumnStatisticsCache = RecordingHiveMetastore.createCache(metastoreClientConfig);
        this.tableStatisticsCache = RecordingHiveMetastore.createCache(metastoreClientConfig);
        this.partitionStatisticsCache = RecordingHiveMetastore.createCache(metastoreClientConfig);
        this.allTablesCache = RecordingHiveMetastore.createCache(metastoreClientConfig);
        this.allViewsCache = RecordingHiveMetastore.createCache(metastoreClientConfig);
        this.partitionCache = RecordingHiveMetastore.createCache(metastoreClientConfig);
        this.partitionNamesCache = RecordingHiveMetastore.createCache(metastoreClientConfig);
        this.partitionNamesByFilterCache = RecordingHiveMetastore.createCache(metastoreClientConfig);
        this.partitionsByNamesCache = RecordingHiveMetastore.createCache(metastoreClientConfig);
        this.tablePrivilegesCache = RecordingHiveMetastore.createCache(metastoreClientConfig);
        this.roleGrantsCache = RecordingHiveMetastore.createCache(metastoreClientConfig);
        if (this.replay) {
            this.loadRecording();
        }
    }

    @VisibleForTesting
    void loadRecording() throws IOException {
        Recording recording = (Recording)new ObjectMapperProvider().get().readValue(new File(this.recordingPath), Recording.class);
        this.allDatabases = recording.getAllDatabases();
        this.allRoles = recording.getAllRoles();
        this.databaseCache.putAll(RecordingHiveMetastore.toMap(recording.getDatabases()));
        this.tableCache.putAll(RecordingHiveMetastore.toMap(recording.getTables()));
        this.supportedColumnStatisticsCache.putAll(RecordingHiveMetastore.toMap(recording.getSupportedColumnStatistics()));
        this.tableStatisticsCache.putAll(RecordingHiveMetastore.toMap(recording.getTableStatistics()));
        this.partitionStatisticsCache.putAll(RecordingHiveMetastore.toMap(recording.getPartitionStatistics()));
        this.allTablesCache.putAll(RecordingHiveMetastore.toMap(recording.getAllTables()));
        this.allViewsCache.putAll(RecordingHiveMetastore.toMap(recording.getAllViews()));
        this.partitionCache.putAll(RecordingHiveMetastore.toMap(recording.getPartitions()));
        this.partitionNamesCache.putAll(RecordingHiveMetastore.toMap(recording.getPartitionNames()));
        this.partitionNamesByFilterCache.putAll(RecordingHiveMetastore.toMap(recording.getPartitionNamesByFilter()));
        this.partitionsByNamesCache.putAll(RecordingHiveMetastore.toMap(recording.getPartitionsByNames()));
        this.tablePrivilegesCache.putAll(RecordingHiveMetastore.toMap(recording.getTablePrivileges()));
        this.roleGrantsCache.putAll(RecordingHiveMetastore.toMap(recording.getRoleGrants()));
    }

    private static <K, V> Cache<K, V> createCache(MetastoreClientConfig metastoreClientConfig) {
        if (metastoreClientConfig.isReplay()) {
            return CacheBuilder.newBuilder().build();
        }
        return CacheBuilder.newBuilder().expireAfterWrite(metastoreClientConfig.getRecordingDuration().toMillis(), TimeUnit.MILLISECONDS).build();
    }

    @Managed
    public void writeRecording() throws IOException {
        if (this.replay) {
            throw new IllegalStateException("Cannot write recording in replay mode");
        }
        Recording recording = new Recording(this.allDatabases, this.allRoles, RecordingHiveMetastore.toPairs(this.databaseCache), RecordingHiveMetastore.toPairs(this.tableCache), RecordingHiveMetastore.toPairs(this.supportedColumnStatisticsCache), RecordingHiveMetastore.toPairs(this.tableStatisticsCache), RecordingHiveMetastore.toPairs(this.partitionStatisticsCache), RecordingHiveMetastore.toPairs(this.allTablesCache), RecordingHiveMetastore.toPairs(this.allViewsCache), RecordingHiveMetastore.toPairs(this.partitionCache), RecordingHiveMetastore.toPairs(this.partitionNamesCache), RecordingHiveMetastore.toPairs(this.partitionNamesByFilterCache), RecordingHiveMetastore.toPairs(this.partitionsByNamesCache), RecordingHiveMetastore.toPairs(this.tablePrivilegesCache), RecordingHiveMetastore.toPairs(this.roleGrantsCache));
        new ObjectMapperProvider().get().writerWithDefaultPrettyPrinter().writeValue(new File(this.recordingPath), (Object)recording);
    }

    private static <K, V> Map<K, V> toMap(List<Pair<K, V>> pairs) {
        return (Map)pairs.stream().collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    }

    private static <K, V> List<Pair<K, V>> toPairs(Cache<K, V> cache) {
        return (List)cache.asMap().entrySet().stream().map(entry -> new Pair(entry.getKey(), entry.getValue())).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return this.loadValue(this.databaseCache, databaseName, () -> this.delegate.getDatabase(databaseName));
    }

    @Override
    public List<String> getAllDatabases() {
        if (this.replay) {
            return this.allDatabases.orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Missing entry for all databases"));
        }
        List<String> result = this.delegate.getAllDatabases();
        this.allDatabases = Optional.of(result);
        return result;
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        return this.loadValue(this.tableCache, HiveTableName.hiveTableName(databaseName, tableName), () -> this.delegate.getTable(databaseName, tableName));
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.loadValue(this.supportedColumnStatisticsCache, type.getTypeSignature().toString(), () -> this.delegate.getSupportedColumnStatistics(type));
    }

    @Override
    public PartitionStatistics getTableStatistics(String databaseName, String tableName) {
        return this.loadValue(this.tableStatisticsCache, HiveTableName.hiveTableName(databaseName, tableName), () -> this.delegate.getTableStatistics(databaseName, tableName));
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(String databaseName, String tableName, Set<String> partitionNames) {
        return this.loadValue(this.partitionStatisticsCache, this.getHivePartitionNames(databaseName, tableName, partitionNames), () -> this.delegate.getPartitionStatistics(databaseName, tableName, partitionNames));
    }

    @Override
    public void updateTableStatistics(String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update) {
        this.verifyRecordingMode();
        this.delegate.updateTableStatistics(databaseName, tableName, update);
    }

    @Override
    public void updatePartitionStatistics(String databaseName, String tableName, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        this.verifyRecordingMode();
        this.delegate.updatePartitionStatistics(databaseName, tableName, partitionName, update);
    }

    @Override
    public Optional<List<String>> getAllTables(String databaseName) {
        return this.loadValue(this.allTablesCache, databaseName, () -> this.delegate.getAllTables(databaseName));
    }

    @Override
    public Optional<List<String>> getAllViews(String databaseName) {
        return this.loadValue(this.allViewsCache, databaseName, () -> this.delegate.getAllViews(databaseName));
    }

    @Override
    public void createDatabase(Database database) {
        this.verifyRecordingMode();
        this.delegate.createDatabase(database);
    }

    @Override
    public void dropDatabase(String databaseName) {
        this.verifyRecordingMode();
        this.delegate.dropDatabase(databaseName);
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        this.verifyRecordingMode();
        this.delegate.renameDatabase(databaseName, newDatabaseName);
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        this.verifyRecordingMode();
        this.delegate.createTable(table, principalPrivileges);
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        this.verifyRecordingMode();
        this.delegate.dropTable(databaseName, tableName, deleteData);
    }

    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        this.verifyRecordingMode();
        this.delegate.replaceTable(databaseName, tableName, newTable, principalPrivileges);
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        this.verifyRecordingMode();
        this.delegate.renameTable(databaseName, tableName, newDatabaseName, newTableName);
    }

    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        this.verifyRecordingMode();
        this.delegate.addColumn(databaseName, tableName, columnName, columnType, columnComment);
    }

    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        this.verifyRecordingMode();
        this.delegate.renameColumn(databaseName, tableName, oldColumnName, newColumnName);
    }

    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        this.verifyRecordingMode();
        this.delegate.dropColumn(databaseName, tableName, columnName);
    }

    @Override
    public Optional<Partition> getPartition(String databaseName, String tableName, List<String> partitionValues) {
        return this.loadValue(this.partitionCache, HivePartitionName.hivePartitionName(databaseName, tableName, partitionValues), () -> this.delegate.getPartition(databaseName, tableName, partitionValues));
    }

    @Override
    public Optional<List<String>> getPartitionNames(String databaseName, String tableName) {
        return this.loadValue(this.partitionNamesCache, HiveTableName.hiveTableName(databaseName, tableName), () -> this.delegate.getPartitionNames(databaseName, tableName));
    }

    @Override
    public List<String> getPartitionNamesByFilter(String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
        return this.loadValue(this.partitionNamesByFilterCache, PartitionFilter.partitionFilter(databaseName, tableName, partitionPredicates).toString(), () -> this.delegate.getPartitionNamesByFilter(databaseName, tableName, partitionPredicates));
    }

    @Override
    public List<PartitionNameWithVersion> getPartitionNamesWithVersionByFilter(String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        return this.loadValue(this.partitionsByNamesCache, this.getHivePartitionNames(databaseName, tableName, (Set<String>)ImmutableSet.copyOf(partitionNames)), () -> this.delegate.getPartitionsByNames(databaseName, tableName, partitionNames));
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        this.verifyRecordingMode();
        this.delegate.addPartitions(databaseName, tableName, partitions);
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        this.verifyRecordingMode();
        this.delegate.dropPartition(databaseName, tableName, parts, deleteData);
    }

    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        this.verifyRecordingMode();
        this.delegate.alterPartition(databaseName, tableName, partition);
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, PrestoPrincipal principal) {
        return this.loadValue(this.tablePrivilegesCache, new UserTableKey(principal, databaseName, tableName), () -> this.delegate.listTablePrivileges(databaseName, tableName, principal));
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.verifyRecordingMode();
        this.delegate.grantTablePrivileges(databaseName, tableName, grantee, privileges);
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.verifyRecordingMode();
        this.delegate.revokeTablePrivileges(databaseName, tableName, grantee, privileges);
    }

    private Set<HivePartitionName> getHivePartitionNames(String databaseName, String tableName, Set<String> partitionNames) {
        return (Set)partitionNames.stream().map(partitionName -> HivePartitionName.hivePartitionName(databaseName, tableName, partitionName)).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public void createRole(String role, String grantor) {
        this.verifyRecordingMode();
        this.delegate.createRole(role, grantor);
    }

    @Override
    public void dropRole(String role) {
        this.verifyRecordingMode();
        this.delegate.dropRole(role);
    }

    @Override
    public Set<String> listRoles() {
        if (this.replay) {
            return this.allRoles.orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Missing entry for roles"));
        }
        Set<String> result = this.delegate.listRoles();
        this.allRoles = Optional.of(result);
        return result;
    }

    @Override
    public void grantRoles(Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, PrestoPrincipal grantor) {
        this.verifyRecordingMode();
        this.delegate.grantRoles(roles, grantees, withAdminOption, grantor);
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, PrestoPrincipal grantor) {
        this.verifyRecordingMode();
        this.delegate.revokeRoles(roles, grantees, adminOptionFor, grantor);
    }

    @Override
    public Set<RoleGrant> listRoleGrants(PrestoPrincipal principal) {
        return this.loadValue(this.roleGrantsCache, principal, () -> this.delegate.listRoleGrants(principal));
    }

    private <K, V> V loadValue(Cache<K, V> cache, K key, Supplier<V> valueSupplier) {
        if (this.replay) {
            return (V)Optional.ofNullable(cache.getIfPresent(key)).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Missing entry found for key: " + key));
        }
        V value = valueSupplier.get();
        cache.put(key, value);
        return value;
    }

    private void verifyRecordingMode() {
        if (this.replay) {
            throw new IllegalStateException("Cannot perform Metastore updates in replay mode");
        }
    }

    @Immutable
    public static class Pair<K, V> {
        private final K key;
        private final V value;

        @JsonCreator
        public Pair(@JsonProperty(value="key") K key, @JsonProperty(value="value") V value) {
            this.key = Objects.requireNonNull(key, "key is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        @JsonProperty
        public K getKey() {
            return this.key;
        }

        @JsonProperty
        public V getValue() {
            return this.value;
        }
    }

    @Immutable
    public static class Recording {
        private final Optional<List<String>> allDatabases;
        private final Optional<Set<String>> allRoles;
        private final List<Pair<String, Optional<Database>>> databases;
        private final List<Pair<HiveTableName, Optional<Table>>> tables;
        private final List<Pair<String, Set<ColumnStatisticType>>> supportedColumnStatistics;
        private final List<Pair<HiveTableName, PartitionStatistics>> tableStatistics;
        private final List<Pair<Set<HivePartitionName>, Map<String, PartitionStatistics>>> partitionStatistics;
        private final List<Pair<String, Optional<List<String>>>> allTables;
        private final List<Pair<String, Optional<List<String>>>> allViews;
        private final List<Pair<HivePartitionName, Optional<Partition>>> partitions;
        private final List<Pair<HiveTableName, Optional<List<String>>>> partitionNames;
        private final List<Pair<String, List<String>>> partitionNamesByFilter;
        private final List<Pair<Set<HivePartitionName>, Map<String, Optional<Partition>>>> partitionsByNames;
        private final List<Pair<UserTableKey, Set<HivePrivilegeInfo>>> tablePrivileges;
        private final List<Pair<PrestoPrincipal, Set<RoleGrant>>> roleGrants;

        @JsonCreator
        public Recording(@JsonProperty(value="allDatabases") Optional<List<String>> allDatabases, @JsonProperty(value="allRoles") Optional<Set<String>> allRoles, @JsonProperty(value="databases") List<Pair<String, Optional<Database>>> databases, @JsonProperty(value="tables") List<Pair<HiveTableName, Optional<Table>>> tables, @JsonProperty(value="supportedColumnStatistics") List<Pair<String, Set<ColumnStatisticType>>> supportedColumnStatistics, @JsonProperty(value="tableStatistics") List<Pair<HiveTableName, PartitionStatistics>> tableStatistics, @JsonProperty(value="partitionStatistics") List<Pair<Set<HivePartitionName>, Map<String, PartitionStatistics>>> partitionStatistics, @JsonProperty(value="allTables") List<Pair<String, Optional<List<String>>>> allTables, @JsonProperty(value="allViews") List<Pair<String, Optional<List<String>>>> allViews, @JsonProperty(value="partitions") List<Pair<HivePartitionName, Optional<Partition>>> partitions, @JsonProperty(value="partitionNames") List<Pair<HiveTableName, Optional<List<String>>>> partitionNames, @JsonProperty(value="partitionNamesByFilter") List<Pair<String, List<String>>> partitionNamesByFilter, @JsonProperty(value="partitionsByNames") List<Pair<Set<HivePartitionName>, Map<String, Optional<Partition>>>> partitionsByNames, @JsonProperty(value="tablePrivileges") List<Pair<UserTableKey, Set<HivePrivilegeInfo>>> tablePrivileges, @JsonProperty(value="roleGrants") List<Pair<PrestoPrincipal, Set<RoleGrant>>> roleGrants) {
            this.allDatabases = allDatabases;
            this.allRoles = allRoles;
            this.databases = databases;
            this.tables = tables;
            this.supportedColumnStatistics = supportedColumnStatistics;
            this.tableStatistics = tableStatistics;
            this.partitionStatistics = partitionStatistics;
            this.allTables = allTables;
            this.allViews = allViews;
            this.partitions = partitions;
            this.partitionNames = partitionNames;
            this.partitionNamesByFilter = partitionNamesByFilter;
            this.partitionsByNames = partitionsByNames;
            this.tablePrivileges = tablePrivileges;
            this.roleGrants = roleGrants;
        }

        @JsonProperty
        public Optional<List<String>> getAllDatabases() {
            return this.allDatabases;
        }

        @JsonProperty
        public Optional<Set<String>> getAllRoles() {
            return this.allRoles;
        }

        @JsonProperty
        public List<Pair<String, Optional<Database>>> getDatabases() {
            return this.databases;
        }

        @JsonProperty
        public List<Pair<HiveTableName, Optional<Table>>> getTables() {
            return this.tables;
        }

        @JsonProperty
        public List<Pair<String, Set<ColumnStatisticType>>> getSupportedColumnStatistics() {
            return this.supportedColumnStatistics;
        }

        @JsonProperty
        public List<Pair<HiveTableName, PartitionStatistics>> getTableStatistics() {
            return this.tableStatistics;
        }

        @JsonProperty
        public List<Pair<Set<HivePartitionName>, Map<String, PartitionStatistics>>> getPartitionStatistics() {
            return this.partitionStatistics;
        }

        @JsonProperty
        public List<Pair<String, Optional<List<String>>>> getAllTables() {
            return this.allTables;
        }

        @JsonProperty
        public List<Pair<String, Optional<List<String>>>> getAllViews() {
            return this.allViews;
        }

        @JsonProperty
        public List<Pair<HivePartitionName, Optional<Partition>>> getPartitions() {
            return this.partitions;
        }

        @JsonProperty
        public List<Pair<HiveTableName, Optional<List<String>>>> getPartitionNames() {
            return this.partitionNames;
        }

        @JsonProperty
        public List<Pair<String, List<String>>> getPartitionNamesByFilter() {
            return this.partitionNamesByFilter;
        }

        @JsonProperty
        public List<Pair<Set<HivePartitionName>, Map<String, Optional<Partition>>>> getPartitionsByNames() {
            return this.partitionsByNames;
        }

        @JsonProperty
        public List<Pair<UserTableKey, Set<HivePrivilegeInfo>>> getTablePrivileges() {
            return this.tablePrivileges;
        }

        @JsonProperty
        public List<Pair<PrestoPrincipal, Set<RoleGrant>>> getRoleGrants() {
            return this.roleGrants;
        }
    }
}

