/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.alluxio;

import alluxio.client.table.TableMasterClient;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.table.ColumnStatisticsInfo;
import alluxio.grpc.table.Constraint;
import alluxio.grpc.table.layout.hive.PartitionInfo;
import alluxio.shaded.client.com.google.protobuf.ProtocolStringList;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionNameWithVersion;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.alluxio.AlluxioProtoUtils;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NotFoundException;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;

public class AlluxioHiveMetastore
implements ExtendedHiveMetastore {
    private final TableMasterClient client;

    @Inject
    public AlluxioHiveMetastore(TableMasterClient client) {
        this.client = Objects.requireNonNull(client, "client is null");
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        try {
            return Optional.of(AlluxioProtoUtils.fromProto(this.client.getDatabase(databaseName)));
        }
        catch (AlluxioStatusException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getAllDatabases() {
        try {
            return this.client.getAllDatabases();
        }
        catch (AlluxioStatusException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        try {
            return Optional.of(AlluxioProtoUtils.fromProto(this.client.getTable(databaseName, tableName)));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
        catch (AlluxioStatusException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return MetastoreUtil.getSupportedColumnStatistics(type);
    }

    private Map<String, HiveColumnStatistics> groupStatisticsByColumn(List<ColumnStatisticsInfo> statistics, OptionalLong rowCount) {
        return (Map)statistics.stream().collect(ImmutableMap.toImmutableMap(ColumnStatisticsInfo::getColName, statisticsInfo -> AlluxioProtoUtils.fromProto(statisticsInfo.getData(), rowCount)));
    }

    @Override
    public PartitionStatistics getTableStatistics(String databaseName, String tableName) {
        try {
            Table table = this.getTable(databaseName, tableName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, String.format("Could not retrieve table %s.%s", databaseName, tableName)));
            HiveBasicStatistics basicStatistics = MetastoreUtil.getHiveBasicStatistics(table.getParameters());
            List<Column> columns = table.getPartitionColumns();
            List columnNames = (List)columns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
            List columnStatistics = this.client.getTableColumnStatistics(table.getDatabaseName(), table.getTableName(), columnNames);
            return new PartitionStatistics(basicStatistics, this.groupStatisticsByColumn(columnStatistics, basicStatistics.getRowCount()));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(String databaseName, String tableName, Set<String> partitionNames) {
        Map columnStatisticss;
        Table table = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        Map partitionBasicStatistics = (Map)this.getPartitionsByNames(databaseName, tableName, (List<String>)ImmutableList.copyOf(partitionNames)).entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(entry -> MetastoreUtil.makePartName(table.getPartitionColumns(), ((Partition)((Optional)entry.getValue()).get()).getValues()), entry -> MetastoreUtil.getHiveBasicStatistics(((Partition)((Optional)entry.getValue()).get()).getParameters())));
        Map partitionRowCounts = (Map)partitionBasicStatistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((HiveBasicStatistics)entry.getValue()).getRowCount()));
        List dataColumns = (List)table.getDataColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        try {
            columnStatisticss = this.client.getPartitionColumnStatistics(table.getDatabaseName(), table.getTableName(), (List)partitionBasicStatistics.keySet().stream().collect(ImmutableList.toImmutableList()), dataColumns);
        }
        catch (AlluxioStatusException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        Map partitionColumnStatistics = (Map)columnStatisticss.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.groupStatisticsByColumn((List)entry.getValue(), partitionRowCounts.getOrDefault(entry.getKey(), OptionalLong.empty()))));
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (String partitionName : partitionBasicStatistics.keySet()) {
            HiveBasicStatistics basicStatistics = (HiveBasicStatistics)partitionBasicStatistics.get(partitionName);
            Map columnStatistics = (Map)partitionColumnStatistics.getOrDefault(partitionName, ImmutableMap.of());
            result.put((Object)partitionName, (Object)new PartitionStatistics(basicStatistics, columnStatistics));
        }
        return result.build();
    }

    @Override
    public void updateTableStatistics(String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update) {
        throw new UnsupportedOperationException("updateTableStatistics is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void updatePartitionStatistics(String databaseName, String tableName, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        throw new UnsupportedOperationException("updatePartitionStatistics is not supported in AlluxioHiveMetastore");
    }

    @Override
    public Optional<List<String>> getAllTables(String databaseName) {
        try {
            return Optional.of(this.client.getAllTables(databaseName));
        }
        catch (AlluxioStatusException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<List<String>> getAllViews(String databaseName) {
        return Optional.of(Collections.emptyList());
    }

    @Override
    public void createDatabase(Database database) {
        throw new UnsupportedOperationException("createDatabase is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void dropDatabase(String databaseName) {
        throw new UnsupportedOperationException("dropDatabase is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        throw new UnsupportedOperationException("renameDatabase is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        throw new UnsupportedOperationException("createTable is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        throw new UnsupportedOperationException("dropTable is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        throw new UnsupportedOperationException("replaceTable is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        throw new UnsupportedOperationException("renameTable is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        throw new UnsupportedOperationException("addColumn is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        throw new UnsupportedOperationException("renameColumn is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        throw new UnsupportedOperationException("dropColumn is not supported in AlluxioHiveMetastore");
    }

    @Override
    public Optional<Partition> getPartition(String databaseName, String tableName, List<String> partitionValues) {
        throw new UnsupportedOperationException("getPartition is not supported in AlluxioHiveMetastore");
    }

    @Override
    public Optional<List<String>> getPartitionNames(String databaseName, String tableName) {
        try {
            List<PartitionInfo> partitionInfos = AlluxioProtoUtils.toPartitionInfoList(this.client.readTable(databaseName, tableName, Constraint.getDefaultInstance()));
            return Optional.of(partitionInfos.stream().map(PartitionInfo::getPartitionName).collect(ImmutableList.toImmutableList()));
        }
        catch (AlluxioStatusException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getPartitionNamesByFilter(String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
        List<String> parts = MetastoreUtil.convertPredicateToParts(partitionPredicates);
        return this.getPartitionNamesByParts(databaseName, tableName, parts).orElse((List<String>)ImmutableList.of());
    }

    @Override
    public List<PartitionNameWithVersion> getPartitionNamesWithVersionByFilter(String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
        throw new UnsupportedOperationException();
    }

    public Optional<List<String>> getPartitionNamesByParts(String databaseName, String tableName, List<String> parts) {
        try {
            List partitionInfos = AlluxioProtoUtils.toPartitionInfoList(this.client.readTable(databaseName, tableName, Constraint.getDefaultInstance()));
            partitionInfos = (List)partitionInfos.stream().filter(p -> p.getTableName().equals(tableName)).filter(partition -> {
                ProtocolStringList values = partition.getValuesList();
                if (values.size() != parts.size()) {
                    return false;
                }
                for (int i = 0; i < values.size(); ++i) {
                    String constraintPart = (String)parts.get(i);
                    if (constraintPart.isEmpty() || ((String)values.get(i)).equals(constraintPart)) continue;
                    return false;
                }
                return true;
            }).collect(ImmutableList.toImmutableList());
            List partitionNames = (List)partitionInfos.stream().map(PartitionInfo::getPartitionName).collect(ImmutableList.toImmutableList());
            return Optional.of(partitionNames);
        }
        catch (AlluxioStatusException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        if (partitionNames.isEmpty()) {
            return ImmutableMap.of();
        }
        try {
            List partitionInfos = AlluxioProtoUtils.toPartitionInfoList(this.client.readTable(databaseName, tableName, Constraint.getDefaultInstance()));
            partitionInfos = (List)partitionInfos.stream().filter(p -> p.getTableName().equals(tableName)).collect(ImmutableList.toImmutableList());
            return (Map)partitionInfos.stream().filter(p -> partitionNames.stream().anyMatch(p.getPartitionName()::equals)).collect(ImmutableMap.toImmutableMap(PartitionInfo::getPartitionName, partitionInfo -> Optional.of(AlluxioProtoUtils.fromProto(partitionInfo))));
        }
        catch (AlluxioStatusException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        throw new UnsupportedOperationException("addPartitions is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        throw new UnsupportedOperationException("dropPartition is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        throw new UnsupportedOperationException("alterPartition is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void createRole(String role, String grantor) {
        throw new UnsupportedOperationException("createRole is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void dropRole(String role) {
        throw new UnsupportedOperationException("dropRole is not supported in AlluxioHiveMetastore");
    }

    @Override
    public Set<String> listRoles() {
        throw new UnsupportedOperationException("listRoles is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void grantRoles(Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, PrestoPrincipal grantor) {
        throw new UnsupportedOperationException("grantRoles is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, PrestoPrincipal grantor) {
        throw new UnsupportedOperationException("revokeRoles is not supported in AlluxioHiveMetastore");
    }

    @Override
    public Set<RoleGrant> listRoleGrants(PrestoPrincipal principal) {
        throw new UnsupportedOperationException("listRoleGrants is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        throw new UnsupportedOperationException("grantTablePrivileges is not supported in AlluxioHiveMetastore");
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        throw new UnsupportedOperationException("revokeTablePrivileges is not supported in AlluxioHiveMetastore");
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, PrestoPrincipal principal) {
        throw new UnsupportedOperationException("listTablePrivileges is not supported in AlluxioHiveMetastore");
    }
}

