/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.hive.ConcurrentLazyQueue;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveDirectoryContext;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitLoader;
import com.facebook.presto.hive.HiveSplitPartitionInfo;
import com.facebook.presto.hive.HiveSplitSource;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.InternalHiveSplit;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.NestedDirectoryPolicy;
import com.facebook.presto.hive.S3SelectPushdown;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.facebook.presto.hive.util.HiveFileIterator;
import com.facebook.presto.hive.util.InternalHiveSplitFactory;
import com.facebook.presto.hive.util.ResumableTask;
import com.facebook.presto.hive.util.ResumableTasks;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.HoodieROTablePathFilter;
import org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat;

public class BackgroundHiveSplitLoader
implements HiveSplitLoader {
    private static final ListenableFuture<?> COMPLETED_FUTURE = Futures.immediateFuture(null);
    private final Table table;
    private final Optional<Domain> pathDomain;
    private final Optional<BucketSplitInfo> tableBucketInfo;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsContext hdfsContext;
    private final NamenodeStats namenodeStats;
    private final DirectoryLister directoryLister;
    private final int loaderConcurrency;
    private final boolean recursiveDirWalkerEnabled;
    private final Executor executor;
    private final ConnectorSession session;
    private final ConcurrentLazyQueue<HivePartitionMetadata> partitions;
    private final Deque<Iterator<InternalHiveSplit>> fileIterators = new ConcurrentLinkedDeque<Iterator<InternalHiveSplit>>();
    private final boolean schedulerUsesHostAddresses;
    private final Supplier<HoodieROTablePathFilter> hoodiePathFilterSupplier;
    private final boolean partialAggregationsPushedDown;
    private final ReentrantReadWriteLock taskExecutionLock = new ReentrantReadWriteLock();
    private HiveSplitSource hiveSplitSource;
    private volatile boolean stopped;

    public BackgroundHiveSplitLoader(Table table, Iterable<HivePartitionMetadata> partitions, Optional<Domain> pathDomain, Optional<BucketSplitInfo> tableBucketInfo, ConnectorSession session, HdfsEnvironment hdfsEnvironment, NamenodeStats namenodeStats, DirectoryLister directoryLister, Executor executor, int loaderConcurrency, boolean recursiveDirWalkerEnabled, boolean schedulerUsesHostAddresses, boolean partialAggregationsPushedDown) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.pathDomain = Objects.requireNonNull(pathDomain, "pathDomain is null");
        this.tableBucketInfo = Objects.requireNonNull(tableBucketInfo, "tableBucketInfo is null");
        this.loaderConcurrency = loaderConcurrency;
        Preconditions.checkArgument((loaderConcurrency > 0 ? 1 : 0) != 0, (String)"loaderConcurrency must be > 0, found: %s", (int)loaderConcurrency);
        this.session = Objects.requireNonNull(session, "session is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.namenodeStats = Objects.requireNonNull(namenodeStats, "namenodeStats is null");
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.partitions = new ConcurrentLazyQueue<HivePartitionMetadata>(Objects.requireNonNull(partitions, "partitions is null"));
        this.hdfsContext = new HdfsContext(session, table.getDatabaseName(), table.getTableName());
        this.schedulerUsesHostAddresses = schedulerUsesHostAddresses;
        this.hoodiePathFilterSupplier = () -> ((com.google.common.base.Supplier)Suppliers.memoize(HoodieROTablePathFilter::new)).get();
        this.partialAggregationsPushedDown = partialAggregationsPushedDown;
    }

    @Override
    public void start(HiveSplitSource splitSource) {
        this.hiveSplitSource = splitSource;
        for (int i = 0; i < this.loaderConcurrency; ++i) {
            ResumableTasks.submit(this.executor, new HiveSplitLoaderTask());
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    private void invokeNoMoreSplitsIfNecessary() {
        this.taskExecutionLock.readLock().lock();
        try {
            if (!this.partitions.isEmpty() || !this.fileIterators.isEmpty()) {
                return;
            }
        }
        catch (Exception e) {
            this.hiveSplitSource.fail(e);
            Preconditions.checkState((boolean)this.stopped, (Object)"Task is not marked as stopped even though it failed");
            return;
        }
        finally {
            this.taskExecutionLock.readLock().unlock();
        }
        this.taskExecutionLock.writeLock().lock();
        try {
            if (this.partitions.isEmpty() && this.fileIterators.isEmpty()) {
                this.hiveSplitSource.noMoreSplits();
            }
        }
        catch (Exception e) {
            this.hiveSplitSource.fail(e);
            Preconditions.checkState((boolean)this.stopped, (Object)"Task is not marked as stopped even though it failed");
        }
        finally {
            this.taskExecutionLock.writeLock().unlock();
        }
    }

    private ListenableFuture<?> loadSplits() throws IOException {
        Iterator<InternalHiveSplit> splits = this.fileIterators.poll();
        if (splits == null) {
            HivePartitionMetadata partition = this.partitions.poll();
            if (partition == null) {
                return COMPLETED_FUTURE;
            }
            return this.loadPartition(partition);
        }
        while (splits.hasNext() && !this.stopped) {
            ListenableFuture<?> future = this.hiveSplitSource.addToQueue(splits.next());
            if (future.isDone()) continue;
            this.fileIterators.addFirst(splits);
            return future;
        }
        return COMPLETED_FUTURE;
    }

    private ListenableFuture<?> loadPartition(HivePartitionMetadata partition) throws IOException {
        boolean splittable;
        String partitionName = partition.getHivePartition().getPartitionId();
        Storage storage = partition.getPartition().map(Partition::getStorage).orElse(this.table.getStorage());
        String inputFormatName = storage.getStorageFormat().getInputFormat();
        int partitionDataColumnCount = partition.getPartition().map(p -> p.getColumns().size()).orElse(this.table.getDataColumns().size());
        List<HivePartitionKey> partitionKeys = BackgroundHiveSplitLoader.getPartitionKeys(this.table, partition.getPartition());
        Path path = new Path(MetastoreUtil.getPartitionLocation((Table)this.table, partition.getPartition()));
        Configuration configuration = this.hdfsEnvironment.getConfiguration(this.hdfsContext, path);
        InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, inputFormatName, false);
        ExtendedFileSystem fs = this.hdfsEnvironment.getFileSystem(this.hdfsContext, path);
        boolean s3SelectPushdownEnabled = S3SelectPushdown.shouldEnablePushdownForTable(this.session, this.table, path.toString(), partition.getPartition());
        if (inputFormat instanceof SymlinkTextInputFormat) {
            if (this.tableBucketInfo.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketed table in SymlinkTextInputFormat is not yet supported");
            }
            ListenableFuture<?> lastResult = COMPLETED_FUTURE;
            for (Path targetPath : BackgroundHiveSplitLoader.getTargetPathsFromSymlink(fs, path)) {
                TextInputFormat targetInputFormat = new TextInputFormat();
                ExtendedFileSystem targetFilesystem = this.hdfsEnvironment.getFileSystem(this.hdfsContext, targetPath);
                JobConf targetJob = ConfigurationUtils.toJobConf(targetFilesystem.getConf());
                targetJob.setInputFormat(TextInputFormat.class);
                targetInputFormat.configure(targetJob);
                FileInputFormat.setInputPaths((JobConf)targetJob, (Path[])new Path[]{targetPath});
                InputSplit[] targetSplits = targetInputFormat.getSplits(targetJob, 0);
                InternalHiveSplitFactory splitFactory = new InternalHiveSplitFactory((FileSystem)targetFilesystem, inputFormat, this.pathDomain, HiveSessionProperties.getNodeSelectionStrategy(this.session), HiveSessionProperties.getMaxInitialSplitSize(this.session), s3SelectPushdownEnabled, new HiveSplitPartitionInfo(storage, path.toUri(), partitionKeys, partitionName, partitionDataColumnCount, partition.getPartitionSchemaDifference(), Optional.empty()), this.schedulerUsesHostAddresses, partition.getEncryptionInformation());
                lastResult = this.addSplitsToSource(targetSplits, splitFactory);
                if (!this.stopped) continue;
                return COMPLETED_FUTURE;
            }
            return lastResult;
        }
        Optional<HiveSplit.BucketConversion> bucketConversion = Optional.empty();
        boolean bucketConversionRequiresWorkerParticipation = false;
        if (partition.getPartition().isPresent()) {
            int partitionBucketCount;
            int tableBucketCount;
            Optional partitionBucketProperty = partition.getPartition().get().getStorage().getBucketProperty();
            if (this.tableBucketInfo.isPresent() && partitionBucketProperty.isPresent() && (tableBucketCount = this.tableBucketInfo.get().getTableBucketCount()) != (partitionBucketCount = ((HiveBucketProperty)partitionBucketProperty.get()).getBucketCount())) {
                bucketConversion = Optional.of(new HiveSplit.BucketConversion(tableBucketCount, partitionBucketCount, this.tableBucketInfo.get().getBucketColumns()));
                if (tableBucketCount > partitionBucketCount) {
                    bucketConversionRequiresWorkerParticipation = true;
                }
            }
        }
        InternalHiveSplitFactory splitFactory = new InternalHiveSplitFactory((FileSystem)fs, inputFormat, this.pathDomain, HiveSessionProperties.getNodeSelectionStrategy(this.session), HiveSessionProperties.getMaxInitialSplitSize(this.session), s3SelectPushdownEnabled, new HiveSplitPartitionInfo(storage, path.toUri(), partitionKeys, partitionName, partitionDataColumnCount, partition.getPartitionSchemaDifference(), bucketConversionRequiresWorkerParticipation ? bucketConversion : Optional.empty()), this.schedulerUsesHostAddresses, partition.getEncryptionInformation());
        if (!BackgroundHiveSplitLoader.isHudiParquetInputFormat(inputFormat) && BackgroundHiveSplitLoader.shouldUseFileSplitsFromInputFormat(inputFormat)) {
            if (this.tableBucketInfo.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Presto cannot read bucketed partition in an input format with UseFileSplitsFromInputFormat annotation: " + inputFormat.getClass().getSimpleName());
            }
            JobConf jobConf = ConfigurationUtils.toJobConf(configuration);
            FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path});
            InputSplit[] splits = inputFormat.getSplits(jobConf, 0);
            return this.addSplitsToSource(splits, splitFactory);
        }
        PathFilter pathFilter = BackgroundHiveSplitLoader.isHudiParquetInputFormat(inputFormat) ? (PathFilter)this.hoodiePathFilterSupplier.get() : path1 -> true;
        Properties schema = MetastoreUtil.getHiveSchema((Map)storage.getSerdeParameters(), (Map)this.table.getParameters());
        boolean bl = splittable = !s3SelectPushdownEnabled && !this.partialAggregationsPushedDown && HiveUtil.getFooterCount(schema) == 0 && HiveUtil.getHeaderCount(schema) <= 1;
        if (this.tableBucketInfo.isPresent()) {
            if (this.tableBucketInfo.get().isVirtuallyBucketed()) {
                Preconditions.checkState((!bucketConversion.isPresent() ? 1 : 0) != 0, (Object)"Virtually bucketed table must not have partitions that are physically bucketed");
                Preconditions.checkState((this.tableBucketInfo.get().getTableBucketCount() == this.tableBucketInfo.get().getReadBucketCount() ? 1 : 0) != 0, (Object)"Table and read bucket count should be the same for virtual bucket");
                return this.hiveSplitSource.addToQueue(this.getVirtuallyBucketedSplits(path, fs, splitFactory, this.tableBucketInfo.get().getReadBucketCount(), splittable, pathFilter));
            }
            return this.hiveSplitSource.addToQueue(this.getBucketedSplits(path, fs, splitFactory, this.tableBucketInfo.get(), bucketConversion, partitionName, splittable, pathFilter));
        }
        this.fileIterators.addLast(this.createInternalHiveSplitIterator(path, fs, splitFactory, splittable, pathFilter));
        return COMPLETED_FUTURE;
    }

    private ListenableFuture<?> addSplitsToSource(InputSplit[] targetSplits, InternalHiveSplitFactory splitFactory) throws IOException {
        ListenableFuture<?> lastResult = COMPLETED_FUTURE;
        for (InputSplit inputSplit : targetSplits) {
            Optional<InternalHiveSplit> internalHiveSplit = splitFactory.createInternalHiveSplit((FileSplit)inputSplit);
            if (internalHiveSplit.isPresent()) {
                lastResult = this.hiveSplitSource.addToQueue(internalHiveSplit.get());
            }
            if (!this.stopped) continue;
            return COMPLETED_FUTURE;
        }
        return lastResult;
    }

    private static boolean isHudiParquetInputFormat(InputFormat<?, ?> inputFormat) {
        if (inputFormat instanceof HoodieParquetRealtimeInputFormat) {
            return false;
        }
        return inputFormat instanceof HoodieParquetInputFormat;
    }

    private static boolean shouldUseFileSplitsFromInputFormat(InputFormat<?, ?> inputFormat) {
        return Arrays.stream(inputFormat.getClass().getAnnotations()).map(Annotation::annotationType).map(Class::getSimpleName).anyMatch(name -> name.equals("UseFileSplitsFromInputFormat"));
    }

    private Iterator<InternalHiveSplit> createInternalHiveSplitIterator(Path path, ExtendedFileSystem fileSystem, InternalHiveSplitFactory splitFactory, boolean splittable, PathFilter pathFilter) {
        HiveDirectoryContext hiveDirectoryContext = new HiveDirectoryContext(this.recursiveDirWalkerEnabled ? NestedDirectoryPolicy.RECURSE : NestedDirectoryPolicy.IGNORED, HiveSessionProperties.isUseListDirectoryCache(this.session));
        return Streams.stream(this.directoryLister.list(fileSystem, this.table, path, this.namenodeStats, pathFilter, hiveDirectoryContext)).map(status -> splitFactory.createInternalHiveSplit((HiveFileInfo)status, splittable)).filter(Optional::isPresent).map(Optional::get).iterator();
    }

    private List<InternalHiveSplit> getBucketedSplits(Path path, ExtendedFileSystem fileSystem, InternalHiveSplitFactory splitFactory, BucketSplitInfo bucketSplitInfo, Optional<HiveSplit.BucketConversion> bucketConversion, String partitionName, boolean splittable, PathFilter pathFilter) {
        int readBucketCount = bucketSplitInfo.getReadBucketCount();
        int tableBucketCount = bucketSplitInfo.getTableBucketCount();
        int partitionBucketCount = bucketConversion.map(HiveSplit.BucketConversion::getPartitionBucketCount).orElse(tableBucketCount);
        Preconditions.checkState((readBucketCount <= tableBucketCount ? 1 : 0) != 0, (String)"readBucketCount(%s) should be less than or equal to tableBucketCount(%s)", (int)readBucketCount, (int)tableBucketCount);
        ArrayList fileInfos = new ArrayList(partitionBucketCount);
        try {
            Iterators.addAll(fileInfos, this.directoryLister.list(fileSystem, this.table, path, this.namenodeStats, pathFilter, new HiveDirectoryContext(NestedDirectoryPolicy.FAIL, HiveSessionProperties.isUseListDirectoryCache(this.session))));
        }
        catch (HiveFileIterator.NestedDirectoryNotAllowedException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table '%s' is corrupt. Found sub-directory in bucket directory for partition: %s", new SchemaTableName(this.table.getDatabaseName(), this.table.getTableName()), partitionName));
        }
        if (fileInfos.size() != partitionBucketCount) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table '%s' is corrupt. The number of files in the directory (%s) does not match the declared bucket count (%s) for partition: %s", new SchemaTableName(this.table.getDatabaseName(), this.table.getTableName()), fileInfos.size(), partitionBucketCount, partitionName));
        }
        fileInfos.sort(null);
        ArrayList<InternalHiveSplit> splitList = new ArrayList<InternalHiveSplit>();
        for (int bucketNumber = 0; bucketNumber < Math.max(readBucketCount, partitionBucketCount); ++bucketNumber) {
            int partitionBucketNumber = bucketNumber % partitionBucketCount;
            int readBucketNumber = bucketNumber % readBucketCount;
            boolean containsIneligibleTableBucket = false;
            ArrayList<Integer> eligibleTableBucketNumbers = new ArrayList<Integer>();
            for (int tableBucketNumber2 = bucketNumber % tableBucketCount; tableBucketNumber2 < tableBucketCount; tableBucketNumber2 += Math.max(readBucketCount, partitionBucketCount)) {
                if (bucketSplitInfo.isTableBucketEnabled(tableBucketNumber2)) {
                    eligibleTableBucketNumbers.add(tableBucketNumber2);
                    continue;
                }
                containsIneligibleTableBucket = true;
            }
            if (!eligibleTableBucketNumbers.isEmpty() && containsIneligibleTableBucket) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The bucket filter cannot be satisfied. There are restrictions on the bucket filter when all the following is true: 1. a table has a different buckets count as at least one of its partitions that is read in this query; 2. the table has a different but compatible bucket number with another table in the query; 3. some buckets of the table is filtered out from the query, most likely using a filter on \"$bucket\". (table name: " + this.table.getTableName() + ", table bucket count: " + tableBucketCount + ", partition bucket count: " + partitionBucketCount + ", effective reading bucket count: " + readBucketCount + ")");
            }
            if (eligibleTableBucketNumbers.isEmpty()) continue;
            HiveFileInfo fileInfo = (HiveFileInfo)fileInfos.get(partitionBucketNumber);
            eligibleTableBucketNumbers.stream().map(tableBucketNumber -> splitFactory.createInternalHiveSplit(fileInfo, readBucketNumber, (int)tableBucketNumber, splittable)).forEach(optionalSplit -> optionalSplit.ifPresent(splitList::add));
        }
        return splitList;
    }

    private List<InternalHiveSplit> getVirtuallyBucketedSplits(Path path, ExtendedFileSystem fileSystem, InternalHiveSplitFactory splitFactory, int bucketCount, boolean splittable, PathFilter pathFilter) {
        HiveDirectoryContext hiveDirectoryContext = new HiveDirectoryContext(this.recursiveDirWalkerEnabled ? NestedDirectoryPolicy.RECURSE : NestedDirectoryPolicy.IGNORED, HiveSessionProperties.isUseListDirectoryCache(this.session));
        return (List)Streams.stream(this.directoryLister.list(fileSystem, this.table, path, this.namenodeStats, pathFilter, hiveDirectoryContext)).map(fileInfo -> {
            int virtualBucketNumber = HiveBucketing.getVirtualBucketNumber(bucketCount, fileInfo.getPath());
            return splitFactory.createInternalHiveSplit((HiveFileInfo)fileInfo, virtualBucketNumber, virtualBucketNumber, splittable);
        }).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }

    private static List<Path> getTargetPathsFromSymlink(ExtendedFileSystem fileSystem, Path symlinkDir) {
        try {
            FileStatus[] symlinks = fileSystem.listStatus(symlinkDir, FileUtils.HIDDEN_FILES_PATH_FILTER);
            ArrayList<Path> targets = new ArrayList<Path>();
            for (FileStatus symlink : symlinks) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(symlink.getPath()), StandardCharsets.UTF_8));){
                    CharStreams.readLines((Readable)reader).stream().map(Path::new).forEach(targets::add);
                }
            }
            return targets;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Error parsing symlinks from: " + symlinkDir, (Throwable)e);
        }
    }

    private static List<HivePartitionKey> getPartitionKeys(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        List keys = table.getPartitionColumns();
        List values = partition.get().getValues();
        MetastoreUtil.checkCondition((keys.size() == values.size() ? 1 : 0) != 0, (ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, (String)"Expected %s partition key values, but got %s", (Object[])new Object[]{keys.size(), values.size()});
        for (int i = 0; i < keys.size(); ++i) {
            String name = ((Column)keys.get(i)).getName();
            HiveType hiveType = ((Column)keys.get(i)).getType();
            if (!hiveType.isSupportedType()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type %s found in partition keys of table %s.%s", hiveType, table.getDatabaseName(), table.getTableName()));
            }
            String value = (String)values.get(i);
            MetastoreUtil.checkCondition((value != null ? 1 : 0) != 0, (ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, (String)"partition key value cannot be null for field: %s", (Object[])new Object[]{name});
            partitionKeys.add((Object)new HivePartitionKey(name, value));
        }
        return partitionKeys.build();
    }

    public static class BucketSplitInfo {
        private final List<HiveColumnHandle> bucketColumns;
        private final int tableBucketCount;
        private final int readBucketCount;
        private final IntPredicate bucketFilter;

        public static Optional<BucketSplitInfo> createBucketSplitInfo(Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter) {
            Objects.requireNonNull(bucketHandle, "bucketHandle is null");
            Objects.requireNonNull(bucketFilter, "buckets is null");
            if (!bucketHandle.isPresent()) {
                Preconditions.checkArgument((!bucketFilter.isPresent() ? 1 : 0) != 0, (Object)"bucketHandle must be present if bucketFilter is present");
                return Optional.empty();
            }
            int tableBucketCount = bucketHandle.get().getTableBucketCount();
            int readBucketCount = bucketHandle.get().getReadBucketCount();
            List<HiveColumnHandle> bucketColumns = bucketHandle.get().getColumns();
            IntPredicate predicate = bucketFilter.map(filter -> filter.getBucketsToKeep()::contains).orElse(bucket -> true);
            return Optional.of(new BucketSplitInfo(bucketColumns, tableBucketCount, readBucketCount, predicate));
        }

        private BucketSplitInfo(List<HiveColumnHandle> bucketColumns, int tableBucketCount, int readBucketCount, IntPredicate bucketFilter) {
            this.bucketColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketColumns, "bucketColumns is null"));
            this.tableBucketCount = tableBucketCount;
            this.readBucketCount = readBucketCount;
            this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
        }

        public List<HiveColumnHandle> getBucketColumns() {
            return this.bucketColumns;
        }

        public int getTableBucketCount() {
            return this.tableBucketCount;
        }

        public int getReadBucketCount() {
            return this.readBucketCount;
        }

        public boolean isVirtuallyBucketed() {
            return this.bucketColumns.size() == 1 && this.bucketColumns.get(0).equals(HiveColumnHandle.pathColumnHandle());
        }

        public boolean isTableBucketEnabled(int tableBucketNumber) {
            return this.bucketFilter.test(tableBucketNumber);
        }
    }

    private class HiveSplitLoaderTask
    implements ResumableTask {
        private HiveSplitLoaderTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResumableTask.TaskStatus process() {
            ListenableFuture future;
            do {
                if (BackgroundHiveSplitLoader.this.stopped) {
                    return ResumableTask.TaskStatus.finished();
                }
                BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().lock();
                try {
                    future = BackgroundHiveSplitLoader.this.loadSplits();
                }
                catch (Exception e2) {
                    PrestoException e2;
                    if (e2 instanceof IOException) {
                        e2 = new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, (Throwable)e2);
                    } else if (!(e2 instanceof PrestoException)) {
                        e2 = new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, (Throwable)e2);
                    }
                    BackgroundHiveSplitLoader.this.hiveSplitSource.fail(e2);
                    Preconditions.checkState((boolean)BackgroundHiveSplitLoader.this.stopped);
                    ResumableTask.TaskStatus taskStatus = ResumableTask.TaskStatus.finished();
                    return taskStatus;
                }
                finally {
                    BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().unlock();
                }
                BackgroundHiveSplitLoader.this.invokeNoMoreSplitsIfNecessary();
            } while (future.isDone());
            return ResumableTask.TaskStatus.continueOn(future);
        }
    }
}

