/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.slice.SizeOf;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.openjdk.jol.info.ClassLayout;

public class HiveSplitPartitionInfo {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(HiveSplitPartitionInfo.class).instanceSize();
    private static final int INTEGER_INSTANCE_SIZE = ClassLayout.parseClass(Integer.class).instanceSize();
    private final Storage storage;
    private final URI path;
    private final List<HivePartitionKey> partitionKeys;
    private final String partitionName;
    private final int partitionDataColumnCount;
    private final Map<Integer, Column> partitionSchemaDifference;
    private final Optional<HiveSplit.BucketConversion> bucketConversion;
    private final AtomicInteger references = new AtomicInteger(0);

    public HiveSplitPartitionInfo(Storage storage, URI path, List<HivePartitionKey> partitionKeys, String partitionName, int partitionDataColumnCount, Map<Integer, Column> partitionSchemaDifference, Optional<HiveSplit.BucketConversion> bucketConversion) {
        Objects.requireNonNull(storage, "storage is null");
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Objects.requireNonNull(partitionName, "partitionName is null");
        Objects.requireNonNull(partitionSchemaDifference, "partitionSchemaDifference is null");
        Objects.requireNonNull(bucketConversion, "bucketConversion is null");
        this.storage = storage;
        this.path = HiveSplitPartitionInfo.ensurePathHasTrailingSlash(path);
        this.partitionKeys = partitionKeys;
        this.partitionName = partitionName;
        this.partitionDataColumnCount = partitionDataColumnCount;
        this.partitionSchemaDifference = partitionSchemaDifference;
        this.bucketConversion = bucketConversion;
    }

    private static URI ensurePathHasTrailingSlash(URI path) {
        if (!path.getPath().endsWith("/")) {
            try {
                path = new URI(path.toString() + "/");
            }
            catch (URISyntaxException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
            }
        }
        return path;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public int getPartitionDataColumnCount() {
        return this.partitionDataColumnCount;
    }

    public Map<Integer, Column> getPartitionSchemaDifference() {
        return this.partitionSchemaDifference;
    }

    public Optional<HiveSplit.BucketConversion> getBucketConversion() {
        return this.bucketConversion;
    }

    public int getEstimatedSizeInBytes() {
        int result = INSTANCE_SIZE;
        result = (int)((long)result + SizeOf.sizeOfObjectArray((int)this.partitionKeys.size()));
        for (HivePartitionKey partitionKey : this.partitionKeys) {
            result += partitionKey.getEstimatedSizeInBytes();
        }
        result += this.partitionName.length() * 2;
        result = (int)((long)result + SizeOf.sizeOfObjectArray((int)this.partitionSchemaDifference.size()));
        for (Column column : this.partitionSchemaDifference.values()) {
            result += INTEGER_INSTANCE_SIZE + column.getEstimatedSizeInBytes();
        }
        return result;
    }

    public int incrementAndGetReferences() {
        return this.references.incrementAndGet();
    }

    public int decrementAndGetReferences() {
        return this.references.decrementAndGet();
    }

    public URI getPath() {
        return this.path;
    }
}

