/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Page;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.hive.HiveManifestUtils;
import com.facebook.presto.hive.HiveWriterStats;
import com.facebook.presto.hive.PartitionUpdate;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class HiveWriter {
    private final HiveFileWriter fileWriter;
    private final Optional<String> partitionName;
    private final PartitionUpdate.UpdateMode updateMode;
    private final PartitionUpdate.FileWriteInfo fileWriteInfo;
    private final String writePath;
    private final String targetPath;
    private final Consumer<HiveWriter> onCommit;
    private final HiveWriterStats hiveWriterStats;
    private long rowCount;
    private long inputSizeInBytes;
    private Optional<Page> fileStatistics = Optional.empty();

    public HiveWriter(HiveFileWriter fileWriter, Optional<String> partitionName, PartitionUpdate.UpdateMode updateMode, PartitionUpdate.FileWriteInfo fileWriteInfo, String writePath, String targetPath, Consumer<HiveWriter> onCommit, HiveWriterStats hiveWriterStats) {
        this.fileWriter = Objects.requireNonNull(fileWriter, "fileWriter is null");
        this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
        this.updateMode = Objects.requireNonNull(updateMode, "updateMode is null");
        this.fileWriteInfo = Objects.requireNonNull(fileWriteInfo, "fileWriteInfo is null");
        this.writePath = Objects.requireNonNull(writePath, "writePath is null");
        this.targetPath = Objects.requireNonNull(targetPath, "targetPath is null");
        this.onCommit = Objects.requireNonNull(onCommit, "onCommit is null");
        this.hiveWriterStats = Objects.requireNonNull(hiveWriterStats, "hiveWriterStats is null");
    }

    public long getWrittenBytes() {
        return this.fileWriter.getWrittenBytes();
    }

    public long getSystemMemoryUsage() {
        return this.fileWriter.getSystemMemoryUsage();
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public Optional<String> getPartitionName() {
        return this.partitionName;
    }

    public void append(Page dataPage) {
        this.hiveWriterStats.addInputPageSizesInBytes(dataPage.getRetainedSizeInBytes());
        this.fileWriter.appendRows(dataPage);
        this.rowCount += (long)dataPage.getPositionCount();
        this.inputSizeInBytes += dataPage.getSizeInBytes();
    }

    public void commit() {
        this.fileStatistics = this.fileWriter.commit();
        this.onCommit.accept(this);
    }

    long getValidationCpuNanos() {
        return this.fileWriter.getValidationCpuNanos();
    }

    public Optional<Runnable> getVerificationTask() {
        return this.fileWriter.getVerificationTask();
    }

    public void rollback() {
        this.fileWriter.rollback();
    }

    public PartitionUpdate getPartitionUpdate() {
        return new PartitionUpdate(this.partitionName.orElse(""), this.updateMode, this.writePath, this.targetPath, (List<PartitionUpdate.FileWriteInfo>)ImmutableList.of((Object)new PartitionUpdate.FileWriteInfo(this.fileWriteInfo.getWriteFileName(), this.fileWriteInfo.getTargetFileName(), this.fileStatistics.map(statisticsPage -> HiveManifestUtils.getFileSize(statisticsPage, 0)))), this.rowCount, this.inputSizeInBytes, this.fileWriter.getWrittenBytes());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileWriter", (Object)this.fileWriter).add("writeFilePath", (Object)(this.writePath + "/" + this.fileWriteInfo.getWriteFileName())).add("targetFilePath", (Object)(this.targetPath + "/" + this.fileWriteInfo.getTargetFileName())).toString();
    }
}

