/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.hive.HiveFileWriterFactory;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.parquet.ParquetFileWriter;
import com.facebook.presto.parquet.writer.ParquetWriterOptions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Splitter;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;
import parquet.hadoop.metadata.CompressionCodecName;

public class ParquetFileWriterFactory
implements HiveFileWriterFactory {
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;

    @Inject
    public ParquetFileWriterFactory(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, NodeVersion nodeVersion, HiveClientConfig hiveConfig) {
        this(hdfsEnvironment, typeManager, nodeVersion, Objects.requireNonNull(hiveConfig, "hiveConfig is null").getDateTimeZone());
    }

    public ParquetFileWriterFactory(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, NodeVersion nodeVersion, DateTimeZone hiveStorageTimeZone) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @Override
    public Optional<HiveFileWriter> createFileWriter(Path path, List<String> inputColumnNames, StorageFormat storageFormat, Properties schema, JobConf conf, ConnectorSession session, Optional<EncryptionInformation> encryptionInformation) {
        if (!HiveSessionProperties.isParquetOptimizedWriterEnabled(session)) {
            return Optional.empty();
        }
        if (!MapredParquetOutputFormat.class.getName().equals(storageFormat.getOutputFormat())) {
            return Optional.empty();
        }
        ParquetWriterOptions parquetWriterOptions = ParquetWriterOptions.builder().setMaxPageSize(HiveSessionProperties.getParquetWriterPageSize(session)).setMaxBlockSize(HiveSessionProperties.getParquetWriterBlockSize(session)).build();
        CompressionCodecName compressionCodecName = ParquetFileWriterFactory.getCompression(conf);
        List fileColumnNames = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)schema.getProperty("columns", ""));
        List<Type> fileColumnTypes = HiveType.toHiveTypes((String)schema.getProperty("columns.types", "")).stream().map(hiveType -> hiveType.getType(this.typeManager)).collect(Collectors.toList());
        int[] fileInputColumnIndexes = fileColumnNames.stream().mapToInt(inputColumnNames::indexOf).toArray();
        try {
            ExtendedFileSystem fileSystem = this.hdfsEnvironment.getFileSystem(session.getUser(), path, (Configuration)conf);
            Callable<Void> rollbackAction = () -> ParquetFileWriterFactory.lambda$createFileWriter$1((FileSystem)fileSystem, path);
            return Optional.of(new ParquetFileWriter((OutputStream)fileSystem.create(path), rollbackAction, fileColumnNames, fileColumnTypes, parquetWriterOptions, fileInputColumnIndexes, compressionCodecName));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, "Error creating Parquet file", (Throwable)e);
        }
    }

    private static CompressionCodecName getCompression(JobConf configuration) {
        String compressionName = configuration.get("parquet.compression");
        if (compressionName == null) {
            return CompressionCodecName.GZIP;
        }
        return CompressionCodecName.valueOf((String)compressionName);
    }

    private static /* synthetic */ Void lambda$createFileWriter$1(FileSystem fileSystem, Path path) throws Exception {
        fileSystem.delete(path, false);
        return null;
    }
}

