/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bloom.filter;

import org.apache.hudi.common.bloom.filter.BloomFilter;
import org.apache.hudi.common.bloom.filter.BloomFilterTypeCode;
import org.apache.hudi.common.bloom.filter.HoodieDynamicBoundedBloomFilter;
import org.apache.hudi.common.bloom.filter.SimpleBloomFilter;

public class BloomFilterFactory {
    public static BloomFilter createBloomFilter(int numEntries, double errorRate, int maxNumberOfEntries, String bloomFilterTypeCode) {
        if (bloomFilterTypeCode.equalsIgnoreCase(BloomFilterTypeCode.SIMPLE.name())) {
            return new SimpleBloomFilter(numEntries, errorRate, 1);
        }
        if (bloomFilterTypeCode.equalsIgnoreCase(BloomFilterTypeCode.DYNAMIC_V0.name())) {
            return new HoodieDynamicBoundedBloomFilter(numEntries, errorRate, 1, maxNumberOfEntries);
        }
        throw new IllegalArgumentException("Bloom Filter type code not recognizable " + bloomFilterTypeCode);
    }

    public static BloomFilter fromString(String serString, String bloomFilterTypeCode) {
        if (bloomFilterTypeCode.equalsIgnoreCase(BloomFilterTypeCode.SIMPLE.name())) {
            return new SimpleBloomFilter(serString);
        }
        if (bloomFilterTypeCode.equalsIgnoreCase(BloomFilterTypeCode.DYNAMIC_V0.name())) {
            return new HoodieDynamicBoundedBloomFilter(serString, BloomFilterTypeCode.DYNAMIC_V0);
        }
        throw new IllegalArgumentException("Bloom Filter type code not recognizable " + bloomFilterTypeCode);
    }
}

