/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bloom.filter;

class BloomFilterUtils {
    private static final double LOG2_SQUARED = Math.log(2.0) * Math.log(2.0);

    BloomFilterUtils() {
    }

    static int getBitSize(int numEntries, double errorRate) {
        return (int)Math.ceil((double)numEntries * (-Math.log(errorRate) / LOG2_SQUARED));
    }

    static int getNumHashes(int bitSize, int numEntries) {
        return (int)Math.ceil(Math.log(2.0) * (double)bitSize / (double)numEntries);
    }
}

