/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bloom.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.hudi.common.bloom.filter.InternalFilter;

class InternalDynamicBloomFilter
extends InternalFilter {
    private int nr;
    private int currentNbRecord;
    private int maxNr;
    private boolean reachedMax = false;
    private int curMatrixIndex = 0;
    private BloomFilter[] matrix;

    public InternalDynamicBloomFilter() {
    }

    public InternalDynamicBloomFilter(int vectorSize, int nbHash, int hashType, int nr, int maxNr) {
        super(vectorSize, nbHash, hashType);
        this.nr = nr;
        this.currentNbRecord = 0;
        this.maxNr = maxNr;
        this.matrix = new BloomFilter[1];
        this.matrix[0] = new BloomFilter(this.vectorSize, this.nbHash, this.hashType);
    }

    @Override
    public void add(Key key) {
        if (key == null) {
            throw new NullPointerException("Key can not be null");
        }
        BloomFilter bf = this.getActiveStandardBF();
        if (bf == null) {
            this.addRow();
            bf = this.matrix[this.matrix.length - 1];
            this.currentNbRecord = 0;
        }
        bf.add(key);
        ++this.currentNbRecord;
    }

    @Override
    public void and(InternalFilter filter) {
        if (!(filter instanceof InternalDynamicBloomFilter) || filter.vectorSize != this.vectorSize || filter.nbHash != this.nbHash) {
            throw new IllegalArgumentException("filters cannot be and-ed");
        }
        InternalDynamicBloomFilter dbf = (InternalDynamicBloomFilter)filter;
        if (dbf.matrix.length != this.matrix.length || dbf.nr != this.nr) {
            throw new IllegalArgumentException("filters cannot be and-ed");
        }
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i].and((Filter)dbf.matrix[i]);
        }
    }

    @Override
    public boolean membershipTest(Key key) {
        if (key == null) {
            return true;
        }
        for (BloomFilter bloomFilter : this.matrix) {
            if (!bloomFilter.membershipTest(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void not() {
        for (BloomFilter bloomFilter : this.matrix) {
            bloomFilter.not();
        }
    }

    @Override
    public void or(InternalFilter filter) {
        if (!(filter instanceof InternalDynamicBloomFilter) || filter.vectorSize != this.vectorSize || filter.nbHash != this.nbHash) {
            throw new IllegalArgumentException("filters cannot be or-ed");
        }
        InternalDynamicBloomFilter dbf = (InternalDynamicBloomFilter)filter;
        if (dbf.matrix.length != this.matrix.length || dbf.nr != this.nr) {
            throw new IllegalArgumentException("filters cannot be or-ed");
        }
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i].or((Filter)dbf.matrix[i]);
        }
    }

    @Override
    public void xor(InternalFilter filter) {
        if (!(filter instanceof InternalDynamicBloomFilter) || filter.vectorSize != this.vectorSize || filter.nbHash != this.nbHash) {
            throw new IllegalArgumentException("filters cannot be xor-ed");
        }
        InternalDynamicBloomFilter dbf = (InternalDynamicBloomFilter)filter;
        if (dbf.matrix.length != this.matrix.length || dbf.nr != this.nr) {
            throw new IllegalArgumentException("filters cannot be xor-ed");
        }
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i].xor((Filter)dbf.matrix[i]);
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (BloomFilter bloomFilter : this.matrix) {
            res.append(bloomFilter);
            res.append(13);
        }
        return res.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.nr);
        out.writeInt(this.currentNbRecord);
        out.writeInt(this.matrix.length);
        for (BloomFilter bloomFilter : this.matrix) {
            bloomFilter.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.nr = in.readInt();
        this.currentNbRecord = in.readInt();
        int len = in.readInt();
        this.matrix = new BloomFilter[len];
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = new BloomFilter();
            this.matrix[i].readFields(in);
        }
    }

    private void addRow() {
        BloomFilter[] tmp = new BloomFilter[this.matrix.length + 1];
        System.arraycopy(this.matrix, 0, tmp, 0, this.matrix.length);
        tmp[tmp.length - 1] = new BloomFilter(this.vectorSize, this.nbHash, this.hashType);
        this.matrix = tmp;
    }

    private BloomFilter getActiveStandardBF() {
        if (this.reachedMax) {
            return this.matrix[this.curMatrixIndex++ % this.matrix.length];
        }
        if (this.currentNbRecord >= this.nr && this.matrix.length * this.nr < this.maxNr) {
            return null;
        }
        if (this.currentNbRecord >= this.nr && this.matrix.length * this.nr >= this.maxNr) {
            this.reachedMax = true;
            return this.matrix[0];
        }
        return this.matrix[this.matrix.length - 1];
    }
}

