/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bloom.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.hudi.common.bloom.filter.BloomFilter;
import org.apache.hudi.common.bloom.filter.BloomFilterTypeCode;
import org.apache.hudi.common.bloom.filter.BloomFilterUtils;
import org.apache.hudi.exception.HoodieIndexException;

public class SimpleBloomFilter
implements BloomFilter {
    private org.apache.hadoop.util.bloom.BloomFilter filter;

    public SimpleBloomFilter(int numEntries, double errorRate, int hashType) {
        int bitSize = BloomFilterUtils.getBitSize(numEntries, errorRate);
        int numHashs = BloomFilterUtils.getNumHashes(bitSize, numEntries);
        this.filter = new org.apache.hadoop.util.bloom.BloomFilter(bitSize, numHashs, hashType);
    }

    public SimpleBloomFilter(String serString) {
        this.filter = new org.apache.hadoop.util.bloom.BloomFilter();
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)serString);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            this.filter.readFields((DataInput)dis);
            dis.close();
        }
        catch (IOException e) {
            throw new HoodieIndexException("Could not deserialize BloomFilter instance", e);
        }
    }

    @Override
    public void add(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot by null");
        }
        this.filter.add(new Key(key.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public boolean mightContain(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot by null");
        }
        return this.filter.membershipTest(new Key(key.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public String serializeToString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            this.filter.write((DataOutput)dos);
            byte[] bytes = baos.toByteArray();
            dos.close();
            return DatatypeConverter.printBase64Binary((byte[])bytes);
        }
        catch (IOException e) {
            throw new HoodieIndexException("Could not serialize BloomFilter instance", e);
        }
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        this.filter.write((DataOutput)os);
    }

    private void readObject(ObjectInputStream is) throws IOException {
        this.filter = new org.apache.hadoop.util.bloom.BloomFilter();
        this.filter.readFields((DataInput)is);
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.filter.toString().getBytes());
    }

    public void readFields(DataInput in) throws IOException {
        this.filter = new org.apache.hadoop.util.bloom.BloomFilter();
        this.filter.readFields(in);
    }

    @Override
    public BloomFilterTypeCode getBloomFilterTypeCode() {
        return BloomFilterTypeCode.SIMPLE;
    }
}

