/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.util.List;
import java.util.stream.Stream;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;

public interface TableFileSystemView {
    public Stream<HoodieFileGroup> getAllFileGroups(String var1);

    public Stream<Pair<String, CompactionOperation>> getPendingCompactionOperations();

    public Option<HoodieInstant> getLastInstant();

    public HoodieTimeline getTimeline();

    public static interface SliceView
    extends SliceViewWithLatestSlice {
        public Stream<FileSlice> getAllFileSlices(String var1);
    }

    public static interface SliceViewWithLatestSlice {
        public Stream<FileSlice> getLatestFileSlices(String var1);

        public Option<FileSlice> getLatestFileSlice(String var1, String var2);

        public Stream<FileSlice> getLatestUnCompactedFileSlices(String var1);

        public Stream<FileSlice> getLatestFileSlicesBeforeOrOn(String var1, String var2, boolean var3);

        public Stream<FileSlice> getLatestMergedFileSlicesBeforeOrOn(String var1, String var2);

        public Stream<FileSlice> getLatestFileSliceInRange(List<String> var1);
    }

    public static interface BaseFileOnlyView
    extends BaseFileOnlyViewWithLatestSlice {
        public Stream<HoodieBaseFile> getAllBaseFiles(String var1);

        public Option<HoodieBaseFile> getBaseFileOn(String var1, String var2, String var3);
    }

    public static interface BaseFileOnlyViewWithLatestSlice {
        public Stream<HoodieBaseFile> getLatestBaseFiles(String var1);

        public Option<HoodieBaseFile> getLatestBaseFile(String var1, String var2);

        public Stream<HoodieBaseFile> getLatestBaseFiles();

        public Stream<HoodieBaseFile> getLatestBaseFilesBeforeOrOn(String var1, String var2);

        public Stream<HoodieBaseFile> getLatestBaseFilesInRange(List<String> var1);
    }
}

