/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.DefaultHoodieConfig;

public class FileSystemViewStorageConfig
extends DefaultHoodieConfig {
    public static final String FILESYSTEM_VIEW_STORAGE_TYPE = "hoodie.filesystem.view.type";
    public static final String FILESYSTEM_VIEW_INCREMENTAL_SYNC_MODE = "hoodie.filesystem.view.incr.timeline.sync.enable";
    public static final String FILESYSTEM_SECONDARY_VIEW_STORAGE_TYPE = "hoodie.filesystem.view.secondary.type";
    public static final String FILESYSTEM_VIEW_REMOTE_HOST = "hoodie.filesystem.view.remote.host";
    public static final String FILESYSTEM_VIEW_REMOTE_PORT = "hoodie.filesystem.view.remote.port";
    public static final String FILESYSTEM_VIEW_SPILLABLE_DIR = "hoodie.filesystem.view.spillable.dir";
    public static final String FILESYSTEM_VIEW_SPILLABLE_MEM = "hoodie.filesystem.view.spillable.mem";
    public static final String FILESYSTEM_VIEW_PENDING_COMPACTION_MEM_FRACTION = "hoodie.filesystem.view.spillable.compaction.mem.fraction";
    private static final String ROCKSDB_BASE_PATH_PROP = "hoodie.filesystem.view.rocksdb.base.path";
    public static final FileSystemViewStorageType DEFAULT_VIEW_STORAGE_TYPE = FileSystemViewStorageType.MEMORY;
    public static final FileSystemViewStorageType DEFAULT_SECONDARY_VIEW_STORAGE_TYPE = FileSystemViewStorageType.MEMORY;
    public static final String DEFAULT_ROCKSDB_BASE_PATH = "/tmp/hoodie_timeline_rocksdb";
    public static final String DEFAULT_FILESYSTEM_VIEW_INCREMENTAL_SYNC_MODE = "false";
    public static final String DEFUALT_REMOTE_VIEW_SERVER_HOST = "localhost";
    public static final Integer DEFAULT_REMOTE_VIEW_SERVER_PORT = 26754;
    public static final String DEFAULT_VIEW_SPILLABLE_DIR = "/tmp/view_map/";
    private static final Double DEFAULT_MEM_FRACTION_FOR_PENDING_COMPACTION = 0.01;
    private static final Long DEFAULT_MAX_MEMORY_FOR_VIEW = 0x6400000L;
    public static final String REMOTE_BACKUP_VIEW_HANDLER_ENABLE = "hoodie.filesystem.remote.backup.view.enable";
    public static final String DEFAULT_REMOTE_BACKUP_VIEW_HANDLER_ENABLE = "true";

    public static Builder newBuilder() {
        return new Builder();
    }

    private FileSystemViewStorageConfig(Properties props) {
        super(props);
    }

    public FileSystemViewStorageType getStorageType() {
        return FileSystemViewStorageType.valueOf(this.props.getProperty(FILESYSTEM_VIEW_STORAGE_TYPE));
    }

    public boolean isIncrementalTimelineSyncEnabled() {
        return Boolean.parseBoolean(this.props.getProperty(FILESYSTEM_VIEW_INCREMENTAL_SYNC_MODE));
    }

    public String getRemoteViewServerHost() {
        return this.props.getProperty(FILESYSTEM_VIEW_REMOTE_HOST);
    }

    public Integer getRemoteViewServerPort() {
        return Integer.parseInt(this.props.getProperty(FILESYSTEM_VIEW_REMOTE_PORT));
    }

    public long getMaxMemoryForFileGroupMap() {
        long totalMemory = Long.parseLong(this.props.getProperty(FILESYSTEM_VIEW_SPILLABLE_MEM));
        return totalMemory - this.getMaxMemoryForPendingCompaction();
    }

    public long getMaxMemoryForPendingCompaction() {
        long totalMemory = Long.parseLong(this.props.getProperty(FILESYSTEM_VIEW_SPILLABLE_MEM));
        return new Double((double)totalMemory * Double.parseDouble(this.props.getProperty(FILESYSTEM_VIEW_PENDING_COMPACTION_MEM_FRACTION))).longValue();
    }

    public String getBaseStoreDir() {
        return this.props.getProperty(FILESYSTEM_VIEW_SPILLABLE_DIR);
    }

    public FileSystemViewStorageType getSecondaryStorageType() {
        return FileSystemViewStorageType.valueOf(this.props.getProperty(FILESYSTEM_SECONDARY_VIEW_STORAGE_TYPE));
    }

    public boolean shouldEnableBackupForRemoteFileSystemView() {
        return Boolean.parseBoolean(this.props.getProperty(REMOTE_BACKUP_VIEW_HANDLER_ENABLE));
    }

    public String getRocksdbBasePath() {
        return this.props.getProperty(ROCKSDB_BASE_PATH_PROP);
    }

    public static class Builder {
        private final Properties props = new Properties();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withStorageType(FileSystemViewStorageType storageType) {
            this.props.setProperty(FileSystemViewStorageConfig.FILESYSTEM_VIEW_STORAGE_TYPE, storageType.name());
            return this;
        }

        public Builder withSecondaryStorageType(FileSystemViewStorageType storageType) {
            this.props.setProperty(FileSystemViewStorageConfig.FILESYSTEM_SECONDARY_VIEW_STORAGE_TYPE, storageType.name());
            return this;
        }

        public Builder withIncrementalTimelineSync(boolean enableIncrTimelineSync) {
            this.props.setProperty(FileSystemViewStorageConfig.FILESYSTEM_VIEW_INCREMENTAL_SYNC_MODE, Boolean.toString(enableIncrTimelineSync));
            return this;
        }

        public Builder withRemoteServerHost(String remoteServerHost) {
            this.props.setProperty(FileSystemViewStorageConfig.FILESYSTEM_VIEW_REMOTE_HOST, remoteServerHost);
            return this;
        }

        public Builder withRemoteServerPort(Integer remoteServerPort) {
            this.props.setProperty(FileSystemViewStorageConfig.FILESYSTEM_VIEW_REMOTE_PORT, remoteServerPort.toString());
            return this;
        }

        public Builder withMaxMemoryForView(Long maxMemoryForView) {
            this.props.setProperty(FileSystemViewStorageConfig.FILESYSTEM_VIEW_SPILLABLE_MEM, maxMemoryForView.toString());
            return this;
        }

        public Builder withMemFractionForPendingCompaction(Double memFractionForPendingCompaction) {
            this.props.setProperty(FileSystemViewStorageConfig.FILESYSTEM_VIEW_PENDING_COMPACTION_MEM_FRACTION, memFractionForPendingCompaction.toString());
            return this;
        }

        public Builder withBaseStoreDir(String baseStorePath) {
            this.props.setProperty(FileSystemViewStorageConfig.FILESYSTEM_VIEW_SPILLABLE_DIR, baseStorePath);
            return this;
        }

        public Builder withRocksDBPath(String basePath) {
            this.props.setProperty(FileSystemViewStorageConfig.ROCKSDB_BASE_PATH_PROP, basePath);
            return this;
        }

        public Builder withEnableBackupForRemoteFileSystemView(boolean enable) {
            this.props.setProperty(FileSystemViewStorageConfig.REMOTE_BACKUP_VIEW_HANDLER_ENABLE, Boolean.toString(enable));
            return this;
        }

        public FileSystemViewStorageConfig build() {
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(FileSystemViewStorageConfig.FILESYSTEM_VIEW_STORAGE_TYPE), FileSystemViewStorageConfig.FILESYSTEM_VIEW_STORAGE_TYPE, DEFAULT_VIEW_STORAGE_TYPE.name());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(FileSystemViewStorageConfig.FILESYSTEM_VIEW_INCREMENTAL_SYNC_MODE), FileSystemViewStorageConfig.FILESYSTEM_VIEW_INCREMENTAL_SYNC_MODE, FileSystemViewStorageConfig.DEFAULT_FILESYSTEM_VIEW_INCREMENTAL_SYNC_MODE);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(FileSystemViewStorageConfig.FILESYSTEM_SECONDARY_VIEW_STORAGE_TYPE), FileSystemViewStorageConfig.FILESYSTEM_SECONDARY_VIEW_STORAGE_TYPE, DEFAULT_SECONDARY_VIEW_STORAGE_TYPE.name());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(FileSystemViewStorageConfig.FILESYSTEM_VIEW_REMOTE_HOST), FileSystemViewStorageConfig.FILESYSTEM_VIEW_REMOTE_HOST, FileSystemViewStorageConfig.DEFUALT_REMOTE_VIEW_SERVER_HOST);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(FileSystemViewStorageConfig.FILESYSTEM_VIEW_REMOTE_PORT), FileSystemViewStorageConfig.FILESYSTEM_VIEW_REMOTE_PORT, DEFAULT_REMOTE_VIEW_SERVER_PORT.toString());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(FileSystemViewStorageConfig.FILESYSTEM_VIEW_SPILLABLE_DIR), FileSystemViewStorageConfig.FILESYSTEM_VIEW_SPILLABLE_DIR, FileSystemViewStorageConfig.DEFAULT_VIEW_SPILLABLE_DIR);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(FileSystemViewStorageConfig.FILESYSTEM_VIEW_SPILLABLE_MEM), FileSystemViewStorageConfig.FILESYSTEM_VIEW_SPILLABLE_MEM, DEFAULT_MAX_MEMORY_FOR_VIEW.toString());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(FileSystemViewStorageConfig.FILESYSTEM_VIEW_PENDING_COMPACTION_MEM_FRACTION), FileSystemViewStorageConfig.FILESYSTEM_VIEW_PENDING_COMPACTION_MEM_FRACTION, DEFAULT_MEM_FRACTION_FOR_PENDING_COMPACTION.toString());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(FileSystemViewStorageConfig.ROCKSDB_BASE_PATH_PROP), FileSystemViewStorageConfig.ROCKSDB_BASE_PATH_PROP, FileSystemViewStorageConfig.DEFAULT_ROCKSDB_BASE_PATH);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(FileSystemViewStorageConfig.REMOTE_BACKUP_VIEW_HANDLER_ENABLE), FileSystemViewStorageConfig.REMOTE_BACKUP_VIEW_HANDLER_ENABLE, FileSystemViewStorageConfig.DEFAULT_REMOTE_BACKUP_VIEW_HANDLER_ENABLE);
            FileSystemViewStorageType.valueOf(this.props.getProperty(FileSystemViewStorageConfig.FILESYSTEM_VIEW_STORAGE_TYPE));
            FileSystemViewStorageType.valueOf(this.props.getProperty(FileSystemViewStorageConfig.FILESYSTEM_SECONDARY_VIEW_STORAGE_TYPE));
            ValidationUtils.checkArgument(Integer.parseInt(this.props.getProperty(FileSystemViewStorageConfig.FILESYSTEM_VIEW_REMOTE_PORT)) > 0);
            return new FileSystemViewStorageConfig(this.props);
        }
    }
}

