/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.relation.Predicate;
import com.facebook.presto.orc.array.Arrays;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Objects;

public class FilterFunction {
    private static final byte FILTER_NOT_EVALUATED = 0;
    private static final byte FILTER_PASSED = 1;
    private static final byte FILTER_FAILED = 2;
    private final SqlFunctionProperties properties;
    private final Predicate predicate;
    private final boolean deterministic;
    private final int[] inputChannels;
    private byte[] dictionaryResults;
    private Block previousDictionary;
    private Page dictionaryPage;

    public FilterFunction(SqlFunctionProperties properties, boolean deterministic, Predicate predicate) {
        this.properties = Objects.requireNonNull(properties, "properties is null");
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.deterministic = deterministic;
        this.inputChannels = Objects.requireNonNull(predicate.getInputChannels(), "inputChannels is null");
    }

    public int filter(Page page, int[] positions, int positionCount, RuntimeException[] errors) {
        Preconditions.checkArgument((positionCount <= positions.length ? 1 : 0) != 0);
        Preconditions.checkArgument((positionCount <= errors.length ? 1 : 0) != 0);
        if (this.deterministic && this.inputChannels.length == 1 && page.getBlock(0) instanceof DictionaryBlock) {
            return this.filterWithDictionary(page, positions, positionCount, errors);
        }
        int outputCount = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            try {
                if (!this.predicate.evaluate(this.properties, page, position)) continue;
                positions[outputCount] = position;
                errors[outputCount] = errors[i];
                ++outputCount;
                continue;
            }
            catch (RuntimeException e) {
                positions[outputCount] = position;
                errors[outputCount] = e;
                ++outputCount;
            }
        }
        return outputCount;
    }

    private int filterWithDictionary(Page page, int[] positions, int positionCount, RuntimeException[] errors) {
        int outputCount = 0;
        DictionaryBlock block = (DictionaryBlock)page.getBlock(0);
        Block dictionary = block.getDictionary();
        if (dictionary != this.previousDictionary) {
            this.previousDictionary = dictionary;
            int numEntries = dictionary.getPositionCount();
            this.dictionaryPage = new Page(numEntries, new Block[]{dictionary});
            this.dictionaryResults = Arrays.ensureCapacity(this.dictionaryResults, numEntries);
            java.util.Arrays.fill(this.dictionaryResults, 0, numEntries, (byte)0);
        }
        block7: for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            int dictionaryPosition = block.getId(position);
            byte result = this.dictionaryResults[dictionaryPosition];
            switch (result) {
                case 2: {
                    continue block7;
                }
                case 1: {
                    positions[outputCount] = position;
                    errors[outputCount] = errors[i];
                    ++outputCount;
                    continue block7;
                }
                case 0: {
                    try {
                        if (this.predicate.evaluate(this.properties, this.dictionaryPage, dictionaryPosition)) {
                            positions[outputCount] = position;
                            errors[outputCount] = errors[i];
                            ++outputCount;
                            this.dictionaryResults[dictionaryPosition] = 1;
                            continue block7;
                        }
                        this.dictionaryResults[dictionaryPosition] = 2;
                    }
                    catch (RuntimeException e) {
                        positions[outputCount] = position;
                        errors[outputCount] = e;
                        ++outputCount;
                    }
                    continue block7;
                }
                default: {
                    Verify.verify((boolean)false, (String)("Unexpected filter result: " + result), (Object[])new Object[0]);
                }
            }
        }
        return outputCount;
    }

    public int[] getInputChannels() {
        return this.inputChannels;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }
}

