/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.facebook.presto.orc.checkpoint.InputStreamCheckpoint;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.stream.LongDecode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.ByteArrays;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public final class OrcInputStream
extends InputStream {
    private static final long VARINT_MASK = -9187201950435737472L;
    private static final int MAX_VARINT_LENGTH = 10;
    private final OrcDataSourceId orcDataSourceId;
    private final FixedLengthSliceInput compressedSliceInput;
    private final Optional<OrcDecompressor> decompressor;
    private final Optional<DwrfDataEncryptor> dwrfDecryptor;
    private int currentCompressedBlockOffset;
    private byte[] buffer;
    private byte[] compressedBuffer;
    private byte[] decompressionResultBuffer;
    private int position;
    private int length;
    private int uncompressedOffset;
    private byte[] temporaryBuffer = new byte[8];
    private final OrcLocalMemoryContext bufferMemoryUsage;

    public OrcInputStream(OrcDataSourceId orcDataSourceId, FixedLengthSliceInput sliceInput, Optional<OrcDecompressor> decompressor, Optional<DwrfDataEncryptor> dwrfDecryptor, OrcAggregatedMemoryContext systemMemoryContext, long sliceInputRetainedSizeInBytes) {
        this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSource is null");
        Objects.requireNonNull(sliceInput, "sliceInput is null");
        this.decompressor = Objects.requireNonNull(decompressor, "decompressor is null");
        this.dwrfDecryptor = Objects.requireNonNull(dwrfDecryptor, "dwrfDecryptor is null");
        Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.bufferMemoryUsage = systemMemoryContext.newOrcLocalMemoryContext(OrcInputStream.class.getSimpleName());
        Preconditions.checkArgument((sliceInputRetainedSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"sliceInputRetainedSizeInBytes is negative");
        systemMemoryContext.newOrcLocalMemoryContext(OrcInputStream.class.getSimpleName()).setBytes(sliceInputRetainedSizeInBytes);
        if (!decompressor.isPresent() && !dwrfDecryptor.isPresent()) {
            int sliceInputPosition = Math.toIntExact(sliceInput.position());
            int sliceInputRemaining = Math.toIntExact(sliceInput.remaining());
            this.buffer = new byte[sliceInputRemaining];
            this.length = this.buffer.length;
            sliceInput.readFully(this.buffer, sliceInputPosition, sliceInputRemaining);
            this.compressedSliceInput = Slices.EMPTY_SLICE.getInput();
        } else {
            this.compressedSliceInput = sliceInput;
            this.buffer = new byte[0];
        }
    }

    @Override
    public void close() {
    }

    @Override
    public int available() {
        if (this.buffer == null) {
            return 0;
        }
        return this.length - this.position;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null) {
            return -1;
        }
        if (this.available() > 0) {
            return 0xFF & this.buffer[this.position++];
        }
        this.advance();
        return this.read();
    }

    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        if (this.buffer == null) {
            return -1;
        }
        if (this.available() == 0) {
            this.advance();
            if (this.buffer == null) {
                return -1;
            }
        }
        length = Math.min(length, this.available());
        System.arraycopy(this.buffer, this.position, b, off, length);
        this.position += length;
        return length;
    }

    public void skipFully(long length) throws IOException {
        while (length > 0L) {
            long result = this.skip(length);
            if (result < 0L) {
                throw new OrcCorruptionException(this.orcDataSourceId, "Unexpected end of stream");
            }
            length -= result;
        }
    }

    public void readFully(byte[] buffer, int offset, int length) throws IOException {
        while (offset < length) {
            int result = this.read(buffer, offset, length - offset);
            if (result < 0) {
                throw new OrcCorruptionException(this.orcDataSourceId, "Unexpected end of stream");
            }
            offset += result;
        }
    }

    public OrcDataSourceId getOrcDataSourceId() {
        return this.orcDataSourceId;
    }

    public long getCheckpoint() {
        if (this.buffer == null || this.position == 0 && this.available() == 0) {
            return InputStreamCheckpoint.createInputStreamCheckpoint(Math.toIntExact(this.compressedSliceInput.position()), 0);
        }
        return InputStreamCheckpoint.createInputStreamCheckpoint(this.currentCompressedBlockOffset, Math.toIntExact(this.position - this.uncompressedOffset));
    }

    public boolean seekToCheckpoint(long checkpoint) throws IOException {
        boolean discardedBuffer;
        int compressedBlockOffset = InputStreamCheckpoint.decodeCompressedBlockOffset(checkpoint);
        int decompressedOffset = InputStreamCheckpoint.decodeDecompressedOffset(checkpoint);
        if (compressedBlockOffset != this.currentCompressedBlockOffset) {
            if (!this.decompressor.isPresent() && !this.dwrfDecryptor.isPresent()) {
                throw new OrcCorruptionException(this.orcDataSourceId, "Reset stream has a block offset but stream is not compressed or encrypted");
            }
            this.compressedSliceInput.setPosition((long)compressedBlockOffset);
            this.buffer = new byte[0];
            this.position = 0;
            this.length = 0;
            this.uncompressedOffset = 0;
            discardedBuffer = true;
        } else {
            discardedBuffer = false;
        }
        if (decompressedOffset != this.position - this.uncompressedOffset) {
            this.position = this.uncompressedOffset;
            if (this.available() < decompressedOffset) {
                decompressedOffset -= this.available();
                this.advance();
            }
            this.position += decompressedOffset;
        } else if (this.length == 0) {
            this.advance();
            this.position += decompressedOffset;
        }
        return discardedBuffer;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.buffer == null || n <= 0L) {
            return -1L;
        }
        long result = Math.min((long)this.available(), n);
        this.position += Math.toIntExact(result);
        if (result != 0L) {
            return result;
        }
        if (this.read() == -1) {
            return 0L;
        }
        result = Math.min((long)this.available(), n - 1L);
        this.position += Math.toIntExact(result);
        return 1L + result;
    }

    public long readDwrfLong(OrcType.OrcTypeKind type) throws IOException {
        switch (type) {
            case SHORT: {
                return this.read() | this.read() << 8;
            }
            case INT: {
                return this.read() | this.read() << 8 | this.read() << 16 | this.read() << 24;
            }
            case LONG: {
                return (long)this.read() | (long)this.read() << 8 | (long)this.read() << 16 | (long)this.read() << 24 | (long)this.read() << 32 | (long)this.read() << 40 | (long)this.read() << 48 | (long)this.read() << 56;
            }
        }
        throw new IllegalStateException();
    }

    public void skipDwrfLong(OrcType.OrcTypeKind type, long items) throws IOException {
        if (items == 0L) {
            return;
        }
        long bytes = items;
        switch (type) {
            case SHORT: {
                bytes *= 2L;
                break;
            }
            case INT: {
                bytes *= 4L;
                break;
            }
            case LONG: {
                bytes *= 8L;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.skip(bytes);
    }

    public long readVarint(boolean signed) throws IOException {
        long result = 0L;
        int shift = 0;
        int available = this.available();
        if (available >= 16) {
            long word = ByteArrays.getLong((byte[])this.buffer, (int)this.position);
            int count = 1;
            boolean atEnd = false;
            result = word & 0x7FL;
            if ((word & 0x80L) != 0L) {
                long control = word >>> 8;
                long mask = 16256L;
                while (true) {
                    result |= (word >>>= 1) & mask;
                    ++count;
                    if ((control & 0x80L) == 0L) {
                        atEnd = true;
                        break;
                    }
                    if (mask == 0xFE000000000000L) break;
                    mask <<= 7;
                    control >>>= 8;
                }
                if (!atEnd) {
                    word = ByteArrays.getLong((byte[])this.buffer, (int)(this.position + 8));
                    result |= (word & 0x7FL) << 56;
                    if ((word & 0x80L) == 0L) {
                        ++count;
                    } else {
                        result |= Long.MIN_VALUE;
                        count += 2;
                    }
                }
            }
            this.position += count;
        } else {
            do {
                if (available == 0) {
                    this.advance();
                    available = this.available();
                    if (available == 0) {
                        throw new OrcCorruptionException(this.orcDataSourceId, "End of stream in RLE Integer");
                    }
                }
                --available;
                result |= (long)(this.buffer[this.position] & 0x7F) << shift;
                shift += 7;
            } while ((this.buffer[this.position++] & 0x80) != 0);
        }
        if (signed) {
            return LongDecode.zigzagDecode(result);
        }
        return result;
    }

    public void skipVarints(long items) throws IOException {
        if (items == 0L) {
            return;
        }
        while (items > 0L) {
            items -= this.skipVarintsInBuffer(items);
        }
    }

    private long skipVarintsInBuffer(long items) throws IOException {
        if (this.available() == 0) {
            this.advance();
            if (this.available() == 0) {
                throw new OrcCorruptionException(this.orcDataSourceId, "Unexpected end of stream");
            }
        }
        long skipped = 0L;
        while (items - skipped > 8L && this.available() > 10) {
            long value = ByteArrays.getLong((byte[])this.buffer, (int)this.position);
            this.position += 8;
            long mask = value & 0x8080808080808080L ^ 0x8080808080808080L;
            skipped += (long)Long.bitCount(mask);
        }
        while (skipped < items && this.available() > 0) {
            if ((this.buffer[this.position++] & 0x80) != 0) continue;
            ++skipped;
        }
        return skipped;
    }

    public double readDouble() throws IOException {
        int readPosition = this.ensureContiguousBytesAndAdvance(8);
        if (readPosition < 0) {
            return ByteArrays.getDouble((byte[])this.temporaryBuffer, (int)0);
        }
        return ByteArrays.getDouble((byte[])this.buffer, (int)readPosition);
    }

    public float readFloat() throws IOException {
        int readPosition = this.ensureContiguousBytesAndAdvance(4);
        if (readPosition < 0) {
            return ByteArrays.getFloat((byte[])this.temporaryBuffer, (int)0);
        }
        return ByteArrays.getFloat((byte[])this.buffer, (int)readPosition);
    }

    private int ensureContiguousBytesAndAdvance(int bytes) throws IOException {
        if (this.available() >= bytes) {
            int startPosition = this.position;
            this.position += bytes;
            return startPosition;
        }
        this.readFully(this.temporaryBuffer, 0, bytes);
        return -1;
    }

    private void advance() throws IOException {
        if (this.compressedSliceInput == null || this.compressedSliceInput.remaining() == 0L) {
            this.buffer = null;
            this.position = 0;
            this.length = 0;
            this.uncompressedOffset = 0;
            return;
        }
        this.currentCompressedBlockOffset = Math.toIntExact(this.compressedSliceInput.position());
        int b0 = this.compressedSliceInput.readUnsignedByte();
        int b1 = this.compressedSliceInput.readUnsignedByte();
        int b2 = this.compressedSliceInput.readUnsignedByte();
        boolean isUncompressed = (b0 & 1) == 1;
        int chunkLength = b2 << 15 | b1 << 7 | b0 >>> 1;
        if (chunkLength < 0 || (long)chunkLength > this.compressedSliceInput.remaining()) {
            throw new OrcCorruptionException(this.orcDataSourceId, "The chunkLength (%s) must not be negative or greater than remaining size (%s)", chunkLength, this.compressedSliceInput.remaining());
        }
        if (isUncompressed) {
            this.buffer = OrcInputStream.ensureCapacity(this.buffer, chunkLength);
            this.length = this.compressedSliceInput.read(this.buffer, 0, chunkLength);
            if (this.dwrfDecryptor.isPresent()) {
                this.buffer = this.dwrfDecryptor.get().decrypt(this.buffer, 0, chunkLength);
                this.length = this.buffer.length;
            }
            this.position = 0;
        } else {
            this.compressedBuffer = OrcInputStream.ensureCapacity(this.compressedBuffer, chunkLength);
            int readCompressed = this.compressedSliceInput.read(this.compressedBuffer, 0, chunkLength);
            if (this.dwrfDecryptor.isPresent()) {
                this.compressedBuffer = this.dwrfDecryptor.get().decrypt(this.compressedBuffer, 0, chunkLength);
                readCompressed = this.compressedBuffer.length;
            }
            this.buffer = this.decompressionResultBuffer;
            OrcDecompressor.OutputBuffer output = new OrcDecompressor.OutputBuffer(){

                @Override
                public byte[] initialize(int size) {
                    if (OrcInputStream.this.buffer == null || size > OrcInputStream.this.buffer.length) {
                        OrcInputStream.access$002(OrcInputStream.this, new byte[size]);
                        OrcInputStream.this.bufferMemoryUsage.setBytes(OrcInputStream.this.buffer.length);
                        OrcInputStream.this.position = 0;
                        OrcInputStream.this.length = size;
                    }
                    return OrcInputStream.this.buffer;
                }

                @Override
                public byte[] grow(int size) {
                    if (size > OrcInputStream.this.buffer.length) {
                        OrcInputStream.access$002(OrcInputStream.this, Arrays.copyOfRange(OrcInputStream.this.buffer, 0, size));
                        OrcInputStream.this.bufferMemoryUsage.setBytes(OrcInputStream.this.buffer.length);
                    }
                    return OrcInputStream.this.buffer;
                }
            };
            this.length = this.decompressor.get().decompress(this.compressedBuffer, 0, readCompressed, output);
            this.decompressionResultBuffer = this.buffer;
            this.position = 0;
        }
        this.uncompressedOffset = this.position;
    }

    private static byte[] ensureCapacity(byte[] buffer, int capacity) {
        if (buffer == null || buffer.length < capacity) {
            return new byte[capacity];
        }
        return buffer;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.orcDataSourceId).add("compressedOffset", this.compressedSliceInput.position()).add("uncompressedOffset", this.buffer == null ? null : Integer.valueOf(this.position)).add("decompressor", (Object)this.decompressor.map(Object::toString).orElse("none")).add("decryptor", (Object)this.dwrfDecryptor.map(Object::toString).orElse("none")).toString();
    }

    static /* synthetic */ byte[] access$002(OrcInputStream x0, byte[] x1) {
        x0.buffer = x1;
        return x1;
    }
}

