/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.zlib;

import io.airlift.compress.Compressor;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;

public class DeflateCompressor
implements Compressor {
    private static final int EXTRA_COMPRESSION_SPACE = 16;
    private static final int COMPRESSION_LEVEL = 4;

    public int maxCompressedLength(int uncompressedSize) {
        return uncompressedSize + (uncompressedSize + 7 >> 3) + (uncompressedSize + 63 >> 6) + 5 + 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        int maxCompressedLength = this.maxCompressedLength(inputLength);
        if (maxOutputLength < maxCompressedLength) {
            throw new IllegalArgumentException("Output buffer must be at least " + maxCompressedLength + " bytes");
        }
        Deflater deflater = new Deflater(4, true);
        try {
            deflater.setInput(input, inputOffset, inputLength);
            deflater.finish();
            int compressedDataLength = deflater.deflate(output, outputOffset, maxOutputLength, 3);
            if (!deflater.finished()) {
                throw new IllegalArgumentException("maxCompressedLength formula is incorrect, because deflate produced more data");
            }
            int n = compressedDataLength;
            return n;
        }
        finally {
            deflater.end();
        }
    }

    public void compress(ByteBuffer input, ByteBuffer output) {
        if (input.isDirect() || output.isDirect() || !input.hasArray() || !output.hasArray()) {
            throw new IllegalArgumentException("Non-direct byte buffer backed by byte array required");
        }
        int inputOffset = input.arrayOffset() + input.position();
        int outputOffset = output.arrayOffset() + output.position();
        int written = this.compress(input.array(), inputOffset, input.remaining(), output.array(), outputOffset, output.remaining());
        output.position(output.position() + written);
    }
}

