/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.expressions;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class DynamicFilters {
    private DynamicFilters() {
    }

    public static DynamicFilterExtractResult extractDynamicFilters(RowExpression expression) {
        List<RowExpression> conjuncts = LogicalRowExpressions.extractConjuncts(expression);
        ImmutableList.Builder staticConjuncts = ImmutableList.builder();
        ImmutableList.Builder dynamicConjuncts = ImmutableList.builder();
        for (RowExpression conjunct : conjuncts) {
            Optional<DynamicFilterPlaceholder> placeholder = DynamicFilters.getPlaceholder(conjunct);
            if (placeholder.isPresent()) {
                dynamicConjuncts.add((Object)placeholder.get());
                continue;
            }
            staticConjuncts.add((Object)conjunct);
        }
        return new DynamicFilterExtractResult((List<RowExpression>)staticConjuncts.build(), (List<DynamicFilterPlaceholder>)dynamicConjuncts.build());
    }

    public static RowExpression extractDynamicConjuncts(List<RowExpression> conjuncts, LogicalRowExpressions logicalRowExpressions) {
        ImmutableList.Builder dynamicConjuncts = ImmutableList.builder();
        for (RowExpression conjunct : conjuncts) {
            Optional<DynamicFilterPlaceholder> placeholder = DynamicFilters.getPlaceholder(conjunct);
            if (!placeholder.isPresent()) continue;
            dynamicConjuncts.add((Object)conjunct);
        }
        return logicalRowExpressions.combineConjuncts((Collection<RowExpression>)dynamicConjuncts.build());
    }

    public static RowExpression extractStaticConjuncts(List<RowExpression> conjuncts, LogicalRowExpressions logicalRowExpressions) {
        ImmutableList.Builder staticConjuncts = ImmutableList.builder();
        for (RowExpression conjunct : conjuncts) {
            Optional<DynamicFilterPlaceholder> placeholder = DynamicFilters.getPlaceholder(conjunct);
            if (placeholder.isPresent()) continue;
            staticConjuncts.add((Object)conjunct);
        }
        return logicalRowExpressions.combineConjuncts((Collection<RowExpression>)staticConjuncts.build());
    }

    public static boolean isDynamicFilter(RowExpression expression) {
        return DynamicFilters.getPlaceholder(expression).isPresent();
    }

    public static Optional<DynamicFilterPlaceholder> getPlaceholder(RowExpression expression) {
        if (!(expression instanceof CallExpression)) {
            return Optional.empty();
        }
        CallExpression call = (CallExpression)expression;
        if (!call.getDisplayName().equals("$internal$dynamic_filter_function")) {
            return Optional.empty();
        }
        List arguments = call.getArguments();
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0, (String)"invalid arguments count: %s", (int)arguments.size());
        RowExpression firstArgument = (RowExpression)arguments.get(0);
        Preconditions.checkArgument((boolean)(firstArgument instanceof ConstantExpression));
        Preconditions.checkArgument((boolean)(firstArgument.getType() instanceof VarcharType));
        String id = ((Slice)((ConstantExpression)firstArgument).getValue()).toStringUtf8();
        return Optional.of(new DynamicFilterPlaceholder(id, (RowExpression)arguments.get(1)));
    }

    @ScalarFunction(value="$internal$dynamic_filter_function", visibility=SqlFunctionVisibility.HIDDEN)
    public static final class DynamicFilterPlaceholderFunction {
        public static final String NAME = "$internal$dynamic_filter_function";

        private DynamicFilterPlaceholderFunction() {
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="varchar") Slice id, @SqlType(value="T") Block input) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="varchar") Slice id, @SqlType(value="T") Slice input) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="varchar") Slice id, @SqlType(value="T") long input) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="varchar") Slice id, @SqlType(value="T") boolean input) {
            throw new UnsupportedOperationException();
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean dynamicFilter(@SqlType(value="varchar") Slice id, @SqlType(value="T") double input) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class DynamicFilterPlaceholder {
        private final String id;
        private final RowExpression input;

        public DynamicFilterPlaceholder(String id, RowExpression input) {
            this.id = Objects.requireNonNull(id, "id is null");
            this.input = Objects.requireNonNull(input, "input is null");
        }

        public String getId() {
            return this.id;
        }

        public RowExpression getInput() {
            return this.input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicFilterPlaceholder that = (DynamicFilterPlaceholder)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.input, that.input);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.input);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("input", (Object)this.input).toString();
        }
    }

    public static class DynamicFilterExtractResult {
        private final List<RowExpression> staticConjuncts;
        private final List<DynamicFilterPlaceholder> dynamicConjuncts;

        public DynamicFilterExtractResult(List<RowExpression> staticConjuncts, List<DynamicFilterPlaceholder> dynamicConjuncts) {
            this.staticConjuncts = ImmutableList.copyOf((Collection)Objects.requireNonNull(staticConjuncts, "staticConjuncts is null"));
            this.dynamicConjuncts = ImmutableList.copyOf((Collection)Objects.requireNonNull(dynamicConjuncts, "dynamicConjuncts is null"));
        }

        public List<RowExpression> getStaticConjuncts() {
            return this.staticConjuncts;
        }

        public List<DynamicFilterPlaceholder> getDynamicConjuncts() {
            return this.dynamicConjuncts;
        }
    }
}

