/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader;

import com.facebook.presto.parquet.ColumnReader;
import com.facebook.presto.parquet.DataPage;
import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.batchreader.DefinitionLevelDecodingContext;
import com.facebook.presto.parquet.batchreader.DefinitionLevelValuesDecoderContext;
import com.facebook.presto.parquet.batchreader.RepetitionLevelDecodingContext;
import com.facebook.presto.parquet.batchreader.ValuesDecoderContext;
import com.facebook.presto.parquet.batchreader.decoders.Decoders;
import com.facebook.presto.parquet.batchreader.decoders.DefinitionLevelDecoder;
import com.facebook.presto.parquet.batchreader.decoders.RepetitionLevelDecoder;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.dictionary.Dictionaries;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.facebook.presto.parquet.reader.ColumnChunk;
import com.facebook.presto.parquet.reader.PageReader;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.parquet.Preconditions;
import org.apache.parquet.io.ParquetDecodingException;

public abstract class AbstractNestedBatchReader
implements ColumnReader {
    protected final RichColumnDescriptor columnDescriptor;
    protected Field field;
    protected int nextBatchSize;
    protected int readOffset;
    private Dictionary dictionary;
    private RepetitionLevelDecoder repetitionLevelDecoder;
    private DefinitionLevelDecoder definitionLevelDecoder;
    private ValuesDecoder valuesDecoder;
    private int remainingCountInPage;
    private PageReader pageReader;
    private int lastRepetitionLevel = -1;

    protected abstract ColumnChunk readNestedNoNull() throws IOException;

    protected abstract ColumnChunk readNestedWithNull() throws IOException;

    protected abstract void seek() throws IOException;

    public AbstractNestedBatchReader(RichColumnDescriptor columnDescriptor) {
        com.google.common.base.Preconditions.checkArgument((columnDescriptor.getPath().length > 1 ? 1 : 0) != 0, (Object)"expected to read a nested column");
        this.columnDescriptor = Objects.requireNonNull(columnDescriptor, "columnDescriptor is null");
    }

    @Override
    public boolean isInitialized() {
        return this.pageReader != null && this.field != null;
    }

    @Override
    public void init(PageReader pageReader, Field field) {
        Preconditions.checkState((!this.isInitialized() ? 1 : 0) != 0, (String)"already initialized");
        this.pageReader = Objects.requireNonNull(pageReader, "pageReader is null");
        com.google.common.base.Preconditions.checkArgument((pageReader.getTotalValueCount() > 0L ? 1 : 0) != 0, (Object)"page is empty");
        this.field = Objects.requireNonNull(field, "field is null");
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            this.dictionary = Dictionaries.createDictionary(this.columnDescriptor, dictionaryPage);
        }
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public ColumnChunk readNext() {
        ColumnChunk columnChunk = null;
        try {
            this.seek();
            columnChunk = this.field.isRequired() ? this.readNestedNoNull() : this.readNestedWithNull();
        }
        catch (IOException ex) {
            throw new ParquetDecodingException("Failed to decode.", (Throwable)ex);
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return columnChunk;
    }

    protected void readNextPage() {
        this.remainingCountInPage = 0;
        DataPage page = this.pageReader.readPage();
        if (page == null) {
            return;
        }
        Decoders.NestedDecoders nestedDecoders = Decoders.readNestedPage(page, this.columnDescriptor, this.dictionary);
        this.repetitionLevelDecoder = nestedDecoders.getRepetitionLevelDecoder();
        this.definitionLevelDecoder = nestedDecoders.getDefinitionLevelDecoder();
        this.valuesDecoder = nestedDecoders.getValuesDecoder();
        this.remainingCountInPage = page.getValueCount();
    }

    protected final RepetitionLevelDecodingContext readRepetitionLevels(int batchSize) throws IOException {
        IntArrayList repetitionLevels = new IntArrayList(batchSize);
        RepetitionLevelDecodingContext repetitionLevelDecodingContext = new RepetitionLevelDecodingContext();
        int remainingInBatch = batchSize + 1;
        if (this.remainingCountInPage == 0) {
            this.readNextPage();
        }
        int startOffset = 0;
        if (this.lastRepetitionLevel != -1) {
            repetitionLevels.add(this.lastRepetitionLevel);
            this.lastRepetitionLevel = -1;
            --remainingInBatch;
        }
        while (remainingInBatch > 0) {
            int valueCount = this.repetitionLevelDecoder.readNext((IntList)repetitionLevels, remainingInBatch);
            if (valueCount == 0) {
                int endOffset = repetitionLevels.size();
                repetitionLevelDecodingContext.add(new DefinitionLevelValuesDecoderContext(this.definitionLevelDecoder, this.valuesDecoder, startOffset, endOffset));
                this.remainingCountInPage -= endOffset - startOffset;
                startOffset = endOffset;
                this.readNextPage();
                if (this.remainingCountInPage != 0) continue;
                break;
            }
            remainingInBatch -= valueCount;
        }
        if (remainingInBatch == 0) {
            this.lastRepetitionLevel = 0;
            repetitionLevels.remove(repetitionLevels.size() - 1);
        }
        if (this.repetitionLevelDecoder != null) {
            repetitionLevelDecodingContext.add(new DefinitionLevelValuesDecoderContext(this.definitionLevelDecoder, this.valuesDecoder, startOffset, repetitionLevels.size()));
        }
        repetitionLevelDecodingContext.setRepetitionLevels(repetitionLevels.toIntArray());
        return repetitionLevelDecodingContext;
    }

    protected final DefinitionLevelDecodingContext readDefinitionLevels(List<DefinitionLevelValuesDecoderContext> decoderInfos, int batchSize) throws IOException {
        DefinitionLevelDecodingContext definitionLevelDecodingContext = new DefinitionLevelDecodingContext();
        int[] definitionLevels = new int[batchSize];
        int remainingInBatch = batchSize;
        for (DefinitionLevelValuesDecoderContext decoderInfo : decoderInfos) {
            int readChunkSize = decoderInfo.getEnd() - decoderInfo.getStart();
            decoderInfo.getDefinitionLevelDecoder().readNext(definitionLevels, decoderInfo.getStart(), readChunkSize);
            definitionLevelDecodingContext.add(new ValuesDecoderContext<ValuesDecoder>(decoderInfo.getValuesDecoder(), decoderInfo.getStart(), decoderInfo.getEnd()));
            remainingInBatch -= readChunkSize;
        }
        if (remainingInBatch != 0) {
            throw new IllegalStateException("We didn't read correct number of definitionLevels");
        }
        definitionLevelDecodingContext.setDefinitionLevels(definitionLevels);
        return definitionLevelDecodingContext;
    }
}

