/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders;

import com.facebook.presto.parquet.batchreader.decoders.rle.BaseRLEBitPackedDecoder;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.io.InputStream;
import org.apache.parquet.io.ParquetDecodingException;

public class RepetitionLevelDecoder
extends BaseRLEBitPackedDecoder {
    private int remaining;
    private int currentOffsetPackedBuffer;
    private int endOffsetPackedBuffer;

    public RepetitionLevelDecoder(int valueCount, int bitWidth, InputStream inputStream) {
        super(valueCount, bitWidth, inputStream);
        this.remaining = valueCount;
    }

    public RepetitionLevelDecoder(int rleValue, int valueCount) {
        super(rleValue, valueCount);
    }

    public int readNext(IntList repetitionLevels, int batchSize) throws IOException {
        int remainingToCopy = batchSize;
        block4: while (remainingToCopy > 0 && this.ensureBlockAvailable()) {
            switch (this.mode) {
                case RLE: {
                    int rleValue = this.currentValue;
                    if (rleValue == 0) {
                        int chunkSize = Math.min(remainingToCopy, this.currentCount);
                        for (int i = 0; i < chunkSize; ++i) {
                            repetitionLevels.add(0);
                        }
                        this.currentCount -= chunkSize;
                        this.remaining -= chunkSize;
                        remainingToCopy -= chunkSize;
                        continue block4;
                    }
                    this.remaining -= this.currentCount;
                    for (int i = 0; i < this.currentCount; ++i) {
                        repetitionLevels.add(rleValue);
                    }
                    this.currentCount = 0;
                    continue block4;
                }
                case PACKED: {
                    int[] localBuffer = this.currentBuffer;
                    do {
                        int rlValue = localBuffer[this.currentOffsetPackedBuffer];
                        ++this.currentOffsetPackedBuffer;
                        repetitionLevels.add(rlValue);
                        if (rlValue == 0) {
                            --remainingToCopy;
                        }
                        --this.remaining;
                    } while (this.currentOffsetPackedBuffer < this.endOffsetPackedBuffer && remainingToCopy > 0);
                    this.currentCount = this.endOffsetPackedBuffer - this.currentOffsetPackedBuffer;
                    continue block4;
                }
            }
            throw new ParquetDecodingException("not a valid mode " + (Object)((Object)this.mode));
        }
        return batchSize - remainingToCopy;
    }

    private boolean ensureBlockAvailable() throws IOException {
        if (this.currentCount == 0) {
            if (!this.decode()) {
                return false;
            }
            this.currentCount = Math.min(this.remaining, this.currentCount);
            this.currentOffsetPackedBuffer = 0;
            this.endOffsetPackedBuffer = this.currentCount;
        }
        return true;
    }
}

