/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.IntArrayBlock;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.parquet.ColumnReader;
import com.facebook.presto.parquet.ColumnReaderFactory;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.GroupField;
import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetResultVerifierUtils;
import com.facebook.presto.parquet.ParquetValidationUtils;
import com.facebook.presto.parquet.PrimitiveField;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.reader.ColumnChunk;
import com.facebook.presto.parquet.reader.ColumnChunkDescriptor;
import com.facebook.presto.parquet.reader.ListColumnReader;
import com.facebook.presto.parquet.reader.ParquetColumnChunk;
import com.facebook.presto.parquet.reader.StructColumnReader;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.PrimitiveType;

public class ParquetReader
implements Closeable {
    private static final int MAX_VECTOR_LENGTH = 1024;
    private static final int INITIAL_BATCH_SIZE = 1;
    private static final int BATCH_SIZE_GROWTH_FACTOR = 2;
    private final List<BlockMetaData> blocks;
    private final List<PrimitiveColumnIO> columns;
    private final ParquetDataSource dataSource;
    private final AggregatedMemoryContext systemMemoryContext;
    private final boolean batchReadEnabled;
    private final boolean enableVerification;
    private int currentBlock;
    private BlockMetaData currentBlockMetadata;
    private long currentPosition;
    private long currentGroupRowCount;
    private long nextRowInGroup;
    private int batchSize;
    private int nextBatchSize = 1;
    private final ColumnReader[] columnReaders;
    protected final ColumnReader[] verificationColumnReaders;
    private long[] maxBytesPerCell;
    private long maxCombinedBytesPerRow;
    private final long maxReadBlockBytes;
    private int maxBatchSize = 1024;
    private AggregatedMemoryContext currentRowGroupMemoryContext;

    public ParquetReader(MessageColumnIO messageColumnIO, List<BlockMetaData> blocks, ParquetDataSource dataSource, AggregatedMemoryContext systemMemoryContext, DataSize maxReadBlockSize, boolean batchReadEnabled, boolean enableVerification) {
        this.blocks = blocks;
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.currentRowGroupMemoryContext = systemMemoryContext.newAggregatedMemoryContext();
        this.maxReadBlockBytes = Objects.requireNonNull(maxReadBlockSize, "maxReadBlockSize is null").toBytes();
        this.batchReadEnabled = batchReadEnabled;
        this.columns = messageColumnIO.getLeaves();
        this.columnReaders = new ColumnReader[this.columns.size()];
        this.enableVerification = enableVerification;
        this.verificationColumnReaders = enableVerification ? new ColumnReader[this.columns.size()] : null;
        this.maxBytesPerCell = new long[this.columns.size()];
    }

    @Override
    public void close() throws IOException {
        this.currentRowGroupMemoryContext.close();
        this.dataSource.close();
    }

    public long getPosition() {
        return this.currentPosition;
    }

    public int nextBatch() {
        if (this.nextRowInGroup >= this.currentGroupRowCount && !this.advanceToNextRowGroup()) {
            return -1;
        }
        this.batchSize = Math.toIntExact(Math.min(this.nextBatchSize, this.maxBatchSize));
        this.nextBatchSize = Math.min(this.batchSize * 2, 1024);
        this.batchSize = Math.toIntExact(Math.min((long)this.batchSize, this.currentGroupRowCount - this.nextRowInGroup));
        this.nextRowInGroup += (long)this.batchSize;
        this.currentPosition += (long)this.batchSize;
        Arrays.stream(this.columnReaders).forEach(reader -> reader.prepareNextRead(this.batchSize));
        if (this.enableVerification) {
            Arrays.stream(this.verificationColumnReaders).forEach(reader -> reader.prepareNextRead(this.batchSize));
        }
        return this.batchSize;
    }

    private boolean advanceToNextRowGroup() {
        this.currentRowGroupMemoryContext.close();
        this.currentRowGroupMemoryContext = this.systemMemoryContext.newAggregatedMemoryContext();
        if (this.currentBlock == this.blocks.size()) {
            return false;
        }
        this.currentBlockMetadata = this.blocks.get(this.currentBlock);
        ++this.currentBlock;
        this.nextRowInGroup = 0L;
        this.currentGroupRowCount = this.currentBlockMetadata.getRowCount();
        this.initializeColumnReaders();
        return true;
    }

    private ColumnChunk readArray(GroupField field) throws IOException {
        List parameters = field.getType().getTypeParameters();
        Preconditions.checkArgument((parameters.size() == 1 ? 1 : 0) != 0, (String)"Arrays must have a single type parameter, found %d", (int)parameters.size());
        Field elementField = field.getChildren().get(0).get();
        ColumnChunk columnChunk = this.readColumnChunk(elementField);
        IntArrayList offsets = new IntArrayList();
        BooleanArrayList valueIsNull = new BooleanArrayList();
        ListColumnReader.calculateCollectionOffsets(field, (IntList)offsets, (BooleanList)valueIsNull, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        Block arrayBlock = ArrayBlock.fromElementBlock((int)valueIsNull.size(), Optional.of(valueIsNull.toBooleanArray()), (int[])offsets.toIntArray(), (Block)columnChunk.getBlock());
        return new ColumnChunk(arrayBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readMap(GroupField field) throws IOException {
        List parameters = field.getType().getTypeParameters();
        Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0, (String)"Maps must have two type parameters, found %d", (int)parameters.size());
        Block[] blocks = new Block[parameters.size()];
        ColumnChunk columnChunk = this.readColumnChunk(field.getChildren().get(0).get());
        blocks[0] = columnChunk.getBlock();
        blocks[1] = this.readColumnChunk(field.getChildren().get(1).get()).getBlock();
        IntArrayList offsets = new IntArrayList();
        BooleanArrayList valueIsNull = new BooleanArrayList();
        ListColumnReader.calculateCollectionOffsets(field, (IntList)offsets, (BooleanList)valueIsNull, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        Block mapBlock = ((MapType)field.getType()).createBlockFromKeyValue(offsets.size() - 1, Optional.of(valueIsNull.toBooleanArray()), offsets.toIntArray(), blocks[0], blocks[1]);
        return new ColumnChunk(mapBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readStruct(GroupField field) throws IOException {
        int i;
        List fields = field.getType().getTypeSignature().getParameters();
        Block[] blocks = new Block[fields.size()];
        ColumnChunk columnChunk = null;
        List<Optional<Field>> parameters = field.getChildren();
        for (i = 0; i < fields.size(); ++i) {
            Optional<Field> parameter = parameters.get(i);
            if (!parameter.isPresent()) continue;
            columnChunk = this.readColumnChunk(parameter.get());
            blocks[i] = columnChunk.getBlock();
        }
        for (i = 0; i < fields.size(); ++i) {
            if (blocks[i] != null) continue;
            blocks[i] = RunLengthEncodedBlock.create((Type)field.getType(), null, (int)columnChunk.getBlock().getPositionCount());
        }
        BooleanList structIsNull = StructColumnReader.calculateStructOffsets(field, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        boolean[] structIsNullVector = structIsNull.toBooleanArray();
        Block rowBlock = RowBlock.fromFieldBlocks((int)structIsNullVector.length, Optional.of(structIsNullVector), (Block[])blocks);
        return new ColumnChunk(rowBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readPrimitive(PrimitiveField field) throws IOException {
        long bytesPerCell;
        RichColumnDescriptor columnDescriptor = field.getDescriptor();
        int fieldId = field.getId();
        ColumnReader columnReader = this.columnReaders[fieldId];
        if (!columnReader.isInitialized()) {
            ParquetValidationUtils.validateParquet(this.currentBlockMetadata.getRowCount() > 0L, "Row group has 0 rows", new Object[0]);
            ColumnChunkMetaData metadata = this.getColumnChunkMetaData(columnDescriptor);
            long startingPosition = metadata.getStartingPos();
            int totalSize = Math.toIntExact(metadata.getTotalSize());
            byte[] buffer = this.allocateBlock(totalSize);
            this.dataSource.readFully(startingPosition, buffer);
            ColumnChunkDescriptor descriptor = new ColumnChunkDescriptor(columnDescriptor, metadata, totalSize);
            ParquetColumnChunk columnChunk = new ParquetColumnChunk(descriptor, buffer, 0);
            columnReader.init(columnChunk.readAllPages(), field);
            if (this.enableVerification) {
                ColumnReader verificationColumnReader = this.verificationColumnReaders[field.getId()];
                ParquetColumnChunk columnChunkVerfication = new ParquetColumnChunk(descriptor, buffer, 0);
                verificationColumnReader.init(columnChunkVerfication.readAllPages(), field);
            }
        }
        ColumnChunk columnChunk = columnReader.readNext();
        columnChunk = ParquetReader.typeCoercion(columnChunk, field.getDescriptor().getPrimitiveType().getPrimitiveTypeName(), field.getType());
        if (this.enableVerification) {
            ColumnReader verificationColumnReader = this.verificationColumnReaders[field.getId()];
            ColumnChunk expected = verificationColumnReader.readNext();
            ParquetResultVerifierUtils.verifyColumnChunks(columnChunk, expected, columnDescriptor.getPath().length > 1, field, this.dataSource.getId());
        }
        if (this.maxBytesPerCell[fieldId] < (bytesPerCell = columnChunk.getBlock().getSizeInBytes() / (long)this.batchSize)) {
            this.maxCombinedBytesPerRow = this.maxCombinedBytesPerRow - this.maxBytesPerCell[fieldId] + bytesPerCell;
            this.maxBatchSize = Math.toIntExact(Math.min((long)this.maxBatchSize, Math.max(1L, this.maxReadBlockBytes / this.maxCombinedBytesPerRow)));
            this.maxBytesPerCell[fieldId] = bytesPerCell;
        }
        return columnChunk;
    }

    private byte[] allocateBlock(int length) {
        byte[] buffer = new byte[length];
        LocalMemoryContext blockMemoryContext = this.currentRowGroupMemoryContext.newLocalMemoryContext(ParquetReader.class.getSimpleName());
        blockMemoryContext.setBytes((long)buffer.length);
        return buffer;
    }

    private ColumnChunkMetaData getColumnChunkMetaData(ColumnDescriptor columnDescriptor) throws IOException {
        for (ColumnChunkMetaData metadata : this.currentBlockMetadata.getColumns()) {
            if (!metadata.getPath().equals((Object)ColumnPath.get((String[])columnDescriptor.getPath()))) continue;
            return metadata;
        }
        throw new ParquetCorruptionException("Metadata is missing for column: %s", columnDescriptor);
    }

    private void initializeColumnReaders() {
        for (PrimitiveColumnIO columnIO : this.columns) {
            RichColumnDescriptor column = new RichColumnDescriptor(columnIO.getColumnDescriptor(), columnIO.getType().asPrimitiveType());
            this.columnReaders[columnIO.getId()] = ColumnReaderFactory.createReader(column, this.batchReadEnabled);
            if (!this.enableVerification) continue;
            this.verificationColumnReaders[columnIO.getId()] = ColumnReaderFactory.createReader(column, false);
        }
    }

    public Block readBlock(Field field) throws IOException {
        return this.readColumnChunk(field).getBlock();
    }

    private ColumnChunk readColumnChunk(Field field) throws IOException {
        ColumnChunk columnChunk = "row".equals(field.getType().getTypeSignature().getBase()) ? this.readStruct((GroupField)field) : ("map".equals(field.getType().getTypeSignature().getBase()) ? this.readMap((GroupField)field) : ("array".equals(field.getType().getTypeSignature().getBase()) ? this.readArray((GroupField)field) : this.readPrimitive((PrimitiveField)field)));
        return columnChunk;
    }

    public ParquetDataSource getDataSource() {
        return this.dataSource;
    }

    public AggregatedMemoryContext getSystemMemoryContext() {
        return this.systemMemoryContext;
    }

    private static ColumnChunk typeCoercion(ColumnChunk columnChunk, PrimitiveType.PrimitiveTypeName physicalDataType, Type outputType) {
        Block newBlock = null;
        if ("smallint".equals(outputType) || TinyintType.TINYINT.equals((Object)outputType)) {
            if (columnChunk.getBlock() instanceof IntArrayBlock) {
                newBlock = ParquetReader.rewriteIntegerArrayBlock((IntArrayBlock)columnChunk.getBlock(), outputType);
            } else if (columnChunk.getBlock() instanceof LongArrayBlock) {
                newBlock = ParquetReader.rewriteLongArrayBlock((LongArrayBlock)columnChunk.getBlock(), outputType);
            }
        } else if (IntegerType.INTEGER.equals((Object)outputType) && physicalDataType == PrimitiveType.PrimitiveTypeName.INT64) {
            if (columnChunk.getBlock() instanceof LongArrayBlock) {
                newBlock = ParquetReader.rewriteLongArrayBlock((LongArrayBlock)columnChunk.getBlock(), outputType);
            }
        } else if (BigintType.BIGINT.equals((Object)outputType) && physicalDataType == PrimitiveType.PrimitiveTypeName.INT32 && columnChunk.getBlock() instanceof IntArrayBlock) {
            newBlock = ParquetReader.rewriteIntegerArrayBlock((IntArrayBlock)columnChunk.getBlock(), outputType);
        }
        if (newBlock != null) {
            return new ColumnChunk(newBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        }
        return columnChunk;
    }

    private static Block rewriteIntegerArrayBlock(IntArrayBlock intArrayBlock, Type targetType) {
        int positionCount = intArrayBlock.getPositionCount();
        BlockBuilder newBlockBuilder = targetType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            if (intArrayBlock.isNull(position)) {
                newBlockBuilder.appendNull();
                continue;
            }
            targetType.writeLong(newBlockBuilder, (long)intArrayBlock.getInt(position));
        }
        return newBlockBuilder.build();
    }

    private static Block rewriteLongArrayBlock(LongArrayBlock longArrayBlock, Type targetType) {
        int positionCount = longArrayBlock.getPositionCount();
        BlockBuilder newBlockBuilder = targetType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            if (longArrayBlock.isNull(position)) {
                newBlockBuilder.appendNull();
                continue;
            }
            targetType.writeLong(newBlockBuilder, longArrayBlock.getLong(position, 0));
        }
        return newBlockBuilder.build();
    }
}

