/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer.valuewriter;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.airlift.slice.Slice;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;

public class CharValueWriter
extends PrimitiveValueWriter {
    private final ValuesWriter valuesWriter;
    private final Type type;

    public CharValueWriter(ValuesWriter valuesWriter, Type type, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.valuesWriter = Objects.requireNonNull(valuesWriter, "valuesWriter is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @Override
    public void write(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            Slice slice = this.type.getSlice(block, i);
            Binary binary = Binary.fromConstantByteBuffer((ByteBuffer)slice.toByteBuffer());
            this.valuesWriter.writeBytes(binary);
            this.getStatistics().updateStats(binary);
        }
    }
}

