/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBaseSpecific;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.hadoop.conf.Configuration;

public class GoogleHadoopFileSystemConfigurationProperty<T> {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private final String key;
    private final List<String> deprecatedKeys;
    private final T defaultValue;

    public GoogleHadoopFileSystemConfigurationProperty(String key) {
        this(key, null, new String[0]);
    }

    public GoogleHadoopFileSystemConfigurationProperty(String key, T defaultValue, String ... deprecatedKeys) {
        this.key = key;
        this.deprecatedKeys = deprecatedKeys == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])deprecatedKeys);
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    T get(Configuration config, BiFunction<String, T, T> getterFn) {
        String lookupKey = GoogleHadoopFileSystemConfigurationProperty.getLookupKey(config, this.key, this.deprecatedKeys);
        return GoogleHadoopFileSystemConfigurationProperty.logProperty(lookupKey, getterFn.apply(lookupKey, (String)this.defaultValue));
    }

    String getPassword(Configuration config) {
        Preconditions.checkState((this.defaultValue == null || this.defaultValue instanceof String ? 1 : 0) != 0, (Object)"Not a string property");
        String lookupKey = GoogleHadoopFileSystemConfigurationProperty.getLookupKey(config, this.key, this.deprecatedKeys);
        String value = GoogleHadoopFileSystemBaseSpecific.getPassword(config, lookupKey);
        return GoogleHadoopFileSystemConfigurationProperty.logProperty(lookupKey, value == null ? (String)this.defaultValue : value);
    }

    Collection<String> getStringCollection(Configuration config) {
        Preconditions.checkState((this.defaultValue == null || this.defaultValue instanceof Collection ? 1 : 0) != 0, (Object)"Not a collection property");
        String lookupKey = GoogleHadoopFileSystemConfigurationProperty.getLookupKey(config, this.key, this.deprecatedKeys);
        String valueString = config.get(lookupKey, this.defaultValue == null ? null : COMMA_JOINER.join((Iterable)((Collection)this.defaultValue)));
        List value = COMMA_SPLITTER.splitToList((CharSequence)Strings.nullToEmpty((String)valueString));
        return GoogleHadoopFileSystemConfigurationProperty.logProperty(lookupKey, value);
    }

    private static String getLookupKey(Configuration config, String key, List<String> deprecatedKeys) {
        if (config.get(key) != null) {
            return key;
        }
        for (String deprecatedKey : deprecatedKeys) {
            if (config.get(deprecatedKey) == null) continue;
            ((GoogleLogger.Api)logger.atWarning()).log("Using deprecated key '%s', use '%s' key instead.", (Object)deprecatedKey, (Object)key);
            return deprecatedKey;
        }
        return key;
    }

    private static <S> S logProperty(String key, S value) {
        ((GoogleLogger.Api)logger.atFine()).log("%s = %s", (Object)key, value);
        return value;
    }
}

