/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.hive.ConcurrentLazyQueue;
import com.facebook.presto.hive.DelegatingPartitionLoader;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveSplitLoader;
import com.facebook.presto.hive.HiveSplitSource;
import com.facebook.presto.hive.InternalHiveSplit;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.PartitionLoader;
import com.facebook.presto.hive.StoragePartitionLoader;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.util.ResumableTask;
import com.facebook.presto.hive.util.ResumableTasks;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BackgroundHiveSplitLoader
implements HiveSplitLoader {
    private static final ListenableFuture<?> COMPLETED_FUTURE = Futures.immediateFuture(null);
    private final int loaderConcurrency;
    private final Executor executor;
    private final ConcurrentLazyQueue<HivePartitionMetadata> partitions;
    private final Deque<Iterator<InternalHiveSplit>> fileIterators = new ConcurrentLinkedDeque<Iterator<InternalHiveSplit>>();
    private final PartitionLoader delegatingPartitionLoader;
    private final ReentrantReadWriteLock taskExecutionLock = new ReentrantReadWriteLock();
    private HiveSplitSource hiveSplitSource;
    private volatile boolean stopped;

    public BackgroundHiveSplitLoader(Table table, Iterable<HivePartitionMetadata> partitions, Optional<Domain> pathDomain, Optional<StoragePartitionLoader.BucketSplitInfo> tableBucketInfo, ConnectorSession session, HdfsEnvironment hdfsEnvironment, NamenodeStats namenodeStats, DirectoryLister directoryLister, Executor executor, int loaderConcurrency, boolean recursiveDirWalkerEnabled, boolean schedulerUsesHostAddresses, boolean partialAggregationsPushedDown) {
        this.loaderConcurrency = loaderConcurrency;
        Preconditions.checkArgument((loaderConcurrency > 0 ? 1 : 0) != 0, (String)"loaderConcurrency must be > 0, found: %s", (int)loaderConcurrency);
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.partitions = new ConcurrentLazyQueue<HivePartitionMetadata>(Objects.requireNonNull(partitions, "partitions is null"));
        this.delegatingPartitionLoader = new DelegatingPartitionLoader(table, pathDomain, tableBucketInfo, session, hdfsEnvironment, namenodeStats, directoryLister, this.fileIterators, recursiveDirWalkerEnabled, schedulerUsesHostAddresses, partialAggregationsPushedDown);
    }

    @Override
    public void start(HiveSplitSource splitSource) {
        this.hiveSplitSource = splitSource;
        for (int i = 0; i < this.loaderConcurrency; ++i) {
            ResumableTasks.submit(this.executor, new HiveSplitLoaderTask());
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    private void invokeNoMoreSplitsIfNecessary() {
        this.taskExecutionLock.readLock().lock();
        try {
            if (!this.partitions.isEmpty() || !this.fileIterators.isEmpty()) {
                return;
            }
        }
        catch (Exception e) {
            this.hiveSplitSource.fail(e);
            Preconditions.checkState((boolean)this.stopped, (Object)"Task is not marked as stopped even though it failed");
            return;
        }
        finally {
            this.taskExecutionLock.readLock().unlock();
        }
        this.taskExecutionLock.writeLock().lock();
        try {
            if (this.partitions.isEmpty() && this.fileIterators.isEmpty()) {
                this.hiveSplitSource.noMoreSplits();
            }
        }
        catch (Exception e) {
            this.hiveSplitSource.fail(e);
            Preconditions.checkState((boolean)this.stopped, (Object)"Task is not marked as stopped even though it failed");
        }
        finally {
            this.taskExecutionLock.writeLock().unlock();
        }
    }

    private ListenableFuture<?> loadSplits() throws IOException {
        Iterator<InternalHiveSplit> splits = this.fileIterators.poll();
        if (splits == null) {
            HivePartitionMetadata partition = this.partitions.poll();
            if (partition == null) {
                return COMPLETED_FUTURE;
            }
            return this.delegatingPartitionLoader.loadPartition(partition, this.hiveSplitSource, this.stopped);
        }
        while (splits.hasNext() && !this.stopped) {
            ListenableFuture<?> future = this.hiveSplitSource.addToQueue(splits.next());
            if (future.isDone()) continue;
            this.fileIterators.addFirst(splits);
            return future;
        }
        return COMPLETED_FUTURE;
    }

    private class HiveSplitLoaderTask
    implements ResumableTask {
        private HiveSplitLoaderTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResumableTask.TaskStatus process() {
            ListenableFuture future;
            do {
                if (BackgroundHiveSplitLoader.this.stopped) {
                    return ResumableTask.TaskStatus.finished();
                }
                BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().lock();
                try {
                    future = BackgroundHiveSplitLoader.this.loadSplits();
                }
                catch (Exception e2) {
                    PrestoException e2;
                    if (e2 instanceof IOException) {
                        e2 = new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, (Throwable)e2);
                    } else if (!(e2 instanceof PrestoException)) {
                        e2 = new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, (Throwable)e2);
                    }
                    BackgroundHiveSplitLoader.this.hiveSplitSource.fail(e2);
                    Preconditions.checkState((boolean)BackgroundHiveSplitLoader.this.stopped);
                    ResumableTask.TaskStatus taskStatus = ResumableTask.TaskStatus.finished();
                    return taskStatus;
                }
                finally {
                    BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().unlock();
                }
                BackgroundHiveSplitLoader.this.invokeNoMoreSplitsIfNecessary();
            } while (future.isDone());
            return ResumableTask.TaskStatus.continueOn(future);
        }
    }
}

