/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.relation.Predicate;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.expressions.DynamicFilters;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.RowExpressionNodeInliner;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.orc.FilterFunction;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.TupleDomainFilterUtils;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import sun.misc.Unsafe;

public class FilteringPageSource
implements ConnectorPageSource {
    private final ConnectorPageSource delegate;
    private final TupleDomainFilter[] domainFilters;
    private final Type[] columnTypes;
    private final Map<Integer, Integer> functionInputs;
    private final FilterFunction filterFunction;
    private final int outputBlockCount;

    public FilteringPageSource(List<HivePageSourceProvider.ColumnMapping> columnMappings, TupleDomain<HiveColumnHandle> domainPredicate, RowExpression remainingPredicate, TypeManager typeManager, RowExpressionService rowExpressionService, ConnectorSession session, Set<Integer> originalIndices, ConnectorPageSource delegate) {
        Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        Objects.requireNonNull(remainingPredicate, "remainingPredicate is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.domainFilters = new TupleDomainFilter[columnMappings.size()];
        this.columnTypes = new Type[columnMappings.size()];
        if (!domainPredicate.isAll()) {
            Map domains = (Map)domainPredicate.transform(HiveColumnHandle::getHiveColumnIndex).getDomains().get();
            for (int i2 = 0; i2 < columnMappings.size(); ++i2) {
                HiveColumnHandle columnHandle2 = columnMappings.get(i2).getHiveColumnHandle();
                int hiveColumnIndex = columnHandle2.getHiveColumnIndex();
                if (!domains.containsKey(hiveColumnIndex)) continue;
                this.domainFilters[i2] = TupleDomainFilterUtils.toFilter((Domain)((Domain)domains.get(hiveColumnIndex)));
                this.columnTypes[i2] = columnHandle2.getHiveType().getType(typeManager);
            }
        }
        this.functionInputs = (Map)IntStream.range(0, columnMappings.size()).boxed().collect(ImmutableMap.toImmutableMap(i -> ((HivePageSourceProvider.ColumnMapping)columnMappings.get((int)i)).getHiveColumnHandle().getHiveColumnIndex(), Function.identity()));
        Map variableToInput = (Map)columnMappings.stream().map(HivePageSourceProvider.ColumnMapping::getHiveColumnHandle).collect(ImmutableMap.toImmutableMap(columnHandle -> new VariableReferenceExpression(columnHandle.getName(), columnHandle.getHiveType().getType(typeManager)), columnHandle -> new InputReferenceExpression(columnHandle.getHiveColumnIndex(), columnHandle.getHiveType().getType(typeManager))));
        RowExpression optimizedRemainingPredicate = rowExpressionService.getExpressionOptimizer().optimize(remainingPredicate, ExpressionOptimizer.Level.OPTIMIZED, session);
        if (LogicalRowExpressions.TRUE_CONSTANT.equals((Object)optimizedRemainingPredicate)) {
            this.filterFunction = null;
        } else {
            RowExpression expression = RowExpressionNodeInliner.replaceExpression((RowExpression)optimizedRemainingPredicate, (Map)variableToInput);
            DynamicFilters.DynamicFilterExtractResult extractDynamicFilterResult = DynamicFilters.extractDynamicFilters((RowExpression)expression);
            expression = LogicalRowExpressions.and((Collection)extractDynamicFilterResult.getStaticConjuncts());
            this.filterFunction = new FilterFunction(session.getSqlFunctionProperties(), rowExpressionService.getDeterminismEvaluator().isDeterministic(expression), (Predicate)rowExpressionService.getPredicateCompiler().compilePredicate(session.getSqlFunctionProperties(), session.getSessionFunctions(), expression).get());
        }
        this.outputBlockCount = Objects.requireNonNull(originalIndices, "originalIndices is null").size();
    }

    public Page getNextPage() {
        int i;
        Page page = this.delegate.getNextPage();
        if (page == null || page.getPositionCount() == 0) {
            return page;
        }
        int positionCount = page.getPositionCount();
        int[] positions = new int[positionCount];
        for (i = 0; i < positionCount; ++i) {
            positions[i] = i;
        }
        for (i = 0; i < page.getChannelCount(); ++i) {
            TupleDomainFilter domainFilter = this.domainFilters[i];
            if (domainFilter == null || (positionCount = FilteringPageSource.filterBlock(page.getBlock(i), this.columnTypes[i], domainFilter, positions, positionCount)) != 0) continue;
            return new Page(0);
        }
        if (this.filterFunction != null) {
            RuntimeException[] errors = new RuntimeException[positionCount];
            int[] inputChannels = this.filterFunction.getInputChannels();
            Block[] inputBlocks = new Block[inputChannels.length];
            for (int i2 = 0; i2 < inputChannels.length; ++i2) {
                inputBlocks[i2] = page.getBlock(this.functionInputs.get(inputChannels[i2]).intValue());
            }
            Page inputPage = new Page(page.getPositionCount(), inputBlocks);
            positionCount = this.filterFunction.filter(inputPage, positions, positionCount, errors);
            for (int i3 = 0; i3 < positionCount; ++i3) {
                if (errors[i3] == null) continue;
                throw errors[i3];
            }
            if (positionCount == 0) {
                return new Page(0);
            }
        }
        if (this.outputBlockCount == page.getChannelCount()) {
            return page.getPositions(positions, 0, positionCount);
        }
        Block[] blocks = new Block[this.outputBlockCount];
        for (int i4 = 0; i4 < this.outputBlockCount; ++i4) {
            blocks[i4] = page.getBlock(i4);
        }
        return new Page(page.getPositionCount(), blocks).getPositions(positions, 0, positionCount);
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    private static int filterBlock(Block block, Type type, TupleDomainFilter filter, int[] positions, int positionCount) {
        int outputPositionsCount = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (block.isNull(position)) {
                if (!filter.testNull()) continue;
                positions[outputPositionsCount] = position;
                ++outputPositionsCount;
                continue;
            }
            if (!FilteringPageSource.testNonNullPosition(block, position, type, filter)) continue;
            positions[outputPositionsCount] = position;
            ++outputPositionsCount;
        }
        return outputPositionsCount;
    }

    private static boolean testNonNullPosition(Block block, int position, Type type, TupleDomainFilter filter) {
        if (type == BigintType.BIGINT || type == IntegerType.INTEGER || type == SmallintType.SMALLINT || type == TinyintType.TINYINT || type == TimestampType.TIMESTAMP || type == DateType.DATE) {
            return filter.testLong(type.getLong(block, position));
        }
        if (type == BooleanType.BOOLEAN) {
            return filter.testBoolean(type.getBoolean(block, position));
        }
        if (type == DoubleType.DOUBLE) {
            return filter.testDouble(Double.longBitsToDouble(block.getLong(position)));
        }
        if (type == RealType.REAL) {
            return filter.testFloat(Float.intBitsToFloat(block.getInt(position)));
        }
        if (type instanceof DecimalType) {
            if (((DecimalType)type).isShort()) {
                return filter.testLong(block.getLong(position));
            }
            return filter.testDecimal(block.getLong(position, 0), block.getLong(position, 8));
        }
        if (Varchars.isVarcharType((Type)type) || Chars.isCharType((Type)type)) {
            Slice slice = block.getSlice(position, 0, block.getSliceLength(position));
            return filter.testBytes((byte[])slice.getBase(), (int)slice.getAddress() - Unsafe.ARRAY_BYTE_BASE_OFFSET, slice.length());
        }
        if (type instanceof ArrayType || type instanceof MapType || type instanceof RowType) {
            if (TupleDomainFilter.IS_NULL == filter) {
                return block.isNull(position);
            }
            if (TupleDomainFilter.IS_NOT_NULL == filter) {
                return !block.isNull(position);
            }
        }
        throw new UnsupportedOperationException("Unexpected column type " + type);
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getCompletedPositions() {
        return this.delegate.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }
}

