/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HiveDirectoryContext;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.util.HiveFileIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;

public class HadoopDirectoryLister
implements DirectoryLister {
    @Override
    public Iterator<HiveFileInfo> list(ExtendedFileSystem fileSystem, Table table, Path path, NamenodeStats namenodeStats, PathFilter pathFilter, HiveDirectoryContext hiveDirectoryContext) {
        return new HiveFileIterator(path, p -> new HadoopFileInfoIterator((RemoteIterator<LocatedFileStatus>)fileSystem.listLocatedStatus(p)), namenodeStats, hiveDirectoryContext.getNestedDirectoryPolicy(), pathFilter);
    }

    public static class HadoopFileInfoIterator
    implements RemoteIterator<HiveFileInfo> {
        private final RemoteIterator<LocatedFileStatus> locatedFileStatusIterator;

        public HadoopFileInfoIterator(RemoteIterator<LocatedFileStatus> locatedFileStatusIterator) {
            this.locatedFileStatusIterator = Objects.requireNonNull(locatedFileStatusIterator, "locatedFileStatusIterator is null");
        }

        public boolean hasNext() throws IOException {
            return this.locatedFileStatusIterator.hasNext();
        }

        public HiveFileInfo next() throws IOException {
            return HiveFileInfo.createHiveFileInfo((LocatedFileStatus)((LocatedFileStatus)this.locatedFileStatusIterator.next()), Optional.empty());
        }
    }
}

