/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.DefunctConfig;
import com.facebook.airlift.configuration.LegacyConfig;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.s3.S3FileSystemType;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTimeZone;

@DefunctConfig(value={"hive.file-system-cache-ttl", "hive.max-global-split-iterator-threads", "hive.max-sort-files-per-bucket", "hive.bucket-writing", "hive.optimized-reader.enabled"})
public class HiveClientConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private String timeZone = TimeZone.getDefault().getID();
    private DataSize maxSplitSize = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private int maxPartitionsPerScan = 100000;
    private int maxOutstandingSplits = 1000;
    private DataSize maxOutstandingSplitsSize = new DataSize(256.0, DataSize.Unit.MEGABYTE);
    private int maxSplitIteratorThreads = 1000;
    private int minPartitionBatchSize = 10;
    private int maxPartitionBatchSize = 100;
    private int maxInitialSplits = 200;
    private int splitLoaderConcurrency = 4;
    private DataSize maxInitialSplitSize;
    private int domainCompactionThreshold = 100;
    private DataSize writerSortBufferSize = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private NodeSelectionStrategy nodeSelectionStrategy = NodeSelectionStrategy.NO_PREFERENCE;
    private boolean recursiveDirWalkerEnabled;
    private int maxConcurrentFileRenames = 20;
    private int maxConcurrentZeroRowFileCreations = 20;
    private boolean allowCorruptWritesForTesting;
    private Duration ipcPingInterval = new Duration(10.0, TimeUnit.SECONDS);
    private Duration dfsTimeout = new Duration(60.0, TimeUnit.SECONDS);
    private Duration dfsConnectTimeout = new Duration(500.0, TimeUnit.MILLISECONDS);
    private int dfsConnectMaxRetries = 5;
    private String domainSocketPath;
    private S3FileSystemType s3FileSystemType = S3FileSystemType.PRESTO;
    private HiveStorageFormat hiveStorageFormat = HiveStorageFormat.ORC;
    private HiveCompressionCodec compressionCodec = HiveCompressionCodec.GZIP;
    private HiveCompressionCodec orcCompressionCodec = HiveCompressionCodec.GZIP;
    private boolean respectTableFormat = true;
    private boolean immutablePartitions;
    private boolean insertOverwriteImmutablePartitions;
    private boolean failFastOnInsertIntoImmutablePartitionsEnabled = true;
    private int maxPartitionsPerWriter = 100;
    private int maxOpenSortFiles = 50;
    private int writeValidationThreads = 16;
    private List<String> resourceConfigFiles = ImmutableList.of();
    private DataSize textMaxLineLength = new DataSize(100.0, DataSize.Unit.MEGABYTE);
    private boolean useParquetColumnNames;
    private boolean failOnCorruptedParquetStatistics = true;
    private DataSize parquetMaxReadBlockSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private boolean assumeCanonicalPartitionKeys;
    private boolean useOrcColumnNames;
    private boolean orcBloomFiltersEnabled;
    private double orcDefaultBloomFilterFpp = 0.05;
    private DataSize orcMaxMergeDistance = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private DataSize orcMaxBufferSize = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private DataSize orcTinyStripeThreshold = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private DataSize orcStreamBufferSize = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private DataSize orcMaxReadBlockSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private boolean orcLazyReadSmallRanges = true;
    private boolean orcOptimizedWriterEnabled = true;
    private double orcWriterValidationPercentage;
    private OrcWriteValidation.OrcWriteValidationMode orcWriterValidationMode = OrcWriteValidation.OrcWriteValidationMode.BOTH;
    private boolean rcfileOptimizedWriterEnabled = true;
    private boolean rcfileWriterValidate;
    private HiveMetastoreAuthenticationType hiveMetastoreAuthenticationType = HiveMetastoreAuthenticationType.NONE;
    private HdfsAuthenticationType hdfsAuthenticationType = HdfsAuthenticationType.NONE;
    private boolean hdfsImpersonationEnabled;
    private boolean hdfsWireEncryptionEnabled;
    private boolean skipDeletionForAlter;
    private boolean skipTargetCleanupOnRollback;
    private boolean bucketExecutionEnabled = true;
    private boolean sortedWritingEnabled = true;
    private BucketFunctionType bucketFunctionTypeForExchange = BucketFunctionType.HIVE_COMPATIBLE;
    private boolean ignoreTableBucketing;
    private boolean ignoreUnreadablePartition;
    private int minBucketCountToNotIgnoreTableBucketing;
    private int maxBucketsForGroupedExecution = 1000000;
    private boolean sortedWriteToTempPathEnabled;
    private int sortedWriteTempPathSubdirectoryCount = 10;
    private int fileSystemMaxCacheSize = 1000;
    private boolean optimizeMismatchedBucketCount;
    private boolean writesToNonManagedTablesEnabled;
    private boolean createsOfNonManagedTablesEnabled = true;
    private boolean tableStatisticsEnabled = true;
    private int partitionStatisticsSampleSize = 100;
    private boolean ignoreCorruptedStatistics;
    private boolean collectColumnStatisticsOnWrite;
    private boolean partitionStatisticsBasedOptimizationEnabled;
    private boolean s3SelectPushdownEnabled;
    private int s3SelectPushdownMaxConnections = 500;
    private boolean isTemporaryStagingDirectoryEnabled = true;
    private String temporaryStagingDirectoryPath = "/tmp/presto-${USER}";
    private String temporaryTableSchema = "default";
    private HiveStorageFormat temporaryTableStorageFormat = HiveStorageFormat.ORC;
    private HiveCompressionCodec temporaryTableCompressionCodec = HiveCompressionCodec.SNAPPY;
    private boolean shouldCreateEmptyBucketFilesForTemporaryTable;
    private boolean usePageFileForHiveUnsupportedType = true;
    private boolean pushdownFilterEnabled;
    private boolean rangeFiltersOnSubscriptsEnabled;
    private boolean adaptiveFilterReorderingEnabled = true;
    private boolean zstdJniDecompressionEnabled;
    private Duration fileStatusCacheExpireAfterWrite = new Duration(0.0, TimeUnit.SECONDS);
    private long fileStatusCacheMaxSize;
    private List<String> fileStatusCacheTables = ImmutableList.of();
    private DataSize pageFileStripeMaxSize = new DataSize(24.0, DataSize.Unit.MEGABYTE);
    private boolean parquetBatchReadOptimizationEnabled;
    private boolean parquetEnableBatchReaderVerification;
    private boolean parquetDereferencePushdownEnabled;
    private int maxMetadataUpdaterThreads = 100;
    private boolean isPartialAggregationPushdownEnabled;
    private boolean isPartialAggregationPushdownForVariableLengthDatatypesEnabled;
    private boolean fileRenamingEnabled;
    private boolean preferManifestToListFiles;
    private boolean manifestVerificationEnabled;
    private boolean undoMetastoreOperationsEnabled = true;
    private boolean optimizedPartitionUpdateSerializationEnabled;

    public int getMaxInitialSplits() {
        return this.maxInitialSplits;
    }

    @Config(value="hive.max-initial-splits")
    public HiveClientConfig setMaxInitialSplits(int maxInitialSplits) {
        this.maxInitialSplits = maxInitialSplits;
        return this;
    }

    public DataSize getMaxInitialSplitSize() {
        if (this.maxInitialSplitSize == null) {
            return new DataSize(this.maxSplitSize.getValue() / 2.0, this.maxSplitSize.getUnit());
        }
        return this.maxInitialSplitSize;
    }

    @Config(value="hive.max-initial-split-size")
    public HiveClientConfig setMaxInitialSplitSize(DataSize maxInitialSplitSize) {
        this.maxInitialSplitSize = maxInitialSplitSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSplitLoaderConcurrency() {
        return this.splitLoaderConcurrency;
    }

    @Config(value="hive.split-loader-concurrency")
    public HiveClientConfig setSplitLoaderConcurrency(int splitLoaderConcurrency) {
        this.splitLoaderConcurrency = splitLoaderConcurrency;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getDomainCompactionThreshold() {
        return this.domainCompactionThreshold;
    }

    @Config(value="hive.domain-compaction-threshold")
    @ConfigDescription(value="Maximum ranges to allow in a tuple domain without compacting it")
    public HiveClientConfig setDomainCompactionThreshold(int domainCompactionThreshold) {
        this.domainCompactionThreshold = domainCompactionThreshold;
        return this;
    }

    @MinDataSize(value="1MB")
    @MaxDataSize(value="1GB")
    public DataSize getWriterSortBufferSize() {
        return this.writerSortBufferSize;
    }

    @Config(value="hive.writer-sort-buffer-size")
    public HiveClientConfig setWriterSortBufferSize(DataSize writerSortBufferSize) {
        this.writerSortBufferSize = writerSortBufferSize;
        return this;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return this.nodeSelectionStrategy;
    }

    @Config(value="hive.node-selection-strategy")
    public HiveClientConfig setNodeSelectionStrategy(NodeSelectionStrategy nodeSelectionStrategy) {
        this.nodeSelectionStrategy = nodeSelectionStrategy;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxConcurrentFileRenames() {
        return this.maxConcurrentFileRenames;
    }

    @Config(value="hive.max-concurrent-file-renames")
    public HiveClientConfig setMaxConcurrentFileRenames(int maxConcurrentFileRenames) {
        this.maxConcurrentFileRenames = maxConcurrentFileRenames;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxConcurrentZeroRowFileCreations() {
        return this.maxConcurrentZeroRowFileCreations;
    }

    @Config(value="hive.max-concurrent-zero-row-file-creations")
    public HiveClientConfig setMaxConcurrentZeroRowFileCreations(int maxConcurrentZeroRowFileCreations) {
        this.maxConcurrentZeroRowFileCreations = maxConcurrentZeroRowFileCreations;
        return this;
    }

    public boolean getRecursiveDirWalkerEnabled() {
        return this.recursiveDirWalkerEnabled;
    }

    @Config(value="hive.recursive-directories")
    public HiveClientConfig setRecursiveDirWalkerEnabled(boolean recursiveDirWalkerEnabled) {
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        return this;
    }

    public DateTimeZone getDateTimeZone() {
        return DateTimeZone.forID((String)this.timeZone);
    }

    @NotNull
    public String getTimeZone() {
        return this.timeZone;
    }

    @Config(value="hive.time-zone")
    public HiveClientConfig setTimeZone(String id) {
        this.timeZone = id != null ? id : TimeZone.getDefault().getID();
        return this;
    }

    @NotNull
    public DataSize getMaxSplitSize() {
        return this.maxSplitSize;
    }

    @Config(value="hive.max-split-size")
    public HiveClientConfig setMaxSplitSize(DataSize maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionsPerScan() {
        return this.maxPartitionsPerScan;
    }

    @Config(value="hive.max-partitions-per-scan")
    @ConfigDescription(value="Maximum allowed partitions for a single table scan")
    public HiveClientConfig setMaxPartitionsPerScan(int maxPartitionsPerScan) {
        this.maxPartitionsPerScan = maxPartitionsPerScan;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxOutstandingSplits() {
        return this.maxOutstandingSplits;
    }

    @Config(value="hive.max-outstanding-splits")
    @ConfigDescription(value="Target number of buffered splits for each table scan in a query, before the scheduler tries to pause itself")
    public HiveClientConfig setMaxOutstandingSplits(int maxOutstandingSplits) {
        this.maxOutstandingSplits = maxOutstandingSplits;
        return this;
    }

    @MinDataSize(value="1MB")
    public DataSize getMaxOutstandingSplitsSize() {
        return this.maxOutstandingSplitsSize;
    }

    @Config(value="hive.max-outstanding-splits-size")
    @ConfigDescription(value="Maximum amount of memory allowed for split buffering for each table scan in a query, before the query is failed")
    public HiveClientConfig setMaxOutstandingSplitsSize(DataSize maxOutstandingSplits) {
        this.maxOutstandingSplitsSize = maxOutstandingSplits;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxSplitIteratorThreads() {
        return this.maxSplitIteratorThreads;
    }

    @Config(value="hive.max-split-iterator-threads")
    public HiveClientConfig setMaxSplitIteratorThreads(int maxSplitIteratorThreads) {
        this.maxSplitIteratorThreads = maxSplitIteratorThreads;
        return this;
    }

    @Deprecated
    public boolean getAllowCorruptWritesForTesting() {
        return this.allowCorruptWritesForTesting;
    }

    @Deprecated
    @Config(value="hive.allow-corrupt-writes-for-testing")
    @ConfigDescription(value="Allow Hive connector to write data even when data will likely be corrupt")
    public HiveClientConfig setAllowCorruptWritesForTesting(boolean allowCorruptWritesForTesting) {
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinPartitionBatchSize() {
        return this.minPartitionBatchSize;
    }

    @Config(value="hive.metastore.partition-batch-size.min")
    public HiveClientConfig setMinPartitionBatchSize(int minPartitionBatchSize) {
        this.minPartitionBatchSize = minPartitionBatchSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionBatchSize() {
        return this.maxPartitionBatchSize;
    }

    @Config(value="hive.metastore.partition-batch-size.max")
    public HiveClientConfig setMaxPartitionBatchSize(int maxPartitionBatchSize) {
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        return this;
    }

    @NotNull
    public List<String> getResourceConfigFiles() {
        return this.resourceConfigFiles;
    }

    @Config(value="hive.config.resources")
    public HiveClientConfig setResourceConfigFiles(String files) {
        this.resourceConfigFiles = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)files);
        return this;
    }

    public HiveClientConfig setResourceConfigFiles(List<String> files) {
        this.resourceConfigFiles = ImmutableList.copyOf(files);
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getIpcPingInterval() {
        return this.ipcPingInterval;
    }

    @Config(value="hive.dfs.ipc-ping-interval")
    public HiveClientConfig setIpcPingInterval(Duration pingInterval) {
        this.ipcPingInterval = pingInterval;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getDfsTimeout() {
        return this.dfsTimeout;
    }

    @Config(value="hive.dfs-timeout")
    public HiveClientConfig setDfsTimeout(Duration dfsTimeout) {
        this.dfsTimeout = dfsTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getDfsConnectTimeout() {
        return this.dfsConnectTimeout;
    }

    @Config(value="hive.dfs.connect.timeout")
    public HiveClientConfig setDfsConnectTimeout(Duration dfsConnectTimeout) {
        this.dfsConnectTimeout = dfsConnectTimeout;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getDfsConnectMaxRetries() {
        return this.dfsConnectMaxRetries;
    }

    @Config(value="hive.dfs.connect.max-retries")
    public HiveClientConfig setDfsConnectMaxRetries(int dfsConnectMaxRetries) {
        this.dfsConnectMaxRetries = dfsConnectMaxRetries;
        return this;
    }

    public HiveStorageFormat getHiveStorageFormat() {
        return this.hiveStorageFormat;
    }

    @Config(value="hive.storage-format")
    public HiveClientConfig setHiveStorageFormat(HiveStorageFormat hiveStorageFormat) {
        this.hiveStorageFormat = hiveStorageFormat;
        return this;
    }

    public HiveCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    @Config(value="hive.compression-codec")
    public HiveClientConfig setCompressionCodec(HiveCompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    public HiveCompressionCodec getOrcCompressionCodec() {
        return this.orcCompressionCodec;
    }

    @Config(value="hive.orc-compression-codec")
    public HiveClientConfig setOrcCompressionCodec(HiveCompressionCodec orcCompressionCodec) {
        this.orcCompressionCodec = orcCompressionCodec;
        return this;
    }

    public boolean isRespectTableFormat() {
        return this.respectTableFormat;
    }

    @Config(value="hive.respect-table-format")
    @ConfigDescription(value="Should new partitions be written using the existing table format or the default Presto format")
    public HiveClientConfig setRespectTableFormat(boolean respectTableFormat) {
        this.respectTableFormat = respectTableFormat;
        return this;
    }

    public boolean isInsertOverwriteImmutablePartitionEnabled() {
        return this.insertOverwriteImmutablePartitions;
    }

    @Config(value="hive.insert-overwrite-immutable-partitions-enabled")
    @ConfigDescription(value="When enabled, insertion query will overwrite existing partitions when partitions are immutable. This config only takes effect with hive.immutable-partitions set to true")
    public HiveClientConfig setInsertOverwriteImmutablePartitionEnabled(boolean insertOverwriteImmutablePartitions) {
        this.insertOverwriteImmutablePartitions = insertOverwriteImmutablePartitions;
        return this;
    }

    public boolean isImmutablePartitions() {
        return this.immutablePartitions;
    }

    @Config(value="hive.immutable-partitions")
    @ConfigDescription(value="Can new data be inserted into existing partitions or existing unpartitioned tables")
    public HiveClientConfig setImmutablePartitions(boolean immutablePartitions) {
        this.immutablePartitions = immutablePartitions;
        return this;
    }

    public boolean isFailFastOnInsertIntoImmutablePartitionsEnabled() {
        return this.failFastOnInsertIntoImmutablePartitionsEnabled;
    }

    @Config(value="hive.fail-fast-on-insert-into-immutable-partitions-enabled")
    @ConfigDescription(value="Fail fast when inserting into an immutable partition. Increases load on the metastore")
    public HiveClientConfig setFailFastOnInsertIntoImmutablePartitionsEnabled(boolean failFastOnInsertIntoImmutablePartitionsEnabled) {
        this.failFastOnInsertIntoImmutablePartitionsEnabled = failFastOnInsertIntoImmutablePartitionsEnabled;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionsPerWriter() {
        return this.maxPartitionsPerWriter;
    }

    @Config(value="hive.max-partitions-per-writers")
    @ConfigDescription(value="Maximum number of partitions per writer")
    public HiveClientConfig setMaxPartitionsPerWriter(int maxPartitionsPerWriter) {
        this.maxPartitionsPerWriter = maxPartitionsPerWriter;
        return this;
    }

    @Min(value=2L)
    @Max(value=1000L)
    public @Min(value=2L) @Max(value=1000L) int getMaxOpenSortFiles() {
        return this.maxOpenSortFiles;
    }

    @Config(value="hive.max-open-sort-files")
    @ConfigDescription(value="Maximum number of writer temporary files to read in one pass")
    public HiveClientConfig setMaxOpenSortFiles(int maxOpenSortFiles) {
        this.maxOpenSortFiles = maxOpenSortFiles;
        return this;
    }

    public int getWriteValidationThreads() {
        return this.writeValidationThreads;
    }

    @Config(value="hive.write-validation-threads")
    @ConfigDescription(value="Number of threads used for verifying data after a write")
    public HiveClientConfig setWriteValidationThreads(int writeValidationThreads) {
        this.writeValidationThreads = writeValidationThreads;
        return this;
    }

    public String getDomainSocketPath() {
        return this.domainSocketPath;
    }

    @Config(value="hive.dfs.domain-socket-path")
    @LegacyConfig(value={"dfs.domain-socket-path"})
    public HiveClientConfig setDomainSocketPath(String domainSocketPath) {
        this.domainSocketPath = domainSocketPath;
        return this;
    }

    @NotNull
    public S3FileSystemType getS3FileSystemType() {
        return this.s3FileSystemType;
    }

    @Config(value="hive.s3-file-system-type")
    public HiveClientConfig setS3FileSystemType(S3FileSystemType s3FileSystemType) {
        this.s3FileSystemType = s3FileSystemType;
        return this;
    }

    public boolean isUseOrcColumnNames() {
        return this.useOrcColumnNames;
    }

    @Config(value="hive.orc.use-column-names")
    @ConfigDescription(value="Access ORC columns using names from the file")
    public HiveClientConfig setUseOrcColumnNames(boolean useOrcColumnNames) {
        this.useOrcColumnNames = useOrcColumnNames;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxMergeDistance() {
        return this.orcMaxMergeDistance;
    }

    @Config(value="hive.orc.max-merge-distance")
    public HiveClientConfig setOrcMaxMergeDistance(DataSize orcMaxMergeDistance) {
        this.orcMaxMergeDistance = orcMaxMergeDistance;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxBufferSize() {
        return this.orcMaxBufferSize;
    }

    @Config(value="hive.orc.max-buffer-size")
    public HiveClientConfig setOrcMaxBufferSize(DataSize orcMaxBufferSize) {
        this.orcMaxBufferSize = orcMaxBufferSize;
        return this;
    }

    @NotNull
    public DataSize getOrcStreamBufferSize() {
        return this.orcStreamBufferSize;
    }

    @Config(value="hive.orc.stream-buffer-size")
    public HiveClientConfig setOrcStreamBufferSize(DataSize orcStreamBufferSize) {
        this.orcStreamBufferSize = orcStreamBufferSize;
        return this;
    }

    @NotNull
    public DataSize getOrcTinyStripeThreshold() {
        return this.orcTinyStripeThreshold;
    }

    @Config(value="hive.orc.tiny-stripe-threshold")
    public HiveClientConfig setOrcTinyStripeThreshold(DataSize orcTinyStripeThreshold) {
        this.orcTinyStripeThreshold = orcTinyStripeThreshold;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxReadBlockSize() {
        return this.orcMaxReadBlockSize;
    }

    @Config(value="hive.orc.max-read-block-size")
    public HiveClientConfig setOrcMaxReadBlockSize(DataSize orcMaxReadBlockSize) {
        this.orcMaxReadBlockSize = orcMaxReadBlockSize;
        return this;
    }

    @Deprecated
    public boolean isOrcLazyReadSmallRanges() {
        return this.orcLazyReadSmallRanges;
    }

    @Deprecated
    @Config(value="hive.orc.lazy-read-small-ranges")
    @ConfigDescription(value="ORC read small disk ranges lazily")
    public HiveClientConfig setOrcLazyReadSmallRanges(boolean orcLazyReadSmallRanges) {
        this.orcLazyReadSmallRanges = orcLazyReadSmallRanges;
        return this;
    }

    public boolean isOrcBloomFiltersEnabled() {
        return this.orcBloomFiltersEnabled;
    }

    @Config(value="hive.orc.bloom-filters.enabled")
    public HiveClientConfig setOrcBloomFiltersEnabled(boolean orcBloomFiltersEnabled) {
        this.orcBloomFiltersEnabled = orcBloomFiltersEnabled;
        return this;
    }

    public double getOrcDefaultBloomFilterFpp() {
        return this.orcDefaultBloomFilterFpp;
    }

    @Config(value="hive.orc.default-bloom-filter-fpp")
    @ConfigDescription(value="ORC Bloom filter false positive probability")
    public HiveClientConfig setOrcDefaultBloomFilterFpp(double orcDefaultBloomFilterFpp) {
        this.orcDefaultBloomFilterFpp = orcDefaultBloomFilterFpp;
        return this;
    }

    @Deprecated
    public boolean isOrcOptimizedWriterEnabled() {
        return this.orcOptimizedWriterEnabled;
    }

    @Deprecated
    @Config(value="hive.orc.optimized-writer.enabled")
    public HiveClientConfig setOrcOptimizedWriterEnabled(boolean orcOptimizedWriterEnabled) {
        this.orcOptimizedWriterEnabled = orcOptimizedWriterEnabled;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="100.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="100.0") double getOrcWriterValidationPercentage() {
        return this.orcWriterValidationPercentage;
    }

    @Config(value="hive.orc.writer.validation-percentage")
    @ConfigDescription(value="Percentage of ORC files to validate after write by re-reading the whole file")
    public HiveClientConfig setOrcWriterValidationPercentage(double orcWriterValidationPercentage) {
        this.orcWriterValidationPercentage = orcWriterValidationPercentage;
        return this;
    }

    @NotNull
    public OrcWriteValidation.OrcWriteValidationMode getOrcWriterValidationMode() {
        return this.orcWriterValidationMode;
    }

    @Config(value="hive.orc.writer.validation-mode")
    @ConfigDescription(value="Level of detail in ORC validation. Lower levels require more memory.")
    public HiveClientConfig setOrcWriterValidationMode(OrcWriteValidation.OrcWriteValidationMode orcWriterValidationMode) {
        this.orcWriterValidationMode = orcWriterValidationMode;
        return this;
    }

    @Deprecated
    public boolean isRcfileOptimizedWriterEnabled() {
        return this.rcfileOptimizedWriterEnabled;
    }

    @Deprecated
    @Config(value="hive.rcfile-optimized-writer.enabled")
    public HiveClientConfig setRcfileOptimizedWriterEnabled(boolean rcfileOptimizedWriterEnabled) {
        this.rcfileOptimizedWriterEnabled = rcfileOptimizedWriterEnabled;
        return this;
    }

    public boolean isRcfileWriterValidate() {
        return this.rcfileWriterValidate;
    }

    @Config(value="hive.rcfile.writer.validate")
    @ConfigDescription(value="Validate RCFile after write by re-reading the whole file")
    public HiveClientConfig setRcfileWriterValidate(boolean rcfileWriterValidate) {
        this.rcfileWriterValidate = rcfileWriterValidate;
        return this;
    }

    public boolean isAssumeCanonicalPartitionKeys() {
        return this.assumeCanonicalPartitionKeys;
    }

    @Config(value="hive.assume-canonical-partition-keys")
    public HiveClientConfig setAssumeCanonicalPartitionKeys(boolean assumeCanonicalPartitionKeys) {
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        return this;
    }

    @MinDataSize(value="1B")
    @MaxDataSize(value="1GB")
    @NotNull
    public DataSize getTextMaxLineLength() {
        return this.textMaxLineLength;
    }

    @Config(value="hive.text.max-line-length")
    @ConfigDescription(value="Maximum line length for text files")
    public HiveClientConfig setTextMaxLineLength(DataSize textMaxLineLength) {
        this.textMaxLineLength = textMaxLineLength;
        return this;
    }

    public boolean isUseParquetColumnNames() {
        return this.useParquetColumnNames;
    }

    @Config(value="hive.parquet.use-column-names")
    @ConfigDescription(value="Access Parquet columns using names from the file")
    public HiveClientConfig setUseParquetColumnNames(boolean useParquetColumnNames) {
        this.useParquetColumnNames = useParquetColumnNames;
        return this;
    }

    public boolean isFailOnCorruptedParquetStatistics() {
        return this.failOnCorruptedParquetStatistics;
    }

    @Config(value="hive.parquet.fail-on-corrupted-statistics")
    @ConfigDescription(value="Fail when scanning Parquet files with corrupted statistics")
    public HiveClientConfig setFailOnCorruptedParquetStatistics(boolean failOnCorruptedParquetStatistics) {
        this.failOnCorruptedParquetStatistics = failOnCorruptedParquetStatistics;
        return this;
    }

    @NotNull
    public DataSize getParquetMaxReadBlockSize() {
        return this.parquetMaxReadBlockSize;
    }

    @Config(value="hive.parquet.max-read-block-size")
    public HiveClientConfig setParquetMaxReadBlockSize(DataSize parquetMaxReadBlockSize) {
        this.parquetMaxReadBlockSize = parquetMaxReadBlockSize;
        return this;
    }

    @Deprecated
    public boolean isOptimizeMismatchedBucketCount() {
        return this.optimizeMismatchedBucketCount;
    }

    @Deprecated
    @Config(value="hive.optimize-mismatched-bucket-count")
    public HiveClientConfig setOptimizeMismatchedBucketCount(boolean optimizeMismatchedBucketCount) {
        this.optimizeMismatchedBucketCount = optimizeMismatchedBucketCount;
        return this;
    }

    public boolean isZstdJniDecompressionEnabled() {
        return this.zstdJniDecompressionEnabled;
    }

    @Config(value="hive.zstd-jni-decompression-enabled")
    public HiveClientConfig setZstdJniDecompressionEnabled(boolean zstdJniDecompressionEnabled) {
        this.zstdJniDecompressionEnabled = zstdJniDecompressionEnabled;
        return this;
    }

    public List<String> getFileStatusCacheTables() {
        return this.fileStatusCacheTables;
    }

    @Config(value="hive.file-status-cache-tables")
    @ConfigDescription(value="The tables that have file status cache enabled. Setting to '*' includes all tables.")
    public HiveClientConfig setFileStatusCacheTables(String fileStatusCacheTables) {
        this.fileStatusCacheTables = SPLITTER.splitToList((CharSequence)fileStatusCacheTables);
        return this;
    }

    public long getFileStatusCacheMaxSize() {
        return this.fileStatusCacheMaxSize;
    }

    @Config(value="hive.file-status-cache-size")
    public HiveClientConfig setFileStatusCacheMaxSize(long fileStatusCacheMaxSize) {
        this.fileStatusCacheMaxSize = fileStatusCacheMaxSize;
        return this;
    }

    public Duration getFileStatusCacheExpireAfterWrite() {
        return this.fileStatusCacheExpireAfterWrite;
    }

    @Config(value="hive.file-status-cache-expire-time")
    public HiveClientConfig setFileStatusCacheExpireAfterWrite(Duration fileStatusCacheExpireAfterWrite) {
        this.fileStatusCacheExpireAfterWrite = fileStatusCacheExpireAfterWrite;
        return this;
    }

    @NotNull
    public HiveMetastoreAuthenticationType getHiveMetastoreAuthenticationType() {
        return this.hiveMetastoreAuthenticationType;
    }

    @Config(value="hive.metastore.authentication.type")
    @ConfigDescription(value="Hive Metastore authentication type")
    public HiveClientConfig setHiveMetastoreAuthenticationType(HiveMetastoreAuthenticationType hiveMetastoreAuthenticationType) {
        this.hiveMetastoreAuthenticationType = hiveMetastoreAuthenticationType;
        return this;
    }

    @NotNull
    public HdfsAuthenticationType getHdfsAuthenticationType() {
        return this.hdfsAuthenticationType;
    }

    @Config(value="hive.hdfs.authentication.type")
    @ConfigDescription(value="HDFS authentication type")
    public HiveClientConfig setHdfsAuthenticationType(HdfsAuthenticationType hdfsAuthenticationType) {
        this.hdfsAuthenticationType = hdfsAuthenticationType;
        return this;
    }

    public boolean isHdfsImpersonationEnabled() {
        return this.hdfsImpersonationEnabled;
    }

    @Config(value="hive.hdfs.impersonation.enabled")
    @ConfigDescription(value="Should Presto user be impersonated when communicating with HDFS")
    public HiveClientConfig setHdfsImpersonationEnabled(boolean hdfsImpersonationEnabled) {
        this.hdfsImpersonationEnabled = hdfsImpersonationEnabled;
        return this;
    }

    public boolean isHdfsWireEncryptionEnabled() {
        return this.hdfsWireEncryptionEnabled;
    }

    @Config(value="hive.hdfs.wire-encryption.enabled")
    @ConfigDescription(value="Should be turned on when HDFS wire encryption is enabled")
    public HiveClientConfig setHdfsWireEncryptionEnabled(boolean hdfsWireEncryptionEnabled) {
        this.hdfsWireEncryptionEnabled = hdfsWireEncryptionEnabled;
        return this;
    }

    public boolean isSkipDeletionForAlter() {
        return this.skipDeletionForAlter;
    }

    @Config(value="hive.skip-deletion-for-alter")
    @ConfigDescription(value="Skip deletion of old partition data when a partition is deleted and then inserted in the same transaction")
    public HiveClientConfig setSkipDeletionForAlter(boolean skipDeletionForAlter) {
        this.skipDeletionForAlter = skipDeletionForAlter;
        return this;
    }

    public boolean isSkipTargetCleanupOnRollback() {
        return this.skipTargetCleanupOnRollback;
    }

    @Config(value="hive.skip-target-cleanup-on-rollback")
    @ConfigDescription(value="Skip deletion of target directories when a metastore operation fails and the write mode is DIRECT_TO_TARGET_NEW_DIRECTORY")
    public HiveClientConfig setSkipTargetCleanupOnRollback(boolean skipTargetCleanupOnRollback) {
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        return this;
    }

    public boolean isBucketExecutionEnabled() {
        return this.bucketExecutionEnabled;
    }

    @Config(value="hive.bucket-execution")
    @ConfigDescription(value="Enable bucket-aware execution: only use a single worker per bucket")
    public HiveClientConfig setBucketExecutionEnabled(boolean bucketExecutionEnabled) {
        this.bucketExecutionEnabled = bucketExecutionEnabled;
        return this;
    }

    public boolean isSortedWritingEnabled() {
        return this.sortedWritingEnabled;
    }

    @Config(value="hive.sorted-writing")
    @ConfigDescription(value="Enable writing to bucketed sorted tables")
    public HiveClientConfig setSortedWritingEnabled(boolean sortedWritingEnabled) {
        this.sortedWritingEnabled = sortedWritingEnabled;
        return this;
    }

    @Config(value="hive.bucket-function-type-for-exchange")
    @ConfigDescription(value="Hash function type for exchange")
    public HiveClientConfig setBucketFunctionTypeForExchange(BucketFunctionType bucketFunctionTypeForExchange) {
        this.bucketFunctionTypeForExchange = bucketFunctionTypeForExchange;
        return this;
    }

    public BucketFunctionType getBucketFunctionTypeForExchange() {
        return this.bucketFunctionTypeForExchange;
    }

    @Config(value="hive.ignore-unreadable-partition")
    @ConfigDescription(value="Ignore unreadable partitions and report as warnings instead of failing the query")
    public HiveClientConfig setIgnoreUnreadablePartition(boolean ignoreUnreadablePartition) {
        this.ignoreUnreadablePartition = ignoreUnreadablePartition;
        return this;
    }

    public boolean isIgnoreUnreadablePartition() {
        return this.ignoreUnreadablePartition;
    }

    @Config(value="hive.ignore-table-bucketing")
    @ConfigDescription(value="Ignore table bucketing to allow reading from unbucketed partitions")
    public HiveClientConfig setIgnoreTableBucketing(boolean ignoreTableBucketing) {
        this.ignoreTableBucketing = ignoreTableBucketing;
        return this;
    }

    public boolean isIgnoreTableBucketing() {
        return this.ignoreTableBucketing;
    }

    @Config(value="hive.min-bucket-count-to-not-ignore-table-bucketing")
    @ConfigDescription(value="Ignore table bucketing when table bucket count is less than the value specified, otherwise, it is controlled by property hive.ignore-table-bucketing")
    public HiveClientConfig setMinBucketCountToNotIgnoreTableBucketing(int minBucketCountToNotIgnoreTableBucketing) {
        this.minBucketCountToNotIgnoreTableBucketing = minBucketCountToNotIgnoreTableBucketing;
        return this;
    }

    public int getMinBucketCountToNotIgnoreTableBucketing() {
        return this.minBucketCountToNotIgnoreTableBucketing;
    }

    @Config(value="hive.max-buckets-for-grouped-execution")
    @ConfigDescription(value="Maximum number of buckets to run with grouped execution")
    public HiveClientConfig setMaxBucketsForGroupedExecution(int maxBucketsForGroupedExecution) {
        this.maxBucketsForGroupedExecution = maxBucketsForGroupedExecution;
        return this;
    }

    public int getMaxBucketsForGroupedExecution() {
        return this.maxBucketsForGroupedExecution;
    }

    @Config(value="hive.sorted-write-to-temp-path-enabled")
    @ConfigDescription(value="Enable writing temp files to temp path when writing to bucketed sorted tables")
    public HiveClientConfig setSortedWriteToTempPathEnabled(boolean sortedWriteToTempPathEnabled) {
        this.sortedWriteToTempPathEnabled = sortedWriteToTempPathEnabled;
        return this;
    }

    public boolean isSortedWriteToTempPathEnabled() {
        return this.sortedWriteToTempPathEnabled;
    }

    @Config(value="hive.sorted-write-temp-path-subdirectory-count")
    @ConfigDescription(value="Number of directories per partition for temp files generated by writing sorted table")
    public HiveClientConfig setSortedWriteTempPathSubdirectoryCount(int sortedWriteTempPathSubdirectoryCount) {
        this.sortedWriteTempPathSubdirectoryCount = sortedWriteTempPathSubdirectoryCount;
        return this;
    }

    public int getSortedWriteTempPathSubdirectoryCount() {
        return this.sortedWriteTempPathSubdirectoryCount;
    }

    public int getFileSystemMaxCacheSize() {
        return this.fileSystemMaxCacheSize;
    }

    @Config(value="hive.fs.cache.max-size")
    @ConfigDescription(value="Hadoop FileSystem cache size")
    public HiveClientConfig setFileSystemMaxCacheSize(int fileSystemMaxCacheSize) {
        this.fileSystemMaxCacheSize = fileSystemMaxCacheSize;
        return this;
    }

    public boolean getWritesToNonManagedTablesEnabled() {
        return this.writesToNonManagedTablesEnabled;
    }

    @Config(value="hive.non-managed-table-writes-enabled")
    @ConfigDescription(value="Enable writes to non-managed (external) tables")
    public HiveClientConfig setWritesToNonManagedTablesEnabled(boolean writesToNonManagedTablesEnabled) {
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        return this;
    }

    public boolean getCreatesOfNonManagedTablesEnabled() {
        return this.createsOfNonManagedTablesEnabled;
    }

    @Config(value="hive.non-managed-table-creates-enabled")
    @ConfigDescription(value="Enable non-managed (external) table creates")
    public HiveClientConfig setCreatesOfNonManagedTablesEnabled(boolean createsOfNonManagedTablesEnabled) {
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        return this;
    }

    public boolean isTableStatisticsEnabled() {
        return this.tableStatisticsEnabled;
    }

    @Config(value="hive.table-statistics-enabled")
    @ConfigDescription(value="Enable use of table statistics")
    public HiveClientConfig setTableStatisticsEnabled(boolean tableStatisticsEnabled) {
        this.tableStatisticsEnabled = tableStatisticsEnabled;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getPartitionStatisticsSampleSize() {
        return this.partitionStatisticsSampleSize;
    }

    @Config(value="hive.partition-statistics-sample-size")
    @ConfigDescription(value="Maximum sample size of the partitions column statistics")
    public HiveClientConfig setPartitionStatisticsSampleSize(int partitionStatisticsSampleSize) {
        this.partitionStatisticsSampleSize = partitionStatisticsSampleSize;
        return this;
    }

    public boolean isIgnoreCorruptedStatistics() {
        return this.ignoreCorruptedStatistics;
    }

    @Config(value="hive.ignore-corrupted-statistics")
    @ConfigDescription(value="Ignore corrupted statistics rather than failing")
    public HiveClientConfig setIgnoreCorruptedStatistics(boolean ignoreCorruptedStatistics) {
        this.ignoreCorruptedStatistics = ignoreCorruptedStatistics;
        return this;
    }

    public boolean isCollectColumnStatisticsOnWrite() {
        return this.collectColumnStatisticsOnWrite;
    }

    @Config(value="hive.collect-column-statistics-on-write")
    @ConfigDescription(value="Enables automatic column level statistics collection on write")
    public HiveClientConfig setCollectColumnStatisticsOnWrite(boolean collectColumnStatisticsOnWrite) {
        this.collectColumnStatisticsOnWrite = collectColumnStatisticsOnWrite;
        return this;
    }

    public boolean isPartitionStatisticsBasedOptimizationEnabled() {
        return this.partitionStatisticsBasedOptimizationEnabled;
    }

    @Config(value="hive.partition-statistics-based-optimization-enabled")
    @ConfigDescription(value="Enables partition statistics based optimization, including partition pruning and predicate stripping")
    public HiveClientConfig setPartitionStatisticsBasedOptimizationEnabled(boolean partitionStatisticsBasedOptimizationEnabled) {
        this.partitionStatisticsBasedOptimizationEnabled = partitionStatisticsBasedOptimizationEnabled;
        return this;
    }

    public boolean isS3SelectPushdownEnabled() {
        return this.s3SelectPushdownEnabled;
    }

    @Config(value="hive.s3select-pushdown.enabled")
    @ConfigDescription(value="Enable query pushdown to AWS S3 Select service")
    public HiveClientConfig setS3SelectPushdownEnabled(boolean s3SelectPushdownEnabled) {
        this.s3SelectPushdownEnabled = s3SelectPushdownEnabled;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getS3SelectPushdownMaxConnections() {
        return this.s3SelectPushdownMaxConnections;
    }

    @Config(value="hive.s3select-pushdown.max-connections")
    public HiveClientConfig setS3SelectPushdownMaxConnections(int s3SelectPushdownMaxConnections) {
        this.s3SelectPushdownMaxConnections = s3SelectPushdownMaxConnections;
        return this;
    }

    public boolean isTemporaryStagingDirectoryEnabled() {
        return this.isTemporaryStagingDirectoryEnabled;
    }

    @Config(value="hive.temporary-staging-directory-enabled")
    @ConfigDescription(value="Should use (if possible) temporary staging directory for write operations")
    public HiveClientConfig setTemporaryStagingDirectoryEnabled(boolean temporaryStagingDirectoryEnabled) {
        this.isTemporaryStagingDirectoryEnabled = temporaryStagingDirectoryEnabled;
        return this;
    }

    @NotNull
    public String getTemporaryStagingDirectoryPath() {
        return this.temporaryStagingDirectoryPath;
    }

    @Config(value="hive.temporary-staging-directory-path")
    @ConfigDescription(value="Location of temporary staging directory for write operations. Use ${USER} placeholder to use different location for each user.")
    public HiveClientConfig setTemporaryStagingDirectoryPath(String temporaryStagingDirectoryPath) {
        this.temporaryStagingDirectoryPath = temporaryStagingDirectoryPath;
        return this;
    }

    @NotNull
    public String getTemporaryTableSchema() {
        return this.temporaryTableSchema;
    }

    @Config(value="hive.temporary-table-schema")
    public HiveClientConfig setTemporaryTableSchema(String temporaryTableSchema) {
        this.temporaryTableSchema = temporaryTableSchema;
        return this;
    }

    @NotNull
    public HiveStorageFormat getTemporaryTableStorageFormat() {
        return this.temporaryTableStorageFormat;
    }

    @Config(value="hive.temporary-table-storage-format")
    public HiveClientConfig setTemporaryTableStorageFormat(HiveStorageFormat temporaryTableStorageFormat) {
        this.temporaryTableStorageFormat = temporaryTableStorageFormat;
        return this;
    }

    @NotNull
    public HiveCompressionCodec getTemporaryTableCompressionCodec() {
        return this.temporaryTableCompressionCodec;
    }

    @Config(value="hive.temporary-table-compression-codec")
    public HiveClientConfig setTemporaryTableCompressionCodec(HiveCompressionCodec temporaryTableCompressionCodec) {
        this.temporaryTableCompressionCodec = temporaryTableCompressionCodec;
        return this;
    }

    public boolean isCreateEmptyBucketFilesForTemporaryTable() {
        return this.shouldCreateEmptyBucketFilesForTemporaryTable;
    }

    @Config(value="hive.create-empty-bucket-files-for-temporary-table")
    @ConfigDescription(value="Create empty files when there is no data for temporary table buckets")
    public HiveClientConfig setCreateEmptyBucketFilesForTemporaryTable(boolean shouldCreateEmptyBucketFilesForTemporaryTable) {
        this.shouldCreateEmptyBucketFilesForTemporaryTable = shouldCreateEmptyBucketFilesForTemporaryTable;
        return this;
    }

    public boolean getUsePageFileForHiveUnsupportedType() {
        return this.usePageFileForHiveUnsupportedType;
    }

    @Config(value="hive.use-pagefile-for-hive-unsupported-type")
    public HiveClientConfig setUsePageFileForHiveUnsupportedType(boolean usePageFileForHiveUnsupportedType) {
        this.usePageFileForHiveUnsupportedType = usePageFileForHiveUnsupportedType;
        return this;
    }

    public boolean isPushdownFilterEnabled() {
        return this.pushdownFilterEnabled;
    }

    @Config(value="hive.pushdown-filter-enabled")
    @ConfigDescription(value="Experimental: enable complex filter pushdown")
    public HiveClientConfig setPushdownFilterEnabled(boolean pushdownFilterEnabled) {
        this.pushdownFilterEnabled = pushdownFilterEnabled;
        return this;
    }

    public boolean isRangeFiltersOnSubscriptsEnabled() {
        return this.rangeFiltersOnSubscriptsEnabled;
    }

    @Config(value="hive.range-filters-on-subscripts-enabled")
    @ConfigDescription(value="Experimental: enable pushdown of range filters on subscripts (a[2] = 5) into ORC column readers")
    public HiveClientConfig setRangeFiltersOnSubscriptsEnabled(boolean rangeFiltersOnSubscriptsEnabled) {
        this.rangeFiltersOnSubscriptsEnabled = rangeFiltersOnSubscriptsEnabled;
        return this;
    }

    public boolean isAdaptiveFilterReorderingEnabled() {
        return this.adaptiveFilterReorderingEnabled;
    }

    @Config(value="hive.adaptive-filter-reordering-enabled")
    @ConfigDescription(value="Experimental: enable adaptive filter reordering")
    public HiveClientConfig setAdaptiveFilterReorderingEnabled(boolean adaptiveFilterReorderingEnabled) {
        this.adaptiveFilterReorderingEnabled = adaptiveFilterReorderingEnabled;
        return this;
    }

    public DataSize getPageFileStripeMaxSize() {
        return this.pageFileStripeMaxSize;
    }

    @Config(value="hive.pagefile.writer.stripe-max-size")
    public HiveClientConfig setPageFileStripeMaxSize(DataSize pageFileStripeMaxSize) {
        this.pageFileStripeMaxSize = pageFileStripeMaxSize;
        return this;
    }

    @Config(value="hive.parquet-batch-read-optimization-enabled")
    @ConfigDescription(value="enable parquet batch reads optimization")
    public HiveClientConfig setParquetBatchReadOptimizationEnabled(boolean parquetBatchReadOptimizationEnabled) {
        this.parquetBatchReadOptimizationEnabled = parquetBatchReadOptimizationEnabled;
        return this;
    }

    public boolean isParquetBatchReadOptimizationEnabled() {
        return this.parquetBatchReadOptimizationEnabled;
    }

    @Config(value="hive.enable-parquet-batch-reader-verification")
    @ConfigDescription(value="enable optimized parquet reader")
    public HiveClientConfig setParquetBatchReaderVerificationEnabled(boolean parquetEnableBatchReaderVerification) {
        this.parquetEnableBatchReaderVerification = parquetEnableBatchReaderVerification;
        return this;
    }

    public boolean isParquetBatchReaderVerificationEnabled() {
        return this.parquetEnableBatchReaderVerification;
    }

    @Config(value="hive.enable-parquet-dereference-pushdown")
    @ConfigDescription(value="enable parquet dereference pushdown")
    public HiveClientConfig setParquetDereferencePushdownEnabled(boolean parquetDereferencePushdownEnabled) {
        this.parquetDereferencePushdownEnabled = parquetDereferencePushdownEnabled;
        return this;
    }

    public boolean isParquetDereferencePushdownEnabled() {
        return this.parquetDereferencePushdownEnabled;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxMetadataUpdaterThreads() {
        return this.maxMetadataUpdaterThreads;
    }

    @Config(value="hive.max-metadata-updater-threads")
    public HiveClientConfig setMaxMetadataUpdaterThreads(int maxMetadataUpdaterThreads) {
        this.maxMetadataUpdaterThreads = maxMetadataUpdaterThreads;
        return this;
    }

    @Config(value="hive.partial_aggregation_pushdown_enabled")
    @ConfigDescription(value="enable partial aggregation pushdown")
    public HiveClientConfig setPartialAggregationPushdownEnabled(boolean partialAggregationPushdownEnabled) {
        this.isPartialAggregationPushdownEnabled = partialAggregationPushdownEnabled;
        return this;
    }

    public boolean isPartialAggregationPushdownEnabled() {
        return this.isPartialAggregationPushdownEnabled;
    }

    @Config(value="hive.partial_aggregation_pushdown_for_variable_length_datatypes_enabled")
    @ConfigDescription(value="enable partial aggregation pushdown for variable length datatypes")
    public HiveClientConfig setPartialAggregationPushdownForVariableLengthDatatypesEnabled(boolean partialAggregationPushdownForVariableLengthDatatypesEnabled) {
        this.isPartialAggregationPushdownForVariableLengthDatatypesEnabled = partialAggregationPushdownForVariableLengthDatatypesEnabled;
        return this;
    }

    public boolean isPartialAggregationPushdownForVariableLengthDatatypesEnabled() {
        return this.isPartialAggregationPushdownForVariableLengthDatatypesEnabled;
    }

    @Config(value="hive.file_renaming_enabled")
    @ConfigDescription(value="enable file renaming")
    public HiveClientConfig setFileRenamingEnabled(boolean fileRenamingEnabled) {
        this.fileRenamingEnabled = fileRenamingEnabled;
        return this;
    }

    public boolean isFileRenamingEnabled() {
        return this.fileRenamingEnabled;
    }

    @Config(value="hive.prefer-manifests-to-list-files")
    @ConfigDescription(value="Prefer to fetch the list of file names and sizes from manifests rather than storage")
    public HiveClientConfig setPreferManifestsToListFiles(boolean preferManifestToListFiles) {
        this.preferManifestToListFiles = preferManifestToListFiles;
        return this;
    }

    public boolean isPreferManifestsToListFiles() {
        return this.preferManifestToListFiles;
    }

    @Config(value="hive.manifest-verification-enabled")
    @ConfigDescription(value="Enable verification of file names and sizes in manifest / partition parameters")
    public HiveClientConfig setManifestVerificationEnabled(boolean manifestVerificationEnabled) {
        this.manifestVerificationEnabled = manifestVerificationEnabled;
        return this;
    }

    public boolean isManifestVerificationEnabled() {
        return this.manifestVerificationEnabled;
    }

    @Config(value="hive.undo-metastore-operations-enabled")
    @ConfigDescription(value="Enable undo metastore operations")
    public HiveClientConfig setUndoMetastoreOperationsEnabled(boolean undoMetastoreOperationsEnabled) {
        this.undoMetastoreOperationsEnabled = undoMetastoreOperationsEnabled;
        return this;
    }

    public boolean isUndoMetastoreOperationsEnabled() {
        return this.undoMetastoreOperationsEnabled;
    }

    public boolean isOptimizedPartitionUpdateSerializationEnabled() {
        return this.optimizedPartitionUpdateSerializationEnabled;
    }

    @Config(value="hive.experimental-optimized-partition-update-serialization-enabled")
    @ConfigDescription(value="Serialize PartitionUpdate objects using binary SMILE encoding and compress with the ZSTD compression")
    public HiveClientConfig setOptimizedPartitionUpdateSerializationEnabled(boolean optimizedPartitionUpdateSerializationEnabled) {
        this.optimizedPartitionUpdateSerializationEnabled = optimizedPartitionUpdateSerializationEnabled;
        return this;
    }

    public static enum HdfsAuthenticationType {
        NONE,
        KERBEROS;

    }

    public static enum HiveMetastoreAuthenticationType {
        NONE,
        KERBEROS;

    }
}

