/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.EncryptionLibrary;
import com.facebook.presto.orc.UnsupportedEncryptionLibrary;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;

public class HiveDwrfEncryptionProvider {
    public static final HiveDwrfEncryptionProvider NO_ENCRYPTION = new HiveDwrfEncryptionProvider((EncryptionLibrary)new UnsupportedEncryptionLibrary(), (EncryptionLibrary)new UnsupportedEncryptionLibrary());
    private final EncryptionLibrary cryptoServiceLibrary;
    private final EncryptionLibrary unknownLibrary;

    @Inject
    public HiveDwrfEncryptionProvider(@ForCryptoService EncryptionLibrary cryptoServiceLibrary, @ForUnknown EncryptionLibrary unknownLibrary) {
        this.cryptoServiceLibrary = Objects.requireNonNull(cryptoServiceLibrary, "cryptoServiceLibrary is null");
        this.unknownLibrary = Objects.requireNonNull(unknownLibrary, "unknownLibrary is null");
    }

    public DwrfEncryptionProvider toDwrfEncryptionProvider() {
        return new DwrfEncryptionProvider(this.cryptoServiceLibrary, this.unknownLibrary);
    }

    @BindingAnnotation
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ForUnknown {
    }

    @BindingAnnotation
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ForCryptoService {
    }
}

