/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.smile.SmileCodec;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.ColumnEncryptionInformation;
import com.facebook.presto.hive.DwrfEncryptionMetadata;
import com.facebook.presto.hive.DwrfTableEncryptionProperties;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveAnalyzeProperties;
import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveEncryptionInformationProvider;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileRenamer;
import com.facebook.presto.hive.HiveInputInfo;
import com.facebook.presto.hive.HiveInsertTableHandle;
import com.facebook.presto.hive.HiveManifestUtils;
import com.facebook.presto.hive.HiveMaterializedViewUtils;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HivePartitionResult;
import com.facebook.presto.hive.HivePartitionStats;
import com.facebook.presto.hive.HivePartitioningHandle;
import com.facebook.presto.hive.HiveSchemaProperties;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTableProperties;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.HiveViewNotSupportedException;
import com.facebook.presto.hive.HiveWritableTableHandle;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.HiveWriterFactory;
import com.facebook.presto.hive.HiveWrittenPartitions;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.MaterializedViewAlreadyExistsException;
import com.facebook.presto.hive.PartitionObjectBuilder;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.StagingFileCommitter;
import com.facebook.presto.hive.SubfieldExtractor;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.TableEncryptionProperties;
import com.facebook.presto.hive.TableParameterCodec;
import com.facebook.presto.hive.TransactionalMetadata;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.ViewAlreadyExistsException;
import com.facebook.presto.hive.ZeroRowFileCreator;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.SortingColumn;
import com.facebook.presto.hive.metastore.Statistics;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.thrift.ThriftMetastoreUtil;
import com.facebook.presto.hive.statistics.HiveStatisticsProvider;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorMaterializedViewDefinition;
import com.facebook.presto.spi.ConnectorMetadataUpdateHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorTablePartitioning;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.DiscretePredicates;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.MaterializedViewNotFoundException;
import com.facebook.presto.spi.MaterializedViewStatus;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.TableLayoutFilterCoverage;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.ViewNotFoundException;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.connector.ConnectorPartitioningMetadata;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterStatsCalculatorService;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.facebook.presto.spi.security.GrantInfo;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.PrivilegeInfo;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ColumnStatisticMetadata;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.statistics.TableStatisticsMetadata;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.airlift.slice.Slice;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.joda.time.DateTimeZone;

public class HiveMetadata
implements TransactionalMetadata {
    public static final String PRESTO_VERSION_NAME = "presto_version";
    public static final String TABLE_COMMENT = "comment";
    public static final Set<String> RESERVED_ROLES = ImmutableSet.of((Object)"all", (Object)"default", (Object)"none");
    private static final String ORC_BLOOM_FILTER_COLUMNS_KEY = "orc.bloom.filter.columns";
    private static final String ORC_BLOOM_FILTER_FPP_KEY = "orc.bloom.filter.fpp";
    private static final String PRESTO_TEMPORARY_TABLE_NAME_PREFIX = "__presto_temporary_table_";
    private static final char COMMA = ',';
    private static final int SHUFFLE_MAX_PARALLELISM_FOR_PARTITIONED_TABLE_WRITE = 1009;
    private static final String CSV_SEPARATOR_KEY = "separatorChar";
    private static final String CSV_QUOTE_KEY = "quoteChar";
    private static final String CSV_ESCAPE_KEY = "escapeChar";
    private static final JsonCodec<ConnectorMaterializedViewDefinition> MATERIALIZED_VIEW_JSON_CODEC = JsonCodec.jsonCodec(ConnectorMaterializedViewDefinition.class);
    private final boolean allowCorruptWritesForTesting;
    private final SemiTransactionalHiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    private final DateTimeZone timeZone;
    private final TypeManager typeManager;
    private final LocationService locationService;
    private final StandardFunctionResolution functionResolution;
    private final RowExpressionService rowExpressionService;
    private final FilterStatsCalculatorService filterStatsCalculatorService;
    private final TableParameterCodec tableParameterCodec;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final SmileCodec<PartitionUpdate> partitionUpdateSmileCodec;
    private final boolean writesToNonManagedTablesEnabled;
    private final boolean createsOfNonManagedTablesEnabled;
    private final int maxPartitionBatchSize;
    private final TypeTranslator typeTranslator;
    private final String prestoVersion;
    private final HiveStatisticsProvider hiveStatisticsProvider;
    private final StagingFileCommitter stagingFileCommitter;
    private final ZeroRowFileCreator zeroRowFileCreator;
    private final PartitionObjectBuilder partitionObjectBuilder;
    private final HiveEncryptionInformationProvider encryptionInformationProvider;
    private final HivePartitionStats hivePartitionStats;
    private final HiveFileRenamer hiveFileRenamer;

    public HiveMetadata(SemiTransactionalHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, DateTimeZone timeZone, boolean allowCorruptWritesForTesting, boolean writesToNonManagedTablesEnabled, boolean createsOfNonManagedTablesEnabled, int maxPartitionBatchSize, TypeManager typeManager, LocationService locationService, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, FilterStatsCalculatorService filterStatsCalculatorService, TableParameterCodec tableParameterCodec, JsonCodec<PartitionUpdate> partitionUpdateCodec, SmileCodec<PartitionUpdate> partitionUpdateSmileCodec, TypeTranslator typeTranslator, String prestoVersion, HiveStatisticsProvider hiveStatisticsProvider, StagingFileCommitter stagingFileCommitter, ZeroRowFileCreator zeroRowFileCreator, PartitionObjectBuilder partitionObjectBuilder, HiveEncryptionInformationProvider encryptionInformationProvider, HivePartitionStats hivePartitionStats, HiveFileRenamer hiveFileRenamer) {
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.filterStatsCalculatorService = Objects.requireNonNull(filterStatsCalculatorService, "filterStatsCalculatorService is null");
        this.tableParameterCodec = Objects.requireNonNull(tableParameterCodec, "tableParameterCodec is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.partitionUpdateSmileCodec = Objects.requireNonNull(partitionUpdateSmileCodec, "partitionUpdateSmileCodec is null");
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        this.typeTranslator = Objects.requireNonNull(typeTranslator, "typeTranslator is null");
        this.prestoVersion = Objects.requireNonNull(prestoVersion, "prestoVersion is null");
        this.hiveStatisticsProvider = Objects.requireNonNull(hiveStatisticsProvider, "hiveStatisticsProvider is null");
        this.stagingFileCommitter = Objects.requireNonNull(stagingFileCommitter, "stagingFileCommitter is null");
        this.zeroRowFileCreator = Objects.requireNonNull(zeroRowFileCreator, "zeroRowFileCreator is null");
        this.partitionObjectBuilder = Objects.requireNonNull(partitionObjectBuilder, "partitionObjectBuilder is null");
        this.encryptionInformationProvider = Objects.requireNonNull(encryptionInformationProvider, "encryptionInformationProvider is null");
        this.hivePartitionStats = Objects.requireNonNull(hivePartitionStats, "hivePartitionStats is null");
        this.hiveFileRenamer = Objects.requireNonNull(hiveFileRenamer, "hiveFileRenamer is null");
    }

    @Override
    public SemiTransactionalHiveMetastore getMetastore() {
        return this.metastore;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.metastore.getAllDatabases(new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource()));
    }

    public HiveTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Optional table = this.metastore.getTable(metastoreContext, tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent()) {
            return null;
        }
        if (HiveMetadata.getSourceTableNameFromSystemTable(tableName).isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unexpected table %s present in Hive metastore", tableName));
        }
        if (!HiveSessionProperties.isOfflineDataDebugModeEnabled(session)) {
            MetastoreUtil.verifyOnline((SchemaTableName)tableName, Optional.empty(), (ProtectMode)MetastoreUtil.getProtectMode((Table)((Table)table.get())), (Map)((Table)table.get()).getParameters());
        }
        return new HiveTableHandle(tableName.getSchemaName(), tableName.getTableName());
    }

    public ConnectorTableHandle getTableHandleForStatisticsCollection(ConnectorSession session, SchemaTableName tableName, Map<String, Object> analyzeProperties) {
        HiveTableHandle handle = this.getTableHandle(session, tableName);
        if (handle == null) {
            return null;
        }
        Optional<List<List<String>>> partitionValuesList = HiveAnalyzeProperties.getPartitionList(analyzeProperties);
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, handle.getSchemaTableName());
        handle = handle.withAnalyzePartitionValues(partitionValuesList);
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        if (partitionValuesList.isPresent() && partitionedBy.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Only partitioned table can be analyzed with a partition list");
        }
        return handle;
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        if (SystemTableHandler.PARTITIONS.matches(tableName)) {
            return this.getPartitionsSystemTable(session, tableName, SystemTableHandler.PARTITIONS.getSourceTableName(tableName));
        }
        if (SystemTableHandler.PROPERTIES.matches(tableName)) {
            return this.getPropertiesSystemTable(session, tableName, SystemTableHandler.PROPERTIES.getSourceTableName(tableName));
        }
        return Optional.empty();
    }

    private Optional<SystemTable> getPropertiesSystemTable(ConnectorSession session, SchemaTableName tableName, SchemaTableName sourceTableName) {
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Optional table = this.metastore.getTable(metastoreContext, sourceTableName.getSchemaName(), sourceTableName.getTableName());
        if (!table.isPresent() || ((Table)table.get()).getTableType().equals((Object)PrestoTableType.VIRTUAL_VIEW)) {
            throw new TableNotFoundException(tableName);
        }
        ImmutableSortedMap sortedTableParameters = ImmutableSortedMap.copyOf((Map)((Table)table.get()).getParameters());
        List columns = (List)sortedTableParameters.keySet().stream().map(key -> new ColumnMetadata(key, (Type)VarcharType.VARCHAR)).collect(ImmutableList.toImmutableList());
        List types = (List)columns.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        ImmutableList propertyValues = ImmutableList.of((Object)ImmutableList.copyOf(sortedTableParameters.values()));
        return Optional.of(HiveMetadata.createSystemTable(new ConnectorTableMetadata(sourceTableName, columns), arg_0 -> HiveMetadata.lambda$getPropertiesSystemTable$1(types, (Iterable)propertyValues, arg_0)));
    }

    private Optional<SystemTable> getPartitionsSystemTable(ConnectorSession session, SchemaTableName tableName, SchemaTableName sourceTableName) {
        HiveTableHandle sourceTableHandle = this.getTableHandle(session, sourceTableName);
        if (sourceTableHandle == null) {
            return Optional.empty();
        }
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        List<HiveColumnHandle> partitionColumns = this.getPartitionColumns(session.getIdentity(), metastoreContext, sourceTableName);
        if (partitionColumns.isEmpty()) {
            return Optional.empty();
        }
        List partitionColumnTypes = (List)partitionColumns.stream().map(HiveColumnHandle::getTypeSignature).map(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList());
        List partitionSystemTableColumns = (List)partitionColumns.stream().map(column -> new ColumnMetadata(column.getName(), this.typeManager.getType(column.getTypeSignature()), (String)column.getComment().orElse(null), column.isHidden())).collect(ImmutableList.toImmutableList());
        Map fieldIdToColumnHandle = (Map)IntStream.range(0, partitionColumns.size()).boxed().collect(ImmutableMap.toImmutableMap(Function.identity(), partitionColumns::get));
        return Optional.of(HiveMetadata.createSystemTable(new ConnectorTableMetadata(tableName, partitionSystemTableColumns), constraint -> {
            TupleDomain targetTupleDomain = constraint.transform(fieldIdToColumnHandle::get);
            Predicate<Map<ColumnHandle, NullableValue>> targetPredicate = HiveMetadata.convertToPredicate((TupleDomain<ColumnHandle>)targetTupleDomain);
            Constraint targetConstraint = new Constraint(targetTupleDomain, targetPredicate);
            Iterable records = () -> Streams.stream(this.partitionManager.getPartitionsIterator(this.metastore, sourceTableHandle, (Constraint<ColumnHandle>)targetConstraint, session)).map(hivePartition -> IntStream.range(0, partitionColumns.size()).mapToObj(fieldIdToColumnHandle::get).map(columnHandle -> ((HivePartition)hivePartition).getKeys().get(columnHandle).getValue()).collect(Collectors.toList())).iterator();
            return new InMemoryRecordSet((Collection)partitionColumnTypes, records).cursor();
        }));
    }

    private List<HiveColumnHandle> getPartitionColumns(ConnectorIdentity identity, MetastoreContext metastoreContext, SchemaTableName tableName) {
        Table sourceTable = (Table)this.metastore.getTable(metastoreContext, tableName.getSchemaName(), tableName.getTableName()).get();
        return HiveUtil.getPartitionKeyColumnHandles(sourceTable);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        return this.getTableMetadata(session, tableName);
    }

    private ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName tableName) {
        String avroSchemaUrl;
        String orcBloomFilterFfp;
        String orcBloomFilterColumns;
        List<SortingColumn> preferredOrderingColumns;
        Optional bucketProperty;
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Optional table = this.metastore.getTable(metastoreContext, tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent() || ((Table)table.get()).getTableType().equals((Object)PrestoTableType.VIRTUAL_VIEW)) {
            throw new TableNotFoundException(tableName);
        }
        Function<HiveColumnHandle, ColumnMetadata> metadataGetter = HiveMetadata.columnMetadataGetter((Table)table.get(), this.typeManager);
        ImmutableList.Builder columns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles((Table)table.get())) {
            columns.add((Object)metadataGetter.apply(columnHandle));
        }
        ImmutableMap.Builder properties = ImmutableMap.builder();
        if (((Table)table.get()).getTableType().equals((Object)PrestoTableType.EXTERNAL_TABLE)) {
            properties.put((Object)"external_location", (Object)((Table)table.get()).getStorage().getLocation());
        }
        HiveStorageFormat format = null;
        try {
            format = HiveMetadata.extractHiveStorageFormat((Table)table.get());
            properties.put((Object)"format", (Object)format);
        }
        catch (PrestoException prestoException) {
        }
        this.getTableEncryptionPropertiesFromHiveProperties(((Table)table.get()).getParameters(), format).map(TableEncryptionProperties::toTableProperties).ifPresent(arg_0 -> ((ImmutableMap.Builder)properties).putAll(arg_0));
        List partitionedBy = ((Table)table.get()).getPartitionColumns().stream().map(Column::getName).collect(Collectors.toList());
        if (!partitionedBy.isEmpty()) {
            properties.put((Object)"partitioned_by", partitionedBy);
        }
        if ((bucketProperty = ((Table)table.get()).getStorage().getBucketProperty()).isPresent()) {
            properties.put((Object)"bucket_count", (Object)((HiveBucketProperty)bucketProperty.get()).getBucketCount());
            properties.put((Object)"bucketed_by", (Object)((HiveBucketProperty)bucketProperty.get()).getBucketedBy());
            properties.put((Object)"sorted_by", (Object)((HiveBucketProperty)bucketProperty.get()).getSortedBy());
        }
        if (!(preferredOrderingColumns = HiveMetadata.decodePreferredOrderingColumnsFromStorage(((Table)table.get()).getStorage())).isEmpty()) {
            if (bucketProperty.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("bucketed table %s should not specify preferred_ordering_columns", tableName));
            }
            properties.put((Object)"preferred_ordering_columns", preferredOrderingColumns);
        }
        if ((orcBloomFilterColumns = (String)((Table)table.get()).getParameters().get(ORC_BLOOM_FILTER_COLUMNS_KEY)) != null) {
            properties.put((Object)"orc_bloom_filter_columns", (Object)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)orcBloomFilterColumns));
        }
        if ((orcBloomFilterFfp = (String)((Table)table.get()).getParameters().get(ORC_BLOOM_FILTER_FPP_KEY)) != null) {
            properties.put((Object)"orc_bloom_filter_fpp", (Object)Double.parseDouble(orcBloomFilterFfp));
        }
        if ((avroSchemaUrl = (String)((Table)table.get()).getParameters().get("avro.schema.url")) != null) {
            properties.put((Object)"avro_schema_url", (Object)avroSchemaUrl);
        }
        HiveMetadata.getCsvSerdeProperty((Table)table.get(), CSV_SEPARATOR_KEY).ifPresent(csvSeparator -> properties.put((Object)"csv_separator", csvSeparator));
        HiveMetadata.getCsvSerdeProperty((Table)table.get(), CSV_QUOTE_KEY).ifPresent(csvQuote -> properties.put((Object)"csv_quote", csvQuote));
        HiveMetadata.getCsvSerdeProperty((Table)table.get(), CSV_ESCAPE_KEY).ifPresent(csvEscape -> properties.put((Object)"csv_escape", csvEscape));
        properties.putAll(this.tableParameterCodec.decode(((Table)table.get()).getParameters()));
        Optional comment = Optional.ofNullable(((Table)table.get()).getParameters().get(TABLE_COMMENT));
        return new ConnectorTableMetadata(tableName, (List)columns.build(), (Map)properties.build(), comment);
    }

    private static Optional<String> getCsvSerdeProperty(Table table, String key) {
        return HiveMetadata.getSerdeProperty(table, key).map(csvSerdeProperty -> {
            if (csvSerdeProperty.length() > 1) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Only single character can be set for property: " + key);
            }
            return csvSerdeProperty;
        });
    }

    private static Optional<String> getSerdeProperty(Table table, String key) {
        String serdePropertyValue = (String)table.getStorage().getSerdeParameters().get(key);
        String tablePropertyValue = (String)table.getParameters().get(key);
        if (serdePropertyValue != null && tablePropertyValue != null && !tablePropertyValue.equals(serdePropertyValue)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Different values for '%s' set in serde properties and table properties: '%s' and '%s'", key, serdePropertyValue, tablePropertyValue));
        }
        return HiveMetadata.firstNonNullable(tablePropertyValue, serdePropertyValue);
    }

    protected Optional<? extends TableEncryptionProperties> getTableEncryptionPropertiesFromHiveProperties(Map<String, String> parameters, HiveStorageFormat storageFormat) {
        if (storageFormat != HiveStorageFormat.DWRF) {
            return Optional.empty();
        }
        return DwrfTableEncryptionProperties.fromHiveTableProperties(parameters);
    }

    public Optional<Object> getInfo(ConnectorTableLayoutHandle layoutHandle) {
        HiveTableLayoutHandle tableLayoutHandle = (HiveTableLayoutHandle)layoutHandle;
        if (tableLayoutHandle.getPartitions().isPresent()) {
            return Optional.of(new HiveInputInfo(tableLayoutHandle.getPartitions().get().stream().map(HivePartition::getPartitionId).collect(Collectors.toList()), false));
        }
        return Optional.empty();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        for (String schemaName : this.listSchemas(session, schemaNameOrNull)) {
            for (String tableName : this.metastore.getAllTables(metastoreContext, schemaName).orElse(Collections.emptyList())) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return tableNames.build();
    }

    private List<String> listSchemas(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return this.listSchemaNames(session);
        }
        return ImmutableList.of((Object)schemaNameOrNull);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Optional table = this.metastore.getTable(metastoreContext, tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles((Table)table.get())) {
            columnHandles.put((Object)columnHandle.getName(), (Object)columnHandle);
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(session, tableName).getColumns());
            }
            catch (HiveViewNotSupportedException hiveViewNotSupportedException) {
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
        return columns.build();
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<ConnectorTableLayoutHandle> tableLayoutHandle, List<ColumnHandle> columnHandles, Constraint<ColumnHandle> constraint) {
        block5: {
            block4: {
                if (!HiveSessionProperties.isStatisticsEnabled(session)) {
                    return TableStatistics.empty();
                }
                if (!tableLayoutHandle.isPresent()) break block4;
                if (((HiveTableLayoutHandle)tableLayoutHandle.get()).isPushdownFilterEnabled()) break block5;
            }
            Map columns = (Map)columnHandles.stream().map(HiveColumnHandle.class::cast).filter((Predicate<HiveColumnHandle>)Predicates.not(HiveColumnHandle::isHidden)).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, Function.identity()));
            Map columnTypes = (Map)columns.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.getColumnMetadata(session, tableHandle, (ColumnHandle)entry.getValue()).getType()));
            List<HivePartition> partitions = this.partitionManager.getPartitions(this.metastore, tableHandle, constraint, session).getPartitions();
            return this.hiveStatisticsProvider.getTableStatistics(session, ((HiveTableHandle)tableHandle).getSchemaTableName(), columns, columnTypes, partitions);
        }
        Verify.verify((!constraint.predicate().isPresent() ? 1 : 0) != 0);
        HiveTableLayoutHandle hiveLayoutHandle = (HiveTableLayoutHandle)tableLayoutHandle.get();
        Set columnNames = (Set)columnHandles.stream().map(HiveColumnHandle.class::cast).map(HiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
        ImmutableSet allColumnHandles = ImmutableSet.builder().addAll(columnHandles).addAll((Iterable)hiveLayoutHandle.getPredicateColumns().values().stream().filter(column -> !columnNames.contains(column.getName())).collect(ImmutableList.toImmutableList())).build();
        ImmutableMap allColumns = Maps.uniqueIndex((Iterable)allColumnHandles, column -> ((HiveColumnHandle)column).getName());
        Map allColumnTypes = (Map)allColumns.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.getColumnMetadata(session, tableHandle, (ColumnHandle)entry.getValue()).getType()));
        Constraint combinedConstraint = new Constraint(constraint.getSummary().intersect(hiveLayoutHandle.getDomainPredicate().transform(subfield -> HiveMetadata.isEntireColumn(subfield) ? subfield.getRootName() : null).transform(((Map)allColumns)::get)));
        SubfieldExtractor subfieldExtractor = new SubfieldExtractor(this.functionResolution, this.rowExpressionService.getExpressionOptimizer(), session);
        RowExpression domainPredicate = this.rowExpressionService.getDomainTranslator().toPredicate(hiveLayoutHandle.getDomainPredicate().transform(subfield -> subfieldExtractor.toRowExpression((Subfield)subfield, (Type)allColumnTypes.get(subfield.getRootName()))));
        RowExpression combinedPredicate = LogicalRowExpressions.binaryExpression((SpecialFormExpression.Form)SpecialFormExpression.Form.AND, (Collection)ImmutableList.of((Object)hiveLayoutHandle.getRemainingPredicate(), (Object)domainPredicate));
        List<HivePartition> partitions = this.partitionManager.getPartitions(this.metastore, tableHandle, (Constraint<ColumnHandle>)combinedConstraint, session).getPartitions();
        TableStatistics tableStatistics = this.hiveStatisticsProvider.getTableStatistics(session, ((HiveTableHandle)tableHandle).getSchemaTableName(), (Map<String, ColumnHandle>)allColumns, allColumnTypes, partitions);
        return this.filterStatsCalculatorService.filterStats(tableStatistics, combinedPredicate, session, (Map)ImmutableBiMap.copyOf((Map)allColumns).inverse(), allColumnTypes);
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null || prefix.getTableName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((HiveColumnHandle)columnHandle).getColumnMetadata(this.typeManager);
    }

    public TupleDomain<ColumnHandle> toExplainIOConstraints(ConnectorSession session, ConnectorTableHandle tableHandle, TupleDomain<ColumnHandle> constraints) {
        return constraints.transform(columnHandle -> ((HiveColumnHandle)columnHandle).isPartitionKey() ? columnHandle : null);
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        Optional<String> location = HiveSchemaProperties.getLocation(properties).map(locationUri -> {
            try {
                this.hdfsEnvironment.getFileSystem(new HdfsContext(session, schemaName), new Path(locationUri));
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + locationUri, (Throwable)e);
            }
            return locationUri;
        });
        Database database = Database.builder().setDatabaseName(schemaName).setLocation(location).setOwnerType(PrincipalType.USER).setOwnerName(session.getUser()).build();
        this.metastore.createDatabase(new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource()), database);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        if (!this.listTables(session, schemaName).isEmpty() || !this.listViews(session, schemaName).isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + schemaName);
        }
        this.metastore.dropDatabase(new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource()), schemaName);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        this.metastore.renameDatabase(new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource()), source, target);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        PrestoTableType tableType = HiveTableProperties.isExternalTable(tableMetadata.getProperties()) ? PrestoTableType.EXTERNAL_TABLE : PrestoTableType.MANAGED_TABLE;
        Table table = this.prepareTable(session, tableMetadata, tableType);
        PrincipalPrivileges principalPrivileges = HiveMetadata.buildInitialPrivilegeSet(table.getOwner());
        HiveBasicStatistics basicStatistics = table.getPartitionColumns().isEmpty() ? HiveBasicStatistics.createZeroStatistics() : HiveBasicStatistics.createEmptyStatistics();
        this.metastore.createTable(session, table, principalPrivileges, Optional.empty(), ignoreExisting, new PartitionStatistics(basicStatistics, (Map)ImmutableMap.of()));
    }

    private Table prepareTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, PrestoTableType tableType) {
        Path targetPath;
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if ((bucketProperty.isPresent() || !partitionedBy.isEmpty()) && HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties()) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketing/Partitioning columns not supported when Avro schema url is set");
        }
        List<HiveColumnHandle> columnHandles = HiveMetadata.getColumnHandles(tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy), this.typeTranslator);
        HiveStorageFormat hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        List<SortingColumn> preferredOrderingColumns = HiveTableProperties.getPreferredOrderingColumns(tableMetadata.getProperties());
        Optional<TableEncryptionProperties> tableEncryptionProperties = this.getTableEncryptionPropertiesFromTableProperties(tableMetadata, hiveStorageFormat, partitionedBy);
        if (tableEncryptionProperties.isPresent() && partitionedBy.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_ENCRYPTION_OPERATION, "Creating an encrypted table without partitions is not supported. Use CREATE TABLE AS SELECT to create an encrypted table without partitions");
        }
        this.validateColumns(hiveStorageFormat, columnHandles);
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List<Column> partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(column -> new Column(column.getName(), column.getHiveType(), column.getComment())).collect(Collectors.toList());
        this.checkPartitionTypesSupported(partitionColumns);
        if (tableType.equals((Object)PrestoTableType.EXTERNAL_TABLE)) {
            if (!this.createsOfNonManagedTablesEnabled) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot create non-managed Hive table");
            }
            String externalLocation = HiveTableProperties.getExternalLocation(tableMetadata.getProperties());
            targetPath = this.getExternalPath(new HdfsContext(session, schemaName, tableName, externalLocation, true), externalLocation);
        } else if (tableType.equals((Object)PrestoTableType.MANAGED_TABLE) || tableType.equals((Object)PrestoTableType.MATERIALIZED_VIEW)) {
            LocationHandle locationHandle = this.locationService.forNewTable(this.metastore, session, schemaName, tableName, HiveMetadata.isTempPathRequired(session, bucketProperty, preferredOrderingColumns));
            targetPath = this.locationService.getQueryWriteInfo(locationHandle).getTargetPath();
        } else {
            throw new IllegalStateException(String.format("%s is not a valid table type to be created.", tableType));
        }
        Map<String, String> tableProperties = this.getEmptyTableProperties(tableMetadata, new HdfsContext(session, schemaName, tableName, targetPath.toString(), true), hiveStorageFormat, tableEncryptionProperties);
        return HiveMetadata.buildTableObject(session.getQueryId(), schemaName, tableName, session.getUser(), columnHandles, hiveStorageFormat, partitionedBy, bucketProperty, preferredOrderingColumns, tableProperties, targetPath, tableType, this.prestoVersion);
    }

    public ConnectorTableHandle createTemporaryTable(ConnectorSession session, List<ColumnMetadata> columns, Optional<ConnectorPartitioningMetadata> partitioningMetadata) {
        String schemaName = HiveSessionProperties.getTemporaryTableSchema(session);
        HiveStorageFormat storageFormat = HiveSessionProperties.getTemporaryTableStorageFormat(session);
        Optional<HiveBucketProperty> bucketProperty = partitioningMetadata.map(partitioning -> {
            Set allColumns = (Set)columns.stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
            if (!allColumns.containsAll(partitioning.getPartitionColumns())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Bucketing columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf((Collection)partitioning.getPartitionColumns()), (Set)allColumns)));
            }
            HivePartitioningHandle partitioningHandle = (HivePartitioningHandle)partitioning.getPartitioningHandle();
            List partitionColumns = partitioning.getPartitionColumns();
            BucketFunctionType bucketFunctionType = partitioningHandle.getBucketFunctionType();
            switch (bucketFunctionType) {
                case HIVE_COMPATIBLE: {
                    return new HiveBucketProperty(partitionColumns, partitioningHandle.getBucketCount(), (List)ImmutableList.of(), BucketFunctionType.HIVE_COMPATIBLE, Optional.empty());
                }
                case PRESTO_NATIVE: {
                    Map<String, Type> columnNameToTypeMap = columns.stream().collect(Collectors.toMap(ColumnMetadata::getName, ColumnMetadata::getType));
                    return new HiveBucketProperty(partitionColumns, partitioningHandle.getBucketCount(), (List)ImmutableList.of(), BucketFunctionType.PRESTO_NATIVE, Optional.of(partitionColumns.stream().map(columnNameToTypeMap::get).collect(ImmutableList.toImmutableList())));
                }
            }
            throw new IllegalArgumentException("Unsupported bucket function type " + bucketFunctionType);
        });
        if (HiveSessionProperties.isUsePageFileForHiveUnsupportedType(session) && !columns.stream().map(ColumnMetadata::getType).allMatch(HiveTypeTranslator::isSupportedHiveType)) {
            storageFormat = HiveStorageFormat.PAGEFILE;
        }
        Optional<HiveType> defaultHiveType = storageFormat == HiveStorageFormat.PAGEFILE ? Optional.of(HiveType.HIVE_BINARY) : Optional.empty();
        List<HiveColumnHandle> columnHandles = HiveMetadata.getColumnHandles(HiveUtil.translateHiveUnsupportedTypesForTemporaryTable(columns, this.typeManager), (Set<String>)ImmutableSet.of(), this.typeTranslator, defaultHiveType);
        this.validateColumns(storageFormat, columnHandles);
        HiveStorageFormat finalStorageFormat = storageFormat;
        String tableName = PRESTO_TEMPORARY_TABLE_NAME_PREFIX + finalStorageFormat.name() + "_" + UUID.randomUUID().toString().replaceAll("-", "_");
        Table table = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(session.getUser()).setTableType(PrestoTableType.TEMPORARY_TABLE).setDataColumns((List)columnHandles.stream().map(handle -> new Column(handle.getName(), handle.getHiveType(), handle.getComment())).collect(ImmutableList.toImmutableList())).withStorage(storage -> storage.setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)finalStorageFormat)).setBucketProperty(bucketProperty).setLocation("")).build();
        List partitionColumnNames = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        List<HiveColumnHandle> hiveColumnHandles = HiveUtil.hiveColumnHandles(table);
        Map columnTypes = (Map)hiveColumnHandles.stream().filter(columnHandle -> !columnHandle.isHidden()).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager)));
        Map columnStatisticTypes = (Map)hiveColumnHandles.stream().filter(columnHandle -> !partitionColumnNames.contains(columnHandle.getName())).filter(column -> !column.isHidden()).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> ImmutableSet.copyOf(this.getSupportedColumnStatisticsForTemporaryTable(this.typeManager.getType(column.getTypeSignature())))));
        this.metastore.createTable(session, table, HiveMetadata.buildInitialPrivilegeSet(table.getOwner()), Optional.empty(), false, Statistics.createEmptyPartitionStatistics((Map)columnTypes, (Map)columnStatisticTypes));
        return new HiveTableHandle(schemaName, tableName);
    }

    private Set<ColumnStatisticType> getSupportedColumnStatisticsForTemporaryTable(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return ImmutableSet.of((Object)ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES, (Object)ColumnStatisticType.NUMBER_OF_TRUE_VALUES);
        }
        if (TypeUtils.isNumericType((Type)type) || type.equals(DateType.DATE) || type.equals(TimestampType.TIMESTAMP)) {
            return ImmutableSet.of((Object)ColumnStatisticType.MIN_VALUE, (Object)ColumnStatisticType.MAX_VALUE, (Object)ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES, (Object)ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES);
        }
        if (Varchars.isVarcharType((Type)type) || Chars.isCharType((Type)type)) {
            return ImmutableSet.of((Object)ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES, (Object)ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES, (Object)ColumnStatisticType.TOTAL_SIZE_IN_BYTES, (Object)ColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES);
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return ImmutableSet.of((Object)ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES, (Object)ColumnStatisticType.TOTAL_SIZE_IN_BYTES, (Object)ColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES);
        }
        if (type instanceof ArrayType || type instanceof RowType || type instanceof MapType) {
            return ImmutableSet.of((Object)ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES, (Object)ColumnStatisticType.TOTAL_SIZE_IN_BYTES);
        }
        return ImmutableSet.of((Object)ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES, (Object)ColumnStatisticType.TOTAL_SIZE_IN_BYTES);
    }

    private void validateColumns(HiveStorageFormat hiveStorageFormat, List<HiveColumnHandle> handles) {
        if (hiveStorageFormat == HiveStorageFormat.AVRO) {
            for (HiveColumnHandle handle : handles) {
                if (handle.isPartitionKey()) continue;
                HiveMetadata.validateAvroType(handle.getHiveType().getTypeInfo(), handle.getName());
            }
        }
    }

    private static void validateAvroType(TypeInfo type, String columnName) {
        if (type.getCategory() == ObjectInspector.Category.MAP) {
            TypeInfo keyType = HiveMetadata.mapTypeInfo(type).getMapKeyTypeInfo();
            if (keyType.getCategory() != ObjectInspector.Category.PRIMITIVE || HiveMetadata.primitiveTypeInfo(keyType).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column %s has a non-varchar map key, which is not supported by Avro", columnName));
            }
        } else if (type.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector.PrimitiveCategory primitive = HiveMetadata.primitiveTypeInfo(type).getPrimitiveCategory();
            if (primitive == PrimitiveObjectInspector.PrimitiveCategory.BYTE) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column %s is tinyint, which is not supported by Avro. Use integer instead.", columnName));
            }
            if (primitive == PrimitiveObjectInspector.PrimitiveCategory.SHORT) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column %s is smallint, which is not supported by Avro. Use integer instead.", columnName));
            }
        }
    }

    private static PrimitiveTypeInfo primitiveTypeInfo(TypeInfo typeInfo) {
        return (PrimitiveTypeInfo)typeInfo;
    }

    private static MapTypeInfo mapTypeInfo(TypeInfo typeInfo) {
        return (MapTypeInfo)typeInfo;
    }

    private Map<String, String> getEmptyTableProperties(ConnectorTableMetadata tableMetadata, HdfsContext hdfsContext, HiveStorageFormat hiveStorageFormat, Optional<TableEncryptionProperties> tableEncryptionProperties) {
        String avroSchemaUrl;
        ImmutableMap.Builder tableProperties = ImmutableMap.builder();
        tableProperties.putAll(this.tableParameterCodec.encode(tableMetadata.getProperties()));
        List<String> columns = HiveTableProperties.getOrcBloomFilterColumns(tableMetadata.getProperties());
        if (columns != null && !columns.isEmpty()) {
            tableProperties.put((Object)ORC_BLOOM_FILTER_COLUMNS_KEY, (Object)Joiner.on((char)',').join(columns));
            tableProperties.put((Object)ORC_BLOOM_FILTER_FPP_KEY, (Object)String.valueOf(HiveTableProperties.getOrcBloomFilterFpp(tableMetadata.getProperties())));
        }
        if ((avroSchemaUrl = HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties())) != null) {
            if (hiveStorageFormat != HiveStorageFormat.AVRO) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Cannot specify %s table property for storage format: %s", "avro_schema_url", hiveStorageFormat));
            }
            tableProperties.put((Object)"avro.schema.url", (Object)this.validateAndNormalizeAvroSchemaUrl(avroSchemaUrl, hdfsContext));
        }
        HiveTableProperties.getCsvProperty(tableMetadata.getProperties(), "csv_escape").ifPresent(escape -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_escape");
            tableProperties.put((Object)CSV_ESCAPE_KEY, (Object)escape.toString());
        });
        HiveTableProperties.getCsvProperty(tableMetadata.getProperties(), "csv_quote").ifPresent(quote -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_quote");
            tableProperties.put((Object)CSV_QUOTE_KEY, (Object)quote.toString());
        });
        HiveTableProperties.getCsvProperty(tableMetadata.getProperties(), "csv_separator").ifPresent(separator -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_separator");
            tableProperties.put((Object)CSV_SEPARATOR_KEY, (Object)separator.toString());
        });
        tableMetadata.getComment().ifPresent(value -> tableProperties.put((Object)TABLE_COMMENT, value));
        tableProperties.putAll(tableEncryptionProperties.map(TableEncryptionProperties::toHiveProperties).orElseGet(ImmutableMap::of));
        return tableProperties.build();
    }

    private static void checkFormatForProperty(HiveStorageFormat actualStorageFormat, HiveStorageFormat expectedStorageFormat, String propertyName) {
        if (actualStorageFormat != expectedStorageFormat) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Cannot specify %s table property for storage format: %s", propertyName, actualStorageFormat));
        }
    }

    private String validateAndNormalizeAvroSchemaUrl(String url, HdfsContext context) {
        try {
            new URL(url).openStream().close();
            return url;
        }
        catch (MalformedURLException e) {
            if (new File(url).exists()) {
                return new File(url).toURI().toString();
            }
            try {
                if (!this.hdfsEnvironment.getFileSystem(context, new Path(url)).exists(new Path(url))) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Cannot locate Avro schema file: " + url);
                }
                return url;
            }
            catch (IOException ex) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Avro schema file is not a valid file system URI: " + url, (Throwable)ex);
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Cannot open Avro schema file: " + url, (Throwable)e);
        }
    }

    private Path getExternalPath(HdfsContext context, String location) {
        try {
            Path path = new Path(location);
            if (!this.hdfsEnvironment.getFileSystem(context, path).isDirectory(path)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location must be a directory");
            }
            return path;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location is not a valid file system URI", (Throwable)e);
        }
    }

    private void checkPartitionTypesSupported(List<Column> partitionColumns) {
        for (Column partitionColumn : partitionColumns) {
            Type partitionType = this.typeManager.getType(partitionColumn.getType().getTypeSignature());
            HiveUtil.verifyPartitionTypeSupported(partitionColumn.getName(), partitionType);
        }
    }

    private static Table buildTableObject(String queryId, String schemaName, String tableName, String tableOwner, List<HiveColumnHandle> columnHandles, HiveStorageFormat hiveStorageFormat, List<String> partitionedBy, Optional<HiveBucketProperty> bucketProperty, List<SortingColumn> preferredOrderingColumns, Map<String, String> additionalTableParameters, Path targetPath, PrestoTableType tableType, String prestoVersion) {
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(column -> new Column(column.getName(), column.getHiveType(), column.getComment())).collect(Collectors.toList());
        ImmutableSet partitionColumnNames = ImmutableSet.copyOf(partitionedBy);
        ImmutableList.Builder columns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : columnHandles) {
            String name = columnHandle.getName();
            HiveType type = columnHandle.getHiveType();
            if (!partitionColumnNames.contains(name)) {
                Verify.verify((!columnHandle.isPartitionKey() ? 1 : 0) != 0, (String)"Column handles are not consistent with partitioned by property", (Object[])new Object[0]);
                columns.add((Object)new Column(name, type, columnHandle.getComment()));
                continue;
            }
            Verify.verify((boolean)columnHandle.isPartitionKey(), (String)"Column handles are not consistent with partitioned by property", (Object[])new Object[0]);
        }
        ImmutableMap.Builder tableParameters = ImmutableMap.builder().put((Object)PRESTO_VERSION_NAME, (Object)prestoVersion).put((Object)"presto_query_id", (Object)queryId).putAll(additionalTableParameters);
        if (tableType.equals((Object)PrestoTableType.EXTERNAL_TABLE)) {
            tableParameters.put((Object)"EXTERNAL", (Object)"TRUE");
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(tableOwner).setTableType(tableType).setDataColumns((List)columns.build()).setPartitionColumns(partitionColumns).setParameters((Map)tableParameters.build());
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)hiveStorageFormat)).setBucketProperty(bucketProperty).setParameters((Map)ImmutableMap.of((Object)"preferred_ordering_columns", (Object)HiveMetadata.encodePreferredOrderingColumns(preferredOrderingColumns))).setLocation(targetPath.toString());
        return tableBuilder.build();
    }

    private static PrincipalPrivileges buildInitialPrivilegeSet(String tableOwner) {
        PrestoPrincipal owner = new PrestoPrincipal(PrincipalType.USER, tableOwner);
        return new PrincipalPrivileges((Multimap)ImmutableMultimap.builder().put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, true, owner, owner)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.INSERT, true, owner, owner)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.UPDATE, true, owner, owner)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.DELETE, true, owner, owner)).build(), (Multimap)ImmutableMultimap.of());
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(session, handle);
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        this.metastore.addColumn(metastoreContext, handle.getSchemaName(), handle.getTableName(), column.getName(), HiveType.toHiveType((TypeTranslator)this.typeTranslator, (Type)column.getType()), column.getComment());
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(session, hiveTableHandle);
        HiveColumnHandle sourceHandle = (HiveColumnHandle)source;
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        this.metastore.renameColumn(metastoreContext, hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName(), sourceHandle.getName(), target);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(session, hiveTableHandle);
        HiveColumnHandle columnHandle = (HiveColumnHandle)column;
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        this.metastore.dropColumn(metastoreContext, hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName(), columnHandle.getName());
    }

    private void failIfAvroSchemaIsSet(ConnectorSession session, HiveTableHandle handle) {
        String tableName = handle.getTableName();
        String schemaName = handle.getSchemaName();
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Optional table = this.metastore.getTable(metastoreContext, schemaName, tableName);
        if (!table.isPresent()) {
            throw new TableNotFoundException(new SchemaTableName(schemaName, tableName));
        }
        if (((Table)table.get()).getParameters().get("avro.schema.url") != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ALTER TABLE not supported when Avro schema url is set");
        }
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        this.metastore.renameTable(metastoreContext, handle.getSchemaName(), handle.getTableName(), newTableName.getSchemaName(), newTableName.getTableName());
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Optional target = this.metastore.getTable(metastoreContext, handle.getSchemaName(), handle.getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        this.metastore.dropTable(new HdfsContext(session, handle.getSchemaName(), handle.getTableName(), ((Table)target.get()).getStorage().getLocation(), false), handle.getSchemaName(), handle.getTableName());
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.verifyJvmTimeZone();
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = handle.getSchemaTableName();
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        this.metastore.getTable(metastoreContext, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        return handle;
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = handle.getSchemaTableName();
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Table table = (Table)this.metastore.getTable(metastoreContext, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        List partitionColumns = table.getPartitionColumns();
        List partitionColumnNames = (List)partitionColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        List<HiveColumnHandle> hiveColumnHandles = HiveUtil.hiveColumnHandles(table);
        Map columnTypes = (Map)hiveColumnHandles.stream().filter(columnHandle -> !columnHandle.isHidden()).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager)));
        Map computedStatisticsMap = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, (List)partitionColumnNames, (Map)columnTypes);
        if (partitionColumns.isEmpty()) {
            this.metastore.setTableStatistics(metastoreContext, table, this.createPartitionStatistics(session, columnTypes, (ComputedStatistics)computedStatisticsMap.get(ImmutableList.of())));
        } else {
            List partitionValuesList = handle.getAnalyzePartitionValues().isPresent() ? handle.getAnalyzePartitionValues().get() : (List)((List)this.metastore.getPartitionNames(metastoreContext, handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(((HiveTableHandle)tableHandle).getSchemaTableName()))).stream().map(MetastoreUtil::toPartitionValues).collect(ImmutableList.toImmutableList());
            ImmutableMap.Builder partitionStatistics = ImmutableMap.builder();
            Map columnStatisticTypes = (Map)hiveColumnHandles.stream().filter(columnHandle -> !partitionColumnNames.contains(columnHandle.getName())).filter(column -> !column.isHidden()).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> ImmutableSet.copyOf((Collection)this.metastore.getSupportedColumnStatistics(metastoreContext, this.typeManager.getType(column.getTypeSignature())))));
            Supplier emptyPartitionStatistics = Suppliers.memoize(() -> Statistics.createEmptyPartitionStatistics((Map)columnTypes, (Map)columnStatisticTypes));
            int usedComputedStatistics = 0;
            for (List partitionValues : partitionValuesList) {
                ComputedStatistics collectedStatistics = (ComputedStatistics)computedStatisticsMap.get(partitionValues);
                if (collectedStatistics == null) {
                    partitionStatistics.put((Object)partitionValues, emptyPartitionStatistics.get());
                    continue;
                }
                ++usedComputedStatistics;
                partitionStatistics.put((Object)partitionValues, (Object)this.createPartitionStatistics(session, columnTypes, collectedStatistics));
            }
            Verify.verify((usedComputedStatistics == computedStatistics.size() ? 1 : 0) != 0, (String)"All computed statistics must be used", (Object[])new Object[0]);
            this.metastore.setPartitionStatistics(metastoreContext, table, (Map)partitionStatistics.build());
        }
    }

    public HiveOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        this.verifyJvmTimeZone();
        if (HiveTableProperties.getExternalLocation(tableMetadata.getProperties()) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "External tables cannot be created using CREATE TABLE AS");
        }
        if (HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties()) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE AS not supported when Avro schema url is set");
        }
        HiveStorageFormat tableStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        List<SortingColumn> preferredOrderingColumns = HiveTableProperties.getPreferredOrderingColumns(tableMetadata.getProperties());
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Optional<TableEncryptionProperties> tableEncryptionProperties = this.getTableEncryptionPropertiesFromTableProperties(tableMetadata, tableStorageFormat, partitionedBy);
        List<HiveColumnHandle> columnHandles = HiveMetadata.getColumnHandles(tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy), this.typeTranslator);
        HiveStorageFormat partitionStorageFormat = HiveSessionProperties.isRespectTableFormat(session) ? tableStorageFormat : HiveSessionProperties.getHiveStorageFormat(session);
        HiveStorageFormat actualStorageFormat = partitionedBy.isEmpty() ? tableStorageFormat : partitionStorageFormat;
        this.validateColumns(actualStorageFormat, columnHandles);
        if (tableEncryptionProperties.isPresent() && tableStorageFormat != actualStorageFormat) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("For encrypted tables, partition format (%s) should match table format (%s). Using the session property %s or appropriately setting %s can help with ensuring this", actualStorageFormat.name(), tableStorageFormat.name(), "respect_table_format", "hive_storage_format"));
        }
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List<Column> partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(column -> new Column(column.getName(), column.getHiveType(), column.getComment())).collect(Collectors.toList());
        this.checkPartitionTypesSupported(partitionColumns);
        LocationHandle locationHandle = this.locationService.forNewTable(this.metastore, session, schemaName, tableName, HiveMetadata.isTempPathRequired(session, bucketProperty, preferredOrderingColumns));
        HdfsContext context = new HdfsContext(session, schemaName, tableName, locationHandle.getTargetPath().toString(), true);
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Map<String, String> tableProperties = this.getEmptyTableProperties(tableMetadata, context, tableStorageFormat, tableEncryptionProperties);
        HiveOutputTableHandle result = new HiveOutputTableHandle(schemaName, tableName, columnHandles, session.getQueryId(), this.metastore.generatePageSinkMetadata(metastoreContext, schemaTableName), locationHandle, tableStorageFormat, partitionStorageFormat, actualStorageFormat, this.getHiveCompressionCodec(session, false, actualStorageFormat), partitionedBy, bucketProperty, preferredOrderingColumns, session.getUser(), tableProperties, this.encryptionInformationProvider.getWriteEncryptionInformation(session, tableEncryptionProperties, schemaName, tableName));
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.declareIntentionToWrite(context, metastoreContext, writeInfo.getWriteMode(), writeInfo.getWritePath(), writeInfo.getTempPath(), result.getFilePrefix(), schemaTableName, false);
        return result;
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        PartitionStatistics tableStatistics;
        EncryptionInformation encryptionInformation;
        HiveOutputTableHandle handle = (HiveOutputTableHandle)tableHandle;
        List<PartitionUpdate> partitionUpdates = this.getPartitionUpdates(session, fragments);
        ImmutableMap tableEncryptionParameters = ImmutableMap.of();
        ImmutableMap partitionEncryptionParameters = ImmutableMap.of();
        if (handle.getEncryptionInformation().isPresent() && (encryptionInformation = handle.getEncryptionInformation().get()).getDwrfEncryptionMetadata().isPresent()) {
            if (handle.getPartitionedBy().isEmpty()) {
                tableEncryptionParameters = ImmutableMap.copyOf(encryptionInformation.getDwrfEncryptionMetadata().get().getExtraMetadata());
            } else {
                partitionEncryptionParameters = ImmutableMap.copyOf(encryptionInformation.getDwrfEncryptionMetadata().get().getExtraMetadata());
            }
        }
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(handle.getLocationHandle());
        Table table = HiveMetadata.buildTableObject(session.getQueryId(), handle.getSchemaName(), handle.getTableName(), handle.getTableOwner(), handle.getInputColumns(), handle.getTableStorageFormat(), handle.getPartitionedBy(), handle.getBucketProperty(), handle.getPreferredOrderingColumns(), (Map<String, String>)ImmutableMap.builder().putAll(handle.getAdditionalTableParameters()).putAll((Map)tableEncryptionParameters).build(), writeInfo.getTargetPath(), PrestoTableType.MANAGED_TABLE, this.prestoVersion);
        PrincipalPrivileges principalPrivileges = HiveMetadata.buildInitialPrivilegeSet(handle.getTableOwner());
        partitionUpdates = PartitionUpdate.mergePartitionUpdates(partitionUpdates);
        if (handle.getBucketProperty().isPresent()) {
            ImmutableList<PartitionUpdate> partitionUpdatesForMissingBuckets = this.computePartitionUpdatesForMissingBuckets(session, handle, table, partitionUpdates);
            partitionUpdates = PartitionUpdate.mergePartitionUpdates(Iterables.concat(partitionUpdates, partitionUpdatesForMissingBuckets));
            HdfsContext hdfsContext = new HdfsContext(session, table.getDatabaseName(), table.getTableName(), table.getStorage().getLocation(), true);
            for (PartitionUpdate partitionUpdate : partitionUpdatesForMissingBuckets) {
                Optional<Partition> partition = table.getPartitionColumns().isEmpty() ? Optional.empty() : Optional.of(this.partitionObjectBuilder.buildPartitionObject(session, table, partitionUpdate, this.prestoVersion, (Map<String, String>)partitionEncryptionParameters));
                this.zeroRowFileCreator.createFiles(session, hdfsContext, partitionUpdate.getWritePath(), this.getTargetFileNames(partitionUpdate.getFileWriteInfos()), this.getStorageFormat(partition, table), handle.getCompressionCodec(), this.getSchema(partition, table));
            }
        }
        Map columnTypes = (Map)handle.getInputColumns().stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager)));
        Map partitionComputedStatistics = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, handle.getPartitionedBy(), (Map)columnTypes);
        if (table.getPartitionColumns().isEmpty()) {
            HiveBasicStatistics basicStatistics = partitionUpdates.stream().map(PartitionUpdate::getStatistics).reduce((first, second) -> Statistics.reduce((HiveBasicStatistics)first, (HiveBasicStatistics)second, (Statistics.ReduceOperator)Statistics.ReduceOperator.ADD)).orElse(HiveBasicStatistics.createZeroStatistics());
            tableStatistics = this.createPartitionStatistics(session, basicStatistics, columnTypes, this.getColumnStatistics(partitionComputedStatistics, (List<String>)ImmutableList.of()));
        } else {
            tableStatistics = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of());
        }
        this.metastore.createTable(session, table, principalPrivileges, Optional.of(writeInfo.getWritePath()), false, tableStatistics);
        if (handle.getPartitionedBy().isEmpty()) {
            return Optional.of(new HiveWrittenPartitions((List<String>)ImmutableList.of((Object)"<UNPARTITIONED>")));
        }
        if (HiveSessionProperties.isRespectTableFormat(session)) {
            Verify.verify((handle.getPartitionStorageFormat() == handle.getTableStorageFormat() ? 1 : 0) != 0);
        }
        for (PartitionUpdate update : partitionUpdates) {
            Object partitionParameters = partitionEncryptionParameters;
            if (HiveSessionProperties.isPreferManifestsToListFiles(session) && HiveSessionProperties.isFileRenamingEnabled(session)) {
                partitionParameters = HiveManifestUtils.updatePartitionMetadataWithFileNamesAndSizes(update, (Map<String, String>)partitionParameters);
            }
            Partition partition = this.partitionObjectBuilder.buildPartitionObject(session, table, update, this.prestoVersion, (Map<String, String>)partitionParameters);
            PartitionStatistics partitionStatistics = this.createPartitionStatistics(session, update.getStatistics(), columnTypes, this.getColumnStatistics(partitionComputedStatistics, partition.getValues()));
            this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), table.getStorage().getLocation(), true, this.partitionObjectBuilder.buildPartitionObject(session, table, update, this.prestoVersion, (Map<String, String>)partitionParameters), update.getWritePath(), partitionStatistics);
        }
        return Optional.of(new HiveWrittenPartitions(partitionUpdates.stream().map(PartitionUpdate::getName).collect(Collectors.toList())));
    }

    public static boolean shouldCreateFilesForMissingBuckets(Table table, ConnectorSession session) {
        return !table.getTableType().equals((Object)PrestoTableType.TEMPORARY_TABLE) || HiveSessionProperties.shouldCreateEmptyBucketFilesForTemporaryTable(session);
    }

    private Properties getSchema(Optional<Partition> partition, Table table) {
        return partition.isPresent() ? MetastoreUtil.getHiveSchema((Partition)partition.get(), (Table)table) : MetastoreUtil.getHiveSchema((Table)table);
    }

    private StorageFormat getStorageFormat(Optional<Partition> partition, Table table) {
        return partition.isPresent() ? partition.get().getStorage().getStorageFormat() : table.getStorage().getStorageFormat();
    }

    private ImmutableList<PartitionUpdate> computePartitionUpdatesForMissingBuckets(ConnectorSession session, HiveWritableTableHandle handle, Table table, List<PartitionUpdate> partitionUpdates) {
        HiveStorageFormat storageFormat;
        if (!HiveMetadata.shouldCreateFilesForMissingBuckets(table, session)) {
            return ImmutableList.of();
        }
        HiveStorageFormat hiveStorageFormat = storageFormat = table.getPartitionColumns().isEmpty() ? handle.getTableStorageFormat() : handle.getPartitionStorageFormat();
        if (table.getPartitionColumns().isEmpty() && partitionUpdates.isEmpty()) {
            int bucketCount = handle.getBucketProperty().get().getBucketCount();
            LocationHandle locationHandle = handle.getLocationHandle();
            List<String> fileNamesForMissingBuckets = this.computeFileNamesForMissingBuckets(session, storageFormat, handle.getCompressionCodec(), handle.getFilePrefix(), bucketCount, (Set<String>)ImmutableSet.of());
            return ImmutableList.of((Object)new PartitionUpdate("", handle instanceof HiveInsertTableHandle ? PartitionUpdate.UpdateMode.APPEND : PartitionUpdate.UpdateMode.NEW, locationHandle.getWritePath(), locationHandle.getTargetPath(), (List<PartitionUpdate.FileWriteInfo>)((List)fileNamesForMissingBuckets.stream().map(fileName -> new PartitionUpdate.FileWriteInfo((String)fileName, (String)fileName, Optional.of(0L))).collect(ImmutableList.toImmutableList())), 0L, 0L, 0L, HiveSessionProperties.isFileRenamingEnabled(session)));
        }
        ImmutableList.Builder partitionUpdatesForMissingBucketsBuilder = ImmutableList.builder();
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            int bucketCount = handle.getBucketProperty().get().getBucketCount();
            List<String> fileNamesForMissingBuckets = this.computeFileNamesForMissingBuckets(session, storageFormat, handle.getCompressionCodec(), handle.getFilePrefix(), bucketCount, (Set<String>)ImmutableSet.copyOf(this.getTargetFileNames(partitionUpdate.getFileWriteInfos())));
            partitionUpdatesForMissingBucketsBuilder.add((Object)new PartitionUpdate(partitionUpdate.getName(), partitionUpdate.getUpdateMode(), partitionUpdate.getWritePath(), partitionUpdate.getTargetPath(), (List<PartitionUpdate.FileWriteInfo>)((List)fileNamesForMissingBuckets.stream().map(fileName -> new PartitionUpdate.FileWriteInfo((String)fileName, (String)fileName, Optional.of(0L))).collect(ImmutableList.toImmutableList())), 0L, 0L, 0L, HiveSessionProperties.isFileRenamingEnabled(session)));
        }
        return partitionUpdatesForMissingBucketsBuilder.build();
    }

    private List<String> computeFileNamesForMissingBuckets(ConnectorSession session, HiveStorageFormat storageFormat, HiveCompressionCodec compressionCodec, String filePrefix, int bucketCount, Set<String> existingFileNames) {
        if (existingFileNames.size() == bucketCount) {
            return ImmutableList.of();
        }
        String fileExtension = HiveWriterFactory.getFileExtension(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)storageFormat), compressionCodec);
        ImmutableList.Builder missingFileNamesBuilder = ImmutableList.builder();
        for (int i = 0; i < bucketCount; ++i) {
            String targetFileName;
            String string = targetFileName = HiveSessionProperties.isFileRenamingEnabled(session) ? String.valueOf(i) : HiveWriterFactory.computeBucketedFileName(filePrefix, i) + fileExtension;
            if (existingFileNames.contains(targetFileName)) continue;
            missingFileNamesBuilder.add((Object)targetFileName);
        }
        ImmutableList missingFileNames = missingFileNamesBuilder.build();
        Verify.verify((existingFileNames.size() + missingFileNames.size() == bucketCount ? 1 : 0) != 0);
        return missingFileNames;
    }

    public HiveInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveStorageFormat actualStorageFormat;
        this.verifyJvmTimeZone();
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        Optional table = this.metastore.getTable(metastoreContext, tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        HiveWriteUtils.checkTableIsWritable((Table)table.get(), this.writesToNonManagedTablesEnabled);
        for (Column column : ((Table)table.get()).getDataColumns()) {
            if (HiveWriteUtils.isWritableType(column.getType())) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into Hive table %s.%s with column type %s not supported", ((Table)table.get()).getDatabaseName(), ((Table)table.get()).getTableName(), column.getType()));
        }
        List<HiveColumnHandle> handles = HiveUtil.hiveColumnHandles((Table)table.get()).stream().filter(columnHandle -> !columnHandle.isHidden()).collect(Collectors.toList());
        HiveStorageFormat tableStorageFormat = HiveMetadata.extractHiveStorageFormat((Table)table.get());
        boolean isTemporaryTable = ((Table)table.get()).getTableType().equals((Object)PrestoTableType.TEMPORARY_TABLE);
        boolean tempPathRequired = HiveMetadata.isTempPathRequired(session, table.map(Table::getStorage).flatMap(Storage::getBucketProperty), HiveMetadata.decodePreferredOrderingColumnsFromStorage(((Table)table.get()).getStorage()));
        LocationHandle locationHandle = isTemporaryTable ? this.locationService.forTemporaryTable(this.metastore, session, (Table)table.get(), tempPathRequired) : this.locationService.forExistingTable(this.metastore, session, (Table)table.get(), tempPathRequired);
        Optional<? extends TableEncryptionProperties> tableEncryptionProperties = this.getTableEncryptionPropertiesFromHiveProperties(((Table)table.get()).getParameters(), tableStorageFormat);
        HiveStorageFormat partitionStorageFormat = HiveSessionProperties.isRespectTableFormat(session) ? tableStorageFormat : HiveSessionProperties.getHiveStorageFormat(session);
        HiveStorageFormat hiveStorageFormat = actualStorageFormat = ((Table)table.get()).getPartitionColumns().isEmpty() ? tableStorageFormat : partitionStorageFormat;
        if (tableEncryptionProperties.isPresent() && actualStorageFormat != tableStorageFormat) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("For encrypted tables, partition format (%s) should match table format (%s). Using the session property %s or appropriately setting %s can help with ensuring this", actualStorageFormat.name(), tableStorageFormat.name(), "respect_table_format", "hive_storage_format"));
        }
        HiveInsertTableHandle result = new HiveInsertTableHandle(tableName.getSchemaName(), tableName.getTableName(), handles, session.getQueryId(), this.metastore.generatePageSinkMetadata(metastoreContext, tableName), locationHandle, ((Table)table.get()).getStorage().getBucketProperty(), HiveMetadata.decodePreferredOrderingColumnsFromStorage(((Table)table.get()).getStorage()), tableStorageFormat, partitionStorageFormat, actualStorageFormat, this.getHiveCompressionCodec(session, isTemporaryTable, actualStorageFormat), this.encryptionInformationProvider.getWriteEncryptionInformation(session, tableEncryptionProperties.map(Function.identity()), tableName.getSchemaName(), tableName.getTableName()));
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.declareIntentionToWrite(new HdfsContext(session, tableName.getSchemaName(), tableName.getTableName(), ((Table)table.get()).getStorage().getLocation(), false), metastoreContext, writeInfo.getWriteMode(), writeInfo.getWritePath(), writeInfo.getTempPath(), result.getFilePrefix(), tableName, isTemporaryTable);
        return result;
    }

    private HiveCompressionCodec getHiveCompressionCodec(ConnectorSession session, boolean isTemporaryTable, HiveStorageFormat storageFormat) {
        if (isTemporaryTable) {
            return HiveSessionProperties.getTemporaryTableCompressionCodec(session);
        }
        if (storageFormat == HiveStorageFormat.ORC || storageFormat == HiveStorageFormat.DWRF) {
            return HiveSessionProperties.getOrcCompressionCodec(session);
        }
        return HiveSessionProperties.getCompressionCodec(session);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        HiveInsertTableHandle handle = (HiveInsertTableHandle)insertHandle;
        List<PartitionUpdate> partitionUpdates = this.getPartitionUpdates(session, fragments);
        HiveStorageFormat tableStorageFormat = handle.getTableStorageFormat();
        partitionUpdates = PartitionUpdate.mergePartitionUpdates(partitionUpdates);
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Optional table = this.metastore.getTable(metastoreContext, handle.getSchemaName(), handle.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(new SchemaTableName(handle.getSchemaName(), handle.getTableName()));
        }
        if (!((Table)table.get()).getStorage().getStorageFormat().getInputFormat().equals(tableStorageFormat.getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Table format changed during insert");
        }
        if (handle.getBucketProperty().isPresent()) {
            ImmutableList<PartitionUpdate> partitionUpdatesForMissingBuckets = this.computePartitionUpdatesForMissingBuckets(session, handle, (Table)table.get(), partitionUpdates);
            partitionUpdates = PartitionUpdate.mergePartitionUpdates(Iterables.concat(partitionUpdates, partitionUpdatesForMissingBuckets));
            HdfsContext hdfsContext = new HdfsContext(session, ((Table)table.get()).getDatabaseName(), ((Table)table.get()).getTableName(), ((Table)table.get()).getStorage().getLocation(), false);
            for (PartitionUpdate partitionUpdate : partitionUpdatesForMissingBuckets) {
                Optional<Partition> partition = ((Table)table.get()).getPartitionColumns().isEmpty() ? Optional.empty() : Optional.of(this.partitionObjectBuilder.buildPartitionObject(session, (Table)table.get(), partitionUpdate, this.prestoVersion, handle.getEncryptionInformation().map(encryptionInfo -> encryptionInfo.getDwrfEncryptionMetadata().map(DwrfEncryptionMetadata::getExtraMetadata).orElseGet(ImmutableMap::of)).orElseGet(ImmutableMap::of)));
                this.zeroRowFileCreator.createFiles(session, hdfsContext, partitionUpdate.getWritePath(), this.getTargetFileNames(partitionUpdate.getFileWriteInfos()), this.getStorageFormat(partition, (Table)table.get()), handle.getCompressionCodec(), this.getSchema(partition, (Table)table.get()));
            }
        }
        List partitionedBy = (List)((Table)table.get()).getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        Map columnTypes = (Map)handle.getInputColumns().stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager)));
        Map partitionComputedStatistics = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, (List)partitionedBy, (Map)columnTypes);
        Set<String> existingPartitions = this.getExistingPartitionNames(session.getIdentity(), metastoreContext, handle.getSchemaName(), handle.getTableName(), partitionUpdates);
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            if (partitionUpdate.getName().isEmpty()) {
                if (handle.getEncryptionInformation().isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_ENCRYPTION_OPERATION, "Inserting into an existing table with encryption enabled is not supported yet");
                }
                PartitionStatistics partitionStatistics = this.createPartitionStatistics(session, partitionUpdate.getStatistics(), columnTypes, this.getColumnStatistics(partitionComputedStatistics, (List<String>)ImmutableList.of()));
                this.metastore.finishInsertIntoExistingTable(session, handle.getSchemaName(), handle.getTableName(), partitionUpdate.getWritePath(), this.getTargetFileNames(partitionUpdate.getFileWriteInfos()), partitionStatistics);
                continue;
            }
            if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.APPEND) {
                if (handle.getEncryptionInformation().isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_ENCRYPTION_OPERATION, "Inserting into an existing partition with encryption enabled is not supported yet");
                }
                List partitionValues = MetastoreUtil.toPartitionValues((String)partitionUpdate.getName());
                PartitionStatistics partitionStatistics = this.createPartitionStatistics(session, partitionUpdate.getStatistics(), columnTypes, this.getColumnStatistics(partitionComputedStatistics, partitionValues));
                this.metastore.finishInsertIntoExistingPartition(session, handle.getSchemaName(), handle.getTableName(), handle.getLocationHandle().getTargetPath().toString(), partitionValues, partitionUpdate.getWritePath(), this.getTargetFileNames(partitionUpdate.getFileWriteInfos()), partitionStatistics);
                continue;
            }
            if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.NEW || partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
                Map<String, String> extraPartitionMetadata = handle.getEncryptionInformation().map(encryptionInfo -> encryptionInfo.getDwrfEncryptionMetadata().map(DwrfEncryptionMetadata::getExtraMetadata).orElseGet(ImmutableMap::of)).orElseGet(ImmutableMap::of);
                if (HiveSessionProperties.isPreferManifestsToListFiles(session) && HiveSessionProperties.isFileRenamingEnabled(session)) {
                    extraPartitionMetadata = HiveManifestUtils.updatePartitionMetadataWithFileNamesAndSizes(partitionUpdate, extraPartitionMetadata);
                }
                HiveManifestUtils.getManifestSizeInBytes(session, partitionUpdate, extraPartitionMetadata).ifPresent(this.hivePartitionStats::addManifestSizeInBytes);
                Partition partition = this.partitionObjectBuilder.buildPartitionObject(session, (Table)table.get(), partitionUpdate, this.prestoVersion, extraPartitionMetadata);
                if (!partition.getStorage().getStorageFormat().getInputFormat().equals(handle.getPartitionStorageFormat().getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Partition format changed during insert");
                }
                if (existingPartitions.contains(partitionUpdate.getName())) {
                    if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
                        this.metastore.dropPartition(session, handle.getSchemaName(), handle.getTableName(), handle.getLocationHandle().getTargetPath().toString(), partition.getValues());
                    } else {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Cannot insert into an existing partition of Hive table: " + partitionUpdate.getName());
                    }
                }
                PartitionStatistics partitionStatistics = this.createPartitionStatistics(session, partitionUpdate.getStatistics(), columnTypes, this.getColumnStatistics(partitionComputedStatistics, partition.getValues()));
                this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), ((Table)table.get()).getStorage().getLocation(), false, partition, partitionUpdate.getWritePath(), partitionStatistics);
                continue;
            }
            throw new IllegalArgumentException(String.format("Unsupported update mode: %s", new Object[]{partitionUpdate.getUpdateMode()}));
        }
        return Optional.of(new HiveWrittenPartitions(partitionUpdates.stream().map(PartitionUpdate::getName).map(name -> name.isEmpty() ? "<UNPARTITIONED>" : name).collect(Collectors.toList())));
    }

    private static boolean isTempPathRequired(ConnectorSession session, Optional<HiveBucketProperty> bucketProperty, List<SortingColumn> preferredOrderingColumns) {
        boolean hasSortedWrite = bucketProperty.map(property -> !property.getSortedBy().isEmpty()).orElse(false) != false || !preferredOrderingColumns.isEmpty();
        return HiveSessionProperties.isSortedWriteToTempPathEnabled(session) && hasSortedWrite;
    }

    private List<String> getTargetFileNames(List<PartitionUpdate.FileWriteInfo> fileWriteInfos) {
        return (List)fileWriteInfos.stream().map(PartitionUpdate.FileWriteInfo::getTargetFileName).collect(ImmutableList.toImmutableList());
    }

    private PartitionStatistics createPartitionStatistics(ConnectorSession session, Map<String, Type> columnTypes, ComputedStatistics computedStatistics) {
        Map computedColumnStatistics = computedStatistics.getColumnStatistics();
        Block rowCountBlock = (Block)Optional.ofNullable(computedStatistics.getTableStatistics().get(TableStatisticType.ROW_COUNT)).orElseThrow(() -> new VerifyException("rowCount not present"));
        Verify.verify((!rowCountBlock.isNull(0) ? 1 : 0) != 0, (String)"rowCount must never be null", (Object[])new Object[0]);
        long rowCount = BigintType.BIGINT.getLong(rowCountBlock, 0);
        HiveBasicStatistics rowCountOnlyBasicStatistics = new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(rowCount), OptionalLong.empty(), OptionalLong.empty());
        return this.createPartitionStatistics(session, rowCountOnlyBasicStatistics, columnTypes, computedColumnStatistics);
    }

    private PartitionStatistics createPartitionStatistics(ConnectorSession session, HiveBasicStatistics basicStatistics, Map<String, Type> columnTypes, Map<ColumnStatisticMetadata, Block> computedColumnStatistics) {
        long rowCount = basicStatistics.getRowCount().orElseThrow(() -> new IllegalArgumentException("rowCount not present"));
        Map columnStatistics = Statistics.fromComputedStatistics((ConnectorSession)session, (DateTimeZone)this.timeZone, computedColumnStatistics, columnTypes, (long)rowCount);
        return new PartitionStatistics(basicStatistics, columnStatistics);
    }

    private Map<ColumnStatisticMetadata, Block> getColumnStatistics(Map<List<String>, ComputedStatistics> partitionComputedStatistics, List<String> partitionValues) {
        return Optional.ofNullable(partitionComputedStatistics.get(partitionValues)).map(ComputedStatistics::getColumnStatistics).orElse((Map)ImmutableMap.of());
    }

    private Set<String> getExistingPartitionNames(ConnectorIdentity identity, MetastoreContext metastoreContext, String databaseName, String tableName, List<PartitionUpdate> partitionUpdates) {
        ImmutableSet.Builder existingPartitions = ImmutableSet.builder();
        ImmutableSet.Builder potentiallyNewPartitions = ImmutableSet.builder();
        block4: for (PartitionUpdate update : partitionUpdates) {
            switch (update.getUpdateMode()) {
                case APPEND: {
                    existingPartitions.add((Object)update.getName());
                    continue block4;
                }
                case NEW: 
                case OVERWRITE: {
                    potentiallyNewPartitions.add((Object)update.getName());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("unexpected update mode: " + (Object)((Object)update.getUpdateMode()));
        }
        Lists.partition((List)ImmutableList.copyOf((Collection)potentiallyNewPartitions.build()), (int)this.maxPartitionBatchSize).stream().flatMap(partitionNames -> this.metastore.getPartitionsByNames(metastoreContext, databaseName, tableName, partitionNames).entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).map(Map.Entry::getKey)).forEach(arg_0 -> ((ImmutableSet.Builder)existingPartitions).add(arg_0));
        return existingPartitions.build();
    }

    public void createView(ConnectorSession session, ConnectorTableMetadata viewMetadata, String viewData, boolean replace) {
        ImmutableMap properties = ImmutableMap.builder().put((Object)TABLE_COMMENT, (Object)"Presto View").put((Object)"presto_view", (Object)"true").put((Object)PRESTO_VERSION_NAME, (Object)this.prestoVersion).put((Object)"presto_query_id", (Object)session.getQueryId()).build();
        ImmutableList columns = new ArrayList();
        for (ColumnMetadata column : viewMetadata.getColumns()) {
            try {
                columns.add(new Column(column.getName(), HiveType.toHiveType((TypeTranslator)this.typeTranslator, (Type)column.getType()), Optional.ofNullable(column.getComment())));
            }
            catch (PrestoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode())) {
                    columns = ImmutableList.of((Object)new Column("dummy", HiveType.HIVE_STRING, Optional.of(String.format("Using dummy because column %s uses unsupported Hive type %s ", column.getName(), column.getType()))));
                    break;
                }
                throw e;
            }
        }
        SchemaTableName viewName = viewMetadata.getTable();
        Table.Builder tableBuilder = Table.builder().setDatabaseName(viewName.getSchemaName()).setTableName(viewName.getTableName()).setOwner(session.getUser()).setTableType(PrestoTableType.VIRTUAL_VIEW).setDataColumns(columns).setPartitionColumns((List)ImmutableList.of()).setParameters((Map)properties).setViewOriginalText(Optional.of(HiveUtil.encodeViewData(viewData))).setViewExpandedText(Optional.of("/* Presto View */"));
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.VIEW_STORAGE_FORMAT).setLocation("");
        Table table = tableBuilder.build();
        PrincipalPrivileges principalPrivileges = HiveMetadata.buildInitialPrivilegeSet(session.getUser());
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Optional existing = this.metastore.getTable(metastoreContext, viewName.getSchemaName(), viewName.getTableName());
        if (existing.isPresent()) {
            if (!replace || !MetastoreUtil.isPrestoView((Table)((Table)existing.get()))) {
                throw new ViewAlreadyExistsException(viewName);
            }
            this.metastore.replaceView(metastoreContext, viewName.getSchemaName(), viewName.getTableName(), table, principalPrivileges);
            return;
        }
        try {
            this.metastore.createTable(session, table, principalPrivileges, Optional.empty(), false, new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of()));
        }
        catch (TableAlreadyExistsException e) {
            throw new ViewAlreadyExistsException(e.getTableName());
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        ConnectorViewDefinition view = this.getViews(session, viewName.toSchemaTablePrefix()).get(viewName);
        if (view == null) {
            throw new ViewNotFoundException(viewName);
        }
        try {
            this.metastore.dropTable(new HdfsContext(session, viewName.getSchemaName()), viewName.getSchemaName(), viewName.getTableName());
        }
        catch (TableNotFoundException e) {
            throw new ViewNotFoundException(e.getTableName());
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        for (String schemaName : this.listSchemas(session, schemaNameOrNull)) {
            for (String tableName : this.metastore.getAllViews(metastoreContext, schemaName).orElse(Collections.emptyList())) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return tableNames.build();
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder views = ImmutableMap.builder();
        ImmutableList tableNames = prefix.getTableName() != null ? ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName())) : this.listViews(session, prefix.getSchemaName());
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        for (SchemaTableName schemaTableName : tableNames) {
            Optional table = this.metastore.getTable(metastoreContext, schemaTableName.getSchemaName(), schemaTableName.getTableName());
            if (!table.isPresent() || !MetastoreUtil.isPrestoView((Table)((Table)table.get()))) continue;
            views.put((Object)schemaTableName, (Object)new ConnectorViewDefinition(schemaTableName, Optional.ofNullable(((Table)table.get()).getOwner()), HiveUtil.decodeViewData((String)((Table)table.get()).getViewOriginalText().get())));
        }
        return views.build();
    }

    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        Objects.requireNonNull(viewName, "viewName is null");
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Optional table = this.metastore.getTable(metastoreContext, viewName.getSchemaName(), viewName.getTableName());
        if (table.isPresent() && MetastoreUtil.isPrestoMaterializedView((Table)((Table)table.get()))) {
            try {
                return Optional.of(MATERIALIZED_VIEW_JSON_CODEC.fromJson(HiveUtil.decodeMaterializedViewData((String)((Table)table.get()).getViewOriginalText().get())));
            }
            catch (IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, "Invalid materialized view JSON", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public MaterializedViewStatus getMaterializedViewStatus(ConnectorSession session, SchemaTableName materializedViewName) {
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        ConnectorMaterializedViewDefinition viewDefinition = this.getMaterializedView(session, materializedViewName).orElseThrow(() -> new MaterializedViewNotFoundException(materializedViewName));
        List baseTables = (List)viewDefinition.getBaseTables().stream().map(baseTableName -> (Table)this.metastore.getTable(metastoreContext, baseTableName.getSchemaName(), baseTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(baseTableName))).collect(ImmutableList.toImmutableList());
        baseTables.forEach(table -> Preconditions.checkState((boolean)table.getTableType().equals((Object)PrestoTableType.MANAGED_TABLE), (Object)String.format("base table %s is not a managed table", table.getTableName())));
        Table materializedViewTable = (Table)this.metastore.getTable(metastoreContext, materializedViewName.getSchemaName(), materializedViewName.getTableName()).orElseThrow(() -> new MaterializedViewNotFoundException(materializedViewName));
        Preconditions.checkState((boolean)materializedViewTable.getTableType().equals((Object)PrestoTableType.MATERIALIZED_VIEW), (Object)String.format("materialized view table %s is not a materialized view", materializedViewTable.getTableName()));
        HiveMaterializedViewUtils.validateMaterializedViewPartitionColumns(this.metastore, metastoreContext, materializedViewTable, viewDefinition);
        Map<SchemaTableName, Map<String, String>> viewToBasePartitionMap = HiveMaterializedViewUtils.getViewToBasePartitionMap(materializedViewTable, baseTables, viewDefinition.getColumnMappingsAsMap());
        MaterializedViewStatus.MaterializedDataPredicates materializedDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates(this.metastore, metastoreContext, this.typeManager, materializedViewTable, this.timeZone);
        if (materializedDataPredicates.getPredicateDisjuncts().isEmpty()) {
            return new MaterializedViewStatus(MaterializedViewStatus.MaterializedViewState.NOT_MATERIALIZED);
        }
        Map partitionsFromBaseTables = (Map)baseTables.stream().collect(ImmutableMap.toImmutableMap(baseTable -> new SchemaTableName(baseTable.getDatabaseName(), baseTable.getTableName()), baseTable -> HiveMaterializedViewUtils.differenceDataPredicates(HiveMaterializedViewUtils.getMaterializedDataPredicates(this.metastore, metastoreContext, this.typeManager, baseTable, this.timeZone), materializedDataPredicates, (Map)viewToBasePartitionMap.getOrDefault(new SchemaTableName(baseTable.getDatabaseName(), baseTable.getTableName()), (Map<String, String>)ImmutableMap.of()))));
        for (MaterializedViewStatus.MaterializedDataPredicates dataPredicates : partitionsFromBaseTables.values()) {
            if (dataPredicates.getPredicateDisjuncts().isEmpty()) continue;
            return new MaterializedViewStatus(MaterializedViewStatus.MaterializedViewState.PARTIALLY_MATERIALIZED, partitionsFromBaseTables);
        }
        return new MaterializedViewStatus(MaterializedViewStatus.MaterializedViewState.FULLY_MATERIALIZED);
    }

    public void createMaterializedView(ConnectorSession session, ConnectorTableMetadata viewMetadata, ConnectorMaterializedViewDefinition viewDefinition, boolean ignoreExisting) {
        if (HiveTableProperties.isExternalTable(viewMetadata.getProperties())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Specifying external location for materialized view is not supported.");
        }
        Table basicTable = this.prepareTable(session, viewMetadata, PrestoTableType.MATERIALIZED_VIEW);
        ImmutableMap parameters = ImmutableMap.builder().putAll(basicTable.getParameters()).put((Object)"presto_materialized_view", (Object)"true").build();
        Table viewTable = Table.builder((Table)basicTable).setParameters((Map)parameters).setViewOriginalText(Optional.of(HiveUtil.encodeMaterializedViewData(MATERIALIZED_VIEW_JSON_CODEC.toJson((Object)viewDefinition)))).setViewExpandedText(Optional.of("/* Presto Materialized View */")).build();
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        HiveMaterializedViewUtils.validateMaterializedViewPartitionColumns(this.metastore, metastoreContext, viewTable, viewDefinition);
        try {
            PrincipalPrivileges principalPrivileges = HiveMetadata.buildInitialPrivilegeSet(viewTable.getOwner());
            this.metastore.createTable(session, viewTable, principalPrivileges, Optional.empty(), ignoreExisting, new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of()));
        }
        catch (TableAlreadyExistsException e) {
            throw new MaterializedViewAlreadyExistsException(e.getTableName());
        }
    }

    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        Optional<ConnectorMaterializedViewDefinition> view = this.getMaterializedView(session, viewName);
        if (!view.isPresent()) {
            throw new MaterializedViewNotFoundException(viewName);
        }
        try {
            this.metastore.dropTable(new HdfsContext(session, viewName.getSchemaName(), viewName.getTableName()), viewName.getSchemaName(), viewName.getTableName());
        }
        catch (TableNotFoundException e) {
            throw new MaterializedViewNotFoundException(e.getTableName());
        }
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector only supports delete where one or more partitions are deleted entirely");
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return HiveColumnHandle.updateRowIdHandle();
    }

    public OptionalLong metadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        HiveTableLayoutHandle layoutHandle = (HiveTableLayoutHandle)tableLayoutHandle;
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Optional table = this.metastore.getTable(metastoreContext, handle.getSchemaName(), handle.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        if (((Table)table.get()).getPartitionColumns().isEmpty()) {
            this.metastore.truncateUnpartitionedTable(session, handle.getSchemaName(), handle.getTableName());
        } else {
            for (HivePartition hivePartition : this.getOrComputePartitions(layoutHandle, session, tableHandle)) {
                this.metastore.dropPartition(session, handle.getSchemaName(), handle.getTableName(), ((Table)table.get()).getStorage().getLocation(), MetastoreUtil.toPartitionValues((String)hivePartition.getPartitionId()));
            }
        }
        return OptionalLong.empty();
    }

    private List<HivePartition> getOrComputePartitions(HiveTableLayoutHandle layoutHandle, ConnectorSession session, ConnectorTableHandle tableHandle) {
        if (layoutHandle.getPartitions().isPresent()) {
            return layoutHandle.getPartitions().get();
        }
        TupleDomain<ColumnHandle> partitionColumnPredicate = layoutHandle.getPartitionColumnPredicate();
        Predicate<Map<ColumnHandle, NullableValue>> predicate = HiveMetadata.convertToPredicate(partitionColumnPredicate);
        List<ConnectorTableLayoutResult> tableLayoutResults = this.getTableLayouts(session, tableHandle, (Constraint<ColumnHandle>)new Constraint(partitionColumnPredicate, predicate), Optional.empty());
        return ((HiveTableLayoutHandle)((ConnectorTableLayoutResult)Iterables.getOnlyElement(tableLayoutResults)).getTableLayout().getHandle()).getPartitions().get();
    }

    @VisibleForTesting
    static Predicate<Map<ColumnHandle, NullableValue>> convertToPredicate(TupleDomain<ColumnHandle> tupleDomain) {
        return bindings -> tupleDomain.contains(TupleDomain.fromFixedValues((Map)bindings));
    }

    public boolean supportsMetadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<ConnectorTableLayoutHandle> tableLayoutHandle) {
        if (!tableLayoutHandle.isPresent()) {
            return true;
        }
        HiveTableLayoutHandle layoutHandle = (HiveTableLayoutHandle)tableLayoutHandle.get();
        if (!layoutHandle.isPushdownFilterEnabled()) {
            return true;
        }
        if (layoutHandle.getPredicateColumns().isEmpty()) {
            return true;
        }
        if (!LogicalRowExpressions.TRUE_CONSTANT.equals((Object)layoutHandle.getRemainingPredicate())) {
            return false;
        }
        TupleDomain<Subfield> domainPredicate = layoutHandle.getDomainPredicate();
        if (domainPredicate.isAll()) {
            return true;
        }
        Set predicateColumnNames = (Set)((Map)domainPredicate.getDomains().get()).keySet().stream().map(Subfield::getRootName).collect(ImmutableSet.toImmutableSet());
        Set partitionColumnNames = (Set)layoutHandle.getPartitionColumns().stream().map(HiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
        return partitionColumnNames.containsAll(predicateColumnNames);
    }

    public boolean isLegacyGetLayoutSupported(ConnectorSession session, ConnectorTableHandle tableHandle) {
        if (((HiveTableHandle)tableHandle).getAnalyzePartitionValues().isPresent()) {
            return true;
        }
        return !this.isPushdownFilterEnabled(session, tableHandle);
    }

    private String createTableLayoutString(ConnectorSession session, SchemaTableName tableName, Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter, RowExpression remainingPredicate, TupleDomain<Subfield> domainPredicate) {
        return MoreObjects.toStringHelper((String)tableName.toString()).omitNullValues().add("buckets", bucketHandle.map(HiveBucketHandle::getReadBucketCount).orElse(null)).add("bucketsToKeep", bucketFilter.map(HiveBucketing.HiveBucketFilter::getBucketsToKeep).orElse(null)).add("filter", LogicalRowExpressions.TRUE_CONSTANT.equals((Object)remainingPredicate) ? null : this.rowExpressionService.formatRowExpression(session, remainingPredicate)).add("domains", domainPredicate.isAll() ? null : domainPredicate.toString(session.getSqlFunctionProperties())).toString();
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        HivePartitionResult hivePartitionResult;
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        if (handle.getAnalyzePartitionValues().isPresent()) {
            Verify.verify((boolean)constraint.getSummary().isAll(), (String)"There shouldn't be any constraint for ANALYZE operation", (Object[])new Object[0]);
            hivePartitionResult = this.partitionManager.getPartitions(this.metastore, tableHandle, handle.getAnalyzePartitionValues().get(), session);
        } else {
            hivePartitionResult = this.partitionManager.getPartitions(this.metastore, tableHandle, constraint, session);
        }
        Map predicateColumns = (Map)((Map)hivePartitionResult.getEffectivePredicate().getDomains().get()).keySet().stream().map(HiveColumnHandle.class::cast).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, (Function)Functions.identity()));
        Optional<HiveBucketHandle> hiveBucketHandle = hivePartitionResult.getBucketHandle();
        int virtualBucketCount = HiveSessionProperties.getVirtualBucketCount(session);
        if (!hivePartitionResult.getBucketHandle().isPresent() && virtualBucketCount > 0) {
            hiveBucketHandle = Optional.of(HiveBucketHandle.createVirtualBucketHandle(virtualBucketCount));
        }
        TupleDomain domainPredicate = hivePartitionResult.getEffectivePredicate().transform(HiveMetadata::toSubfield);
        Table table = (Table)this.metastore.getTable(new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource()), handle.getSchemaTableName().getSchemaName(), handle.getSchemaTableName().getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(this.getTableLayout(session, new HiveTableLayoutHandle(handle.getSchemaTableName(), table.getStorage().getLocation(), hivePartitionResult.getPartitionColumns(), this.pruneColumnComments(hivePartitionResult.getDataColumns()), hivePartitionResult.getTableParameters(), hivePartitionResult.getPartitions(), (TupleDomain<Subfield>)domainPredicate, (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, predicateColumns, hivePartitionResult.getEnforcedConstraint(), hiveBucketHandle, hivePartitionResult.getBucketFilter(), false, this.createTableLayoutString(session, handle.getSchemaTableName(), hivePartitionResult.getBucketHandle(), hivePartitionResult.getBucketFilter(), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (TupleDomain<Subfield>)domainPredicate), desiredColumns.map(columns -> (ImmutableSet)columns.stream().map(column -> (HiveColumnHandle)column).collect(ImmutableSet.toImmutableSet())), false)), hivePartitionResult.getUnenforcedConstraint()));
    }

    private static Subfield toSubfield(ColumnHandle columnHandle) {
        return new Subfield(((HiveColumnHandle)columnHandle).getName(), (List)ImmutableList.of());
    }

    private static boolean isEntireColumn(Subfield subfield) {
        return subfield.getPath().isEmpty();
    }

    private boolean isPushdownFilterEnabled(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveStorageFormat hiveStorageFormat;
        boolean pushdownFilterEnabled = HiveSessionProperties.isPushdownFilterEnabled(session);
        return pushdownFilterEnabled && ((hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(this.getTableMetadata(session, tableHandle).getProperties())) == HiveStorageFormat.ORC || hiveStorageFormat == HiveStorageFormat.DWRF);
    }

    private List<Column> pruneColumnComments(List<Column> columns) {
        return (List)columns.stream().map(column -> new Column(column.getName(), column.getType(), Optional.empty())).collect(ImmutableList.toImmutableList());
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle layoutHandle) {
        boolean bucketExecutionEnabled;
        HiveTableLayoutHandle hiveLayoutHandle = (HiveTableLayoutHandle)layoutHandle;
        ImmutableList partitionColumns = ImmutableList.copyOf(hiveLayoutHandle.getPartitionColumns());
        List<HivePartition> partitions = hiveLayoutHandle.getPartitions().get();
        Optional<Object> discretePredicates = Optional.empty();
        if (!partitionColumns.isEmpty()) {
            Iterable partitionDomains = Iterables.transform(partitions, hivePartition -> TupleDomain.fromFixedValues(hivePartition.getKeys()));
            discretePredicates = Optional.of(new DiscretePredicates((List)partitionColumns, partitionDomains));
        }
        Optional<Object> tablePartitioning = Optional.empty();
        SchemaTableName tableName = hiveLayoutHandle.getSchemaTableName();
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Table table = (Table)this.metastore.getTable(metastoreContext, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        boolean bl = bucketExecutionEnabled = table.getTableType().equals((Object)PrestoTableType.TEMPORARY_TABLE) || HiveSessionProperties.isBucketExecutionEnabled(session);
        if (bucketExecutionEnabled && hiveLayoutHandle.getBucketHandle().isPresent()) {
            HivePartitioningHandle partitioningHandle;
            HiveBucketHandle hiveBucketHandle = hiveLayoutHandle.getBucketHandle().get();
            int bucketCount = hiveBucketHandle.getReadBucketCount();
            OptionalInt maxCompatibleBucketCount = OptionalInt.empty();
            if (hiveBucketHandle.isVirtuallyBucketed()) {
                partitioningHandle = HivePartitioningHandle.createHiveCompatiblePartitioningHandle(bucketCount, (List)hiveBucketHandle.getColumns().stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList()), maxCompatibleBucketCount);
            } else {
                HiveBucketProperty bucketProperty = (HiveBucketProperty)table.getStorage().getBucketProperty().orElseThrow(() -> new IllegalArgumentException("bucketProperty is expected to be present"));
                switch (bucketProperty.getBucketFunctionType()) {
                    case HIVE_COMPATIBLE: {
                        partitioningHandle = HivePartitioningHandle.createHiveCompatiblePartitioningHandle(bucketCount, (List)hiveBucketHandle.getColumns().stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList()), maxCompatibleBucketCount);
                        break;
                    }
                    case PRESTO_NATIVE: {
                        partitioningHandle = HivePartitioningHandle.createPrestoNativePartitioningHandle(bucketCount, (List)bucketProperty.getTypes().get(), maxCompatibleBucketCount);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported bucket function type " + bucketProperty.getBucketFunctionType());
                    }
                }
            }
            tablePartitioning = Optional.of(new ConnectorTablePartitioning((ConnectorPartitioningHandle)partitioningHandle, (List)hiveBucketHandle.getColumns().stream().map(ColumnHandle.class::cast).collect(ImmutableList.toImmutableList())));
        }
        TupleDomain predicate = hiveLayoutHandle.isPushdownFilterEnabled() ? hiveLayoutHandle.getDomainPredicate().transform(subfield -> HiveMetadata.isEntireColumn(subfield) ? subfield.getRootName() : null).transform(hiveLayoutHandle.getPredicateColumns()::get).transform(ColumnHandle.class::cast).intersect(HiveMetadata.createPredicate((List<ColumnHandle>)partitionColumns, partitions)) : HiveMetadata.createPredicate((List<ColumnHandle>)partitionColumns, partitions);
        return new ConnectorTableLayout((ConnectorTableLayoutHandle)hiveLayoutHandle, Optional.empty(), predicate, tablePartitioning, Optional.empty(), discretePredicates, (List)ImmutableList.of());
    }

    public Optional<ConnectorPartitioningHandle> getCommonPartitioningHandle(ConnectorSession session, ConnectorPartitioningHandle left, ConnectorPartitioningHandle right) {
        int smallerBucketCount;
        HivePartitioningHandle leftHandle = (HivePartitioningHandle)left;
        HivePartitioningHandle rightHandle = (HivePartitioningHandle)right;
        if (!(leftHandle.getBucketFunctionType().equals((Object)rightHandle.getBucketFunctionType()) && leftHandle.getHiveTypes().equals(rightHandle.getHiveTypes()) && leftHandle.getTypes().equals(rightHandle.getTypes()))) {
            return Optional.empty();
        }
        if (leftHandle.getBucketCount() == rightHandle.getBucketCount()) {
            return Optional.of(leftHandle);
        }
        if (!HiveSessionProperties.isOptimizedMismatchedBucketCount(session)) {
            return Optional.empty();
        }
        int largerBucketCount = Math.max(leftHandle.getBucketCount(), rightHandle.getBucketCount());
        if (largerBucketCount % (smallerBucketCount = Math.min(leftHandle.getBucketCount(), rightHandle.getBucketCount())) != 0) {
            return Optional.empty();
        }
        if (Integer.bitCount(largerBucketCount / smallerBucketCount) != 1) {
            return Optional.empty();
        }
        OptionalInt maxCompatibleBucketCount = HiveMetadata.min(leftHandle.getMaxCompatibleBucketCount(), rightHandle.getMaxCompatibleBucketCount());
        if (maxCompatibleBucketCount.isPresent() && maxCompatibleBucketCount.getAsInt() < smallerBucketCount) {
            return Optional.empty();
        }
        return Optional.of(new HivePartitioningHandle(smallerBucketCount, maxCompatibleBucketCount, leftHandle.getBucketFunctionType(), leftHandle.getHiveTypes(), leftHandle.getTypes()));
    }

    public boolean isRefinedPartitioningOver(ConnectorSession session, ConnectorPartitioningHandle left, ConnectorPartitioningHandle right) {
        int rightBucketCount;
        HivePartitioningHandle leftHandle = (HivePartitioningHandle)left;
        HivePartitioningHandle rightHandle = (HivePartitioningHandle)right;
        if (!(leftHandle.getBucketFunctionType().equals((Object)rightHandle.getBucketFunctionType()) && leftHandle.getHiveTypes().equals(rightHandle.getHiveTypes()) && leftHandle.getTypes().equals(rightHandle.getTypes()))) {
            return false;
        }
        int leftBucketCount = leftHandle.getBucketCount();
        return leftBucketCount == (rightBucketCount = rightHandle.getBucketCount()) || leftBucketCount % rightBucketCount == 0 && Integer.bitCount(leftBucketCount / rightBucketCount) == 1;
    }

    private static OptionalInt min(OptionalInt left, OptionalInt right) {
        if (!left.isPresent()) {
            return right;
        }
        if (!right.isPresent()) {
            return left;
        }
        return OptionalInt.of(Math.min(left.getAsInt(), right.getAsInt()));
    }

    public ConnectorTableLayoutHandle getAlternativeLayoutHandle(ConnectorSession session, ConnectorTableLayoutHandle tableLayoutHandle, ConnectorPartitioningHandle partitioningHandle) {
        HiveTableLayoutHandle hiveLayoutHandle = (HiveTableLayoutHandle)tableLayoutHandle;
        HivePartitioningHandle hivePartitioningHandle = (HivePartitioningHandle)partitioningHandle;
        Preconditions.checkArgument((boolean)hiveLayoutHandle.getBucketHandle().isPresent(), (Object)"Hive connector only provides alternative layout for bucketed table");
        HiveBucketHandle bucketHandle = hiveLayoutHandle.getBucketHandle().get();
        ImmutableList bucketTypes = (ImmutableList)bucketHandle.getColumns().stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList());
        Optional<List<HiveType>> hiveTypes = hivePartitioningHandle.getHiveTypes();
        Preconditions.checkArgument((boolean)hivePartitioningHandle.getBucketFunctionType().equals((Object)BucketFunctionType.HIVE_COMPATIBLE), (String)"bucketFunctionType is expected to be HIVE_COMPATIBLE, got: %s", (Object)hivePartitioningHandle.getBucketFunctionType());
        Preconditions.checkArgument((boolean)hiveTypes.get().equals(bucketTypes), (String)"Types from the new PartitioningHandle (%s) does not match the TableLayoutHandle (%s)", hiveTypes.get(), (Object)bucketTypes);
        int largerBucketCount = Math.max(bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount());
        int smallerBucketCount = Math.min(bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount());
        Preconditions.checkArgument((largerBucketCount % smallerBucketCount == 0 && Integer.bitCount(largerBucketCount / smallerBucketCount) == 1 ? 1 : 0) != 0, (Object)"The requested partitioning is not a valid alternative for the table layout");
        return new HiveTableLayoutHandle(hiveLayoutHandle.getSchemaTableName(), hiveLayoutHandle.getTablePath(), hiveLayoutHandle.getPartitionColumns(), hiveLayoutHandle.getDataColumns(), hiveLayoutHandle.getTableParameters(), hiveLayoutHandle.getPartitions().get(), hiveLayoutHandle.getDomainPredicate(), hiveLayoutHandle.getRemainingPredicate(), hiveLayoutHandle.getPredicateColumns(), hiveLayoutHandle.getPartitionColumnPredicate(), Optional.of(new HiveBucketHandle(bucketHandle.getColumns(), bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount())), hiveLayoutHandle.getBucketFilter(), hiveLayoutHandle.isPushdownFilterEnabled(), hiveLayoutHandle.getLayoutString(), hiveLayoutHandle.getRequestedColumns(), hiveLayoutHandle.isPartialAggregationsPushedDown());
    }

    public ConnectorPartitioningHandle getPartitioningHandleForExchange(ConnectorSession session, int partitionCount, List<Type> partitionTypes) {
        BucketFunctionType bucketFunctionType = HiveSessionProperties.getBucketFunctionTypeForExchange(session);
        if (HiveSessionProperties.isUsePageFileForHiveUnsupportedType(session)) {
            if (!partitionTypes.stream().allMatch(HiveTypeTranslator::isSupportedHiveType)) {
                bucketFunctionType = BucketFunctionType.PRESTO_NATIVE;
            }
        } else if (HiveSessionProperties.getTemporaryTableStorageFormat(session) == HiveStorageFormat.ORC) {
            bucketFunctionType = BucketFunctionType.HIVE_COMPATIBLE;
        }
        switch (bucketFunctionType) {
            case HIVE_COMPATIBLE: {
                return HivePartitioningHandle.createHiveCompatiblePartitioningHandle(partitionCount, (List)partitionTypes.stream().map(type -> HiveType.toHiveType((TypeTranslator)this.typeTranslator, (Type)HiveUtil.translateHiveUnsupportedTypeForTemporaryTable(type, this.typeManager))).collect(ImmutableList.toImmutableList()), OptionalInt.empty());
            }
            case PRESTO_NATIVE: {
                return HivePartitioningHandle.createPrestoNativePartitioningHandle(partitionCount, partitionTypes, OptionalInt.empty());
            }
        }
        throw new IllegalArgumentException("Unsupported bucket function type " + bucketFunctionType);
    }

    @VisibleForTesting
    static TupleDomain<ColumnHandle> createPredicate(List<ColumnHandle> partitionColumns, List<HivePartition> partitions) {
        if (partitions.isEmpty()) {
            return TupleDomain.none();
        }
        return TupleDomain.withColumnDomains(partitionColumns.stream().collect(Collectors.toMap(Function.identity(), column -> HiveMetadata.buildColumnDomain(column, partitions))));
    }

    private static Domain buildColumnDomain(ColumnHandle column, List<HivePartition> partitions) {
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"partitions cannot be empty");
        boolean hasNull = false;
        HashSet<Object> nonNullValues = new HashSet<Object>();
        Type type = null;
        for (HivePartition partition : partitions) {
            NullableValue value = partition.getKeys().get(column);
            if (value == null) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, String.format("Partition %s does not have a value for partition column %s", partition, column));
            }
            if (value.isNull()) {
                hasNull = true;
            } else {
                nonNullValues.add(value.getValue());
            }
            if (type != null) continue;
            type = value.getType();
        }
        if (!nonNullValues.isEmpty()) {
            Domain domain = Domain.multipleValues(type, (List)ImmutableList.copyOf(nonNullValues));
            if (hasNull) {
                return domain.union(Domain.onlyNull(type));
            }
            return domain;
        }
        return Domain.onlyNull(type);
    }

    public Optional<ConnectorNewTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HivePartitioningHandle partitioningHandle;
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Table table = (Table)this.metastore.getTable(metastoreContext, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        Optional<HiveBucketHandle> hiveBucketHandle = HiveBucketing.getHiveBucketHandle(table);
        if (!hiveBucketHandle.isPresent()) {
            return Optional.empty();
        }
        HiveBucketProperty bucketProperty = (HiveBucketProperty)table.getStorage().getBucketProperty().orElseThrow(() -> new NoSuchElementException("Bucket property should be set"));
        if (!bucketProperty.getSortedBy().isEmpty() && !HiveSessionProperties.isSortedWritingEnabled(session)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed sorted Hive tables is disabled");
        }
        int bucketCount = hiveBucketHandle.get().getTableBucketCount();
        OptionalInt maxCompatibleBucketCount = OptionalInt.of(bucketCount);
        switch (bucketProperty.getBucketFunctionType()) {
            case HIVE_COMPATIBLE: {
                partitioningHandle = HivePartitioningHandle.createHiveCompatiblePartitioningHandle(bucketCount, (List)hiveBucketHandle.get().getColumns().stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList()), maxCompatibleBucketCount);
                break;
            }
            case PRESTO_NATIVE: {
                partitioningHandle = HivePartitioningHandle.createPrestoNativePartitioningHandle(bucketCount, (List)bucketProperty.getTypes().get(), maxCompatibleBucketCount);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported bucket function type " + bucketProperty.getBucketFunctionType());
            }
        }
        List partitionColumns = hiveBucketHandle.get().getColumns().stream().map(HiveColumnHandle::getName).collect(Collectors.toList());
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)partitioningHandle, partitionColumns));
    }

    public Optional<ConnectorNewTableLayout> getPreferredShuffleLayoutForInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Table table = (Table)this.metastore.getTable(metastoreContext, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        Optional<HiveBucketHandle> hiveBucketHandle = HiveBucketing.getHiveBucketHandle(table);
        if (hiveBucketHandle.isPresent()) {
            return Optional.empty();
        }
        if (!HiveSessionProperties.isShufflePartitionedColumnsForTableWriteEnabled(session) || table.getPartitionColumns().isEmpty()) {
            return Optional.empty();
        }
        HivePartitioningHandle partitioningHandle = HivePartitioningHandle.createHiveCompatiblePartitioningHandle(1009, table.getPartitionColumns().stream().map(Column::getType).collect(Collectors.toList()), OptionalInt.empty());
        List partitionedBy = table.getPartitionColumns().stream().map(Column::getName).collect(Collectors.toList());
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)partitioningHandle, partitionedBy));
    }

    public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        HiveMetadata.validatePartitionColumns(tableMetadata);
        HiveMetadata.validateBucketColumns(tableMetadata);
        HiveMetadata.validateCsvColumns(tableMetadata);
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (!bucketProperty.isPresent()) {
            return Optional.empty();
        }
        Preconditions.checkArgument((boolean)bucketProperty.get().getBucketFunctionType().equals((Object)BucketFunctionType.HIVE_COMPATIBLE), (String)"bucketFunctionType is expected to be HIVE_COMPATIBLE, got: %s", (Object)bucketProperty.get().getBucketFunctionType());
        if (!bucketProperty.get().getSortedBy().isEmpty() && !HiveSessionProperties.isSortedWritingEnabled(session)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed sorted Hive tables is disabled");
        }
        List bucketedBy = bucketProperty.get().getBucketedBy();
        Map<String, HiveType> hiveTypeMap = tableMetadata.getColumns().stream().collect(Collectors.toMap(ColumnMetadata::getName, column -> HiveType.toHiveType((TypeTranslator)this.typeTranslator, (Type)column.getType())));
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)HivePartitioningHandle.createHiveCompatiblePartitioningHandle(bucketProperty.get().getBucketCount(), (List)bucketedBy.stream().map(hiveTypeMap::get).collect(ImmutableList.toImmutableList()), OptionalInt.of(bucketProperty.get().getBucketCount())), bucketedBy));
    }

    public Optional<ConnectorNewTableLayout> getPreferredShuffleLayoutForNewTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        HiveMetadata.validatePartitionColumns(tableMetadata);
        HiveMetadata.validateBucketColumns(tableMetadata);
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (bucketProperty.isPresent()) {
            return Optional.empty();
        }
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        if (!HiveSessionProperties.isShufflePartitionedColumnsForTableWriteEnabled(session) || partitionedBy.isEmpty()) {
            return Optional.empty();
        }
        List<HiveColumnHandle> columnHandles = HiveMetadata.getColumnHandles(tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy), this.typeTranslator);
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(column -> new Column(column.getName(), column.getHiveType(), column.getComment())).collect(Collectors.toList());
        HivePartitioningHandle partitioningHandle = HivePartitioningHandle.createHiveCompatiblePartitioningHandle(1009, partitionColumns.stream().map(Column::getType).collect(Collectors.toList()), OptionalInt.empty());
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)partitioningHandle, partitionedBy));
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        if (!HiveSessionProperties.isCollectColumnStatisticsOnWrite(session)) {
            return TableStatisticsMetadata.empty();
        }
        List partitionedBy = (List)MoreObjects.firstNonNull(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()), (Object)ImmutableList.of());
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Optional table = this.metastore.getTable(metastoreContext, tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName());
        return this.getStatisticsCollectionMetadata(session, tableMetadata.getColumns(), partitionedBy, false, table.isPresent() && ((Table)table.get()).getTableType() == PrestoTableType.TEMPORARY_TABLE);
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        List partitionedBy = (List)MoreObjects.firstNonNull(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()), (Object)ImmutableList.of());
        return this.getStatisticsCollectionMetadata(session, tableMetadata.getColumns(), partitionedBy, true, false);
    }

    private TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorSession session, List<ColumnMetadata> columns, List<String> partitionedBy, boolean includeRowCount, boolean isTemporaryTable) {
        Set columnStatistics = (Set)columns.stream().filter(column -> !partitionedBy.contains(column.getName())).filter(column -> !column.isHidden()).map(meta -> isTemporaryTable ? this.getColumnStatisticMetadataForTemporaryTable((ColumnMetadata)meta) : this.getColumnStatisticMetadata(session, (ColumnMetadata)meta)).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        ImmutableSet tableStatistics = includeRowCount ? ImmutableSet.of((Object)TableStatisticType.ROW_COUNT) : ImmutableSet.of();
        return new TableStatisticsMetadata(columnStatistics, (Set)tableStatistics, partitionedBy);
    }

    private List<ColumnStatisticMetadata> getColumnStatisticMetadata(ConnectorSession session, ColumnMetadata columnMetadata) {
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        return this.getColumnStatisticMetadata(columnMetadata.getName(), this.metastore.getSupportedColumnStatistics(metastoreContext, columnMetadata.getType()));
    }

    private List<ColumnStatisticMetadata> getColumnStatisticMetadataForTemporaryTable(ColumnMetadata columnMetadata) {
        return this.getColumnStatisticMetadata(columnMetadata.getName(), this.getSupportedColumnStatisticsForTemporaryTable(columnMetadata.getType()));
    }

    private List<ColumnStatisticMetadata> getColumnStatisticMetadata(String columnName, Set<ColumnStatisticType> statisticTypes) {
        return (List)statisticTypes.stream().map(type -> new ColumnStatisticMetadata(columnName, type)).collect(ImmutableList.toImmutableList());
    }

    public void createRole(ConnectorSession session, String role, Optional<PrestoPrincipal> grantor) {
        if (RESERVED_ROLES.contains(role)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Role name cannot be one of the reserved roles: " + RESERVED_ROLES);
        }
        this.metastore.createRole(new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource()), role, null);
    }

    public void dropRole(ConnectorSession session, String role) {
        this.metastore.dropRole(new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource()), role);
    }

    public Set<String> listRoles(ConnectorSession session) {
        return ImmutableSet.copyOf((Collection)this.metastore.listRoles(new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource())));
    }

    public Set<RoleGrant> listRoleGrants(ConnectorSession session, PrestoPrincipal principal) {
        return ImmutableSet.copyOf((Collection)this.metastore.listRoleGrants(new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource()), principal));
    }

    public void grantRoles(ConnectorSession session, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor) {
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        this.metastore.grantRoles(metastoreContext, roles, grantees, withAdminOption, grantor.orElse(new PrestoPrincipal(PrincipalType.USER, session.getUser())));
    }

    public void revokeRoles(ConnectorSession session, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor) {
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        this.metastore.revokeRoles(metastoreContext, roles, grantees, adminOptionFor, grantor.orElse(new PrestoPrincipal(PrincipalType.USER, session.getUser())));
    }

    public Set<RoleGrant> listApplicableRoles(ConnectorSession session, PrestoPrincipal principal) {
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        return (Set)ThriftMetastoreUtil.listApplicableRoles((PrestoPrincipal)principal, p -> this.metastore.listRoleGrants(metastoreContext, p)).collect(ImmutableSet.toImmutableSet());
    }

    public Set<String> listEnabledRoles(ConnectorSession session) {
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        return (Set)ThriftMetastoreUtil.listEnabledRoles((ConnectorIdentity)session.getIdentity(), p -> this.metastore.listRoleGrants(metastoreContext, p)).collect(ImmutableSet.toImmutableSet());
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Set hivePrivilegeInfos = privileges.stream().map(privilege -> new HivePrivilegeInfo(HivePrivilegeInfo.toHivePrivilege((Privilege)privilege), grantOption, new PrestoPrincipal(PrincipalType.USER, session.getUser()), new PrestoPrincipal(PrincipalType.USER, session.getUser()))).collect(Collectors.toSet());
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        this.metastore.grantTablePrivileges(metastoreContext, schemaName, tableName, grantee, hivePrivilegeInfos);
    }

    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Set hivePrivilegeInfos = privileges.stream().map(privilege -> new HivePrivilegeInfo(HivePrivilegeInfo.toHivePrivilege((Privilege)privilege), grantOption, new PrestoPrincipal(PrincipalType.USER, session.getUser()), new PrestoPrincipal(PrincipalType.USER, session.getUser()))).collect(Collectors.toSet());
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        this.metastore.revokeTablePrivileges(metastoreContext, schemaName, tableName, grantee, hivePrivilegeInfos);
    }

    public List<GrantInfo> listTablePrivileges(ConnectorSession session, SchemaTablePrefix schemaTablePrefix) {
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Set principals = (Set)ThriftMetastoreUtil.listEnabledPrincipals((SemiTransactionalHiveMetastore)this.metastore, (ConnectorIdentity)session.getIdentity(), (MetastoreContext)metastoreContext).collect(ImmutableSet.toImmutableSet());
        boolean isAdminRoleSet = HiveMetadata.hasAdminRole(principals);
        ImmutableList.Builder result = ImmutableList.builder();
        for (SchemaTableName tableName : this.listTables(session, schemaTablePrefix)) {
            if (isAdminRoleSet) {
                result.addAll(this.buildGrants(session, tableName, null));
                continue;
            }
            for (PrestoPrincipal grantee : principals) {
                result.addAll(this.buildGrants(session, tableName, grantee));
            }
        }
        return result.build();
    }

    public CompletableFuture<Void> commitPageSinkAsync(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments) {
        HiveOutputTableHandle handle = (HiveOutputTableHandle)tableHandle;
        return MoreFutures.toCompletableFuture(this.stagingFileCommitter.commitFiles(session, handle.getSchemaName(), handle.getTableName(), handle.getLocationHandle().getTargetPath().toString(), true, this.getPartitionUpdates(session, fragments)));
    }

    public CompletableFuture<Void> commitPageSinkAsync(ConnectorSession session, ConnectorInsertTableHandle tableHandle, Collection<Slice> fragments) {
        HiveInsertTableHandle handle = (HiveInsertTableHandle)tableHandle;
        return MoreFutures.toCompletableFuture(this.stagingFileCommitter.commitFiles(session, handle.getSchemaName(), handle.getTableName(), handle.getLocationHandle().getTargetPath().toString(), false, this.getPartitionUpdates(session, fragments)));
    }

    public List<ConnectorMetadataUpdateHandle> getMetadataUpdateResults(List<ConnectorMetadataUpdateHandle> metadataUpdateRequests, QueryId queryId) {
        return this.hiveFileRenamer.getMetadataUpdateResults(metadataUpdateRequests, queryId);
    }

    public void doMetadataUpdateCleanup(QueryId queryId) {
        this.hiveFileRenamer.cleanup(queryId);
    }

    private List<GrantInfo> buildGrants(ConnectorSession session, SchemaTableName tableName, PrestoPrincipal principal) {
        ImmutableList.Builder result = ImmutableList.builder();
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource());
        Set hivePrivileges = this.metastore.listTablePrivileges(metastoreContext, tableName.getSchemaName(), tableName.getTableName(), principal);
        for (HivePrivilegeInfo hivePrivilege : hivePrivileges) {
            Set prestoPrivileges = hivePrivilege.toPrivilegeInfo();
            for (PrivilegeInfo prestoPrivilege : prestoPrivileges) {
                GrantInfo grant = new GrantInfo(prestoPrivilege, hivePrivilege.getGrantee(), tableName, Optional.of(hivePrivilege.getGrantor()), Optional.empty());
                result.add((Object)grant);
            }
        }
        return result.build();
    }

    private static boolean hasAdminRole(Set<PrestoPrincipal> roles) {
        return roles.stream().anyMatch(principal -> principal.getName().equalsIgnoreCase("admin"));
    }

    public List<PartitionUpdate> getPartitionUpdates(ConnectorSession session, Collection<Slice> fragments) {
        boolean optimizedPartitionUpdateSerializationEnabled = HiveSessionProperties.isOptimizedPartitionUpdateSerializationEnabled(session);
        ImmutableList.Builder result = ImmutableList.builder();
        for (Slice fragment : fragments) {
            byte[] bytes = fragment.getBytes();
            PartitionUpdate partitionUpdate = optimizedPartitionUpdateSerializationEnabled ? HiveUtil.deserializeZstdCompressed(this.partitionUpdateSmileCodec, bytes) : (PartitionUpdate)this.partitionUpdateCodec.fromJson(bytes);
            result.add((Object)partitionUpdate);
        }
        return result.build();
    }

    private void verifyJvmTimeZone() {
        if (!this.allowCorruptWritesForTesting && !this.timeZone.equals((Object)DateTimeZone.getDefault())) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TIMEZONE_MISMATCH, String.format("To write Hive data, your JVM timezone must match the Hive storage timezone. Add -Duser.timezone=%s to your JVM arguments.", this.timeZone.getID()));
        }
    }

    private static HiveStorageFormat extractHiveStorageFormat(Table table) {
        StorageFormat storageFormat = table.getStorage().getStorageFormat();
        String outputFormat = storageFormat.getOutputFormat();
        String serde = storageFormat.getSerDe();
        for (HiveStorageFormat format : HiveStorageFormat.values()) {
            if (!format.getOutputFormat().equals(outputFormat) || !format.getSerDe().equals(serde)) continue;
            return format;
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, String.format("Output format %s with SerDe %s is not supported", outputFormat, serde));
    }

    @VisibleForTesting
    static String encodePreferredOrderingColumns(List<SortingColumn> preferredOrderingColumns) {
        return Joiner.on((char)',').join((Iterable)preferredOrderingColumns.stream().map(SortingColumn::sortingColumnToString).collect(ImmutableList.toImmutableList()));
    }

    @VisibleForTesting
    static List<SortingColumn> decodePreferredOrderingColumnsFromStorage(Storage storage) {
        if (!storage.getParameters().containsKey("preferred_ordering_columns")) {
            return ImmutableList.of();
        }
        return (List)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)storage.getParameters().get("preferred_ordering_columns")).stream().map(SortingColumn::sortingColumnFromString).collect(ImmutableList.toImmutableList());
    }

    private static void validateBucketColumns(ConnectorTableMetadata tableMetadata) {
        List bucketedBy;
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (!bucketProperty.isPresent()) {
            return;
        }
        Set allColumns = tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toSet());
        if (!allColumns.containsAll(bucketedBy = bucketProperty.get().getBucketedBy())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Bucketing columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf((Collection)bucketedBy), (Set)ImmutableSet.copyOf(allColumns))));
        }
        List sortedBy = (List)bucketProperty.get().getSortedBy().stream().map(SortingColumn::getColumnName).collect(ImmutableList.toImmutableList());
        if (!allColumns.containsAll(sortedBy)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Sorting columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf((Collection)sortedBy), (Set)ImmutableSet.copyOf(allColumns))));
        }
    }

    private static void validatePartitionColumns(ConnectorTableMetadata tableMetadata) {
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        List allColumns = tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
        if (!allColumns.containsAll(partitionedBy)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Partition columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf(partitionedBy), (Set)ImmutableSet.copyOf(allColumns))));
        }
        if (allColumns.size() == partitionedBy.size()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Table contains only partition columns");
        }
        if (!allColumns.subList(allColumns.size() - partitionedBy.size(), allColumns.size()).equals(partitionedBy)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_COLUMN_ORDER_MISMATCH, "Partition keys must be the last columns in the table and in the same order as the table properties: " + partitionedBy);
        }
    }

    protected Optional<TableEncryptionProperties> getTableEncryptionPropertiesFromTableProperties(ConnectorTableMetadata tableMetadata, HiveStorageFormat hiveStorageFormat, List<String> partitionedBy) {
        ColumnEncryptionInformation columnEncryptionInformation = HiveTableProperties.getEncryptColumns(tableMetadata.getProperties());
        String tableEncryptionReference = HiveTableProperties.getEncryptTable(tableMetadata.getProperties());
        if (!(tableEncryptionReference != null || columnEncryptionInformation != null && columnEncryptionInformation.hasEntries())) {
            return Optional.empty();
        }
        if (tableEncryptionReference != null && columnEncryptionInformation.hasEntries()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Only one of %s or %s should be specified", "encrypt_table", "encrypt_columns"));
        }
        if (hiveStorageFormat != HiveStorageFormat.DWRF) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Only DWRF file format supports encryption at this time");
        }
        if (tableEncryptionReference != null) {
            return Optional.of(HiveMetadata.getDwrfTableEncryptionProperties(Optional.of(tableEncryptionReference), Optional.empty(), tableMetadata));
        }
        partitionedBy.forEach(partitionColumn -> {
            if (columnEncryptionInformation.getColumnToKeyReference().containsKey(ColumnEncryptionInformation.ColumnWithStructSubfield.valueOf((String)partitionColumn))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Partition column (%s) cannot be used as an encryption column", partitionColumn));
            }
        });
        Map columnMetadata = (Map)tableMetadata.getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, Function.identity()));
        ArrayList sortedColumns = new ArrayList(columnEncryptionInformation.getColumnToKeyReference().keySet());
        sortedColumns.sort(Comparator.comparing(ColumnEncryptionInformation.ColumnWithStructSubfield::toString));
        HashSet<String> seenColumns = new HashSet<String>();
        for (ColumnEncryptionInformation.ColumnWithStructSubfield columnWithSubfield : sortedColumns) {
            ColumnMetadata column = (ColumnMetadata)columnMetadata.get(columnWithSubfield.getColumnName());
            if (column == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("In %s unable to find column %s", "encrypt_columns", columnWithSubfield.getColumnName()));
            }
            if (seenColumns.contains(columnWithSubfield.toString())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("The same column/subfield cannot have 2 encryption keys", new Object[0]));
            }
            if (columnWithSubfield.getSubfieldPath().isPresent()) {
                Iterable subfieldPathFragments = Splitter.on((String)".").split((CharSequence)columnWithSubfield.getSubfieldPath().get());
                Type columnType = column.getType();
                String parentPath = columnWithSubfield.getColumnName();
                for (String pathFragment : subfieldPathFragments) {
                    if (!(columnType instanceof RowType)) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("In %s subfields declared in %s, but %s has type %s", "encrypt_columns", columnWithSubfield.toString(), column.getName(), column.getType().getDisplayName()));
                    }
                    if (seenColumns.contains(parentPath)) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("For (%s) found a keyReference at a higher level field (%s)", columnWithSubfield.toString(), parentPath));
                    }
                    RowType row = (RowType)columnType;
                    columnType = row.getFields().stream().filter(f -> f.getName().orElse("").equals(pathFragment)).findAny().map(RowType.Field::getType).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("In %s subfields declared in %s, but %s has type %s", "encrypt_columns", columnWithSubfield.toString(), column.getName(), column.getType().getDisplayName())));
                    parentPath = String.format("%s.%s", parentPath, pathFragment);
                }
            }
            seenColumns.add(columnWithSubfield.toString());
        }
        return Optional.of(HiveMetadata.getDwrfTableEncryptionProperties(Optional.empty(), Optional.of(columnEncryptionInformation), tableMetadata));
    }

    private static DwrfTableEncryptionProperties getDwrfTableEncryptionProperties(Optional<String> encryptTable, Optional<ColumnEncryptionInformation> columnEncryptionInformation, ConnectorTableMetadata tableMetadata) {
        String encryptionAlgorithm = HiveTableProperties.getDwrfEncryptionAlgorithm(tableMetadata.getProperties());
        String encryptionProvider = HiveTableProperties.getDwrfEncryptionProvider(tableMetadata.getProperties());
        if (encryptionAlgorithm == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s needs to be provided for DWRF encrypted tables", "dwrf_encryption_algorithm"));
        }
        if (encryptionProvider == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s needs to be provided for DWRF encrypted tables", "dwrf_encryption_provider"));
        }
        return encryptTable.map(s -> DwrfTableEncryptionProperties.forTable(s, encryptionAlgorithm, encryptionProvider)).orElseGet(() -> DwrfTableEncryptionProperties.forPerColumn((ColumnEncryptionInformation)columnEncryptionInformation.orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "columnEncryptionInformation cannot be empty")), encryptionAlgorithm, encryptionProvider));
    }

    private static List<HiveColumnHandle> getColumnHandles(ConnectorTableMetadata tableMetadata, Set<String> partitionColumnNames, TypeTranslator typeTranslator) {
        HiveMetadata.validatePartitionColumns(tableMetadata);
        HiveMetadata.validateBucketColumns(tableMetadata);
        HiveMetadata.validateCsvColumns(tableMetadata);
        return HiveMetadata.getColumnHandles(tableMetadata.getColumns(), partitionColumnNames, typeTranslator);
    }

    private static List<HiveColumnHandle> getColumnHandles(List<ColumnMetadata> columns, Set<String> partitionColumnNames, TypeTranslator typeTranslator) {
        return HiveMetadata.getColumnHandles(columns, partitionColumnNames, typeTranslator, Optional.empty());
    }

    private static List<HiveColumnHandle> getColumnHandles(List<ColumnMetadata> columns, Set<String> partitionColumnNames, TypeTranslator typeTranslator, Optional<HiveType> defaultHiveType) {
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        int ordinal = 0;
        for (ColumnMetadata column : columns) {
            HiveColumnHandle.ColumnType columnType = partitionColumnNames.contains(column.getName()) ? HiveColumnHandle.ColumnType.PARTITION_KEY : (column.isHidden() ? HiveColumnHandle.ColumnType.SYNTHESIZED : HiveColumnHandle.ColumnType.REGULAR);
            columnHandles.add((Object)new HiveColumnHandle(column.getName(), HiveType.toHiveType((TypeTranslator)typeTranslator, (Type)column.getType(), defaultHiveType), column.getType().getTypeSignature(), ordinal, columnType, Optional.ofNullable(column.getComment()), Optional.empty()));
            ++ordinal;
        }
        return columnHandles.build();
    }

    private static void validateCsvColumns(ConnectorTableMetadata tableMetadata) {
        if (HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties()) != HiveStorageFormat.CSV) {
            return;
        }
        ImmutableSet partitionedBy = ImmutableSet.copyOf(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()));
        List unsupportedColumns = (List)tableMetadata.getColumns().stream().filter(arg_0 -> HiveMetadata.lambda$validateCsvColumns$95((Set)partitionedBy, arg_0)).filter(columnMetadata -> !columnMetadata.getType().equals(VarcharType.createUnboundedVarcharType())).collect(ImmutableList.toImmutableList());
        if (!unsupportedColumns.isEmpty()) {
            String joinedUnsupportedColumns = unsupportedColumns.stream().map(columnMetadata -> String.format("%s %s", columnMetadata.getName(), columnMetadata.getType())).collect(Collectors.joining(", "));
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive CSV storage format only supports VARCHAR (unbounded). Unsupported columns: " + joinedUnsupportedColumns);
        }
    }

    private static Function<HiveColumnHandle, ColumnMetadata> columnMetadataGetter(Table table, TypeManager typeManager) {
        ImmutableList.Builder columnNames = ImmutableList.builder();
        table.getPartitionColumns().stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)columnNames).add(arg_0));
        table.getDataColumns().stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)columnNames).add(arg_0));
        ImmutableList allColumnNames = columnNames.build();
        if (allColumnNames.size() > Sets.newHashSet((Iterable)allColumnNames).size()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Hive metadata for table %s is invalid: Table descriptor contains duplicate columns", table.getTableName()));
        }
        List tableColumns = table.getDataColumns();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Column field : Iterables.concat((Iterable)tableColumns, (Iterable)table.getPartitionColumns())) {
            if (field.getComment().isPresent() && !((String)field.getComment().get()).equals("from deserializer")) {
                builder.put((Object)field.getName(), (Object)field.getComment());
                continue;
            }
            builder.put((Object)field.getName(), Optional.empty());
        }
        builder.put((Object)"$path", Optional.empty());
        if (table.getStorage().getBucketProperty().isPresent()) {
            builder.put((Object)"$bucket", Optional.empty());
        }
        ImmutableMap columnComment = builder.build();
        return arg_0 -> HiveMetadata.lambda$columnMetadataGetter$98(typeManager, (Map)columnComment, arg_0);
    }

    @Override
    public void rollback() {
        this.metastore.rollback();
    }

    @Override
    public void commit() {
        this.metastore.commit();
    }

    public TableLayoutFilterCoverage getTableLayoutFilterCoverage(ConnectorTableLayoutHandle connectorTableLayoutHandle, Set<String> relevantPartitionColumns) {
        HiveTableLayoutHandle tableHandle = (HiveTableLayoutHandle)connectorTableLayoutHandle;
        Set relevantColumns = (Set)tableHandle.getPartitionColumns().stream().map(HiveColumnHandle::getName).filter(relevantPartitionColumns::contains).collect(ImmutableSet.toImmutableSet());
        if (relevantColumns.isEmpty()) {
            return TableLayoutFilterCoverage.NOT_APPLICABLE;
        }
        return Sets.intersection(tableHandle.getPredicateColumns().keySet(), (Set)relevantColumns).isEmpty() ? TableLayoutFilterCoverage.NOT_COVERED : TableLayoutFilterCoverage.COVERED;
    }

    public static Optional<SchemaTableName> getSourceTableNameFromSystemTable(SchemaTableName tableName) {
        return Stream.of(SystemTableHandler.values()).filter(handler -> handler.matches(tableName)).map(handler -> handler.getSourceTableName(tableName)).findAny();
    }

    private static SystemTable createSystemTable(final ConnectorTableMetadata metadata, final Function<TupleDomain<Integer>, RecordCursor> cursor) {
        return new SystemTable(){

            public SystemTable.Distribution getDistribution() {
                return SystemTable.Distribution.SINGLE_COORDINATOR;
            }

            public ConnectorTableMetadata getTableMetadata() {
                return metadata;
            }

            public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
                return (RecordCursor)cursor.apply(constraint);
            }
        };
    }

    private static <T> Optional<T> firstNonNullable(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private static /* synthetic */ ColumnMetadata lambda$columnMetadataGetter$98(TypeManager typeManager, Map columnComment, HiveColumnHandle handle) {
        return new ColumnMetadata(handle.getName(), typeManager.getType(handle.getTypeSignature()), (String)((Optional)columnComment.get(handle.getName())).orElse(null), HiveUtil.columnExtraInfo(handle.isPartitionKey()), handle.isHidden());
    }

    private static /* synthetic */ boolean lambda$validateCsvColumns$95(Set partitionedBy, ColumnMetadata columnMetadata) {
        return !partitionedBy.contains(columnMetadata.getName());
    }

    private static /* synthetic */ RecordCursor lambda$getPropertiesSystemTable$1(List types, Iterable propertyValues, TupleDomain constraint) {
        return new InMemoryRecordSet((Collection)types, propertyValues).cursor();
    }

    private static enum SystemTableHandler {
        PARTITIONS,
        PROPERTIES;

        private final String suffix = "$" + this.name().toLowerCase(Locale.ENGLISH);

        boolean matches(SchemaTableName table) {
            return table.getTableName().endsWith(this.suffix) && table.getTableName().length() > this.suffix.length();
        }

        SchemaTableName getSourceTableName(SchemaTableName table) {
            return new SchemaTableName(table.getSchemaName(), table.getTableName().substring(0, table.getTableName().length() - this.suffix.length()));
        }
    }
}

