/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitPartitionInfo;
import com.facebook.presto.hive.TableToPartitionMapping;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.fs.Path;
import org.openjdk.jol.info.ClassLayout;

@NotThreadSafe
public class InternalHiveSplit {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(InternalHiveSplit.class).instanceSize();
    private static final int HOST_ADDRESS_INSTANCE_SIZE = ClassLayout.parseClass(HostAddress.class).instanceSize() + ClassLayout.parseClass(String.class).instanceSize();
    private final byte[] relativeUri;
    private final long end;
    private final long fileSize;
    private final long[] blockEndOffsets;
    private final List<List<HostAddress>> blockAddresses;
    private final int readBucketNumber;
    private final int tableBucketNumber;
    private final boolean splittable;
    private final NodeSelectionStrategy nodeSelectionStrategy;
    private final boolean s3SelectPushdownEnabled;
    private final HiveSplitPartitionInfo partitionInfo;
    private final Optional<byte[]> extraFileInfo;
    private final Optional<EncryptionInformation> encryptionInformation;
    private final Map<String, String> customSplitInfo;
    private long start;
    private int currentBlockIndex;

    public InternalHiveSplit(String relativeUri, long start, long end, long fileSize, List<InternalHiveBlock> blocks, OptionalInt readBucketNumber, OptionalInt tableBucketNumber, boolean splittable, NodeSelectionStrategy nodeSelectionStrategy, boolean s3SelectPushdownEnabled, HiveSplitPartitionInfo partitionInfo, Optional<byte[]> extraFileInfo, Optional<EncryptionInformation> encryptionInformation, Map<String, String> customSplitInfo) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start must be positive");
        Preconditions.checkArgument((end >= 0L ? 1 : 0) != 0, (Object)"end must be positive");
        Preconditions.checkArgument((fileSize >= 0L ? 1 : 0) != 0, (Object)"fileSize must be positive");
        Objects.requireNonNull(relativeUri, "relativeUri is null");
        Objects.requireNonNull(readBucketNumber, "readBucketNumber is null");
        Objects.requireNonNull(tableBucketNumber, "tableBucketNumber is null");
        Objects.requireNonNull(nodeSelectionStrategy, "nodeSelectionStrategy is null");
        Objects.requireNonNull(partitionInfo, "partitionInfo is null");
        Objects.requireNonNull(extraFileInfo, "extraFileInfo is null");
        Objects.requireNonNull(encryptionInformation, "encryptionInformation is null");
        this.relativeUri = relativeUri.getBytes(StandardCharsets.UTF_8);
        this.start = start;
        this.end = end;
        this.fileSize = fileSize;
        this.readBucketNumber = readBucketNumber.orElse(-1);
        this.tableBucketNumber = tableBucketNumber.orElse(-1);
        this.splittable = splittable;
        this.nodeSelectionStrategy = nodeSelectionStrategy;
        this.s3SelectPushdownEnabled = s3SelectPushdownEnabled;
        this.partitionInfo = partitionInfo;
        this.extraFileInfo = extraFileInfo;
        this.customSplitInfo = ImmutableMap.copyOf(Objects.requireNonNull(customSplitInfo, "customSplitInfo is null"));
        ImmutableList.Builder addressesBuilder = ImmutableList.builder();
        this.blockEndOffsets = new long[blocks.size()];
        boolean allAddressesEmpty = true;
        for (int i = 0; i < blocks.size(); ++i) {
            InternalHiveBlock block = blocks.get(i);
            List<HostAddress> addresses = block.getAddresses();
            allAddressesEmpty = allAddressesEmpty && addresses.isEmpty();
            addressesBuilder.add(addresses);
            this.blockEndOffsets[i] = block.getEnd();
        }
        this.blockAddresses = allAddressesEmpty ? ImmutableList.of() : addressesBuilder.build();
        this.encryptionInformation = encryptionInformation;
    }

    public String getPath() {
        String relativePathString = new String(this.relativeUri, StandardCharsets.UTF_8);
        return new Path(this.partitionInfo.getPath().resolve(relativePathString)).toString();
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public boolean isS3SelectPushdownEnabled() {
        return this.s3SelectPushdownEnabled;
    }

    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionInfo.getPartitionKeys();
    }

    public String getPartitionName() {
        return this.partitionInfo.getPartitionName();
    }

    public OptionalInt getReadBucketNumber() {
        return this.readBucketNumber >= 0 ? OptionalInt.of(this.readBucketNumber) : OptionalInt.empty();
    }

    public OptionalInt getTableBucketNumber() {
        return this.tableBucketNumber >= 0 ? OptionalInt.of(this.tableBucketNumber) : OptionalInt.empty();
    }

    public boolean isSplittable() {
        return this.splittable;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return this.nodeSelectionStrategy;
    }

    public TableToPartitionMapping getTableToPartitionMapping() {
        return this.partitionInfo.getTableToPartitionMapping();
    }

    public Optional<HiveSplit.BucketConversion> getBucketConversion() {
        return this.partitionInfo.getBucketConversion();
    }

    public InternalHiveBlock currentBlock() {
        Preconditions.checkState((!this.isDone() ? 1 : 0) != 0, (Object)"All blocks have been consumed");
        ImmutableList addresses = this.blockAddresses.isEmpty() ? ImmutableList.of() : this.blockAddresses.get(this.currentBlockIndex);
        return new InternalHiveBlock(this.blockEndOffsets[this.currentBlockIndex], (List<HostAddress>)addresses);
    }

    public boolean isDone() {
        return this.currentBlockIndex == this.blockEndOffsets.length;
    }

    public void increaseStart(long value) {
        this.start += value;
        if (this.start == this.currentBlock().getEnd()) {
            ++this.currentBlockIndex;
        }
    }

    public HiveSplitPartitionInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    public Optional<byte[]> getExtraFileInfo() {
        return this.extraFileInfo;
    }

    public Optional<EncryptionInformation> getEncryptionInformation() {
        return this.encryptionInformation;
    }

    public Map<String, String> getCustomSplitInfo() {
        return this.customSplitInfo;
    }

    public void reset() {
        this.currentBlockIndex = 0;
        this.start = 0L;
    }

    public int getEstimatedSizeInBytes() {
        int result = INSTANCE_SIZE;
        result = (int)((long)result + SizeOf.sizeOf((byte[])this.relativeUri));
        result = (int)((long)result + SizeOf.sizeOf((long[])this.blockEndOffsets));
        if (!this.blockAddresses.isEmpty()) {
            result = (int)((long)result + SizeOf.sizeOfObjectArray((int)this.blockAddresses.size()));
            for (List<HostAddress> addresses : this.blockAddresses) {
                result = (int)((long)result + SizeOf.sizeOfObjectArray((int)addresses.size()));
                for (HostAddress address : addresses) {
                    result += HOST_ADDRESS_INSTANCE_SIZE + address.getHostText().length() * 2;
                }
            }
        }
        if (this.extraFileInfo.isPresent()) {
            result = (int)((long)result + SizeOf.sizeOf((byte[])this.extraFileInfo.get()));
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("relativeUri", (Object)new String(this.relativeUri, StandardCharsets.UTF_8)).add("start", this.start).add("end", this.end).add("fileSize", this.fileSize).toString();
    }

    public static class InternalHiveBlock {
        private final long end;
        private final List<HostAddress> addresses;

        public InternalHiveBlock(long end, List<HostAddress> addresses) {
            Preconditions.checkArgument((end >= 0L ? 1 : 0) != 0, (Object)"block end must be >= 0");
            this.end = end;
            this.addresses = ImmutableList.copyOf(addresses);
        }

        public long getEnd() {
            return this.end;
        }

        public List<HostAddress> getAddresses() {
            return this.addresses;
        }
    }
}

