/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.hive.orc.OrcOutputFormat;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.DwrfEncryptionMetadata;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveDwrfEncryptionProvider;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.hive.HiveFileWriterFactory;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.OrcFileWriter;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.datasink.DataSinkFactory;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.orc.HdfsOrcDataSource;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfWriterEncryption;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcWriterStats;
import com.facebook.presto.orc.WriterEncryptionGroup;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.KeyProvider;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.orc.OrcConf;
import org.joda.time.DateTimeZone;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class OrcFileWriterFactory
implements HiveFileWriterFactory {
    private final DateTimeZone hiveStorageTimeZone;
    private final HdfsEnvironment hdfsEnvironment;
    private final DataSinkFactory dataSinkFactory;
    private final TypeManager typeManager;
    private final NodeVersion nodeVersion;
    private final FileFormatDataSourceStats readStats;
    private final OrcWriterStats stats = new OrcWriterStats();
    private final OrcFileWriterConfig orcFileWriterConfig;
    private final DwrfEncryptionProvider dwrfEncryptionProvider;

    @Inject
    public OrcFileWriterFactory(HdfsEnvironment hdfsEnvironment, DataSinkFactory dataSinkFactory, TypeManager typeManager, NodeVersion nodeVersion, HiveClientConfig hiveClientConfig, FileFormatDataSourceStats readStats, OrcFileWriterConfig orcFileWriterConfig, HiveDwrfEncryptionProvider dwrfEncryptionProvider) {
        this(hdfsEnvironment, dataSinkFactory, typeManager, nodeVersion, Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null").getDateTimeZone(), readStats, orcFileWriterConfig, dwrfEncryptionProvider);
    }

    public OrcFileWriterFactory(HdfsEnvironment hdfsEnvironment, DataSinkFactory dataSinkFactory, TypeManager typeManager, NodeVersion nodeVersion, DateTimeZone hiveStorageTimeZone, FileFormatDataSourceStats readStats, OrcFileWriterConfig orcFileWriterConfig, HiveDwrfEncryptionProvider dwrfEncryptionProvider) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.dataSinkFactory = Objects.requireNonNull(dataSinkFactory, "dataSinkFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.hiveStorageTimeZone = Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        this.readStats = Objects.requireNonNull(readStats, "stats is null");
        this.orcFileWriterConfig = Objects.requireNonNull(orcFileWriterConfig, "orcFileWriterConfig is null");
        this.dwrfEncryptionProvider = Objects.requireNonNull(dwrfEncryptionProvider, "DwrfEncryptionProvider is null").toDwrfEncryptionProvider();
    }

    @Managed
    @Flatten
    public OrcWriterStats getStats() {
        return this.stats;
    }

    @Override
    public Optional<HiveFileWriter> createFileWriter(Path path, List<String> inputColumnNames, StorageFormat storageFormat, Properties schema, JobConf configuration, ConnectorSession session, Optional<EncryptionInformation> encryptionInformation) {
        OrcEncoding orcEncoding;
        if (!HiveSessionProperties.isOrcOptimizedWriterEnabled(session)) {
            return Optional.empty();
        }
        if (org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat.class.getName().equals(storageFormat.getOutputFormat())) {
            orcEncoding = OrcEncoding.ORC;
        } else if (OrcOutputFormat.class.getName().equals(storageFormat.getOutputFormat())) {
            orcEncoding = OrcEncoding.DWRF;
        } else {
            return Optional.empty();
        }
        CompressionKind compression = OrcFileWriterFactory.getCompression(schema, configuration, orcEncoding);
        List fileColumnNames = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)schema.getProperty("columns", ""));
        List<Type> fileColumnTypes = HiveType.toHiveTypes((String)schema.getProperty("columns.types", "")).stream().map(hiveType -> hiveType.getType(this.typeManager)).collect(Collectors.toList());
        int[] fileInputColumnIndexes = fileColumnNames.stream().mapToInt(inputColumnNames::indexOf).toArray();
        try {
            ExtendedFileSystem fileSystem = this.hdfsEnvironment.getFileSystem(session.getUser(), path, (Configuration)configuration);
            DataSink dataSink = this.createDataSink(session, (FileSystem)fileSystem, path);
            Optional<Supplier<OrcDataSource>> validationInputFactory = Optional.empty();
            if (HiveSessionProperties.isOrcOptimizedWriterValidate(session)) {
                validationInputFactory = Optional.of(() -> this.lambda$createFileWriter$1(path, (FileSystem)fileSystem, session));
            }
            Callable<Void> rollbackAction = () -> OrcFileWriterFactory.lambda$createFileWriter$2((FileSystem)fileSystem, path);
            Optional<DwrfWriterEncryption> dwrfWriterEncryption = this.createDwrfEncryption(encryptionInformation, fileColumnNames, fileColumnTypes);
            return Optional.of(new OrcFileWriter(dataSink, rollbackAction, orcEncoding, fileColumnNames, fileColumnTypes, compression, this.orcFileWriterConfig.toOrcWriterOptionsBuilder().withStripeMinSize(HiveSessionProperties.getOrcOptimizedWriterMinStripeSize(session)).withStripeMaxSize(HiveSessionProperties.getOrcOptimizedWriterMaxStripeSize(session)).withStripeMaxRowCount(HiveSessionProperties.getOrcOptimizedWriterMaxStripeRows(session)).withDictionaryMaxMemory(HiveSessionProperties.getOrcOptimizedWriterMaxDictionaryMemory(session)).withMaxStringStatisticsLimit(HiveSessionProperties.getOrcStringStatisticsLimit(session)).build(), fileInputColumnIndexes, (Map<String, String>)ImmutableMap.builder().put((Object)"presto_version", (Object)this.nodeVersion.toString()).put((Object)"presto_query_id", (Object)session.getQueryId()).build(), this.hiveStorageTimeZone, validationInputFactory, HiveSessionProperties.getOrcOptimizedWriterValidateMode(session), (WriterStats)this.stats, this.dwrfEncryptionProvider, dwrfWriterEncryption));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, "Error creating " + orcEncoding + " file", (Throwable)e);
        }
    }

    private Optional<DwrfWriterEncryption> createDwrfEncryption(Optional<EncryptionInformation> encryptionInformation, List<String> fileColumnNames, List<Type> types) {
        if (!encryptionInformation.isPresent()) {
            return Optional.empty();
        }
        if (!encryptionInformation.get().getDwrfEncryptionMetadata().isPresent()) {
            return Optional.empty();
        }
        DwrfEncryptionMetadata dwrfEncryptionMetadata = encryptionInformation.get().getDwrfEncryptionMetadata().get();
        List orcTypes = OrcType.createOrcRowType((int)0, fileColumnNames, types);
        Map columnNamesMap = (Map)IntStream.range(0, fileColumnNames.size()).boxed().collect(ImmutableMap.toImmutableMap(fileColumnNames::get, index -> index));
        Map<Integer, Slice> keyMap = dwrfEncryptionMetadata.toKeyMap((List<OrcType>)orcTypes, columnNamesMap);
        ImmutableListMultimap.Builder encryptionGroupsBuilder = ImmutableListMultimap.builder();
        keyMap.entrySet().stream().forEach(entry -> encryptionGroupsBuilder.put(entry.getValue(), entry.getKey()));
        ImmutableListMultimap encryptionGroups = encryptionGroupsBuilder.build();
        List writerEncryptionGroups = (List)encryptionGroups.keySet().stream().map(key -> new WriterEncryptionGroup((List)encryptionGroups.get(key), key)).collect(ImmutableList.toImmutableList());
        return Optional.of(new DwrfWriterEncryption(this.toKeyProvider(dwrfEncryptionMetadata.getEncryptionProvider()), writerEncryptionGroups));
    }

    public KeyProvider toKeyProvider(String keyProviderName) {
        if (keyProviderName.toLowerCase(Locale.ENGLISH).equals("crypto")) {
            return KeyProvider.CRYPTO_SERVICE;
        }
        return KeyProvider.UNKNOWN;
    }

    public DataSink createDataSink(ConnectorSession session, FileSystem fileSystem, Path path) throws IOException {
        return this.dataSinkFactory.createDataSink(session, fileSystem, path);
    }

    private static CompressionKind getCompression(Properties schema, JobConf configuration, OrcEncoding orcEncoding) {
        CompressionKind compression;
        String compressionName = OrcConf.COMPRESS.getString(schema, (Configuration)configuration);
        if (compressionName == null) {
            return CompressionKind.ZLIB;
        }
        try {
            compression = CompressionKind.valueOf((String)compressionName.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Unknown " + orcEncoding + " compression type " + compressionName);
        }
        return compression;
    }

    private static /* synthetic */ Void lambda$createFileWriter$2(FileSystem fileSystem, Path path) throws Exception {
        fileSystem.delete(path, false);
        return null;
    }

    private /* synthetic */ OrcDataSource lambda$createFileWriter$1(Path path, FileSystem fileSystem, ConnectorSession session) {
        try {
            return new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), fileSystem.getFileStatus(path).getLen(), HiveSessionProperties.getOrcMaxMergeDistance(session), HiveSessionProperties.getOrcMaxBufferSize(session), HiveSessionProperties.getOrcStreamBufferSize(session), false, fileSystem.open(path), this.readStats);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITE_VALIDATION_FAILED, (Throwable)e);
        }
    }
}

