/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.metadata.OrcType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.fs.Path;

public class ProjectionBasedDwrfKeyProvider
implements DwrfKeyProvider {
    private final List<HiveColumnHandle> columns;
    private final boolean useOrcColumnNames;
    private final Path path;
    private final Optional<EncryptionInformation> encryptionInformation;
    private Map<Integer, Slice> keys;

    public ProjectionBasedDwrfKeyProvider(Optional<EncryptionInformation> encryptionInformation, List<HiveColumnHandle> columns, boolean useOrcColumnNames, Path path) {
        this.encryptionInformation = encryptionInformation;
        this.columns = ImmutableList.copyOf(columns);
        this.useOrcColumnNames = useOrcColumnNames;
        this.path = path;
    }

    public Map<Integer, Slice> getIntermediateKeys(List<OrcType> types) {
        if (this.keys == null) {
            if (this.encryptionInformation.isPresent() && this.encryptionInformation.get().getDwrfEncryptionMetadata().isPresent()) {
                List<HiveColumnHandle> physicalColumns = HiveUtil.getPhysicalHiveColumnHandles(this.columns, this.useOrcColumnNames, types, this.path);
                this.keys = this.encryptionInformation.get().getDwrfEncryptionMetadata().get().toKeyMap(types, physicalColumns);
            } else {
                this.keys = ImmutableMap.of();
            }
        }
        return this.keys;
    }
}

