/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.rule;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HiveAddRequestedColumnsToLayout
implements ConnectorPlanOptimizer {
    public PlanNode optimize(PlanNode maxSubplan, ConnectorSession session, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(maxSubplan, "maxSubplan is null");
        return (PlanNode)maxSubplan.accept((PlanVisitor)new Visitor(), null);
    }

    private class Visitor
    extends PlanVisitor<PlanNode, Void> {
        private Visitor() {
        }

        public PlanNode visitPlan(PlanNode node, Void context) {
            ImmutableList.Builder children = ImmutableList.builder();
            boolean changed = false;
            for (PlanNode child : node.getSources()) {
                PlanNode newChild = (PlanNode)child.accept((PlanVisitor)this, null);
                if (newChild != child) {
                    changed = true;
                }
                children.add((Object)newChild);
            }
            if (!changed) {
                return node;
            }
            return node.replaceChildren((List)children.build());
        }

        public PlanNode visitTableScan(TableScanNode tableScan, Void context) {
            Optional layout = tableScan.getTable().getLayout();
            if (!layout.isPresent()) {
                return tableScan;
            }
            HiveTableLayoutHandle hiveLayout = (HiveTableLayoutHandle)layout.get();
            HiveTableLayoutHandle hiveLayoutWithDesiredColumns = new HiveTableLayoutHandle(hiveLayout.getSchemaTableName(), hiveLayout.getTablePath(), hiveLayout.getPartitionColumns(), hiveLayout.getDataColumns(), hiveLayout.getTableParameters(), hiveLayout.getPartitions().get(), hiveLayout.getDomainPredicate(), hiveLayout.getRemainingPredicate(), hiveLayout.getPredicateColumns(), hiveLayout.getPartitionColumnPredicate(), hiveLayout.getBucketHandle(), hiveLayout.getBucketFilter(), hiveLayout.isPushdownFilterEnabled(), hiveLayout.getLayoutString(), Optional.of(tableScan.getOutputVariables().stream().map(output -> (HiveColumnHandle)tableScan.getAssignments().get(output)).collect(ImmutableSet.toImmutableSet())), hiveLayout.isPartialAggregationsPushedDown());
            return new TableScanNode(tableScan.getId(), new TableHandle(tableScan.getTable().getConnectorId(), tableScan.getTable().getConnectorHandle(), tableScan.getTable().getTransaction(), Optional.of(hiveLayoutWithDesiredColumns)), tableScan.getOutputVariables(), tableScan.getAssignments(), tableScan.getCurrentConstraint(), tableScan.getEnforcedConstraint());
        }
    }
}

