/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.ColumnReader;
import com.facebook.presto.parquet.DataPage;
import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.ParquetErrorCode;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.batchreader.decoders.Decoders;
import com.facebook.presto.parquet.batchreader.decoders.FlatDefinitionLevelDecoder;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.dictionary.Dictionaries;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.facebook.presto.parquet.reader.ColumnChunk;
import com.facebook.presto.parquet.reader.PageReader;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.io.ParquetDecodingException;

public class Int64FlatBatchReader
implements ColumnReader {
    private final RichColumnDescriptor columnDescriptor;
    protected Field field;
    protected int nextBatchSize;
    protected FlatDefinitionLevelDecoder definitionLevelDecoder;
    protected ValuesDecoder.Int64ValuesDecoder valuesDecoder;
    protected int remainingCountInPage;
    private Dictionary dictionary;
    private int readOffset;
    private PageReader pageReader;

    public Int64FlatBatchReader(RichColumnDescriptor columnDescriptor) {
        this.columnDescriptor = Objects.requireNonNull(columnDescriptor, "columnDescriptor is null");
    }

    @Override
    public boolean isInitialized() {
        return this.pageReader != null && this.field != null;
    }

    @Override
    public void init(PageReader pageReader, Field field) {
        Preconditions.checkArgument((!this.isInitialized() ? 1 : 0) != 0, (Object)"Parquet batch reader already initialized");
        this.pageReader = Objects.requireNonNull(pageReader, "pageReader is null");
        Preconditions.checkArgument((pageReader.getTotalValueCount() > 0L ? 1 : 0) != 0, (Object)"page is empty");
        this.field = Objects.requireNonNull(field, "field is null");
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            this.dictionary = Dictionaries.createDictionary(this.columnDescriptor, dictionaryPage);
        }
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public ColumnChunk readNext() {
        ColumnChunk columnChunk = null;
        try {
            this.seek();
            columnChunk = this.field.isRequired() ? this.readWithoutNull() : this.readWithNull();
        }
        catch (IOException exception) {
            throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_IO_READ_ERROR, "Error reading Parquet column " + (Object)((Object)this.columnDescriptor), (Throwable)exception);
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return columnChunk;
    }

    protected boolean readNextPage() {
        this.definitionLevelDecoder = null;
        this.valuesDecoder = null;
        this.remainingCountInPage = 0;
        DataPage page = this.pageReader.readPage();
        if (page == null) {
            return false;
        }
        Decoders.FlatDecoders flatDecoders = Decoders.readFlatPage(page, this.columnDescriptor, this.dictionary);
        this.definitionLevelDecoder = flatDecoders.getDefinitionLevelDecoder();
        this.valuesDecoder = (ValuesDecoder.Int64ValuesDecoder)flatDecoders.getValuesDecoder();
        this.remainingCountInPage = page.getValueCount();
        return true;
    }

    private ColumnChunk readWithNull() throws IOException {
        long[] values = new long[this.nextBatchSize];
        boolean[] isNull = new boolean[this.nextBatchSize];
        int totalNonNullCount = 0;
        int remainingInBatch = this.nextBatchSize;
        int startOffset = 0;
        while (remainingInBatch > 0 && (this.remainingCountInPage != 0 || this.readNextPage())) {
            int chunkSize = Math.min(this.remainingCountInPage, remainingInBatch);
            int nonNullCount = this.definitionLevelDecoder.readNext(isNull, startOffset, chunkSize);
            totalNonNullCount += nonNullCount;
            if (nonNullCount > 0) {
                this.valuesDecoder.readNext(values, startOffset, nonNullCount);
                int valueSourceIndex = startOffset + nonNullCount - 1;
                for (int valueDestinationIndex = startOffset + chunkSize - 1; valueDestinationIndex >= startOffset; --valueDestinationIndex) {
                    if (isNull[valueDestinationIndex]) continue;
                    values[valueDestinationIndex] = values[valueSourceIndex];
                    --valueSourceIndex;
                }
            }
            startOffset += chunkSize;
            remainingInBatch -= chunkSize;
            this.remainingCountInPage -= chunkSize;
        }
        if (remainingInBatch != 0) {
            throw new ParquetDecodingException("Still remaining to be read in current batch.");
        }
        if (totalNonNullCount == 0) {
            Block block = RunLengthEncodedBlock.create((Type)this.field.getType(), null, (int)this.nextBatchSize);
            return new ColumnChunk(block, new int[0], new int[0]);
        }
        boolean hasNoNull = totalNonNullCount == this.nextBatchSize;
        LongArrayBlock block = new LongArrayBlock(this.nextBatchSize, hasNoNull ? Optional.empty() : Optional.of(isNull), values);
        return new ColumnChunk((Block)block, new int[0], new int[0]);
    }

    private ColumnChunk readWithoutNull() throws IOException {
        long[] values = new long[this.nextBatchSize];
        int remainingInBatch = this.nextBatchSize;
        int startOffset = 0;
        while (remainingInBatch > 0 && (this.remainingCountInPage != 0 || this.readNextPage())) {
            int chunkSize = Math.min(this.remainingCountInPage, remainingInBatch);
            this.valuesDecoder.readNext(values, startOffset, chunkSize);
            startOffset += chunkSize;
            remainingInBatch -= chunkSize;
            this.remainingCountInPage -= chunkSize;
        }
        if (remainingInBatch != 0) {
            throw new ParquetDecodingException(String.format("Corrupted Parquet file: extra %d values to be consumed when scanning current batch", remainingInBatch));
        }
        LongArrayBlock block = new LongArrayBlock(this.nextBatchSize, Optional.empty(), values);
        return new ColumnChunk((Block)block, new int[0], new int[0]);
    }

    private void seek() throws IOException {
        if (this.readOffset == 0) {
            return;
        }
        int remainingInBatch = this.readOffset;
        int startOffset = 0;
        while (remainingInBatch > 0 && (this.remainingCountInPage != 0 || this.readNextPage())) {
            int chunkSize;
            int skipSize = chunkSize = Math.min(this.remainingCountInPage, remainingInBatch);
            if (!this.columnDescriptor.isRequired()) {
                int nonNullCount;
                boolean[] isNull = new boolean[this.readOffset];
                skipSize = nonNullCount = this.definitionLevelDecoder.readNext(isNull, startOffset, chunkSize);
                startOffset += chunkSize;
            }
            this.valuesDecoder.skip(skipSize);
            remainingInBatch -= chunkSize;
            this.remainingCountInPage -= chunkSize;
        }
    }
}

