/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieArchivedTimeline
extends HoodieDefaultTimeline {
    private static final Pattern ARCHIVE_FILE_PATTERN = Pattern.compile("^\\.commits_\\.archive\\.([0-9]*)$");
    private static final String HOODIE_COMMIT_ARCHIVE_LOG_FILE_PREFIX = "commits";
    private static final String ACTION_TYPE_KEY = "actionType";
    private HoodieTableMetaClient metaClient;
    private Map<String, byte[]> readCommits = new HashMap<String, byte[]>();
    private static final Logger LOG = LogManager.getLogger(HoodieArchivedTimeline.class);

    public HoodieArchivedTimeline(HoodieTableMetaClient metaClient) {
        this.metaClient = metaClient;
        this.setInstants(this.loadInstants(false));
        this.details = this::getInstantDetails;
    }

    public HoodieArchivedTimeline() {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public static Path getArchiveLogPath(String archiveFolder) {
        return new Path(archiveFolder, HOODIE_COMMIT_ARCHIVE_LOG_FILE_PREFIX);
    }

    public void loadInstantDetailsInMemory(String startTs, String endTs) {
        this.loadInstants(startTs, endTs);
    }

    public void clearInstantDetailsFromMemory(String startTs, String endTs) {
        this.findInstantsInRange(startTs, endTs).getInstants().forEach(instant -> this.readCommits.remove(instant.getTimestamp()));
    }

    @Override
    public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        return Option.ofNullable(this.readCommits.get(instant.getTimestamp()));
    }

    public HoodieArchivedTimeline reload() {
        return new HoodieArchivedTimeline(this.metaClient);
    }

    private HoodieInstant readCommit(GenericRecord record, boolean loadDetails) {
        String commitTime = record.get("commitTime").toString();
        String action = record.get(ACTION_TYPE_KEY).toString();
        if (loadDetails) {
            Option.ofNullable(record.get(this.getMetadataKey(action))).map(actionData -> this.readCommits.put(commitTime, actionData.toString().getBytes(StandardCharsets.UTF_8)));
        }
        return new HoodieInstant(false, action, commitTime);
    }

    private String getMetadataKey(String action) {
        switch (action) {
            case "clean": {
                return "hoodieCleanMetadata";
            }
            case "commit": {
                return "hoodieCommitMetadata";
            }
            case "deltacommit": {
                return "hoodieCommitMetadata";
            }
            case "rollback": {
                return "hoodieRollbackMetadata";
            }
            case "savepoint": {
                return "hoodieSavePointMetadata";
            }
        }
        throw new HoodieIOException("Unknown action in metadata " + action);
    }

    private List<HoodieInstant> loadInstants(boolean loadInstantDetails) {
        return this.loadInstants(null, loadInstantDetails);
    }

    private List<HoodieInstant> loadInstants(String startTs, String endTs) {
        return this.loadInstants(new TimeRangeFilter(startTs, endTs), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HoodieInstant> loadInstants(TimeRangeFilter filter, boolean loadInstantDetails) {
        try {
            FileStatus[] fsStatuses = this.metaClient.getFs().globStatus(new Path(this.metaClient.getArchivePath() + "/.commits_.archive*"));
            Arrays.sort(fsStatuses, new ArchiveFileVersionComparator());
            ArrayList<HoodieInstant> instantsInRange = new ArrayList<HoodieInstant>();
            for (FileStatus fs : fsStatuses) {
                try (HoodieLogFormat.Reader reader = HoodieLogFormat.newReader(this.metaClient.getFs(), new HoodieLogFile(fs.getPath()), HoodieArchivedMetaEntry.getClassSchema());){
                    int instantsInPreviousFile = instantsInRange.size();
                    while (reader.hasNext()) {
                        HoodieAvroDataBlock blk = (HoodieAvroDataBlock)reader.next();
                        List<IndexedRecord> records = blk.getRecords();
                        Stream<HoodieInstant> instantsInBlkStream = records.stream().map(r -> this.readCommit((GenericRecord)r, loadInstantDetails));
                        if (filter != null) {
                            instantsInBlkStream = instantsInBlkStream.filter(filter::isInRange);
                        }
                        instantsInRange.addAll(instantsInBlkStream.collect(Collectors.toList()));
                    }
                    if (filter == null) continue;
                    int instantsInCurrentFile = instantsInRange.size() - instantsInPreviousFile;
                    if (instantsInPreviousFile <= 0 || instantsInCurrentFile != 0) continue;
                    break;
                }
            }
            return instantsInRange;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not load archived commit timeline from path " + this.metaClient.getArchivePath(), e);
        }
    }

    public static class ArchiveFileVersionComparator
    implements Comparator<FileStatus>,
    Serializable {
        @Override
        public int compare(FileStatus f1, FileStatus f2) {
            return Integer.compare(this.getArchivedFileSuffix(f2), this.getArchivedFileSuffix(f1));
        }

        private int getArchivedFileSuffix(FileStatus f) {
            try {
                Matcher fileMatcher = ARCHIVE_FILE_PATTERN.matcher(f.getPath().getName());
                if (fileMatcher.matches()) {
                    return Integer.parseInt(fileMatcher.group(1));
                }
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("error getting suffix for archived file: " + f.getPath()));
            }
            return 0;
        }
    }

    private static class TimeRangeFilter {
        private final String startTs;
        private final String endTs;

        public TimeRangeFilter(String startTs, String endTs) {
            this.startTs = startTs;
            this.endTs = endTs;
        }

        public boolean isInRange(HoodieInstant instant) {
            return HoodieTimeline.isInRange(instant.getTimestamp(), this.startTs, this.endTs);
        }
    }
}

