/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.view.IncrementalTimelineSyncFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieTableFileSystemView
extends IncrementalTimelineSyncFileSystemView {
    private static final Logger LOG = LogManager.getLogger(HoodieTableFileSystemView.class);
    protected Map<String, List<HoodieFileGroup>> partitionToFileGroupsMap;
    protected Map<HoodieFileGroupId, Pair<String, CompactionOperation>> fgIdToPendingCompaction;
    private boolean closed = false;

    HoodieTableFileSystemView(boolean enableIncrementalTimelineSync) {
        super(enableIncrementalTimelineSync);
    }

    public HoodieTableFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline) {
        this(metaClient, visibleActiveTimeline, false);
    }

    public HoodieTableFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, boolean enableIncrementalTimelineSync) {
        super(enableIncrementalTimelineSync);
        this.init(metaClient, visibleActiveTimeline);
    }

    @Override
    public void init(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline) {
        this.partitionToFileGroupsMap = this.createPartitionToFileGroups();
        super.init(metaClient, visibleActiveTimeline);
    }

    public void init(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, FileStatus[] fileStatuses) {
        this.init(metaClient, visibleActiveTimeline);
        this.addFilesToView(fileStatuses);
    }

    @Override
    protected void resetViewState() {
        this.fgIdToPendingCompaction = null;
        this.partitionToFileGroupsMap = null;
    }

    protected Map<String, List<HoodieFileGroup>> createPartitionToFileGroups() {
        return new ConcurrentHashMap<String, List<HoodieFileGroup>>();
    }

    protected Map<HoodieFileGroupId, Pair<String, CompactionOperation>> createFileIdToPendingCompactionMap(Map<HoodieFileGroupId, Pair<String, CompactionOperation>> fileIdToPendingCompaction) {
        return fileIdToPendingCompaction;
    }

    public HoodieTableFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, FileStatus[] fileStatuses) {
        this(metaClient, visibleActiveTimeline);
        this.addFilesToView(fileStatuses);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    @Override
    protected boolean isPendingCompactionScheduledForFileId(HoodieFileGroupId fgId) {
        return this.fgIdToPendingCompaction.containsKey(fgId);
    }

    @Override
    protected void resetPendingCompactionOperations(Stream<Pair<String, CompactionOperation>> operations) {
        this.fgIdToPendingCompaction = this.createFileIdToPendingCompactionMap(operations.map(entry -> Pair.of(((CompactionOperation)entry.getValue()).getFileGroupId(), Pair.of(entry.getKey(), entry.getValue()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
    }

    @Override
    protected void addPendingCompactionOperations(Stream<Pair<String, CompactionOperation>> operations) {
        operations.forEach(opInstantPair -> {
            ValidationUtils.checkArgument(!this.fgIdToPendingCompaction.containsKey(((CompactionOperation)opInstantPair.getValue()).getFileGroupId()), "Duplicate FileGroupId found in pending compaction operations. FgId :" + ((CompactionOperation)opInstantPair.getValue()).getFileGroupId());
            this.fgIdToPendingCompaction.put(((CompactionOperation)opInstantPair.getValue()).getFileGroupId(), Pair.of(opInstantPair.getKey(), opInstantPair.getValue()));
        });
    }

    @Override
    protected void removePendingCompactionOperations(Stream<Pair<String, CompactionOperation>> operations) {
        operations.forEach(opInstantPair -> {
            ValidationUtils.checkArgument(this.fgIdToPendingCompaction.containsKey(((CompactionOperation)opInstantPair.getValue()).getFileGroupId()), "Trying to remove a FileGroupId which is not found in pending compaction operations. FgId :" + ((CompactionOperation)opInstantPair.getValue()).getFileGroupId());
            this.fgIdToPendingCompaction.remove(((CompactionOperation)opInstantPair.getValue()).getFileGroupId());
        });
    }

    @Override
    Stream<HoodieFileGroup> fetchAllStoredFileGroups(String partition) {
        ArrayList fileGroups = new ArrayList(this.partitionToFileGroupsMap.get(partition));
        return fileGroups.stream();
    }

    public Stream<HoodieFileGroup> getAllFileGroups() {
        return this.fetchAllStoredFileGroups();
    }

    @Override
    Stream<Pair<String, CompactionOperation>> fetchPendingCompactionOperations() {
        return this.fgIdToPendingCompaction.values().stream();
    }

    @Override
    protected Option<Pair<String, CompactionOperation>> getPendingCompactionOperationWithInstant(HoodieFileGroupId fgId) {
        return Option.ofNullable(this.fgIdToPendingCompaction.get(fgId));
    }

    @Override
    protected boolean isPartitionAvailableInStore(String partitionPath) {
        return this.partitionToFileGroupsMap.containsKey(partitionPath);
    }

    @Override
    protected void storePartitionView(String partitionPath, List<HoodieFileGroup> fileGroups) {
        LOG.info((Object)("Adding file-groups for partition :" + partitionPath + ", #FileGroups=" + fileGroups.size()));
        ArrayList<HoodieFileGroup> newList = new ArrayList<HoodieFileGroup>(fileGroups);
        this.partitionToFileGroupsMap.put(partitionPath, newList);
    }

    @Override
    public Stream<HoodieFileGroup> fetchAllStoredFileGroups() {
        return this.partitionToFileGroupsMap.values().stream().flatMap(Collection::stream);
    }

    @Override
    public void close() {
        this.closed = true;
        super.reset();
        this.partitionToFileGroupsMap = null;
        this.fgIdToPendingCompaction = null;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

