/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.FSUtils;

public class LogReaderUtils {
    private static Schema readSchemaFromLogFileInReverse(FileSystem fs, HoodieActiveTimeline activeTimeline, Path path) throws IOException {
        HoodieLogFormat.Reader reader = HoodieLogFormat.newReader(fs, new HoodieLogFile(path), null, true, true);
        Schema writerSchema = null;
        HoodieTimeline completedTimeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        while (reader.hasPrev()) {
            HoodieAvroDataBlock lastBlock;
            HoodieLogBlock block = reader.prev();
            if (!(block instanceof HoodieAvroDataBlock) || !completedTimeline.containsOrBeforeTimelineStarts((lastBlock = (HoodieAvroDataBlock)block).getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME))) continue;
            writerSchema = new Schema.Parser().parse(lastBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
            break;
        }
        reader.close();
        return writerSchema;
    }

    public static Schema readLatestSchemaFromLogFiles(String basePath, List<String> deltaFilePaths, JobConf jobConf) throws IOException {
        HoodieTableMetaClient metaClient = new HoodieTableMetaClient((Configuration)jobConf, basePath);
        List deltaPaths = deltaFilePaths.stream().map(s -> new HoodieLogFile(new Path(s))).sorted(HoodieLogFile.getReverseLogFileComparator()).map(s -> s.getPath().toString()).collect(Collectors.toList());
        if (deltaPaths.size() > 0) {
            for (String logPath : deltaPaths) {
                FileSystem fs = FSUtils.getFs(logPath, (Configuration)jobConf);
                Schema schemaFromLogFile = LogReaderUtils.readSchemaFromLogFileInReverse(fs, metaClient.getActiveTimeline(), new Path(logPath));
                if (schemaFromLogFile == null) continue;
                return schemaFromLogFile;
            }
        }
        return null;
    }
}

