/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.filter.BloomFilter;
import org.apache.hudi.common.bloom.filter.BloomFilterFactory;
import org.apache.hudi.common.bloom.filter.BloomFilterTypeCode;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.HoodieAvroUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.MetadataNotFoundException;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;

public class ParquetUtils {
    public static Set<String> readRowKeysFromParquet(Configuration configuration, Path filePath) {
        return ParquetUtils.filterParquetRowKeys(configuration, filePath, new HashSet<String>());
    }

    public static Set<String> filterParquetRowKeys(Configuration configuration, Path filePath, Set<String> filter) {
        Option<Object> filterFunction = Option.empty();
        if (filter != null && !filter.isEmpty()) {
            filterFunction = Option.of(new RecordKeysFilterFunction(filter));
        }
        Configuration conf = new Configuration(configuration);
        conf.addResource(FSUtils.getFs(filePath.toString(), conf).getConf());
        Schema readSchema = HoodieAvroUtils.getRecordKeySchema();
        AvroReadSupport.setAvroReadSchema((Configuration)conf, (Schema)readSchema);
        AvroReadSupport.setRequestedProjection((Configuration)conf, (Schema)readSchema);
        HashSet<String> rowKeys = new HashSet<String>();
        try (ParquetReader reader = AvroParquetReader.builder((Path)filePath).withConf(conf).build();){
            Object obj = reader.read();
            while (obj != null) {
                if (obj instanceof GenericRecord) {
                    String recordKey = ((GenericRecord)obj).get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
                    if (!filterFunction.isPresent() || ((RecordKeysFilterFunction)filterFunction.get()).apply(recordKey).booleanValue()) {
                        rowKeys.add(recordKey);
                    }
                }
                obj = reader.read();
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read row keys from Parquet " + filePath, e);
        }
        return rowKeys;
    }

    public static ParquetMetadata readMetadata(Configuration conf, Path parquetFilePath) {
        ParquetMetadata footer;
        try {
            footer = ParquetFileReader.readFooter((Configuration)FSUtils.getFs(parquetFilePath.toString(), conf).getConf(), (Path)parquetFilePath);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read footer for parquet " + parquetFilePath, e);
        }
        return footer;
    }

    public static MessageType readSchema(Configuration configuration, Path parquetFilePath) {
        return ParquetUtils.readMetadata(configuration, parquetFilePath).getFileMetaData().getSchema();
    }

    private static Map<String, String> readParquetFooter(Configuration configuration, boolean required, Path parquetFilePath, String ... footerNames) {
        HashMap<String, String> footerVals = new HashMap<String, String>();
        ParquetMetadata footer = ParquetUtils.readMetadata(configuration, parquetFilePath);
        Map metadata = footer.getFileMetaData().getKeyValueMetaData();
        for (String footerName : footerNames) {
            if (metadata.containsKey(footerName)) {
                footerVals.put(footerName, (String)metadata.get(footerName));
                continue;
            }
            if (!required) continue;
            throw new MetadataNotFoundException("Could not find index in Parquet footer. Looked for key " + footerName + " in " + parquetFilePath);
        }
        return footerVals;
    }

    public static Schema readAvroSchema(Configuration configuration, Path parquetFilePath) {
        return new AvroSchemaConverter().convert(ParquetUtils.readSchema(configuration, parquetFilePath));
    }

    public static BloomFilter readBloomFilterFromParquetMetadata(Configuration configuration, Path parquetFilePath) {
        Map<String, String> footerVals = ParquetUtils.readParquetFooter(configuration, false, parquetFilePath, "org.apache.hudi.bloomfilter", "com.uber.hoodie.bloomfilter", "hoodie_bloom_filter_type_code");
        String footerVal = footerVals.get("org.apache.hudi.bloomfilter");
        if (null == footerVal) {
            footerVal = footerVals.get("com.uber.hoodie.bloomfilter");
        }
        BloomFilter toReturn = null;
        if (footerVal != null) {
            toReturn = footerVals.containsKey("hoodie_bloom_filter_type_code") ? BloomFilterFactory.fromString(footerVal, footerVals.get("hoodie_bloom_filter_type_code")) : BloomFilterFactory.fromString(footerVal, BloomFilterTypeCode.SIMPLE.name());
        }
        return toReturn;
    }

    public static String[] readMinMaxRecordKeys(Configuration configuration, Path parquetFilePath) {
        Map<String, String> minMaxKeys = ParquetUtils.readParquetFooter(configuration, true, parquetFilePath, "hoodie_min_record_key", "hoodie_max_record_key");
        if (minMaxKeys.size() != 2) {
            throw new HoodieException(String.format("Could not read min/max record key out of footer correctly from %s. read) : %s", parquetFilePath, minMaxKeys));
        }
        return new String[]{minMaxKeys.get("hoodie_min_record_key"), minMaxKeys.get("hoodie_max_record_key")};
    }

    public static List<GenericRecord> readAvroRecords(Configuration configuration, Path filePath) {
        ParquetReader reader = null;
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        try {
            reader = AvroParquetReader.builder((Path)filePath).withConf(configuration).build();
            Object obj = reader.read();
            while (obj != null) {
                if (obj instanceof GenericRecord) {
                    records.add((GenericRecord)obj);
                }
                obj = reader.read();
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read avro records from Parquet " + filePath, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return records;
    }

    static class RecordKeysFilterFunction
    implements Function<String, Boolean> {
        private final Set<String> candidateKeys;

        RecordKeysFilterFunction(Set<String> candidateKeys) {
            this.candidateKeys = candidateKeys;
        }

        @Override
        public Boolean apply(String recordKey) {
            return this.candidateKeys.contains(recordKey);
        }
    }
}

